/*
 * Decompiled with CFR 0.152.
 */
package cryptix.pgp;

import cryptix.pgp.KeyID;
import cryptix.pgp.KeyStore;
import cryptix.security.rsa.PublicKey;
import cryptix.util.EmailAddress;
import java.io.IOException;
import java.net.UnknownHostException;

public abstract class KeyClient
extends KeyStore {
    protected String serverName;
    protected int port;

    public PublicKey getKey(String string) throws IOException {
        return this.fetch(string);
    }

    public PublicKey getKey(EmailAddress emailAddress) throws IOException {
        return this.fetch(emailAddress);
    }

    public PublicKey getKey(EmailAddress emailAddress, KeyID keyID) throws IOException {
        return this.fetch(emailAddress, keyID);
    }

    public PublicKey getKey(KeyID keyID) throws IOException {
        return this.fetch(null, keyID);
    }

    protected abstract PublicKey fetch(String var1) throws IOException;

    protected abstract PublicKey fetch(EmailAddress var1, KeyID var2) throws IOException;

    protected abstract PublicKey fetch(EmailAddress var1) throws IOException;

    public abstract String getUserName(KeyID var1);

    protected KeyClient(String string, int n) throws IOException, UnknownHostException {
        this.serverName = string;
        this.port = n;
    }
}

