/*
 * Decompiled with CFR 0.152.
 */
package cryptix.pgp;

import cryptix.pgp.Certificate;
import cryptix.pgp.KeyID;
import cryptix.pgp.PacketFactory;
import cryptix.pgp.Signature;
import cryptix.pgp.UserId;
import cryptix.security.MD5;
import cryptix.security.rsa.PublicKey;
import java.io.IOException;

public abstract class KeyStore {
    protected abstract PublicKey getKey(String var1) throws IOException;

    protected abstract PublicKey getKey(KeyID var1) throws IOException;

    public final boolean checkSignature(Signature signature, Certificate certificate, UserId userId) throws IOException {
        return KeyStore.checkSignature(this, signature, certificate, userId);
    }

    public static boolean checkSignature(KeyStore keyStore, Signature signature, Certificate certificate, UserId userId) throws IOException {
        PublicKey publicKey = keyStore.getKey(signature.getKeyId());
        if (publicKey != null) {
            return KeyStore.checkSignature(publicKey, signature, certificate, userId);
        }
        throw new IOException("Key id " + signature.getKeyId() + " not found");
    }

    public static boolean checkSignature(PublicKey publicKey, Signature signature, Certificate certificate, UserId userId) throws IOException {
        MD5 mD5 = new MD5();
        mD5.add(PacketFactory.save(certificate));
        mD5.add(userId.save());
        return signature.check(publicKey, mD5);
    }
}

