/*
 * Decompiled with CFR 0.152.
 */
package cryptix.pgp;

import cryptix.mime.LegacyString;
import cryptix.pgp.FormatException;
import cryptix.pgp.Packet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Date;

public final class LiteralData
extends Packet {
    private Date timestamp;
    private String filename;
    private char mode;
    private byte[] buffer;

    public Date timestamp() {
        return this.timestamp;
    }

    public String filename() {
        return this.filename;
    }

    public char mode() {
        return this.mode;
    }

    public boolean modeIsText() {
        return this.mode == 't';
    }

    public boolean modeIsBinary() {
        return this.mode == 'b';
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public byte[] data() {
        int n = this.buffer.length;
        byte[] byArray = new byte[n];
        System.arraycopy(this.buffer, 0, byArray, 0, n);
        return byArray;
    }

    public void read(DataInput dataInput, int n) throws IOException {
        if (n < 6) {
            throw new FormatException("Length too short");
        }
        this.mode = (char)dataInput.readByte();
        if (this.mode != 'b' && this.mode != 't') {
            throw new FormatException("Invalid mode");
        }
        int n2 = dataInput.readByte() & 0xFF;
        if (n2 > 0) {
            byte[] byArray = new byte[n2];
            dataInput.readFully(byArray);
            this.filename = LegacyString.toString(byArray);
        } else {
            this.filename = "";
        }
        this.timestamp = new Date(((long)dataInput.readInt() & 0xFFFFFFFFL) * 1000L);
        this.buffer = new byte[n - n2 - 6];
        dataInput.readFully(this.buffer);
    }

    public int write(DataOutput dataOutput) throws IOException {
        int n = this.filename.length();
        dataOutput.writeByte((byte)this.mode);
        dataOutput.writeByte((byte)n);
        dataOutput.writeBytes(this.filename);
        dataOutput.writeInt((int)(this.timestamp.getTime() / 1000L));
        dataOutput.write(this.buffer);
        return 6 + n + this.buffer.length;
    }

    public int getType() {
        return 11;
    }

    public LiteralData(byte[] byArray) {
        this(byArray, "data", 'b');
    }

    public LiteralData(byte[] byArray, String string, char c) {
        this.filename = string.length() < 255 ? string : string.substring(0, 255);
        this.mode = c;
        this.timestamp = new Date();
        this.buffer = byArray;
    }

    public LiteralData(DataInput dataInput, int n) throws IOException {
        super(dataInput, n);
    }
}

