/*
 * Decompiled with CFR 0.152.
 */
package cryptix.pgp;

import cryptix.pgp.FormatException;
import cryptix.pgp.Packet;
import cryptix.util.Streamable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class PacketHeader
extends Streamable {
    public int type;
    public int len;
    public int lensize;

    public void read(DataInput dataInput) throws IOException {
        byte by = dataInput.readByte();
        this.type = (byte)Packet.ctbToType(by);
        byte by2 = (byte)Packet.ctbToLengthSpecifier(by);
        switch (by2) {
            case 0: {
                this.len = dataInput.readByte() & 0xFF;
                break;
            }
            case 1: {
                this.len = dataInput.readShort() & 0xFFFF;
                break;
            }
            case 2: {
                this.len = dataInput.readInt();
                break;
            }
            case 3: {
                this.len = -1;
                break;
            }
            default: {
                throw new FormatException("Bad value for CTB (" + by2 + ")");
            }
        }
        this.lensize = 0;
    }

    public void write(DataOutput dataOutput) throws IOException {
        if (this.lensize == 0 && this.len != -1) {
            this.lensize = this.len < 256 ? 1 : (this.len < 65536 ? 2 : 4);
        }
        if (this.lensize == 1 && this.len > 255) {
            throw new FormatException("packet overflow");
        }
        if (this.lensize == 2 && this.len > 65536) {
            this.lensize = 3;
        }
        if (this.lensize == 0) {
            dataOutput.write(Packet.makeCTB(this.type, 3));
        } else if (this.lensize == 1) {
            dataOutput.write(Packet.makeCTB(this.type, 0));
            dataOutput.write(this.len & 0xFF);
        } else if (this.lensize == 2) {
            dataOutput.write(Packet.makeCTB(this.type, 1));
            dataOutput.writeShort(this.len & 0xFFFF);
        } else {
            dataOutput.write(Packet.makeCTB(this.type, 2));
            dataOutput.writeInt(this.len);
        }
    }

    public static String toString(PacketHeader packetHeader) {
        return "Packet header: type=" + packetHeader.type + ", len=" + packetHeader.len + ", lensize=" + packetHeader.lensize;
    }

    public PacketHeader(int n, int n2) {
        this.type = n;
        this.len = n2;
        this.lensize = 0;
    }

    public PacketHeader(int n, int n2, int n3) {
        this.type = n;
        this.len = n2;
        this.lensize = n3;
    }

    public PacketHeader(DataInput dataInput) throws IOException {
        this.read(dataInput);
    }
}

