/*
 * Decompiled with CFR 0.152.
 */
package cryptix.pgp;

import cryptix.math.BigInteger;
import cryptix.math.MPI;
import cryptix.math.RandomStream;
import cryptix.pgp.FormatException;
import cryptix.pgp.HashFactory;
import cryptix.pgp.KeyID;
import cryptix.pgp.Packet;
import cryptix.security.rsa.PublicKey;
import cryptix.security.rsa.SecretKey;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;

public final class PublicKeyEncrypted
extends Packet {
    private BigInteger enckey;
    private KeyID keyId;

    public void read(DataInput dataInput, int n) throws IOException {
        dataInput.readByte();
        byte[] byArray = new byte[8];
        dataInput.readFully(byArray);
        this.keyId = new KeyID(byArray);
        if (dataInput.readByte() != 1) {
            throw new FormatException("Incorrect algorithm identifier.");
        }
        try {
            this.enckey = MPI.read(dataInput);
        }
        catch (EOFException eOFException) {
            throw new IOException("MPI too long.");
        }
    }

    public int write(DataOutput dataOutput) throws IOException {
        dataOutput.write(2);
        dataOutput.write(this.keyId.toByteArray());
        dataOutput.write(1);
        byte[] byArray = MPI.save(this.enckey);
        dataOutput.write(byArray);
        return byArray.length + 10;
    }

    public KeyID secretKeyID() {
        return this.keyId;
    }

    public BigInteger getEncryptionKey() {
        return this.enckey;
    }

    public byte[] getKey(SecretKey secretKey) {
        byte[] byArray = secretKey.decrypt(this.enckey).toByteArray();
        int n = 0;
        int n2 = byArray.length - 18;
        while (n2 < byArray.length - 2) {
            n += byArray[n2] & 0xFF;
            ++n2;
        }
        n2 = ((byArray[byArray.length - 2] & 0xFF) << 8) + (byArray[byArray.length - 1] & 0xFF);
        if (n != n2) {
            throw new Error("sum mismatch sum:" + n + " check:" + n2);
        }
        byte[] byArray2 = new byte[16];
        System.arraycopy(byArray, byArray.length - 18, byArray2, 0, 16);
        return byArray2;
    }

    public String toString() {
        return "Public key encrypted packet - number: " + this.enckey.toString();
    }

    public int getType() {
        return 1;
    }

    public PublicKeyEncrypted(PublicKey publicKey, byte[] byArray, RandomStream randomStream) {
        this.keyId = new KeyID(publicKey.id());
        this.enckey = HashFactory.bigIntFromHash(publicKey, byArray, randomStream);
    }

    public PublicKeyEncrypted(DataInput dataInput, int n) throws IOException {
        super(dataInput, n);
    }
}

