/*
 * Decompiled with CFR 0.152.
 */
package cryptix.pgp;

import cryptix.math.RandomStream;
import cryptix.pgp.Certificate;
import cryptix.pgp.DecryptException;
import cryptix.pgp.EncryptedSecretKey;
import cryptix.pgp.FormatException;
import cryptix.pgp.KeyID;
import cryptix.pgp.PGPCFB;
import cryptix.pgp.Passphrase;
import cryptix.security.IDEA;
import cryptix.security.rsa.SecretKey;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class SecretKeyCertificate
extends Certificate {
    private EncryptedSecretKey key;

    public void read(DataInput dataInput, int n) throws IOException {
        super.read(dataInput, n);
        if (dataInput.readByte() != 1) {
            throw new FormatException("Bad algorithm byte (not RSA).");
        }
        this.key = new EncryptedSecretKey(dataInput);
    }

    public int write(DataOutput dataOutput) throws IOException {
        int n = super.write(dataOutput) + 1;
        dataOutput.write(1);
        byte[] byArray = this.key.save();
        dataOutput.write(byArray);
        return n += byArray.length;
    }

    public SecretKey getSecretKey(Passphrase passphrase) throws DecryptException {
        if (this.key.isEncrypted()) {
            PGPCFB pGPCFB = new PGPCFB(new IDEA(passphrase.md5hash()));
            return this.key.secretKey(pGPCFB);
        }
        return this.key.secretKey(null);
    }

    public final KeyID id() {
        return this.key.id();
    }

    public String toString() {
        return "Secret key Cert " + super.toString();
    }

    public int getType() {
        return 5;
    }

    public SecretKeyCertificate(SecretKey secretKey, Passphrase passphrase, RandomStream randomStream) throws IOException {
        this.key = new EncryptedSecretKey(secretKey, passphrase, randomStream);
    }

    public SecretKeyCertificate(DataInput dataInput, int n) throws IOException {
        super(dataInput, n);
    }
}

