/*
 * Decompiled with CFR 0.152.
 */
package cryptix.security;

import cryptix.security.BlockCipher;
import cryptix.security.CryptoError;
import xjava.security.Cipher;

public class Blowfish
extends BlockCipher {
    public static final int BLOCK_LENGTH = 8;
    public static final int BLOCK_LENGTH_MIN = 8;
    public static final int BLOCK_LENGTH_MAX = 8;
    public static final int KEY_LENGTH = 16;
    public static final int KEY_LENGTH_MAX = 56;
    public static final int KEY_LENGTH_MIN = 5;
    public static final int KEY_LENGTH_MOD = 1;
    public static final int NUM_ROUNDS = 16;
    private static final byte[][][] tests = new byte[][][]{{{97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122}, {66, 76, 79, 87, 70, 73, 83, 72}, {50, 78, -48, -2, -12, 19, -94, 3}}, {{87, 104, 111, 32, 105, 115, 32, 74, 111, 104, 110, 32, 71, 97, 108, 116, 63}, {-2, -36, -70, -104, 118, 84, 50, 16}, {-52, -111, 115, 43, -128, 34, -10, -124}}, {{65, 121, 110, -96, 82, 97, 110, -28}, {-2, -36, -70, -104, 118, 84, 50, 16}, {-31, 19, -12, 16, 44, -4, -50, 67}}};

    private static Cipher getCipherImpl() {
        try {
            return Cipher.getInstance((String)"Blowfish", (String)"Cryptix");
        }
        catch (Exception exception) {
            throw new CryptoError(exception.toString());
        }
    }

    public static void main(String[] stringArray) {
        Blowfish.self_test();
    }

    public static void self_test() throws CryptoError {
        int n = 0;
        while (n < tests.length) {
            byte[][] byArray = tests[n];
            byte[] byArray2 = byArray[0];
            byte[] byArray3 = byArray[1];
            byte[] byArray4 = byArray[2];
            Blowfish blowfish = new Blowfish(byArray2);
            byte[] byArray5 = new byte[blowfish.blockLength()];
            blowfish.encrypt(byArray3, byArray5);
            if (Blowfish.notEquals(byArray4, byArray5)) {
                throw new CryptoError("encrypt #" + n + " failed");
            }
            blowfish.decrypt(byArray4, byArray5);
            if (Blowfish.notEquals(byArray3, byArray5)) {
                throw new CryptoError("decrypt #" + n + " failed");
            }
            ++n;
        }
    }

    private static boolean notEquals(byte[] byArray, byte[] byArray2) {
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public Blowfish(byte[] byArray) {
        super(Blowfish.getCipherImpl(), byArray);
    }
}

