/*
 * Decompiled with CFR 0.152.
 */
package cryptix.security;

import cryptix.mime.LegacyString;
import cryptix.security.CryptoError;
import cryptix.security.HashMD5;
import cryptix.security.MessageDigest;
import cryptix.util.core.Hex;
import java.io.PrintWriter;

public class MD5
extends MessageDigest
implements Cloneable {
    public static final int HASH_LENGTH = 16;
    public static final int DATA_LENGTH = 64;

    private static java.security.MessageDigest getDigestImpl() {
        try {
            return java.security.MessageDigest.getInstance("MD5", "Cryptix");
        }
        catch (Exception exception) {
            throw new CryptoError(exception.toString());
        }
    }

    public static byte[] hash(String string) {
        try {
            return java.security.MessageDigest.getInstance("MD5", "Cryptix").digest(LegacyString.toByteArray(string));
        }
        catch (Exception exception) {
            throw new CryptoError(exception.toString());
        }
    }

    public static byte[] hash(byte[] byArray) {
        try {
            return java.security.MessageDigest.getInstance("MD5", "Cryptix").digest(byArray);
        }
        catch (Exception exception) {
            throw new CryptoError(exception.toString());
        }
    }

    public static HashMD5 hashAsMessageHash(String string) {
        try {
            return new HashMD5(java.security.MessageDigest.getInstance("MD5", "Cryptix").digest(LegacyString.toByteArray(string)));
        }
        catch (Exception exception) {
            throw new CryptoError(exception.toString());
        }
    }

    public static HashMD5 hashAsMessageHash(byte[] byArray) {
        try {
            return new HashMD5(java.security.MessageDigest.getInstance("MD5", "Cryptix").digest(byArray));
        }
        catch (Exception exception) {
            throw new CryptoError(exception.toString());
        }
    }

    public static HashMD5 CreateHash(byte[] byArray) {
        return new HashMD5(byArray);
    }

    public static void main(String[] stringArray) {
        try {
            MD5.self_test(new PrintWriter(System.out, true));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public static void self_test(PrintWriter printWriter) throws Exception {
        MD5.test(printWriter, "", "D41D8CD98F00B204E9800998ECF8427E");
        MD5.test(printWriter, "a", "0CC175B9C0F1B6A831C399E269772661");
        MD5.test(printWriter, "aa", "4124BC0A9335C27F086F24BA207A4912");
        MD5.test(printWriter, "aaa", "47BCE5C74F589F4867DBD57E9CA9F808");
        MD5.test(printWriter, "bbb", "08F8E0260C64418510CEFB2B06EEE5CD");
        MD5.test(printWriter, "ccc", "9dF62E693988EB4E1E1444ECE0578579");
        MD5.test(printWriter, "abc", "900150983CD24FB0D6963F7D28E17F72");
        MD5.test(printWriter, "abcdefg", "7AC66C0F148DE9519B8BD264312C4D64");
        MD5.test(printWriter, "abcdefghijk", "92B9CCCC0B98C3A0B8D0DF25A421C0E3");
        MD5.test(printWriter, "message digest", "F96B697D7CB7938D525A2F31AAF161D0");
        MD5.test(printWriter, "abcdefghijklmnopqrstuvwxyz", "C3FCD3D76192E4007DFB496CCA67E13B");
        MD5.test(printWriter, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", "D174AB98D277D9F5A5611C2C9F419D9F");
        MD5.test(printWriter, "12345678901234567890123456789012345678901234567890123456789012345678901234567890", "57EDF4A22BE3C955AC49DA2E2107B67A");
    }

    private static void test(PrintWriter printWriter, String string, String string2) throws Exception {
        java.security.MessageDigest messageDigest = java.security.MessageDigest.getInstance("MD5", "Cryptix");
        messageDigest.update(LegacyString.toByteArray(string));
        String string3 = Hex.toString((byte[])messageDigest.digest());
        printWriter.println("Message:   \"" + string + "\"");
        printWriter.println("calc hash: " + string3);
        printWriter.println("real hash: " + string2);
        if (!string2.equalsIgnoreCase(string3)) {
            printWriter.println("************ MD5 FAILED ************");
            throw new Exception("MD5 (V2.2) Failed test <" + string + ">");
        }
        printWriter.println("Good");
    }

    public MD5() {
        super(MD5.getDigestImpl());
    }
}

