/*
 * Decompiled with CFR 0.152.
 */
package cryptix.security.rsa;

import cryptix.math.BigInteger;
import cryptix.math.BigNum;
import cryptix.math.RandomStream;
import cryptix.math.TestPrime;
import cryptix.security.rsa.RSAKeyGenObserver;
import cryptix.security.rsa.SecretKey;

public class RSAKeyGen {
    protected RandomStream rand;

    public BigInteger randomPrime(int n, RSAKeyGenObserver rSAKeyGenObserver) {
        BigInteger bigInteger = new BigInteger();
        int n2 = 1 + n / 8;
        int n3 = n % 8;
        byte[] byArray = new byte[n2];
        do {
            if (this.rand.read(byArray) != n2) {
                throw new Error("Not using a cryptix.math.RandomStream !!!");
            }
            int n4 = n2 - 1;
            byArray[n4] = (byte)(byArray[n4] | 1);
            if (n3 == 0) {
                byArray[0] = 0;
                byArray[1] = (byte)(byArray[1] | 0xFFFFFF80);
            } else {
                byArray[0] = (byte)(byArray[0] & (byte)(255 >>> 8 - n3));
                byArray[0] = (byte)(byArray[0] | (byte)(1 << n3 - 1));
            }
            bigInteger.fromByteArray(byArray);
        } while (!TestPrime.isPrime(bigInteger, rSAKeyGenObserver));
        return bigInteger;
    }

    public static final SecretKey createKey(RandomStream randomStream, int n) {
        return RSAKeyGen.createKey(randomStream, n, null);
    }

    public static final SecretKey createKey(RandomStream randomStream, int n, RSAKeyGenObserver rSAKeyGenObserver) {
        return new RSAKeyGen(randomStream).createKey(n, rSAKeyGenObserver);
    }

    public SecretKey createKey(int n) {
        return this.createKey(n, null);
    }

    public SecretKey createKey(int n, RSAKeyGenObserver rSAKeyGenObserver) {
        int n2 = n / 2;
        int n3 = n - n2;
        BigInteger bigInteger = new BigInteger(0);
        BigInteger bigInteger2 = new BigInteger(0);
        while (new BigInteger().mul(bigInteger, bigInteger2).bitLength() != n) {
            RSAKeyGen.signalObserver(rSAKeyGenObserver, 5);
            bigInteger = this.randomPrime(n2, rSAKeyGenObserver);
            RSAKeyGen.signalObserver(rSAKeyGenObserver, 6);
            bigInteger2 = this.randomPrime(n3, rSAKeyGenObserver);
        }
        BigInteger bigInteger3 = new BigInteger(17);
        RSAKeyGen.signalObserver(rSAKeyGenObserver, 7);
        SecretKey secretKey = this.deriveKeys(bigInteger, bigInteger2, bigInteger3);
        RSAKeyGen.signalObserver(rSAKeyGenObserver, 8);
        return secretKey;
    }

    protected final SecretKey deriveKeys(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        BigInteger bigInteger4;
        if (bigInteger.cmp(bigInteger2) > 0) {
            bigInteger4 = bigInteger;
            bigInteger = bigInteger2;
            bigInteger2 = bigInteger4;
        }
        bigInteger4 = new BigInteger().sub(bigInteger, BigInteger.one);
        BigInteger bigInteger5 = new BigInteger().sub(bigInteger2, BigInteger.one);
        BigInteger bigInteger6 = new BigInteger().mul(bigInteger4, bigInteger5);
        BigInteger bigInteger7 = new BigInteger().gcd(bigInteger4, bigInteger5);
        bigInteger4.div(bigInteger6, bigInteger7);
        if (bigInteger3 == null) {
            bigInteger3 = new BigInteger(3);
        }
        while (true) {
            bigInteger5.gcd(bigInteger3, bigInteger6);
            if (bigInteger5.cmp(BigInteger.one) == 0) break;
            bigInteger3.add(2);
        }
        BigInteger bigInteger8 = new BigInteger();
        BigNum.inverseModN(bigInteger8, bigInteger3, bigInteger4);
        BigInteger bigInteger9 = new BigInteger();
        BigNum.inverseModN(bigInteger9, bigInteger, bigInteger2);
        BigInteger bigInteger10 = new BigInteger().mul(bigInteger, bigInteger2);
        SecretKey secretKey = new SecretKey(bigInteger10, bigInteger3, bigInteger8, bigInteger, bigInteger2, bigInteger9);
        String string = secretKey.test();
        if (string != null) {
            throw new Error("RSA Key generation failed - reason:\n" + string);
        }
        return secretKey;
    }

    private static final void signalObserver(RSAKeyGenObserver rSAKeyGenObserver, int n) {
        if (rSAKeyGenObserver != null) {
            rSAKeyGenObserver.handleEvent(n);
        }
    }

    public RSAKeyGen(RandomStream randomStream) {
        this.rand = randomStream;
    }
}

