#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <linux/reboot.h>
#include <sys/reboot.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <unistd.h>
#include "clinit.h"
#include "conf.h"
#include "error.h"
#include "fs.h"
#include "setup.h"
#include "uid.h"
#include "waitchar.h"

int main( int argc, char *argv[] )
{
	struct params p;
	pid_t pid;
	time_t t;
	char buffer[80];
	char buffer2[10];
	int i;

	printf("Init.\n");

	if( checkfs() ) {
		printf("Error checking filesystems.\n");
		exit(1);
	}

	if( mountfs() ) {
		printf("Error mounting filesystems.\n");
		mkdatafs();
		sync();
		reboot( LINUX_REBOOT_CMD_RESTART );
		exit(1);
	}

	time(&t);
	printf("Current date: %s\n", ctime(&t));

	printf("Enter 'a' to run setup utility: ");
	fflush(stdout);

	if( (waitchar( STDIN, 2000000 )==1) && (toupper(getchar())=='A') ) {
		/* Run setup utility. */
		setup();
		sync();
		reboot( LINUX_REBOOT_CMD_RESTART );
		exit(1);
	} else {
		/* Run cryptd. */
		printf("\n\n");

		i=readconf( CONF_FILE, &p );
		if( i!=0 ) {
			printf("Warning: Config file was not processed correctly.\n");
			printf("         Running of setup utility is recommended.\n");
		}

		/* /bin/ifconfig lo 127.0.0.1 netmask 255.0.0.0 broadcast
		 * 127.255.255.255
		 */
		printf("Setup loopback interface.\n");
		if( (pid=fork()) < 0 ) {
			printf("fork error\n");
			exit(1);
		} else if( pid==0 ) {
			if( execl( "/bin/ifconfig", "ifconfig", "lo", "127.0.0.1",
				"netmask", "255.0.0.0", "broadcast", "127.255.255.255",
				(char *) 0 ) < 0 ) {
				printf("exec error\n");
				exit(1);
			}
		}
		if( waitpid( pid, NULL, 0 ) < 0 ) {
			printf("fork error\n");
			exit(1);
		}

		if( p.interface==ETHERNET ) {
			/* /bin/ifconfig eth0 192.168.249.1 netmask 255.255.255.0 broadcast
			 * 192.168.249.255
			 */
			printf("Setup ethernet interface.\n");
			if( (pid=fork()) < 0 ) {
				printf("fork error\n");
				exit(1);
			} else if( pid==0 ) {
				if( execl( "/bin/ifconfig", "ifconfig", "eth0", p.iplocal,
					"netmask", p.ipmask, "broadcast", p.ipbrcast,
					(char *) 0 ) < 0 ) {
					printf("exec error\n");
					exit(1);
				}
			}
			if( waitpid( pid, NULL, 0 ) < 0 ) {
				printf("fork error\n");
				exit(1);
			}

#if 0
			/* /bin/route add -net 192.168.249.0 netmask 255.255.255.0 eth0 */
			if( (pid=fork()) < 0 ) {
				printf("fork error\n");
				exit(1);
			} else if( pid==0 ) {
				if( execl( "/bin/route", "route", "add", "-net", p.ipnet,
					"netmask", p.ipmask, "eth0", (char *) 0 ) < 0 ) {
					printf("exec error\n");
					exit(1);
				}
			}
			if( waitpid( pid, NULL, 0 ) < 0 ) {
				printf("fork error\n");
				exit(1);
			}
#endif
		} else if( p.interface==PPP ) {
			/* /bin/pppd nodetach xonxoff noauth passive local persist
			 * 192.168.249.1:192.168.249.2 /dev/ttyS1 57600
			 */
			printf("Start pppd.\n");
			strncpy( buffer, p.iplocal, 15 );
			strncat( buffer, ":", 1 );
			strncat( buffer, p.ipremote, 15 );
			snprintf( buffer2, sizeof(buffer2), "%d", p.speed );
			if( (pid=fork()) < 0 ) {
				printf("fork error\n");
				exit(1);
			} else if( pid==0 ) {
				if( execl( "/bin/pppd", "pppd", "nodetach", "xonxoff", "noauth",
					"passive", "local", "persist",
					buffer, "/dev/ttyS1", buffer2,
					(char *) 0 ) < 0 ) {
					printf("exec error\n");
					exit(1);
				}
			}

#if 0
			/* /bin/route add ip.local pointtopoint ip.remote ppp0 */
			if( (pid=fork()) < 0 ) {
				printf("fork error\n");
				exit(1);
			} else if( pid==0 ) {
				if( execl( "/bin/route", "route", "add", p.iplocal,
					"pointtopoint", p.ipremote, "ppp0", (char *) 0 ) < 0 ) {
					printf("exec error\n");
					exit(1);
				}
			}
			if( waitpid( pid, NULL, 0 ) < 0 ) {
				printf("fork error\n");
				exit(1);
			}
#endif
		} else {
			printf("Warning: No network started.\n");
		}

#ifdef DEVEL
		/* /devel/ash */
		printf("Start shell.\n");
		if( execl( "/devel/ash", "ash", (char *) 0 ) < 0 ) {
			printf("exec error\n");
			exit(1);
		}
#else
		droprights( USER_ID );

		/* /bin/cryptd */
		printf("Start cryptd.\n");
		if( execl( "/bin/cryptd", "cryptd", (char *) 0 ) < 0 ) {
			printf("exec error\n");
			exit(1);
		}
#endif
	}

	return( 0 );
}

