#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/wait.h>
#include <unistd.h>
#include "conf.h"
#include "error.h"

int readconf( char *name, struct params *p )
{
	FILE *f;
	char buffer[80];
	int i, i1, i2, i3, ret=0;

	/* Set default values. */
	p->interface=ETHERNET;
	p->ipb1=192;
	p->ipb2=168;
	p->ipb3=249;
	p->speed=57600;

	f=fopen( name, "r" );
	if( f==NULL ) {
		printf("Error opening config file.\n");
		return( ERROR_NO_FILE );
	}

	while( fgets( buffer, sizeof(buffer)-1, f )!=NULL ) {
		buffer[strlen(buffer)-1]=0;
		if( !strncmp( "INTERFACE=", buffer, strlen( "INTERFACE=" ) ) ) {
			if( !strncmp( "INTERFACE=ETHERNET", buffer, 18 ) )
				p->interface=ETHERNET;
			else if( !strncmp( "INTERFACE=PPP", buffer, 13 ) )
				p->interface=PPP;
			else {
				ret=1;
			}
		} else if( !strncmp( "IPNET=", buffer, strlen( "IPNET=" ) ) ) {
			if( sscanf( buffer, "IPNET=%d.%d.%d.%d", &i, &i1, &i2, &i3 )==4 ) {
				if( (i<0) || (i>255) || (i1<0) || (i1>255) || (i2<0) ||
					(i2>255) ) {
					ret=1;
				} else {
					p->ipb1=i;
					p->ipb2=i1;
					p->ipb3=i2;
				}
			} else
				ret=1;
		} else if( !strncmp( "SPEED=", buffer, strlen( "SPEED=" ) ) ) {
			if( sscanf( buffer, "SPEED=%d", &i )==1 ) {
				switch( i ) {
				case 19200:
				case 38400:
				case 57600:
				case 115200:
					p->speed=i;
					break;
				default:
					ret=1;
				}
			} else
				ret=1;
		} else if( !strncmp( "#", buffer, 1 ) ) {
			/* Comment */
		} else {
			ret=1;
		}
	}

	sprintf( p->iplocal, "%d.%d.%d.1", p->ipb1, p->ipb2, p->ipb3 );
	sprintf( p->ipremote, "%d.%d.%d.2", p->ipb1, p->ipb2, p->ipb3 );
	sprintf( p->ipnet, "%d.%d.%d.0", p->ipb1, p->ipb2, p->ipb3 );
	sprintf( p->ipmask, "255.255.255.0" );
	sprintf( p->ipbrcast, "%d.%d.%d.255", p->ipb1, p->ipb2, p->ipb3 );

	if( p->interface==ETHERNET ) {
		printf("Interface: Ethernet\n");
		printf("Net address: %d.%d.%d.0\n", p->ipb1, p->ipb2, p->ipb3 );
	} else if( p->interface==PPP ) {
		printf("Interface: PPP/COM2\n");
		printf("Net address: %d.%d.%d.0\n", p->ipb1, p->ipb2, p->ipb3 );
		printf("Port speed: %d\n", p->speed );
	} else {
		printf("Error: Unknown interface.\n");
		ret=1;
	}

	fclose( f );
	return( ret );
}

int writeconf( char *name, struct params *p )
{
	FILE *f;

	f=fopen( name, "w+" );
	if( f==NULL ) {
		printf("Error opening config file.\n");
		return( ERROR_FOPEN );
	}

	fprintf( f, "# Generated config file.\n");
	if( p->interface==ETHERNET )
		fprintf( f, "INTERFACE=ETHERNET\n");
	else
		fprintf( f, "INTERFACE=PPP\n");
	fprintf( f, "IPNET=%d.%d.%d.0\n", p->ipb1, p->ipb2, p->ipb3 );
	fprintf( f, "SPEED=%d\n", p->speed );

	fclose( f );

	sync();

	printf("Config file written.\n");

	return( 0 );
}

int writedate( char *date )
{
	pid_t pid;

	/* /bin/date $date */
	printf("Running date.\n");
	if( (pid=fork()) < 0 ) {
		printf("fork error\n");
		return(1);
	} else if( pid==0 ) {
		if( execl( "/bin/date", "date", date, (char *) 0 )
			< 0 ) {
			printf("exec error\n");
			return(1);
		}
	}
	if( waitpid( pid, NULL, 0 ) < 0 ) {
		printf("fork error\n");
		return(1);
	}

	/* /bin/hwclock --systohc --utc */
	printf("Running hwclock.\n");
	if( (pid=fork()) < 0 ) {
		printf("fork error\n");
		return(1);
	} else if( pid==0 ) {
		if( execl( "/bin/hwclock", "hwclock", "--systohc", "--utc", (char *) 0 )
			< 0 ) {
			printf("exec error\n");
			return(1);
		}
	}
	if( waitpid( pid, NULL, 0 ) < 0 ) {
		printf("fork error\n");
		return(1);
	}

	return(0);
}

