#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <sys/mount.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>
#include "fs.h"
#include "uid.h"

int checkfs()
{
	pid_t pid;

	/* /bin/fsck.minix /dev/fla2 */
	printf("Check /var.\n");
	if( (pid=fork()) < 0 ) {
		printf("fork error\n");
		return(1);
	} else if( pid==0 ) {
		if( execl( "/bin/fsck.minix", "fsck.minix", "-a", "/dev/fla2", (char *) 0 )
			< 0 ) {
			printf("exec error\n");
			return(1);
		}
	}
	if( waitpid( pid, NULL, 0 ) < 0 ) {
		printf("fork error\n");
		return(1);
	}

	return(0);
}

int mountfs()
{
	/* /bin/mount -t proc none /proc */
	printf("Mount /proc.\n");
	if( mount( "none", "/proc", "proc", MS_MGC_VAL, "" ) ) {
		printf("mount error\n");
		return(1);
	}

	/* /bin/mount -t minix -o noatime,nodev,noexec,nosuid,sync /dev/fla2 /var
	 */
	printf("Mount /var.\n");
	if( mount( "/dev/fla2", "/var", "minix", MS_MGC_VAL|MS_NOSUID|MS_NODEV|
		MS_NOEXEC|MS_SYNCHRONOUS|MS_NOATIME|MS_NODIRATIME, "" ) ) {
		printf("mount error\n");
		return(1);
	}

	return(0);
}

int umountfs()
{
	/* /bin/umount /var
	 */
	printf("Unmount /var.\n");
	if( umount( "/var" ) ) {
		printf("umount error\n");
		return(1);
	}

	return(0);
}

int mkdatafs()
{
	pid_t pid;
	int status;
	FILE *fptr;
	char buffer[20];

	printf("Format data partition? [No/Yes] ");
	if( (fgets( buffer, sizeof(buffer)-1, stdin )==NULL) ||
		strncmp( "Yes", buffer, 3 ) ) {
		return(0);
	}

	printf("Formating data partition.\n");

	umountfs();

	/* /bin/mkfs.minix /dev/fla2
	 */
	printf("Mkfs fla2.\n");
	if( (pid=fork()) < 0 ) {
		printf("fork error\n");
		return(1);
	} else if( pid==0 ) {
		if( execl( "/bin/mkfs.minix", "mkfs.minix", "/dev/fla2", (char *) 0 ) < 0 ) {
			printf("exec error\n");
			return(1);
		}
	}
	if( waitpid( pid, &status, 0 ) < 0 ) {
		printf("fork error\n");
		return(1);
	}
	if( status ) {
		printf("mkfs error.\n");
		return(1);
	}

	/* /bin/mount -t minix -o noatime,nodev,noexec,nosuid,sync /dev/fla2 /var
	 */
	printf("Mount /var.\n");
	if( mount( "/dev/fla2", "/var", "minix", MS_MGC_VAL|MS_NOSUID|MS_NODEV|
		MS_NOEXEC|MS_SYNCHRONOUS|MS_NOATIME|MS_NODIRATIME, "" ) ) {
		printf("mount error\n");
		return(1);
	}

	printf("Create directories and files.\n");
	if( mkdir( "/var/adm", 0755 ) ) {
		printf("mkdir error.\n");
		return(1);
	}

	if( chown( "/var/adm", ADM_ID, ADM_ID ) ) {
		printf("chown error.\n");
		return(1);
	}

	fptr = fopen( "/var/adm/box.conf", "w+" );
	if( fptr==NULL ) {
		printf("fopen error.\n");
		return(1);
	}

	fprintf( fptr, "INTERFACE=ETHERNET\n");
	fprintf( fptr, "IPNET=192.168.249.0\n");
	fprintf( fptr, "SPEED=57600\n");

	fclose( fptr );

	if( mkdir( "/var/user", 0755 ) ) {
		printf("mkdir error.\n");
		return(1);
	}

	if( chown( "/var/user", USER_ID, USER_ID ) ) {
		printf("chown error.\n");
		return(1);
	}

	sync();

	printf("Data partition intialized.\n");

	return(0);
}


