#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "setup.h"
#include "conf.h"
#include "fs.h"
#include "uid.h"

int setup()
{
	struct params p;
	char buffer[80];
	int i, i1, i2, i3, i4;

	printf("\nStarting setup utility.\n");

	while( getchar()!='\n' ) {}

	if( mkdatafs() ) {
		printf("format error\n");
		return(1);
	}

	printf("Enter UTC date and time (MMDDhhmmYYYY): ");
	if( (fgets( buffer, sizeof(buffer)-1, stdin )==NULL) ||
		(strlen(buffer)!=13) ) {
		printf("Warning: Input error. Date will not be set.\n");
	} else {
		buffer[12]=0;
		writedate( buffer );
	}

	droprights( ADM_ID );

	i=readconf( CONF_FILE, &p );
	if( i!=0 )
		printf("Warning: Config file was not processed correctly.\n");

	p.interface=ETHERNET;

	printf("Enter interface number (1=Ethernet, 2=COM2): ");
	if( fgets( buffer, sizeof(buffer)-1, stdin )==NULL ) {
		printf("Warning: Input error. Set to default value.\n");
	} else {
		switch( buffer[0] ) {
		case '1':
			p.interface=ETHERNET;
			break;
		case '2':
			p.interface=PPP;
			break;
		default:
			printf("Warning: Input error. Set to default value.\n");
			p.interface=ETHERNET;
		}
	}

	p.ipb1=192;
	p.ipb2=168;
	p.ipb3=249;

	printf("Enter net address (192.168.249.0): ");
	if( fgets( buffer, sizeof(buffer)-1, stdin )==NULL ) {
		printf("Warning: Input error. Set to default value.\n");
	} else if( (sscanf( buffer, "%d.%d.%d.%d", &i1, &i2, &i3, &i4 )!=4) ||
			(i1>255) || (i1<0) || (i2>255) || (i2<0) || (i3>255) || (i3<0) ) {
			printf("Warning: Input error. Set to default value.\n");
	} else {
			p.ipb1=i1;
			p.ipb2=i2;
			p.ipb3=i3;
	}

	p.speed=57600;

	if( p.interface==PPP ) {
		printf("Enter port speed (57600): ");
		if( fgets( buffer, sizeof(buffer)-1, stdin )==NULL ) {
			printf("Warning: Input error. Set to default value.\n");
		} else if( sscanf( buffer, "%d", &i1 )==1 ) {
			switch( i1 ) {
			case 19200:
			case 38400:
			case 57600:
			case 115200:
				p.speed=i1;
				break;
			default:
				printf("Warning: Input error. Set to default value.\n");
			}
		} else {
			printf("Warning: Input error. Set to default value.\n");
		}
	}

	printf("\nSettings:\n");
	if( p.interface==ETHERNET )
		printf("Interface: Ethernet\n");
	else if( p.interface==PPP )
		printf("Interface: COM2\n");
	else
		printf("Interface: Unknown\n");
	printf("Net address: %d.%d.%d.0\n", p.ipb1, p.ipb2, p.ipb3 );
	if( p.interface==PPP )
		printf("Port speed: %d\n", p.speed);

	/* Write config. */
	i=writeconf( CONF_FILE, &p );
	if( i!=0 ) {
		printf("Error: Config file could not be written.\n");
		return( 1 );
	}

	return( 0 );
}

