package com.cryptlib;

public class CryptLib implements CryptLibConstants
{
	private static final CryptLib instance  = new CryptLib();
	
	private CryptLib() {}
	
	static
	{
		System.loadLibrary("cl32");
	}
	
	public static CryptLib getInstance()
	{
		return instance;
	}
	
	public native int cryptInit();
	
	public native int cryptEnd();
	
	public native int cryptCreateContext( int[] cryptContext,
                          int cryptUser,
                          int cryptAlgo );

	public native int cryptDeviceCreateContext( int device,
                                int[] cryptContext,
                                int cryptAlgo );

	public native int cryptCreateCert( int[] certificate,
                       int cryptUser,
                       int certType );

	public native int cryptDeviceOpen( int[] device,
                       int cryptUser,
                       int deviceType,
                       String name );

	public native int cryptCreateEnvelope( int[] envelope,
                           int cryptUser,
                           int formatType );

	public native int cryptKeysetOpen( int[] keyset,
                       int cryptUser,
                       int keysetType,
                       String name, int options );

	public native int cryptCreateSession( int[] session,
                          int cryptUser,
                          int sessionType );

	public native int cryptLogin( int[] user,
                  String name, String password );

	public native int cryptDestroyObject( int cryptHandle );

	public native int cryptDestroyCert( int certificate );

	public native int cryptDestroyContext( int cryptContext );

	public native int cryptDestroyEnvelope( int cryptEnvelope );

	public native int cryptDeviceClose( int device );

	public native int cryptKeysetClose( int keyset );

	public native int cryptDestroySession( int session );

	public native int cryptLogout( int user );

	public native int cryptGetAttribute( int cryptHandle,
                         int attributeType,
                         int[] value );

	public native int cryptGetAttributeString( int cryptHandle,
                               int attributeType,
                               byte[] value,
                               int[] valueLength );

	public native int cryptSetAttribute( int cryptHandle,
                         int attributeType,
                         int value );

	public native int cryptSetAttributeString( int cryptHandle,
                               int attributeType,
                               byte[] value, int valueLength );

	public native int cryptDeleteAttribute( int cryptHandle,
                            int attributeType );

	public native int cryptGenerateKey( int cryptContext );

	public native int cryptGenerateKeyAsync( int cryptContext );

	public native int cryptAsyncQuery( int cryptContext );

	public native int cryptAsyncCancel( int cryptContext );

	public native int cryptEncrypt( int cryptContext,
                    byte[][] buffer,
                    int length );

	public native int cryptDecrypt( int cryptContext,
                    byte[][] buffer,
                    int length );

	public native int cryptSignCert( int certificate,
                     int signContext );

	public native int cryptCheckCert( int certificate,
                      int sigCheckKey );

	public native int cryptImportCert( byte[] certObject,
                       int certObjectLength,
                       int cryptUser,
                       int[] certificate );

	public native int cryptExportCert( byte[] certObject,
                       int[] certObjectLength,
                       int certFormatType,
                       int certificate );

	public native int cryptCAAddItem( int keyset,
                      int certificate );

	public native int cryptCAGetItem( int keyset,
                      int[] certificate,
                      int certType,
                      int keyIDtype,
                      byte[] keyID );

	public native int cryptCADeleteItem( int keyset,
                         int keyIDtype,
                         byte[] keyID );

	public native int cryptCACertManagement( int[] certificate,
                             int action,
                             int keyset,
                             int caKey,
                             int certRequest );

	public native int cryptPushData( int envelope, byte[] buffer,
                     int length, int[] bytesCopied );

	public native int cryptPopData( int envelope, byte[] buffer,
                    int length, int[] bytesCopied );

	public native int cryptFlushData( int envelope );

	public native int cryptGetPublicKey( int keyset,
                         int[] cryptKey,
                         int keyIDtype,
                         byte[] keyID );

	public native int cryptGetPrivateKey( int keyset,
                          int[] cryptContext,
                          int keyIDtype,
                          byte[] keyID, String password );

	public native int cryptAddPublicKey( int keyset,
                         int certificate );

	public native int cryptAddPrivateKey( int keyset,
                          int cryptKey,
                          String password );

	public native int cryptDeleteKey( int keyset,
                      int keyIDtype,
                      byte[] keyID );

	public native int cryptQueryCapability( int cryptAlgo,
                            String[] algoName, int[] sizes );

	public native int cryptDeviceQueryCapability( int device,
                                  int cryptAlgo,
                                  String[] algoName, int[] sizes );

}
