package com.cryptlib;

public interface CryptLibConstants
{
	int CRYPT_ALGO_NONE = 0;
	int CRYPT_ALGO_DES = 1;
	int CRYPT_ALGO_3DES = 2;
	int CRYPT_ALGO_IDEA = 3;
	int CRYPT_ALGO_CAST = 4;
	int CRYPT_ALGO_RC2 = 5;
	int CRYPT_ALGO_RC4 = 6;
	int CRYPT_ALGO_RC5 = 7;
	int CRYPT_ALGO_AES = 8;
	int CRYPT_ALGO_BLOWFISH = 9;
	int CRYPT_ALGO_SKIPJACK = 10;
	int CRYPT_ALGO_DH = 100 + 0;
	int CRYPT_ALGO_RSA = 100 + 1;
	int CRYPT_ALGO_DSA = 100 + 2;
	int CRYPT_ALGO_ELGAMAL = 100 + 3;
	int CRYPT_ALGO_KEA = 100 + 4;
	int CRYPT_ALGO_MD2 = 200 + 0;
	int CRYPT_ALGO_MD4 = 200 + 1;
	int CRYPT_ALGO_MD5 = 200 + 2;
	int CRYPT_ALGO_SHA = 200 + 3;
	int CRYPT_ALGO_RIPEMD160 = 200 + 4;
	int CRYPT_ALGO_HMAC_MD5 = 300 + 0;
	int CRYPT_ALGO_HMAC_SHA = 300 + 1;
	int CRYPT_ALGO_HMAC_RIPEMD160 = 300 + 2;
	int CRYPT_ALGO_LAST = 300 + 3;
	int CRYPT_ALGO_FIRST_CONVENTIONAL = CRYPT_ALGO_DES + 0;
	int CRYPT_ALGO_LAST_CONVENTIONAL = CRYPT_ALGO_DH - 1 + 0;
	int CRYPT_ALGO_FIRST_PKC = CRYPT_ALGO_DH + 0;
	int CRYPT_ALGO_LAST_PKC = CRYPT_ALGO_MD2 - 1 + 0;
	int CRYPT_ALGO_FIRST_HASH = CRYPT_ALGO_MD2 + 0;
	int CRYPT_ALGO_LAST_HASH = CRYPT_ALGO_HMAC_MD5 - 1 + 0;
	int CRYPT_ALGO_FIRST_MAC = CRYPT_ALGO_HMAC_MD5 + 0;
	int CRYPT_ALGO_LAST_MAC = CRYPT_ALGO_HMAC_MD5 + 99	 + 0;

	int CRYPT_MODE_NONE = 0;
	int CRYPT_MODE_ECB = 1;
	int CRYPT_MODE_CBC = 2;
	int CRYPT_MODE_CFB = 3;
	int CRYPT_MODE_OFB = 4;
	int CRYPT_MODE_LAST = 5;

	int CRYPT_KEYSET_NONE = 0;
	int CRYPT_KEYSET_FILE = 1;
	int CRYPT_KEYSET_HTTP = 2;
	int CRYPT_KEYSET_LDAP = 3;
	int CRYPT_KEYSET_ODBC = 4;
	int CRYPT_KEYSET_MYSQL = 5;
	int CRYPT_KEYSET_DATABASE = 6;
	int CRYPT_KEYSET_ODBC_STORE = 7;
	int CRYPT_KEYSET_MYSQL_STORE = 8;
	int CRYPT_KEYSET_DATABASE_STORE = 9;
	int CRYPT_KEYSET_LAST = 10;

	int CRYPT_DEVICE_NONE = 0;
	int CRYPT_DEVICE_FORTEZZA = 1;
	int CRYPT_DEVICE_PKCS11 = 2;
	int CRYPT_DEVICE_LAST = 3;

	int CRYPT_CERTTYPE_NONE = 0;
	int CRYPT_CERTTYPE_CERTIFICATE = 1;
	int CRYPT_CERTTYPE_ATTRIBUTE_CERT = 2;
	int CRYPT_CERTTYPE_CERTCHAIN = 3;
	int CRYPT_CERTTYPE_CERTREQUEST = 4;
	int CRYPT_CERTTYPE_REQUEST_CERT = 5;
	int CRYPT_CERTTYPE_REQUEST_REVOCATION = 6;
	int CRYPT_CERTTYPE_CRL = 7;
	int CRYPT_CERTTYPE_CMS_ATTRIBUTES = 8;
	int CRYPT_CERTTYPE_OCSP_REQUEST = 9;
	int CRYPT_CERTTYPE_OCSP_RESPONSE = 10;
	int CRYPT_CERTTYPE_PKIUSER = 11;
	int CRYPT_CERTTYPE_LAST = 12;

	int CRYPT_FORMAT_NONE = 0;
	int CRYPT_FORMAT_AUTO = 1;
	int CRYPT_FORMAT_CRYPTLIB = 2;
	int CRYPT_FORMAT_CMS = 3;
	int CRYPT_FORMAT_PKCS7 = CRYPT_FORMAT_CMS + 0;
	int CRYPT_FORMAT_SMIME = CRYPT_FORMAT_CMS + 1;
	int CRYPT_FORMAT_PGP = CRYPT_FORMAT_CMS + 2;
	int CRYPT_FORMAT_LAST = CRYPT_FORMAT_CMS + 3;

	int CRYPT_SESSION_NONE = 0;
	int CRYPT_SESSION_SSH = 1;
	int CRYPT_SESSION_SSH_SERVER = 2;
	int CRYPT_SESSION_SSL = 3;
	int CRYPT_SESSION_SSL_SERVER = 4;
	int CRYPT_SESSION_OCSP = 5;
	int CRYPT_SESSION_OCSP_SERVER = 6;
	int CRYPT_SESSION_TSP = 7;
	int CRYPT_SESSION_TSP_SERVER = 8;
	int CRYPT_SESSION_CMP = 9;
	int CRYPT_SESSION_CMP_SERVER = 10;
	int CRYPT_SESSION_LAST = 11;

	int CRYPT_USER_NONE = 0;
	int CRYPT_USER_NORMAL = 1;
	int CRYPT_USER_SO = 2;
	int CRYPT_USER_CA = 3;
	int CRYPT_USER_LAST = 4;

	int CRYPT_ATTRIBUTE_NONE = 0;
	int CRYPT_PROPERTY_FIRST = 1;
	int CRYPT_PROPERTY_HIGHSECURITY = 2;
	int CRYPT_PROPERTY_OWNER = 3;
	int CRYPT_PROPERTY_FORWARDCOUNT = 4;
	int CRYPT_PROPERTY_LOCKED = 5;
	int CRYPT_PROPERTY_USAGECOUNT = 6;
	int CRYPT_PROPERTY_NONEXPORTABLE = 7;
	int CRYPT_PROPERTY_LAST = 8;
	int CRYPT_GENERIC_FIRST = 9;
	int CRYPT_ATTRIBUTE_ERRORTYPE = 10;
	int CRYPT_ATTRIBUTE_ERRORLOCUS = 11;
	int CRYPT_ATTRIBUTE_INT_ERRORCODE = 12;
	int CRYPT_ATTRIBUTE_INT_ERRORMESSAGE = 13;
	int CRYPT_ATTRIBUTE_BUFFERSIZE = 14;
	int CRYPT_GENERIC_LAST = 15;
	int CRYPT_OPTION_FIRST = 100 + 0;
	int CRYPT_OPTION_INFO_DESCRIPTION = 100 + 1;
	int CRYPT_OPTION_INFO_COPYRIGHT = 100 + 2;
	int CRYPT_OPTION_INFO_MAJORVERSION = 100 + 3;
	int CRYPT_OPTION_INFO_MINORVERSION = 100 + 4;
	int CRYPT_OPTION_INFO_STEPPING = 100 + 5;
	int CRYPT_OPTION_ENCR_ALGO = 100 + 6;
	int CRYPT_OPTION_ENCR_HASH = 100 + 7;
	int CRYPT_OPTION_ENCR_MAC = 100 + 8;
	int CRYPT_OPTION_PKC_ALGO = 100 + 9;
	int CRYPT_OPTION_PKC_KEYSIZE = 100 + 10;
	int CRYPT_OPTION_SIG_ALGO = 100 + 11;
	int CRYPT_OPTION_SIG_KEYSIZE = 100 + 12;
	int CRYPT_OPTION_KEYING_ALGO = 100 + 13;
	int CRYPT_OPTION_KEYING_ITERATIONS = 100 + 14;
	int CRYPT_OPTION_CERT_SIGNUNRECOGNISEDATTRIBUTES = 100 + 15;
	int CRYPT_OPTION_CERT_VALIDITY = 100 + 16;
	int CRYPT_OPTION_CERT_UPDATEINTERVAL = 100 + 17;
	int CRYPT_OPTION_CERT_OBLIVIOUS = 100 + 18;
	int CRYPT_OPTION_CMS_DEFAULTATTRIBUTES = 100 + 19;
	int CRYPT_OPTION_SMIME_DEFAULTATTRIBUTES = CRYPT_OPTION_CMS_DEFAULTATTRIBUTES + 0;
	int CRYPT_OPTION_KEYS_LDAP_OBJECTCLASS = CRYPT_OPTION_CMS_DEFAULTATTRIBUTES + 1;
	int CRYPT_OPTION_KEYS_LDAP_OBJECTTYPE = CRYPT_OPTION_CMS_DEFAULTATTRIBUTES + 2;
	int CRYPT_OPTION_KEYS_LDAP_FILTER = CRYPT_OPTION_CMS_DEFAULTATTRIBUTES + 3;
	int CRYPT_OPTION_KEYS_LDAP_CACERTNAME = CRYPT_OPTION_CMS_DEFAULTATTRIBUTES + 4;
	int CRYPT_OPTION_KEYS_LDAP_CERTNAME = CRYPT_OPTION_CMS_DEFAULTATTRIBUTES + 5;
	int CRYPT_OPTION_KEYS_LDAP_CRLNAME = CRYPT_OPTION_CMS_DEFAULTATTRIBUTES + 6;
	int CRYPT_OPTION_KEYS_LDAP_EMAILNAME = CRYPT_OPTION_CMS_DEFAULTATTRIBUTES + 7;
	int CRYPT_OPTION_DEVICE_PKCS11_DVR01 = CRYPT_OPTION_CMS_DEFAULTATTRIBUTES + 8;
	int CRYPT_OPTION_DEVICE_PKCS11_DVR02 = CRYPT_OPTION_CMS_DEFAULTATTRIBUTES + 9;
	int CRYPT_OPTION_DEVICE_PKCS11_DVR03 = CRYPT_OPTION_CMS_DEFAULTATTRIBUTES + 10;
	int CRYPT_OPTION_DEVICE_PKCS11_DVR04 = CRYPT_OPTION_CMS_DEFAULTATTRIBUTES + 11;
	int CRYPT_OPTION_DEVICE_PKCS11_DVR05 = CRYPT_OPTION_CMS_DEFAULTATTRIBUTES + 12;
	int CRYPT_OPTION_DEVICE_PKCS11_HARDWAREONLY = CRYPT_OPTION_CMS_DEFAULTATTRIBUTES + 13;
	int CRYPT_OPTION_NET_SOCKS_SERVER = CRYPT_OPTION_CMS_DEFAULTATTRIBUTES + 14;
	int CRYPT_OPTION_NET_SOCKS_USERNAME = CRYPT_OPTION_CMS_DEFAULTATTRIBUTES + 15;
	int CRYPT_OPTION_NET_HTTP_PROXY = CRYPT_OPTION_CMS_DEFAULTATTRIBUTES + 16;
	int CRYPT_OPTION_NET_CONNECTTIMEOUT = CRYPT_OPTION_CMS_DEFAULTATTRIBUTES + 17;
	int CRYPT_OPTION_NET_TIMEOUT = CRYPT_OPTION_CMS_DEFAULTATTRIBUTES + 18;
	int CRYPT_OPTION_MISC_ASYNCINIT = CRYPT_OPTION_CMS_DEFAULTATTRIBUTES + 19;
	int CRYPT_OPTION_CONFIGCHANGED = CRYPT_OPTION_CMS_DEFAULTATTRIBUTES + 20;
	int CRYPT_OPTION_SELFTESTOK = CRYPT_OPTION_CMS_DEFAULTATTRIBUTES + 21;
	int CRYPT_OPTION_LAST = CRYPT_OPTION_CMS_DEFAULTATTRIBUTES + 22;
	int CRYPT_CTXINFO_FIRST = 1000 + 0;
	int CRYPT_CTXINFO_ALGO = 1000 + 1;
	int CRYPT_CTXINFO_MODE = 1000 + 2;
	int CRYPT_CTXINFO_NAME_ALGO = 1000 + 3;
	int CRYPT_CTXINFO_NAME_MODE = 1000 + 4;
	int CRYPT_CTXINFO_KEYSIZE = 1000 + 5;
	int CRYPT_CTXINFO_BLOCKSIZE = 1000 + 6;
	int CRYPT_CTXINFO_IVSIZE = 1000 + 7;
	int CRYPT_CTXINFO_KEYING_ALGO = 1000 + 8;
	int CRYPT_CTXINFO_KEYING_ITERATIONS = 1000 + 9;
	int CRYPT_CTXINFO_KEYING_SALT = 1000 + 10;
	int CRYPT_CTXINFO_KEYING_VALUE = 1000 + 11;
	int CRYPT_CTXINFO_KEY = 1000 + 12;
	int CRYPT_CTXINFO_KEY_COMPONENTS = 1000 + 13;
	int CRYPT_CTXINFO_IV = 1000 + 14;
	int CRYPT_CTXINFO_HASHVALUE = 1000 + 15;
	int CRYPT_CTXINFO_LABEL = 1000 + 16;
	int CRYPT_CTXINFO_LAST = 1000 + 17;
	int CRYPT_CERTINFO_FIRST = 2000 + 0;
	int CRYPT_CERTINFO_SELFSIGNED = 2000 + 1;
	int CRYPT_CERTINFO_IMMUTABLE = 2000 + 2;
	int CRYPT_CERTINFO_XYZZY = 2000 + 3;
	int CRYPT_CERTINFO_CERTTYPE = 2000 + 4;
	int CRYPT_CERTINFO_FINGERPRINT = 2000 + 5;
	int CRYPT_CERTINFO_FINGERPRINT_MD5 = CRYPT_CERTINFO_FINGERPRINT + 0;
	int CRYPT_CERTINFO_FINGERPRINT_SHA = CRYPT_CERTINFO_FINGERPRINT + 1;
	int CRYPT_CERTINFO_CURRENT_CERTIFICATE = CRYPT_CERTINFO_FINGERPRINT + 2;
	int CRYPT_CERTINFO_CURRENT_EXTENSION = CRYPT_CERTINFO_FINGERPRINT + 3;
	int CRYPT_CERTINFO_CURRENT_FIELD = CRYPT_CERTINFO_FINGERPRINT + 4;
	int CRYPT_CERTINFO_CURRENT_COMPONENT = CRYPT_CERTINFO_FINGERPRINT + 5;
	int CRYPT_CERTINFO_TRUSTED_USAGE = CRYPT_CERTINFO_FINGERPRINT + 6;
	int CRYPT_CERTINFO_TRUSTED_IMPLICIT = CRYPT_CERTINFO_FINGERPRINT + 7;
	int CRYPT_CERTINFO_SIGNATURELEVEL = CRYPT_CERTINFO_FINGERPRINT + 8;
	int CRYPT_CERTINFO_VERSION = CRYPT_CERTINFO_FINGERPRINT + 9;
	int CRYPT_CERTINFO_SERIALNUMBER = CRYPT_CERTINFO_FINGERPRINT + 10;
	int CRYPT_CERTINFO_SUBJECTPUBLICKEYINFO = CRYPT_CERTINFO_FINGERPRINT + 11;
	int CRYPT_CERTINFO_USERCERTIFICATE = CRYPT_CERTINFO_FINGERPRINT + 12;
	int CRYPT_CERTINFO_CERTIFICATE = CRYPT_CERTINFO_USERCERTIFICATE + 0;
	int CRYPT_CERTINFO_CACERTIFICATE = CRYPT_CERTINFO_USERCERTIFICATE + 1;
	int CRYPT_CERTINFO_ISSUERNAME = CRYPT_CERTINFO_USERCERTIFICATE + 2;
	int CRYPT_CERTINFO_VALIDFROM = CRYPT_CERTINFO_USERCERTIFICATE + 3;
	int CRYPT_CERTINFO_VALIDTO = CRYPT_CERTINFO_USERCERTIFICATE + 4;
	int CRYPT_CERTINFO_SUBJECTNAME = CRYPT_CERTINFO_USERCERTIFICATE + 5;
	int CRYPT_CERTINFO_ISSUERUNIQUEID = CRYPT_CERTINFO_USERCERTIFICATE + 6;
	int CRYPT_CERTINFO_SUBJECTUNIQUEID = CRYPT_CERTINFO_USERCERTIFICATE + 7;
	int CRYPT_CERTINFO_CERTREQUEST = CRYPT_CERTINFO_USERCERTIFICATE + 8;
	int CRYPT_CERTINFO_THISUPDATE = CRYPT_CERTINFO_USERCERTIFICATE + 9;
	int CRYPT_CERTINFO_NEXTUPDATE = CRYPT_CERTINFO_USERCERTIFICATE + 10;
	int CRYPT_CERTINFO_REVOCATIONDATE = CRYPT_CERTINFO_USERCERTIFICATE + 11;
	int CRYPT_CERTINFO_REVOCATIONSTATUS = CRYPT_CERTINFO_USERCERTIFICATE + 12;
	int CRYPT_CERTINFO_CERTSTATUS = CRYPT_CERTINFO_USERCERTIFICATE + 13;
	int CRYPT_CERTINFO_DN = CRYPT_CERTINFO_USERCERTIFICATE + 14;
	int CRYPT_CERTINFO_PKIUSER_ID = CRYPT_CERTINFO_USERCERTIFICATE + 15;
	int CRYPT_CERTINFO_PKIUSER_ISSUEPASSWORD = CRYPT_CERTINFO_USERCERTIFICATE + 16;
	int CRYPT_CERTINFO_PKIUSER_REVPASSWORD = CRYPT_CERTINFO_USERCERTIFICATE + 17;
	int CRYPT_CERTINFO_COUNTRYNAME = CRYPT_CERTINFO_FIRST + 100 + 0;
	int CRYPT_CERTINFO_STATEORPROVINCENAME = CRYPT_CERTINFO_FIRST + 100 + 1;
	int CRYPT_CERTINFO_LOCALITYNAME = CRYPT_CERTINFO_FIRST + 100 + 2;
	int CRYPT_CERTINFO_ORGANIZATIONNAME = CRYPT_CERTINFO_FIRST + 100 + 3;
	int CRYPT_CERTINFO_ORGANISATIONNAME = CRYPT_CERTINFO_ORGANIZATIONNAME + 0;
	int CRYPT_CERTINFO_ORGANIZATIONALUNITNAME = CRYPT_CERTINFO_ORGANIZATIONNAME + 1;
	int CRYPT_CERTINFO_ORGANISATIONALUNITNAME = CRYPT_CERTINFO_ORGANIZATIONALUNITNAME + 0;
	int CRYPT_CERTINFO_COMMONNAME = CRYPT_CERTINFO_ORGANIZATIONALUNITNAME + 1;
	int CRYPT_CERTINFO_OTHERNAME_TYPEID = CRYPT_CERTINFO_ORGANIZATIONALUNITNAME + 2;
	int CRYPT_CERTINFO_OTHERNAME_VALUE = CRYPT_CERTINFO_ORGANIZATIONALUNITNAME + 3;
	int CRYPT_CERTINFO_RFC822NAME = CRYPT_CERTINFO_ORGANIZATIONALUNITNAME + 4;
	int CRYPT_CERTINFO_EMAIL = CRYPT_CERTINFO_RFC822NAME + 0;
	int CRYPT_CERTINFO_DNSNAME = CRYPT_CERTINFO_RFC822NAME + 1;
	int CRYPT_CERTINFO_DIRECTORYNAME = CRYPT_CERTINFO_RFC822NAME + 2;
	int CRYPT_CERTINFO_EDIPARTYNAME_NAMEASSIGNER = CRYPT_CERTINFO_RFC822NAME + 3;
	int CRYPT_CERTINFO_EDIPARTYNAME_PARTYNAME = CRYPT_CERTINFO_RFC822NAME + 4;
	int CRYPT_CERTINFO_UNIFORMRESOURCEIDENTIFIER = CRYPT_CERTINFO_RFC822NAME + 5;
	int CRYPT_CERTINFO_IPADDRESS = CRYPT_CERTINFO_RFC822NAME + 6;
	int CRYPT_CERTINFO_REGISTEREDID = CRYPT_CERTINFO_RFC822NAME + 7;
	int CRYPT_CERTINFO_CRLEXTREASON = CRYPT_CERTINFO_FIRST + 200 + 0;
	int CRYPT_CERTINFO_KEYFEATURES = CRYPT_CERTINFO_FIRST + 200 + 1;
	int CRYPT_CERTINFO_AUTHORITYINFOACCESS = CRYPT_CERTINFO_FIRST + 200 + 2;
	int CRYPT_CERTINFO_AUTHORITYINFO_OCSP = CRYPT_CERTINFO_FIRST + 200 + 3;
	int CRYPT_CERTINFO_AUTHORITYINFO_CAISSUERS = CRYPT_CERTINFO_FIRST + 200 + 4;
	int CRYPT_CERTINFO_AUTHORITYINFO_TIMESTAMPING = CRYPT_CERTINFO_FIRST + 200 + 5;
	int CRYPT_CERTINFO_OCSP_NONCE = CRYPT_CERTINFO_FIRST + 200 + 6;
	int CRYPT_CERTINFO_OCSP_RESPONSE = CRYPT_CERTINFO_FIRST + 200 + 7;
	int CRYPT_CERTINFO_OCSP_RESPONSE_OCSP = CRYPT_CERTINFO_FIRST + 200 + 8;
	int CRYPT_CERTINFO_OCSP_RESPONSE_RTCS = CRYPT_CERTINFO_FIRST + 200 + 9;
	int CRYPT_CERTINFO_OCSP_RESPONSE_RTCS_EXT = CRYPT_CERTINFO_FIRST + 200 + 10;
	int CRYPT_CERTINFO_OCSP_NOCHECK = CRYPT_CERTINFO_FIRST + 200 + 11;
	int CRYPT_CERTINFO_OCSP_ARCHIVECUTOFF = CRYPT_CERTINFO_FIRST + 200 + 12;
	int CRYPT_CERTINFO_SUBJECTINFOACCESS = CRYPT_CERTINFO_FIRST + 200 + 13;
	int CRYPT_CERTINFO_SUBJECTINFO_CAREPOSITORY = CRYPT_CERTINFO_FIRST + 200 + 14;
	int CRYPT_CERTINFO_SUBJECTINFO_TIMESTAMPING = CRYPT_CERTINFO_FIRST + 200 + 15;
	int CRYPT_CERTINFO_SIGG_DATEOFCERTGEN = CRYPT_CERTINFO_FIRST + 200 + 16;
	int CRYPT_CERTINFO_SIGG_PROCURATION = CRYPT_CERTINFO_FIRST + 200 + 17;
	int CRYPT_CERTINFO_SIGG_PROCURE_COUNTRY = CRYPT_CERTINFO_FIRST + 200 + 18;
	int CRYPT_CERTINFO_SIGG_PROCURE_TYPEOFSUBSTITUTION = CRYPT_CERTINFO_FIRST + 200 + 19;
	int CRYPT_CERTINFO_SIGG_PROCURE_SIGNINGFOR = CRYPT_CERTINFO_FIRST + 200 + 20;
	int CRYPT_CERTINFO_SIGG_MONETARYLIMIT = CRYPT_CERTINFO_FIRST + 200 + 21;
	int CRYPT_CERTINFO_SIGG_MONETARY_CURRENCY = CRYPT_CERTINFO_FIRST + 200 + 22;
	int CRYPT_CERTINFO_SIGG_MONETARY_AMOUNT = CRYPT_CERTINFO_FIRST + 200 + 23;
	int CRYPT_CERTINFO_SIGG_MONETARY_EXPONENT = CRYPT_CERTINFO_FIRST + 200 + 24;
	int CRYPT_CERTINFO_SIGG_RESTRICTION = CRYPT_CERTINFO_FIRST + 200 + 25;
	int CRYPT_CERTINFO_STRONGEXTRANET = CRYPT_CERTINFO_FIRST + 200 + 26;
	int CRYPT_CERTINFO_STRONGEXTRANET_ZONE = CRYPT_CERTINFO_FIRST + 200 + 27;
	int CRYPT_CERTINFO_STRONGEXTRANET_ID = CRYPT_CERTINFO_FIRST + 200 + 28;
	int CRYPT_CERTINFO_SUBJECTDIRECTORYATTRIBUTES = CRYPT_CERTINFO_FIRST + 200 + 29;
	int CRYPT_CERTINFO_SUBJECTDIR_TYPE = CRYPT_CERTINFO_FIRST + 200 + 30;
	int CRYPT_CERTINFO_SUBJECTDIR_VALUES = CRYPT_CERTINFO_FIRST + 200 + 31;
	int CRYPT_CERTINFO_SUBJECTKEYIDENTIFIER = CRYPT_CERTINFO_FIRST + 200 + 32;
	int CRYPT_CERTINFO_KEYUSAGE = CRYPT_CERTINFO_FIRST + 200 + 33;
	int CRYPT_CERTINFO_PRIVATEKEYUSAGEPERIOD = CRYPT_CERTINFO_FIRST + 200 + 34;
	int CRYPT_CERTINFO_PRIVATEKEY_NOTBEFORE = CRYPT_CERTINFO_FIRST + 200 + 35;
	int CRYPT_CERTINFO_PRIVATEKEY_NOTAFTER = CRYPT_CERTINFO_FIRST + 200 + 36;
	int CRYPT_CERTINFO_SUBJECTALTNAME = CRYPT_CERTINFO_FIRST + 200 + 37;
	int CRYPT_CERTINFO_ISSUERALTNAME = CRYPT_CERTINFO_FIRST + 200 + 38;
	int CRYPT_CERTINFO_BASICCONSTRAINTS = CRYPT_CERTINFO_FIRST + 200 + 39;
	int CRYPT_CERTINFO_CA = CRYPT_CERTINFO_FIRST + 200 + 40;
	int CRYPT_CERTINFO_AUTHORITY = CRYPT_CERTINFO_CA + 0;
	int CRYPT_CERTINFO_PATHLENCONSTRAINT = CRYPT_CERTINFO_CA + 1;
	int CRYPT_CERTINFO_CRLNUMBER = CRYPT_CERTINFO_CA + 2;
	int CRYPT_CERTINFO_CRLREASON = CRYPT_CERTINFO_CA + 3;
	int CRYPT_CERTINFO_HOLDINSTRUCTIONCODE = CRYPT_CERTINFO_CA + 4;
	int CRYPT_CERTINFO_INVALIDITYDATE = CRYPT_CERTINFO_CA + 5;
	int CRYPT_CERTINFO_DELTACRLINDICATOR = CRYPT_CERTINFO_CA + 6;
	int CRYPT_CERTINFO_ISSUINGDISTRIBUTIONPOINT = CRYPT_CERTINFO_CA + 7;
	int CRYPT_CERTINFO_ISSUINGDIST_FULLNAME = CRYPT_CERTINFO_CA + 8;
	int CRYPT_CERTINFO_ISSUINGDIST_USERCERTSONLY = CRYPT_CERTINFO_CA + 9;
	int CRYPT_CERTINFO_ISSUINGDIST_CACERTSONLY = CRYPT_CERTINFO_CA + 10;
	int CRYPT_CERTINFO_ISSUINGDIST_SOMEREASONSONLY = CRYPT_CERTINFO_CA + 11;
	int CRYPT_CERTINFO_ISSUINGDIST_INDIRECTCRL = CRYPT_CERTINFO_CA + 12;
	int CRYPT_CERTINFO_CERTIFICATEISSUER = CRYPT_CERTINFO_CA + 13;
	int CRYPT_CERTINFO_NAMECONSTRAINTS = CRYPT_CERTINFO_CA + 14;
	int CRYPT_CERTINFO_PERMITTEDSUBTREES = CRYPT_CERTINFO_CA + 15;
	int CRYPT_CERTINFO_EXCLUDEDSUBTREES = CRYPT_CERTINFO_CA + 16;
	int CRYPT_CERTINFO_CRLDISTRIBUTIONPOINT = CRYPT_CERTINFO_CA + 17;
	int CRYPT_CERTINFO_CRLDIST_FULLNAME = CRYPT_CERTINFO_CA + 18;
	int CRYPT_CERTINFO_CRLDIST_REASONS = CRYPT_CERTINFO_CA + 19;
	int CRYPT_CERTINFO_CRLDIST_CRLISSUER = CRYPT_CERTINFO_CA + 20;
	int CRYPT_CERTINFO_CERTIFICATEPOLICIES = CRYPT_CERTINFO_CA + 21;
	int CRYPT_CERTINFO_CERTPOLICYID = CRYPT_CERTINFO_CA + 22;
	int CRYPT_CERTINFO_CERTPOLICY_CPSURI = CRYPT_CERTINFO_CA + 23;
	int CRYPT_CERTINFO_CERTPOLICY_ORGANIZATION = CRYPT_CERTINFO_CA + 24;
	int CRYPT_CERTINFO_CERTPOLICY_NOTICENUMBERS = CRYPT_CERTINFO_CA + 25;
	int CRYPT_CERTINFO_CERTPOLICY_EXPLICITTEXT = CRYPT_CERTINFO_CA + 26;
	int CRYPT_CERTINFO_POLICYMAPPINGS = CRYPT_CERTINFO_CA + 27;
	int CRYPT_CERTINFO_ISSUERDOMAINPOLICY = CRYPT_CERTINFO_CA + 28;
	int CRYPT_CERTINFO_SUBJECTDOMAINPOLICY = CRYPT_CERTINFO_CA + 29;
	int CRYPT_CERTINFO_AUTHORITYKEYIDENTIFIER = CRYPT_CERTINFO_CA + 30;
	int CRYPT_CERTINFO_AUTHORITY_KEYIDENTIFIER = CRYPT_CERTINFO_CA + 31;
	int CRYPT_CERTINFO_AUTHORITY_CERTISSUER = CRYPT_CERTINFO_CA + 32;
	int CRYPT_CERTINFO_AUTHORITY_CERTSERIALNUMBER = CRYPT_CERTINFO_CA + 33;
	int CRYPT_CERTINFO_POLICYCONSTRAINTS = CRYPT_CERTINFO_CA + 34;
	int CRYPT_CERTINFO_REQUIREEXPLICITPOLICY = CRYPT_CERTINFO_CA + 35;
	int CRYPT_CERTINFO_INHIBITPOLICYMAPPING = CRYPT_CERTINFO_CA + 36;
	int CRYPT_CERTINFO_EXTKEYUSAGE = CRYPT_CERTINFO_CA + 37;
	int CRYPT_CERTINFO_EXTKEY_MS_INDIVIDUALCODESIGNING = CRYPT_CERTINFO_CA + 38;
	int CRYPT_CERTINFO_EXTKEY_MS_COMMERCIALCODESIGNING = CRYPT_CERTINFO_CA + 39;
	int CRYPT_CERTINFO_EXTKEY_MS_CERTTRUSTLISTSIGNING = CRYPT_CERTINFO_CA + 40;
	int CRYPT_CERTINFO_EXTKEY_MS_TIMESTAMPSIGNING = CRYPT_CERTINFO_CA + 41;
	int CRYPT_CERTINFO_EXTKEY_MS_SERVERGATEDCRYPTO = CRYPT_CERTINFO_CA + 42;
	int CRYPT_CERTINFO_EXTKEY_MS_ENCRYPTEDFILESYSTEM = CRYPT_CERTINFO_CA + 43;
	int CRYPT_CERTINFO_EXTKEY_SERVERAUTH = CRYPT_CERTINFO_CA + 44;
	int CRYPT_CERTINFO_EXTKEY_CLIENTAUTH = CRYPT_CERTINFO_CA + 45;
	int CRYPT_CERTINFO_EXTKEY_CODESIGNING = CRYPT_CERTINFO_CA + 46;
	int CRYPT_CERTINFO_EXTKEY_EMAILPROTECTION = CRYPT_CERTINFO_CA + 47;
	int CRYPT_CERTINFO_EXTKEY_IPSECENDSYSTEM = CRYPT_CERTINFO_CA + 48;
	int CRYPT_CERTINFO_EXTKEY_IPSECTUNNEL = CRYPT_CERTINFO_CA + 49;
	int CRYPT_CERTINFO_EXTKEY_IPSECUSER = CRYPT_CERTINFO_CA + 50;
	int CRYPT_CERTINFO_EXTKEY_TIMESTAMPING = CRYPT_CERTINFO_CA + 51;
	int CRYPT_CERTINFO_EXTKEY_OCSPSIGNING = CRYPT_CERTINFO_CA + 52;
	int CRYPT_CERTINFO_EXTKEY_DIRECTORYSERVICE = CRYPT_CERTINFO_CA + 53;
	int CRYPT_CERTINFO_EXTKEY_NS_SERVERGATEDCRYPTO = CRYPT_CERTINFO_CA + 54;
	int CRYPT_CERTINFO_EXTKEY_VS_SERVERGATEDCRYPTO_CA = CRYPT_CERTINFO_CA + 55;
	int CRYPT_CERTINFO_FRESHESTCRL = CRYPT_CERTINFO_CA + 56;
	int CRYPT_CERTINFO_FRESHESTCRL_FULLNAME = CRYPT_CERTINFO_CA + 57;
	int CRYPT_CERTINFO_FRESHESTCRL_REASONS = CRYPT_CERTINFO_CA + 58;
	int CRYPT_CERTINFO_FRESHESTCRL_CRLISSUER = CRYPT_CERTINFO_CA + 59;
	int CRYPT_CERTINFO_INHIBITANYPOLICY = CRYPT_CERTINFO_CA + 60;
	int CRYPT_CERTINFO_NS_CERTTYPE = CRYPT_CERTINFO_CA + 61;
	int CRYPT_CERTINFO_NS_BASEURL = CRYPT_CERTINFO_CA + 62;
	int CRYPT_CERTINFO_NS_REVOCATIONURL = CRYPT_CERTINFO_CA + 63;
	int CRYPT_CERTINFO_NS_CAREVOCATIONURL = CRYPT_CERTINFO_CA + 64;
	int CRYPT_CERTINFO_NS_CERTRENEWALURL = CRYPT_CERTINFO_CA + 65;
	int CRYPT_CERTINFO_NS_CAPOLICYURL = CRYPT_CERTINFO_CA + 66;
	int CRYPT_CERTINFO_NS_SSLSERVERNAME = CRYPT_CERTINFO_CA + 67;
	int CRYPT_CERTINFO_NS_COMMENT = CRYPT_CERTINFO_CA + 68;
	int CRYPT_CERTINFO_SET_HASHEDROOTKEY = CRYPT_CERTINFO_CA + 69;
	int CRYPT_CERTINFO_SET_ROOTKEYTHUMBPRINT = CRYPT_CERTINFO_CA + 70;
	int CRYPT_CERTINFO_SET_CERTIFICATETYPE = CRYPT_CERTINFO_CA + 71;
	int CRYPT_CERTINFO_SET_MERCHANTDATA = CRYPT_CERTINFO_CA + 72;
	int CRYPT_CERTINFO_SET_MERID = CRYPT_CERTINFO_CA + 73;
	int CRYPT_CERTINFO_SET_MERACQUIRERBIN = CRYPT_CERTINFO_CA + 74;
	int CRYPT_CERTINFO_SET_MERCHANTLANGUAGE = CRYPT_CERTINFO_CA + 75;
	int CRYPT_CERTINFO_SET_MERCHANTNAME = CRYPT_CERTINFO_CA + 76;
	int CRYPT_CERTINFO_SET_MERCHANTCITY = CRYPT_CERTINFO_CA + 77;
	int CRYPT_CERTINFO_SET_MERCHANTSTATEPROVINCE = CRYPT_CERTINFO_CA + 78;
	int CRYPT_CERTINFO_SET_MERCHANTPOSTALCODE = CRYPT_CERTINFO_CA + 79;
	int CRYPT_CERTINFO_SET_MERCHANTCOUNTRYNAME = CRYPT_CERTINFO_CA + 80;
	int CRYPT_CERTINFO_SET_MERCOUNTRY = CRYPT_CERTINFO_CA + 81;
	int CRYPT_CERTINFO_SET_MERAUTHFLAG = CRYPT_CERTINFO_CA + 82;
	int CRYPT_CERTINFO_SET_CERTCARDREQUIRED = CRYPT_CERTINFO_CA + 83;
	int CRYPT_CERTINFO_SET_TUNNELING = CRYPT_CERTINFO_CA + 84;
	int CRYPT_CERTINFO_SET_TUNNELLING = CRYPT_CERTINFO_SET_TUNNELING + 0;
	int CRYPT_CERTINFO_SET_TUNNELINGFLAG = CRYPT_CERTINFO_SET_TUNNELING + 1;
	int CRYPT_CERTINFO_SET_TUNNELLINGFLAG = CRYPT_CERTINFO_SET_TUNNELINGFLAG + 0;
	int CRYPT_CERTINFO_SET_TUNNELINGALGID = CRYPT_CERTINFO_SET_TUNNELINGFLAG + 1;
	int CRYPT_CERTINFO_SET_TUNNELLINGALGID = CRYPT_CERTINFO_SET_TUNNELINGALGID + 0;
	int CRYPT_CERTINFO_CMS_CONTENTTYPE = CRYPT_CERTINFO_FIRST + 500 + 0;
	int CRYPT_CERTINFO_CMS_MESSAGEDIGEST = CRYPT_CERTINFO_FIRST + 500 + 1;
	int CRYPT_CERTINFO_CMS_SIGNINGTIME = CRYPT_CERTINFO_FIRST + 500 + 2;
	int CRYPT_CERTINFO_CMS_COUNTERSIGNATURE = CRYPT_CERTINFO_FIRST + 500 + 3;
	int CRYPT_CERTINFO_CMS_SMIMECAPABILITIES = CRYPT_CERTINFO_FIRST + 500 + 4;
	int CRYPT_CERTINFO_CMS_SMIMECAP_3DES = CRYPT_CERTINFO_FIRST + 500 + 5;
	int CRYPT_CERTINFO_CMS_SMIMECAP_AES = CRYPT_CERTINFO_FIRST + 500 + 6;
	int CRYPT_CERTINFO_CMS_SMIMECAP_CAST128 = CRYPT_CERTINFO_FIRST + 500 + 7;
	int CRYPT_CERTINFO_CMS_SMIMECAP_IDEA = CRYPT_CERTINFO_FIRST + 500 + 8;
	int CRYPT_CERTINFO_CMS_SMIMECAP_RC2 = CRYPT_CERTINFO_FIRST + 500 + 9;
	int CRYPT_CERTINFO_CMS_SMIMECAP_RC5 = CRYPT_CERTINFO_FIRST + 500 + 10;
	int CRYPT_CERTINFO_CMS_SMIMECAP_SKIPJACK = CRYPT_CERTINFO_FIRST + 500 + 11;
	int CRYPT_CERTINFO_CMS_SMIMECAP_DES = CRYPT_CERTINFO_FIRST + 500 + 12;
	int CRYPT_CERTINFO_CMS_SMIMECAP_PREFERSIGNEDDATA = CRYPT_CERTINFO_FIRST + 500 + 13;
	int CRYPT_CERTINFO_CMS_SMIMECAP_CANNOTDECRYPTANY = CRYPT_CERTINFO_FIRST + 500 + 14;
	int CRYPT_CERTINFO_CMS_RECEIPTREQUEST = CRYPT_CERTINFO_FIRST + 500 + 15;
	int CRYPT_CERTINFO_CMS_RECEIPT_CONTENTIDENTIFIER = CRYPT_CERTINFO_FIRST + 500 + 16;
	int CRYPT_CERTINFO_CMS_RECEIPT_FROM = CRYPT_CERTINFO_FIRST + 500 + 17;
	int CRYPT_CERTINFO_CMS_RECEIPT_TO = CRYPT_CERTINFO_FIRST + 500 + 18;
	int CRYPT_CERTINFO_CMS_SECURITYLABEL = CRYPT_CERTINFO_FIRST + 500 + 19;
	int CRYPT_CERTINFO_CMS_SECLABEL_CLASSIFICATION = CRYPT_CERTINFO_FIRST + 500 + 20;
	int CRYPT_CERTINFO_CMS_SECLABEL_POLICY = CRYPT_CERTINFO_FIRST + 500 + 21;
	int CRYPT_CERTINFO_CMS_SECLABEL_PRIVACYMARK = CRYPT_CERTINFO_FIRST + 500 + 22;
	int CRYPT_CERTINFO_CMS_SECLABEL_CATTYPE = CRYPT_CERTINFO_FIRST + 500 + 23;
	int CRYPT_CERTINFO_CMS_SECLABEL_CATVALUE = CRYPT_CERTINFO_FIRST + 500 + 24;
	int CRYPT_CERTINFO_CMS_MLEXPANSIONHISTORY = CRYPT_CERTINFO_FIRST + 500 + 25;
	int CRYPT_CERTINFO_CMS_MLEXP_ENTITYIDENTIFIER = CRYPT_CERTINFO_FIRST + 500 + 26;
	int CRYPT_CERTINFO_CMS_MLEXP_TIME = CRYPT_CERTINFO_FIRST + 500 + 27;
	int CRYPT_CERTINFO_CMS_MLEXP_NONE = CRYPT_CERTINFO_FIRST + 500 + 28;
	int CRYPT_CERTINFO_CMS_MLEXP_INSTEADOF = CRYPT_CERTINFO_FIRST + 500 + 29;
	int CRYPT_CERTINFO_CMS_MLEXP_INADDITIONTO = CRYPT_CERTINFO_FIRST + 500 + 30;
	int CRYPT_CERTINFO_CMS_CONTENTHINTS = CRYPT_CERTINFO_FIRST + 500 + 31;
	int CRYPT_CERTINFO_CMS_CONTENTHINT_DESCRIPTION = CRYPT_CERTINFO_FIRST + 500 + 32;
	int CRYPT_CERTINFO_CMS_CONTENTHINT_TYPE = CRYPT_CERTINFO_FIRST + 500 + 33;
	int CRYPT_CERTINFO_CMS_EQUIVALENTLABEL = CRYPT_CERTINFO_FIRST + 500 + 34;
	int CRYPT_CERTINFO_CMS_EQVLABEL_POLICY = CRYPT_CERTINFO_FIRST + 500 + 35;
	int CRYPT_CERTINFO_CMS_EQVLABEL_CLASSIFICATION = CRYPT_CERTINFO_FIRST + 500 + 36;
	int CRYPT_CERTINFO_CMS_EQVLABEL_PRIVACYMARK = CRYPT_CERTINFO_FIRST + 500 + 37;
	int CRYPT_CERTINFO_CMS_EQVLABEL_CATTYPE = CRYPT_CERTINFO_FIRST + 500 + 38;
	int CRYPT_CERTINFO_CMS_EQVLABEL_CATVALUE = CRYPT_CERTINFO_FIRST + 500 + 39;
	int CRYPT_CERTINFO_CMS_SIGNINGCERTIFICATE = CRYPT_CERTINFO_FIRST + 500 + 40;
	int CRYPT_CERTINFO_CMS_SIGNINGCERT_ESSCERTID = CRYPT_CERTINFO_FIRST + 500 + 41;
	int CRYPT_CERTINFO_CMS_SIGNINGCERT_POLICIES = CRYPT_CERTINFO_FIRST + 500 + 42;
	int CRYPT_CERTINFO_CMS_SIGTYPEIDENTIFIER = CRYPT_CERTINFO_FIRST + 500 + 43;
	int CRYPT_CERTINFO_CMS_SIGTYPEID_ORIGINATORSIG = CRYPT_CERTINFO_FIRST + 500 + 44;
	int CRYPT_CERTINFO_CMS_SIGTYPEID_DOMAINSIG = CRYPT_CERTINFO_FIRST + 500 + 45;
	int CRYPT_CERTINFO_CMS_SIGTYPEID_ADDITIONALATTRIBUTES = CRYPT_CERTINFO_FIRST + 500 + 46;
	int CRYPT_CERTINFO_CMS_SIGTYPEID_REVIEWSIG = CRYPT_CERTINFO_FIRST + 500 + 47;
	int CRYPT_CERTINFO_CMS_SPCAGENCYINFO = CRYPT_CERTINFO_FIRST + 500 + 48;
	int CRYPT_CERTINFO_CMS_SPCAGENCYURL = CRYPT_CERTINFO_FIRST + 500 + 49;
	int CRYPT_CERTINFO_CMS_SPCSTATEMENTTYPE = CRYPT_CERTINFO_FIRST + 500 + 50;
	int CRYPT_CERTINFO_CMS_SPCSTMT_INDIVIDUALCODESIGNING = CRYPT_CERTINFO_FIRST + 500 + 51;
	int CRYPT_CERTINFO_CMS_SPCSTMT_COMMERCIALCODESIGNING = CRYPT_CERTINFO_FIRST + 500 + 52;
	int CRYPT_CERTINFO_CMS_SPCOPUSINFO = CRYPT_CERTINFO_FIRST + 500 + 53;
	int CRYPT_CERTINFO_CMS_SPCOPUSINFO_NAME = CRYPT_CERTINFO_FIRST + 500 + 54;
	int CRYPT_CERTINFO_CMS_SPCOPUSINFO_URL = CRYPT_CERTINFO_FIRST + 500 + 55;
	int CRYPT_CERTINFO_LAST = CRYPT_CERTINFO_FIRST + 500 + 56;
	int CRYPT_KEYINFO_FIRST = 3000 + 0;
	int CRYPT_KEYINFO_QUERY = 3000 + 1;
	int CRYPT_KEYINFO_QUERY_REQUESTS = 3000 + 2;
	int CRYPT_KEYINFO_LAST = 3000 + 3;
	int CRYPT_DEVINFO_FIRST = 4000 + 0;
	int CRYPT_DEVINFO_INITIALISE = 4000 + 1;
	int CRYPT_DEVINFO_INITIALIZE = CRYPT_DEVINFO_INITIALISE + 0;
	int CRYPT_DEVINFO_AUTHENT_USER = CRYPT_DEVINFO_INITIALISE + 1;
	int CRYPT_DEVINFO_AUTHENT_SUPERVISOR = CRYPT_DEVINFO_INITIALISE + 2;
	int CRYPT_DEVINFO_SET_AUTHENT_USER = CRYPT_DEVINFO_INITIALISE + 3;
	int CRYPT_DEVINFO_SET_AUTHENT_SUPERVISOR = CRYPT_DEVINFO_INITIALISE + 4;
	int CRYPT_DEVINFO_ZEROISE = CRYPT_DEVINFO_INITIALISE + 5;
	int CRYPT_DEVINFO_ZEROIZE = CRYPT_DEVINFO_ZEROISE + 0;
	int CRYPT_DEVINFO_LOGGEDIN = CRYPT_DEVINFO_ZEROISE + 1;
	int CRYPT_DEVINFO_LABEL = CRYPT_DEVINFO_ZEROISE + 2;
	int CRYPT_DEVINFO_LAST = CRYPT_DEVINFO_ZEROISE + 3;
	int CRYPT_ENVINFO_FIRST = 5000 + 0;
	int CRYPT_ENVINFO_DATASIZE = 5000 + 1;
	int CRYPT_ENVINFO_COMPRESSION = 5000 + 2;
	int CRYPT_ENVINFO_CONTENTTYPE = 5000 + 3;
	int CRYPT_ENVINFO_DETACHEDSIGNATURE = 5000 + 4;
	int CRYPT_ENVINFO_SIGNATURE_RESULT = 5000 + 5;
	int CRYPT_ENVINFO_MAC = 5000 + 6;
	int CRYPT_ENVINFO_CURRENT_COMPONENT = 5000 + 7;
	int CRYPT_ENVINFO_PASSWORD = 5000 + 8;
	int CRYPT_ENVINFO_KEY = 5000 + 9;
	int CRYPT_ENVINFO_SIGNATURE = 5000 + 10;
	int CRYPT_ENVINFO_SIGNATURE_EXTRADATA = 5000 + 11;
	int CRYPT_ENVINFO_RECIPIENT = 5000 + 12;
	int CRYPT_ENVINFO_PUBLICKEY = 5000 + 13;
	int CRYPT_ENVINFO_PRIVATEKEY = 5000 + 14;
	int CRYPT_ENVINFO_PRIVATEKEY_LABEL = 5000 + 15;
	int CRYPT_ENVINFO_ORIGINATOR = 5000 + 16;
	int CRYPT_ENVINFO_SESSIONKEY = 5000 + 17;
	int CRYPT_ENVINFO_HASH = 5000 + 18;
	int CRYPT_ENVINFO_TIMESTAMP_AUTHORITY = 5000 + 19;
	int CRYPT_ENVINFO_KEYSET_SIGCHECK = 5000 + 20;
	int CRYPT_ENVINFO_KEYSET_ENCRYPT = 5000 + 21;
	int CRYPT_ENVINFO_KEYSET_DECRYPT = 5000 + 22;
	int CRYPT_ENVINFO_LAST = 5000 + 23;
	int CRYPT_SESSINFO_FIRST = 6000 + 0;
	int CRYPT_SESSINFO_ACTIVE = 6000 + 1;
	int CRYPT_SESSINFO_CONNECTIONACTIVE = 6000 + 2;
	int CRYPT_SESSINFO_USERNAME = 6000 + 3;
	int CRYPT_SESSINFO_PASSWORD = 6000 + 4;
	int CRYPT_SESSINFO_PRIVATEKEY = 6000 + 5;
	int CRYPT_SESSINFO_KEYSET = 6000 + 6;
	int CRYPT_SESSINFO_SERVER_NAME = 6000 + 7;
	int CRYPT_SESSINFO_SERVER_PORT = 6000 + 8;
	int CRYPT_SESSINFO_CLIENT_NAME = 6000 + 9;
	int CRYPT_SESSINFO_CLIENT_PORT = 6000 + 10;
	int CRYPT_SESSINFO_SESSION = 6000 + 11;
	int CRYPT_SESSINFO_NETWORKSOCKET = 6000 + 12;
	int CRYPT_SESSINFO_VERSION = 6000 + 13;
	int CRYPT_SESSINFO_REQUEST = 6000 + 14;
	int CRYPT_SESSINFO_RESPONSE = 6000 + 15;
	int CRYPT_SESSINFO_TSP_MSGIMPRINT = 6000 + 16;
	int CRYPT_SESSINFO_CMP_CACERTIFICATE = 6000 + 17;
	int CRYPT_SESSINFO_CMP_REQUESTTYPE = 6000 + 18;
	int CRYPT_SESSINFO_CMP_PKIBOOT = 6000 + 19;
	int CRYPT_SESSINFO_SSH_FINGERPRINT = 6000 + 20;
	int CRYPT_SESSINFO_LAST = 6000 + 21;
	int CRYPT_USERINFO_FIRST = 7000 + 0;
	int CRYPT_USERINFO_PASSWORD = 7000 + 1;
	int CRYPT_USERINFO_CAKEY_CERTSIGN = 7000 + 2;
	int CRYPT_USERINFO_CAKEY_CRLSIGN = 7000 + 3;
	int CRYPT_USERINFO_CAKEY_OCSPSIGN = 7000 + 4;
	int CRYPT_USERINFO_LAST = 7000 + 5;
	int CRYPT_ATTRIBUTE_LAST = CRYPT_USERINFO_LAST + 0;

	int CRYPT_CRLREASON_UNSPECIFIED = 0;
	int CRYPT_CRLREASON_KEYCOMPROMISE = 1;
	int CRYPT_CRLREASON_CACOMPROMISE = 2;
	int CRYPT_CRLREASON_AFFILIATIONCHANGED = 3;
	int CRYPT_CRLREASON_SUPERSEDED = 4;
	int CRYPT_CRLREASON_CESSATIONOFOPERATION = 5;
	int CRYPT_CRLREASON_CERTIFICATEHOLD = 6;
	int CRYPT_CRLREASON_REMOVEFROMCRL = 8 + 0;
	int CRYPT_CRLREASON_LAST = 8 + 1;
	int CRYPT_CRLREASON_NEVERVALID = 10 + 0;
	int CRYPT_CRLEXTREASON_LAST = 10 + 1;

	int CRYPT_HOLDINSTRUCTION_NONE = 0;
	int CRYPT_HOLDINSTRUCTION_CALLISSUER = 1;
	int CRYPT_HOLDINSTRUCTION_REJECT = 2;
	int CRYPT_HOLDINSTRUCTION_PICKUPTOKEN = 3;
	int CRYPT_HOLDINSTRUCTION_LAST = 4;

	int CRYPT_CONTENT_NONE = 0;
	int CRYPT_CONTENT_DATA = 1;
	int CRYPT_CONTENT_SIGNEDDATA = 2;
	int CRYPT_CONTENT_ENVELOPEDDATA = 3;
	int CRYPT_CONTENT_SIGNEDANDENVELOPEDDATA = 4;
	int CRYPT_CONTENT_DIGESTEDDATA = 5;
	int CRYPT_CONTENT_ENCRYPTEDDATA = 6;
	int CRYPT_CONTENT_COMPRESSEDDATA = 7;
	int CRYPT_CONTENT_TSTINFO = 8;
	int CRYPT_CONTENT_SPCINDIRECTDATACONTEXT = 9;
	int CRYPT_CONTENT_LAST = 10;

	int CRYPT_CLASSIFICATION_UNMARKED = 0;
	int CRYPT_CLASSIFICATION_UNCLASSIFIED = 1;
	int CRYPT_CLASSIFICATION_RESTRICTED = 2;
	int CRYPT_CLASSIFICATION_CONFIDENTIAL = 3;
	int CRYPT_CLASSIFICATION_SECRET = 4;
	int CRYPT_CLASSIFICATION_TOP_SECRET = 5;
	int CRYPT_CLASSIFICATION_LAST = 255  + 0;

	int CRYPT_OCSPSTATUS_NOTREVOKED = 0;
	int CRYPT_OCSPSTATUS_REVOKED = 1;
	int CRYPT_OCSPSTATUS_UNKNOWN = 2;
	int CRYPT_OCSPEXTSTATUS_VALID = 3;
	int CRYPT_OCSPEXTSTATUS_NOTVALID = 4;
	int CRYPT_OCSPEXTSTATUS_NONAUTHORITATIVE = 5;
	int CRYPT_OCSPEXTSTATUS_UNKNOWN = 6;

	int CRYPT_CMPSTATUS_OK = 0;
	int CRYPT_CMPSTATUS_GRANTED = CRYPT_CMPSTATUS_OK + 0;
	int CRYPT_CMPSTATUS_GRANTEDWITHMODS = CRYPT_CMPSTATUS_OK + 1;
	int CRYPT_CMPSTATUS_REJECTION = CRYPT_CMPSTATUS_OK + 2;
	int CRYPT_CMPSTATUS_WAITING = CRYPT_CMPSTATUS_OK + 3;
	int CRYPT_CMPSTATUS_REVOCATIONWARNING = CRYPT_CMPSTATUS_OK + 4;
	int CRYPT_CMPSTATUS_REVOCATIONNOTIFICATION = CRYPT_CMPSTATUS_OK + 5;
	int CRYPT_CMPSTATUS_KEYUPDATEWARNING = CRYPT_CMPSTATUS_OK + 6;
	int CRYPT_CMPSTATUS_LAST = CRYPT_CMPSTATUS_OK + 7;

	int CRYPT_SIGNATURELEVEL_NONE = 0;
	int CRYPT_SIGNATURELEVEL_SIGNERCERT = 1;
	int CRYPT_SIGNATURELEVEL_ALL = 2;
	int CRYPT_SIGNATURELEVEL_LAST = 3;

	int CRYPT_CERTFORMAT_NONE = 0;
	int CRYPT_CERTFORMAT_CERTIFICATE = 1;
	int CRYPT_CERTFORMAT_CERTCHAIN = 2;
	int CRYPT_CERTFORMAT_TEXT_CERTIFICATE = 3;
	int CRYPT_CERTFORMAT_TEXT_CERTCHAIN = 4;
	int CRYPT_CERTFORMAT_LAST = 5;

	int CRYPT_REQUESTTYPE_NONE = 0;
	int CRYPT_REQUESTTYPE_INITIALISATION = 1;
	int CRYPT_REQUESTTYPE_INITIALIZATION = CRYPT_REQUESTTYPE_INITIALISATION + 0;
	int CRYPT_REQUESTTYPE_CERTIFICATE = CRYPT_REQUESTTYPE_INITIALISATION + 1;
	int CRYPT_REQUESTTYPE_KEYUPDATE = CRYPT_REQUESTTYPE_INITIALISATION + 2;
	int CRYPT_REQUESTTYPE_REVOCATION = CRYPT_REQUESTTYPE_INITIALISATION + 3;
	int CRYPT_REQUESTTYPE_LAST = CRYPT_REQUESTTYPE_INITIALISATION + 4;

	int CRYPT_KEYID_NONE = 0;
	int CRYPT_KEYID_NAME = 1;
	int CRYPT_KEYID_EMAIL = 2;
	int CRYPT_KEYID_LAST = 3;

	int CRYPT_OBJECT_NONE = 0;
	int CRYPT_OBJECT_ENCRYPTED_KEY = 1;
	int CRYPT_OBJECT_PKCENCRYPTED_KEY = 2;
	int CRYPT_OBJECT_KEYAGREEMENT = 3;
	int CRYPT_OBJECT_SIGNATURE = 4;
	int CRYPT_OBJECT_LAST = 5;

	int CRYPT_ERRTYPE_NONE = 0;
	int CRYPT_ERRTYPE_ATTR_SIZE = 1;
	int CRYPT_ERRTYPE_ATTR_VALUE = 2;
	int CRYPT_ERRTYPE_ATTR_ABSENT = 3;
	int CRYPT_ERRTYPE_ATTR_PRESENT = 4;
	int CRYPT_ERRTYPE_CONSTRAINT = 5;
	int CRYPT_ERRTYPE_ISSUERCONSTRAINT = 6;
	int CRYPT_ERRTYPE_LAST = 7;

	int CRYPT_CERTACTION_NONE = 0;
	int CRYPT_CERTACTION_CREATE = 1;
	int CRYPT_CERTACTION_CONNECT = 2;
	int CRYPT_CERTACTION_DISCONNECT = 3;
	int CRYPT_CERTACTION_ERROR = 4;
	int CRYPT_CERTACTION_ADDUSER = 5;
	int CRYPT_CERTACTION_REQUEST_CERT = 6;
	int CRYPT_CERTACTION_REQUEST_RENEWAL = 7;
	int CRYPT_CERTACTION_REQUEST_REVOCATION = 8;
	int CRYPT_CERTACTION_CERT_CREATION = 9;
	int CRYPT_CERTACTION_CERT_CREATION_COMPLETE = 10;
	int CRYPT_CERTACTION_CERT_CREATION_DROP = 11;
	int CRYPT_CERTACTION_CERT_CREATION_REVERSE = 12;
	int CRYPT_CERTACTION_RESTART_CLEANUP = 13;
	int CRYPT_CERTACTION_RESTART_REVOKE_CERT = 14;
	int CRYPT_CERTACTION_ISSUE_CERT = 15;
	int CRYPT_CERTACTION_ISSUE_CRL = 16;
	int CRYPT_CERTACTION_REVOKE_CERT = 17;
	int CRYPT_CERTACTION_EXPIRE_CERT = 18;
	int CRYPT_CERTACTION_CLEANUP = 19;
	int CRYPT_CERTACTION_LAST = 20;

	int CRYPT_KEYOPT_NONE = 0;
	int CRYPT_KEYOPT_READONLY = 1;
	int CRYPT_KEYOPT_CREATE = 2;
	int CRYPT_KEYOPT_LAST = 3;

	int CRYPT_KEYUSAGE_NONE = 0x000;
	int CRYPT_KEYUSAGE_DIGITALSIGNATURE = 0x001;
	int CRYPT_KEYUSAGE_NONREPUDIATION = 0x002;
	int CRYPT_KEYUSAGE_KEYENCIPHERMENT = 0x004;
	int CRYPT_KEYUSAGE_DATAENCIPHERMENT = 0x008;
	int CRYPT_KEYUSAGE_KEYAGREEMENT = 0x010;
	int CRYPT_KEYUSAGE_KEYCERTSIGN = 0x020;
	int CRYPT_KEYUSAGE_CRLSIGN = 0x040;
	int CRYPT_KEYUSAGE_ENCIPHERONLY = 0x080;
	int CRYPT_KEYUSAGE_DECIPHERONLY = 0x100;
	int CRYPT_KEYUSAGE_LAST = 0x200;
	int CRYPT_CRLREASONFLAG_UNUSED = 0x001;
	int CRYPT_CRLREASONFLAG_KEYCOMPROMISE = 0x002;
	int CRYPT_CRLREASONFLAG_CACOMPROMISE = 0x004;
	int CRYPT_CRLREASONFLAG_AFFILIATIONCHANGED = 0x008;
	int CRYPT_CRLREASONFLAG_SUPERSEDED = 0x010;
	int CRYPT_CRLREASONFLAG_CESSATIONOFOPERATION = 0x020;
	int CRYPT_CRLREASONFLAG_CERTIFICATEHOLD = 0x040;
	int CRYPT_CRLREASONFLAG_LAST = 0x080;
	int CRYPT_NS_CERTTYPE_SSLCLIENT = 0x001;
	int CRYPT_NS_CERTTYPE_SSLSERVER = 0x002;
	int CRYPT_NS_CERTTYPE_SMIME = 0x004;
	int CRYPT_NS_CERTTYPE_OBJECTSIGNING = 0x008;
	int CRYPT_NS_CERTTYPE_RESERVED = 0x010;
	int CRYPT_NS_CERTTYPE_SSLCA = 0x020;
	int CRYPT_NS_CERTTYPE_SMIMECA = 0x040;
	int CRYPT_NS_CERTTYPE_OBJECTSIGNINGCA = 0x080;
	int CRYPT_NS_CERTTYPE_LAST = 0x100;
	int CRYPT_SET_CERTTYPE_CARD = 0x001;
	int CRYPT_SET_CERTTYPE_MER = 0x002;
	int CRYPT_SET_CERTTYPE_PGWY = 0x004;
	int CRYPT_SET_CERTTYPE_CCA = 0x008;
	int CRYPT_SET_CERTTYPE_MCA = 0x010;
	int CRYPT_SET_CERTTYPE_PCA = 0x020;
	int CRYPT_SET_CERTTYPE_GCA = 0x040;
	int CRYPT_SET_CERTTYPE_BCA = 0x080;
	int CRYPT_SET_CERTTYPE_RCA = 0x100;
	int CRYPT_SET_CERTTYPE_ACQ = 0x200;
	int CRYPT_SET_CERTTYPE_LAST = 0x400;
	int CRYPT_CMPSTATUS_EXT_BADALG = 0x001;
	int CRYPT_CMPSTATUS_EXT_BADMESSAGECHECK = 0x002;
	int CRYPT_CMPSTATUS_EXT_BADREQUEST = 0x004;
	int CRYPT_CMPSTATUS_EXT_BADTIME = 0x008;
	int CRYPT_CMPSTATUS_EXT_BADCERTID = 0x010;
	int CRYPT_CMPSTATUS_EXT_BADDATAFORMAT = 0x020;
	int CRYPT_CMPSTATUS_EXT_WRONGAUTHORITY = 0x040;
	int CRYPT_CMPSTATUS_EXT_INCORRECTDATA = 0x080;
	int CRYPT_CMPSTATUS_EXT_MISSINGTIMESTAMP = 0x100;
	int CRYPT_CMPSTATUS_EXT_BADPOP = 0x200;
	int CRYPT_CMPSTATUS_EXT_LAST = 0x400;
	int CRYPT_MAX_KEYSIZE = 256;
	int CRYPT_MAX_IVSIZE = 32;
	int CRYPT_MAX_PKCSIZE = 512;
	int CRYPT_MAX_HASHSIZE = 32;
	int CRYPT_MAX_TEXTSIZE = 64;
	int CRYPT_USE_DEFAULT = -10;
	int CRYPT_UNUSED = -11;
	int CRYPT_KEYTYPE_PRIVATE = 0;
	int CRYPT_KEYTYPE_PUBLIC = 1;
	int CRYPT_RANDOM_FASTPOLL = -10;
	int CRYPT_RANDOM_SLOWPOLL = -11;
	int CRYPT_CURSOR_FIRST = -20;
	int CRYPT_CURSOR_PREVIOUS = -21;
	int CRYPT_CURSOR_NEXT = -22;
	int CRYPT_CURSOR_LAST = -23;
	int CRYPT_OK = 0;
	int CRYPT_ERROR_PARAM1 = -1;
	int CRYPT_ERROR_PARAM2 = -2;
	int CRYPT_ERROR_PARAM3 = -3;
	int CRYPT_ERROR_PARAM4 = -4;
	int CRYPT_ERROR_PARAM5 = -5;
	int CRYPT_ERROR_PARAM6 = -6;
	int CRYPT_ERROR_PARAM7 = -7;
	int CRYPT_ERROR_MEMORY = -10;
	int CRYPT_ERROR_NOTINITED = -11;
	int CRYPT_ERROR_INITED = -12;
	int CRYPT_ERROR_NOSECURE = -13;
	int CRYPT_ERROR_RANDOM = -14;
	int CRYPT_ERROR_FAILED = -15;
	int CRYPT_ERROR_NOTAVAIL = -20;
	int CRYPT_ERROR_PERMISSION = -21;
	int CRYPT_ERROR_WRONGKEY = -22;
	int CRYPT_ERROR_INCOMPLETE = -23;
	int CRYPT_ERROR_COMPLETE = -24;
	int CRYPT_ERROR_BUSY = -25;
	int CRYPT_ERROR_INVALID = -26;
	int CRYPT_ERROR_SIGNALLED = -27;
	int CRYPT_ERROR_OVERFLOW = -30;
	int CRYPT_ERROR_UNDERFLOW = -31;
	int CRYPT_ERROR_BADDATA = -32;
	int CRYPT_ERROR_SIGNATURE = -33;
	int CRYPT_ERROR_OPEN = -40;
	int CRYPT_ERROR_READ = -41;
	int CRYPT_ERROR_WRITE = -42;
	int CRYPT_ERROR_NOTFOUND = -43;
	int CRYPT_ERROR_DUPLICATE = -44;
	int CRYPT_ENVELOPE_RESOURCE = -50;
}
