import com.cryptlib.*;

class CryptLibTest implements CryptLibConstants
{
    public static void main(String[] args)
    {
        CryptLib cl=CryptLib.getInstance();
        int[] cryptEnvelope = new int[1];
        int[] bytesCopied = new int[1];
        byte[] buffer = new byte[1000];
        java.io.PrintStream stdout = System.out;

        int result = CRYPT_OK;

        // CryptLib equivalent of "try {" where "break out" replaces "throw"
        out: do
        {
            try {
                stdout.println("Initializing...");
                if ((result = cl.cryptInit()) != CRYPT_OK) break out;

                stdout.println("Creating envelope...");
                if ((result = cl.cryptCreateEnvelope( cryptEnvelope, CRYPT_UNUSED, CRYPT_FORMAT_CRYPTLIB )) != CRYPT_OK) break out;

                stdout.println("Setting password...");
                if ((result = cl.cryptSetAttributeString( cryptEnvelope[0], CRYPT_ENVINFO_PASSWORD, "password".getBytes("UTF8"), 8 )) != CRYPT_OK) break out;

                stdout.println("Setting data size...");
                if ((result = cl.cryptSetAttribute( cryptEnvelope[0], CRYPT_ENVINFO_DATASIZE, 11 )) != CRYPT_OK) break out;

                stdout.println("Pushing data...");
                if ((result = cl.cryptPushData( cryptEnvelope[0], "Hello world".getBytes("UTF8"), 11, bytesCopied )) != CRYPT_OK) break out;

                stdout.println("Flushing data...");
                if ((result = cl.cryptFlushData( cryptEnvelope[0] )) != CRYPT_OK) break out;

                stdout.println("Popping data...");
                if ((result = cl.cryptPopData( cryptEnvelope[0], buffer, 1000, bytesCopied )) != CRYPT_OK) break out;

                stdout.println(bytesCopied[0]+" bytes out");
                for (int i=0; i<bytesCopied[0]; ++i)
                {
                    stdout.print(buffer[i]+" ");
                }
                stdout.println("");

                stdout.println("Destroying envelope...");
                if ((result = cl.cryptDestroyEnvelope( cryptEnvelope[0] )) != CRYPT_OK) break out;

                stdout.println("Creating envelope...");
                if ((result = cl.cryptCreateEnvelope( cryptEnvelope, CRYPT_UNUSED, CRYPT_FORMAT_AUTO )) != CRYPT_OK) break out;

                stdout.println("Pushing data...");
                if ((result = cl.cryptPushData( cryptEnvelope[0], buffer, bytesCopied[0], bytesCopied )) != CRYPT_OK)
                {
                    if (result != CRYPT_ENVELOPE_RESOURCE) { break out; }
                }

                stdout.println("Setting password...");
                if ((result = cl.cryptSetAttributeString( cryptEnvelope[0], CRYPT_ENVINFO_PASSWORD, "password".getBytes("UTF8"), 8 )) != CRYPT_OK) break out;

                stdout.println("Flushing data...");
                if ((result = cl.cryptFlushData( cryptEnvelope[0] )) != CRYPT_OK) break out;

                stdout.println("Popping data...");
                if ((result = cl.cryptPopData( cryptEnvelope[0], buffer, 1000, bytesCopied )) != CRYPT_OK) break out;

                byte[] message = new byte[bytesCopied[0]];
                stdout.println(bytesCopied[0]+" bytes out");
                for (int i=0; i<bytesCopied[0]; ++i)
                {
                    stdout.print(buffer[i]+" ");
                    message[i] = buffer[i];
                }
                // End-of-line
                stdout.println("");

                stdout.println("As string:");
                stdout.println(new String(message,"UTF8"));

                stdout.println("Destroying envelope...");
                if ((result = cl.cryptDestroyEnvelope( cryptEnvelope[0] )) != CRYPT_OK) break out;
                
                stdout.println("Querying DES capability...");
                String [] name = new String[1];
                int [] sizes = new int [4];
                if ((result = cl.cryptQueryCapability(CRYPT_ALGO_DES,name,sizes)) != CRYPT_OK) break out;
                stdout.println("Name: "+name[0]+"\t"+sizes[0]+"\t"+sizes[1]+"\t"+sizes[2]+"\t"+sizes[3]);
            }
            catch (java.io.UnsupportedEncodingException e)
            {
                stdout.println("Bad encoding?");
                break out;
            }
        } while (false);

        // Cryptlib "catch"
        if (result != CRYPT_OK)
        {
            stdout.println("Couldn't proceed: "+result);
        }
		stdout.println("Shutting down...");
        cl.cryptEnd();
    }
}