import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

import com.cryptlib.*;

class Demo implements CryptLibConstants
{
	public static void main(String[] args)
	{
		CryptLib cl=CryptLib.getInstance();
		int[] cryptEnvelope = new int[1];
		int[] bytesCopied = new int[1];
		int[] keys = new int[1];
		byte[] buffer = new byte[10000];
		int [] cert = new int[1];
		int [] sigContext = new int[1];
		int [] cryptContext = new int[1];
		PrintStream stdout = System.out;
		String bob = new String("Bob");
		String paul = new String("Paul");

		int result = CRYPT_OK;
		int len=0;

		// CryptLib equivalent of "try {" where "break out" replaces "throw"
		out: do
		{
			try {
				stdout.println("Initializing...");
				if ((result = cl.cryptInit()) != CRYPT_OK) break out;

				stdout.println("Generating keys...");
				if ((result = cl.cryptKeysetOpen(keys, CRYPT_UNUSED, CRYPT_KEYSET_FILE, "SampleKeys", CRYPT_KEYOPT_CREATE)) != CRYPT_OK) break out;

				if ((result = cl.cryptCreateContext(cryptContext,CRYPT_UNUSED,CRYPT_ALGO_RSA))!=CRYPT_OK)break out;
				if ((result = cl.cryptSetAttributeString(cryptContext[0],CRYPT_CTXINFO_LABEL,bob.getBytes("UTF8"),bob.length()))!=CRYPT_OK)break out;
				if ((result = cl.cryptGenerateKey(cryptContext[0]))!=CRYPT_OK)break out;
				if ((result = cl.cryptAddPrivateKey(keys[0],cryptContext[0],"test-bob"))!=CRYPT_OK)break out;
				if ((result = cl.cryptDestroyContext(cryptContext[0]))!=CRYPT_OK)break out;

				if ((result = cl.cryptCreateContext(cryptContext,CRYPT_UNUSED,CRYPT_ALGO_RSA))!=CRYPT_OK)break out;
				if ((result = cl.cryptSetAttributeString(cryptContext[0],CRYPT_CTXINFO_LABEL,paul.getBytes("UTF8"),paul.length()))!=CRYPT_OK)break out;
				if ((result = cl.cryptGenerateKey(cryptContext[0]))!=CRYPT_OK)break out;
				if ((result = cl.cryptAddPrivateKey(keys[0],cryptContext[0],"test-paul"))!=CRYPT_OK)break out;
				if ((result = cl.cryptDestroyContext(cryptContext[0]))!=CRYPT_OK)break out;

				if ((result = cl.cryptKeysetClose(keys[0])) != CRYPT_OK) break out;


				// SIGN

				stdout.println("Creating signature envelope...");
				if ((result = cl.cryptCreateEnvelope( cryptEnvelope, CRYPT_UNUSED, CRYPT_FORMAT_CRYPTLIB )) != CRYPT_OK) break out;

				stdout.println("Setting data size...");
				if ((result = cl.cryptSetAttribute( cryptEnvelope[0], CRYPT_ENVINFO_DATASIZE, 11 )) != CRYPT_OK) break out;

				stdout.println("Setting signing key...");
				if ((result = cl.cryptKeysetOpen(keys, CRYPT_UNUSED, CRYPT_KEYSET_FILE, "SampleKeys", CRYPT_KEYOPT_READONLY)) != CRYPT_OK) break out;

				if ((result = cl.cryptCreateContext(sigContext,CRYPT_UNUSED,CRYPT_ALGO_RSA))!=CRYPT_OK)break out;
				if ((result = cl.cryptGetPrivateKey(keys[0], sigContext, CRYPT_KEYID_NAME, bob, "test-bob" )) != CRYPT_OK) break out;
				if ((result = cl.cryptSetAttribute(cryptEnvelope[0], CRYPT_ENVINFO_SIGNATURE, sigContext[0] )) != CRYPT_OK) break out;

				if ((result = cl.cryptKeysetClose(keys[0])) != CRYPT_OK) break out;

				stdout.println("Pushing data...");
				if ((result = cl.cryptPushData( cryptEnvelope[0], "Hello world".getBytes("UTF8"), 11, bytesCopied )) != CRYPT_OK) break out;

				stdout.println("Flushing data...");
				if ((result = cl.cryptFlushData( cryptEnvelope[0] )) != CRYPT_OK) break out;

				stdout.println("Popping data...");
				if ((result = cl.cryptPopData( cryptEnvelope[0], buffer, 1000, bytesCopied )) != CRYPT_OK) break out;

				stdout.println(bytesCopied[0]+" bytes out");
				stdout.println("Destroying envelope...");
				if ((result = cl.cryptDestroyEnvelope( cryptEnvelope[0] )) != CRYPT_OK) break out;
				if ((result = cl.cryptDestroyContext( sigContext[0] )) != CRYPT_OK) break out;


				// ENCRYPT


				stdout.println("Creating encryption envelope...");
				if ((result = cl.cryptCreateEnvelope( cryptEnvelope, CRYPT_UNUSED, CRYPT_FORMAT_CRYPTLIB )) != CRYPT_OK) break out;

				stdout.println("Setting data size...");
				if ((result = cl.cryptSetAttribute( cryptEnvelope[0], CRYPT_ENVINFO_DATASIZE, bytesCopied[0] )) != CRYPT_OK) break out;

				stdout.println("Setting encryption key...");
				if ((result = cl.cryptKeysetOpen(keys, CRYPT_UNUSED, CRYPT_KEYSET_FILE, "SampleKeys", CRYPT_KEYOPT_READONLY)) != CRYPT_OK) break out;

				if ((result = cl.cryptCreateContext(cryptContext,CRYPT_UNUSED,CRYPT_ALGO_RSA))!=CRYPT_OK)break out;
				if ((result = cl.cryptGetPublicKey(keys[0], cryptContext, CRYPT_KEYID_NAME, paul)) != CRYPT_OK) break out;
				if ((result = cl.cryptSetAttribute(cryptEnvelope[0], CRYPT_ENVINFO_PUBLICKEY, cryptContext[0] )) != CRYPT_OK) break out;

				if ((result = cl.cryptKeysetClose(keys[0])) != CRYPT_OK) break out;

				stdout.println("Pushing data...");
				if ((result = cl.cryptPushData( cryptEnvelope[0], buffer, bytesCopied[0], bytesCopied )) != CRYPT_OK) break out;

				stdout.println("Flushing data...");
				if ((result = cl.cryptFlushData( cryptEnvelope[0] )) != CRYPT_OK) break out;

				stdout.println("Popping data...");
				if ((result = cl.cryptPopData( cryptEnvelope[0], buffer, 1000, bytesCopied )) != CRYPT_OK) break out;

				stdout.println(bytesCopied[0]+" bytes out");
				for (int i=0; i<bytesCopied[0]; ++i)
				{
					stdout.print(buffer[i]+" ");
				}
				stdout.println("");

				stdout.println("Destroying encryption envelope...");
				if ((result = cl.cryptDestroyEnvelope( cryptEnvelope[0] )) != CRYPT_OK) break out;
				if ((result = cl.cryptDestroyContext( cryptContext[0] )) != CRYPT_OK) break out;


				// Now do everything in reverse...

				// DECRYPT

				stdout.println("Creating decryption envelope...");
				if ((result = cl.cryptCreateEnvelope( cryptEnvelope, CRYPT_UNUSED, CRYPT_FORMAT_AUTO )) != CRYPT_OK) break out;

				stdout.println("Pushing data...");
				if ((result = cl.cryptPushData( cryptEnvelope[0], buffer, bytesCopied[0], bytesCopied )) != CRYPT_OK)
				{
					if (result != CRYPT_ENVELOPE_RESOURCE) { break out; }
				}

				stdout.println("Setting decryption key...");
				if ((result = cl.cryptKeysetOpen(keys, CRYPT_UNUSED, CRYPT_KEYSET_FILE, "SampleKeys", CRYPT_KEYOPT_READONLY)) != CRYPT_OK) break out;

				if ((result = cl.cryptCreateContext(cryptContext,CRYPT_UNUSED,CRYPT_ALGO_RSA))!=CRYPT_OK)break out;
				if ((result = cl.cryptGetPrivateKey( keys[0], cryptContext, CRYPT_KEYID_NAME, paul, "test-paul" )) != CRYPT_OK) break out;
				if ((result = cl.cryptSetAttribute( cryptEnvelope[0], CRYPT_ENVINFO_PRIVATEKEY, cryptContext[0] )) != CRYPT_OK) break out;

				if ((result = cl.cryptKeysetClose(keys[0])) != CRYPT_OK) break out;

				stdout.println("Flushing data...");
				if ((result = cl.cryptFlushData( cryptEnvelope[0] )) != CRYPT_OK) break out;

				stdout.println("Popping data...");
				if ((result = cl.cryptPopData( cryptEnvelope[0], buffer, 1000, bytesCopied )) != CRYPT_OK) break out;

				stdout.println(bytesCopied[0]+" bytes out");

				stdout.println("Destroying decryption envelope...");
				if ((result = cl.cryptDestroyEnvelope( cryptEnvelope[0] )) != CRYPT_OK) break out;
				if ((result = cl.cryptDestroyContext( cryptContext[0] )) != CRYPT_OK) break out;


				// VERIFY


				stdout.println("Creating verification envelope...");
				if ((result = cl.cryptCreateEnvelope( cryptEnvelope, CRYPT_UNUSED, CRYPT_FORMAT_AUTO )) != CRYPT_OK) break out;

				stdout.println("Pushing data...");
				if ((result = cl.cryptPushData( cryptEnvelope[0], buffer, bytesCopied[0], bytesCopied )) != CRYPT_OK)
				{
					if (result != CRYPT_ENVELOPE_RESOURCE) { break out; }
				}

				stdout.println("Setting verifying key...");
				if ((result = cl.cryptKeysetOpen(keys, CRYPT_UNUSED, CRYPT_KEYSET_FILE, "SampleKeys", CRYPT_KEYOPT_READONLY)) != CRYPT_OK) break out;

				if ((result = cl.cryptCreateContext(sigContext,CRYPT_UNUSED,CRYPT_ALGO_RSA))!=CRYPT_OK)break out;
				if ((result = cl.cryptGetPublicKey( keys[0], sigContext, CRYPT_KEYID_NAME, bob )) != CRYPT_OK) break out;
				if ((result = cl.cryptSetAttribute( cryptEnvelope[0], CRYPT_ENVINFO_SIGNATURE, sigContext[0] )) != CRYPT_OK) break out;

				if ((result = cl.cryptKeysetClose(keys[0])) != CRYPT_OK) break out;

				stdout.println("Flushing data...");
				if ((result = cl.cryptFlushData( cryptEnvelope[0] )) != CRYPT_OK) break out;

				stdout.println("Popping data...");
				if ((result = cl.cryptPopData( cryptEnvelope[0], buffer, 1000, bytesCopied )) != CRYPT_OK) break out;

				byte[] message = new byte[bytesCopied[0]];
				stdout.println(bytesCopied[0]+" bytes out");

				for (int i=0; i<bytesCopied[0]; ++i)
				{
					stdout.print(buffer[i]+" ");
					message[i] = buffer[i];
				}
				// End-of-line
				stdout.println("");

				stdout.println("As string:");
				stdout.println(new String(message,"UTF8"));

				stdout.println("Destroying verification envelope...");
				if ((result = cl.cryptDestroyEnvelope( cryptEnvelope[0] )) != CRYPT_OK) break out;
				if ((result = cl.cryptDestroyContext( sigContext[0] )) != CRYPT_OK) break out;

			}
			catch (UnsupportedEncodingException e)
			{
				stdout.println("Bad encoding?");
				break out;
			}
		} while (false);

		// Cryptlib "catch"
		if (result != CRYPT_OK)
		{
			stdout.println("Couldn't proceed: "+result);
		}
		stdout.println("Shutting down...");
		cl.cryptEnd();
	}
}