# strip code
if ($#ARGV != 1) { print STDERR "Usage: perl auto.pl cryptapi.c cryptlib.h\n"; exit; }
`perl stripcode.pl $ARGV[0] > stripped.c`;
open (F,'<stripped.c') or die;

# Java, C, and Header
open (J,'>CryptLib.java') or die;
open (C,'>cljni.c') or die;
open (H,'>cljni.h') or die;

# define a singleton CryptLib class in Java
print J <<END_J;
package com.cryptlib;

public class CryptLib implements CryptLibConstants
{
	private static final CryptLib instance  = new CryptLib();
	
	private CryptLib() {}
	
	static
	{
		System.loadLibrary("cl32");
	}
	
	public static CryptLib getInstance()
	{
		return instance;
	}
	
	public native int cryptInit();
	
	public native int cryptEnd();
	
END_J



# include the generated JNI h file and the cryptlib api definitions
# define cryptInit and cryptEnd 'cause they're not in cryptapi.c
print C <<END_C;
#include "cljni.h"
#include "crypt.h"
#include <malloc.h>

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptInit(JNIEnv *env, jobject thisObj)
{
	return cryptInit();
}

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptEnd(JNIEnv *env, jobject thisObj)
{
	return cryptEnd();
}

END_C


# put the standard JNI header prefix on the header file
print H <<END_H;
/* DO NOT EDIT THIS FILE - it is machine generated */
#include <jni.h>
/* Header for class com_cryptlib_CryptLib */

#ifndef _Included_com_cryptlib_CryptLib
#define _Included_com_cryptlib_CryptLib
#ifdef __cplusplus
extern "C" {
#endif
END_H


# start processing the stripped c code
while (<F>)
{
	# concatenate until blank line
	if (!m/^(\s|\r|\n)*$/)
	{
		$line .= $_;
		next;
	}
	$cl=$line;
	$line='';
	# functions start with C_RET
	next if $cl !~ m/^C_RET/;
	$cl =~ s/\t/    /g;
	chomp $cl;

	# java, jni c wrapper, original cryptlib call
	$j = $c = $cl;
	
	$cl =~ s/(C_RET|C_IN|C_OUT|C_INOUT|int|char|void|CRYPT_[A-Z_0-9]*|C_PTR|\r|\n)//g;
	$cl =~ s/\s\s+/ /g;
	$cl =~ s/^\s+//;

	# java native proc declaration
	$j =~ s/C_RET ([^ (]*)(\s*\()([^)]*)\)/\tpublic native int \1\2/;
	$jparams=$cparams=$3;
	
	# C_IN CRYPT_BLAH = int
	$jparams =~ s/C_IN CRYPT_[A-Z_0-9]*/int/g;
	# C_IN char C_PTR = String
	$jparams =~ s/C_IN char C_PTR/String/g;
	# C_IN void C_PTR = byte[]
	# length params always include "(L|l)ength" and come immediately after C_IN void C_PTR params
	$jparams =~ s/C_IN void C_PTR/byte[]/g;
	# C_IN int = int
	$jparams =~ s/C_IN int/int/g;
	# C_INOUT void C_PTR = byte[][] always followed by C_IN int length
	$jparams =~ s/C_INOUT void C_PTR/byte[][]/;
	# C_OUT CRYPT_QUERY_INFO C_PTR = String[1] algoName, int[4] sizes
	$jparams =~ s/C_OUT CRYPT_QUERY_INFO C_PTR cryptQueryInfo/String[] algoName, int[] sizes/;
	# C_OUT CRYPT_BLAH C_PTR = int[1]
	$jparams =~ s/C_OUT CRYPT_[A-Z_0-9]* C_PTR/int[]/;
	# C_OUT int C_PTR= int[1]
	$jparams =~ s/C_OUT int C_PTR/int[]/;
	# C_OUT void C_PTR = byte[] always followed by COUT int C_PTR length = int[1]
	$jparams =~ s/C_OUT void C_PTR/byte[]/;
	
	$j.=$jparams.');';
	print J "$j\n\n";
	
	# C native code definition
	$c =~ s/C_RET ([^ (]*)(\s*\()(.|\r|\n)*/JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_\1\2/;
	
	# split parameter list on commas; throw away CRLF and trailing whitespace
	@params = split/,\s*\r?\n?/,$cparams;
	# get rid of leading whitespace
	map {s/\s*(.*)/\1/} @params;
	
	$cparams='JNIEnv *env, jobject thisObj, ';
	$declare=$lock=$unlock='';
	foreach $param (@params)
	{
		# prefix each parameter with j in the declaration
		# append: declare a normal name in the declare section
		# append: lock jparameters into parameters
		# prepend: unlock parameters into jparameters
		($dir, $type, $ptr, $var) = 
			($param =~ m/(C_IN|C_OUT|C_INOUT) (\w+) (C_PTR )?(\w+)/);
		
		if ($dir eq 'C_IN')
		{
			# C_IN CRYPT_BLAH = int
			if ( ($type =~ /CRYPT_[A-Z_0-9]*/) && (!$ptr) )
			{
				$cparams .= "jint $var, ";
			}
			# C_IN char C_PTR = String
			if ( ($type eq 'char') && ($ptr) )
			{
				$cparams .= "jstring j_$var, ";
				$declare .= "\tchar *$var;\n";
				$declare .= "\tconst char *p_$var;\n";
				$declare .= "\tint ${var}Length;\n";
				$lock .= "\t${var}Length = (*env)->GetStringUTFLength(env,j_$var);\n";
				$lock .= "\tp_$var = (*env)->GetStringUTFChars(env,j_$var,0);\n";
				$lock .= "\tif (!p_$var) return 0;\n";
				$lock .= "\t$var = (char *)malloc(${var}Length+1);\n";
				$lock .= "\tmemcpy($var, p_$var, ${var}Length); $var\[${var}Length] = 0;\n";
				$unlock = "\tfree($var);\n\t(*env)->ReleaseStringUTFChars(env,j_$var,p_$var);\n".$unlock;
			}
			# C_IN void C_PTR = byte[]
			if ( ($type eq 'void') && ($ptr) )
			{
				$cparams .= "jbyteArray j_$var, ";
				$declare .= "\tunsigned char *$var;\n";
				$lock .= "\t$var = (*env)->GetByteArrayElements(env,j_$var,0);\n";
				$lock .= "\tif (!$var) return 0;\n";
				$unlock = "\t(*env)->ReleaseByteArrayElements(env,j_$var,$var,0);\n".$unlock;
			}
			# C_IN int = int
			if ( ($type eq 'int') &&
				 (!$ptr) )
			{
				$cparams .= "jint $var, ";
			}
		}		
		if ( ($dir eq 'C_INOUT') &&
			 ($type eq 'void') &&
			 ($ptr) )
		{
			# C_INOUT void C_PTR = byte[] always followed by C_IN int length
			
			$cparams .= "jbyteArray j_$var, ";
			$declare .= "\tunsigned char *$var;\n";
			$lock .= "\t$var = (*env)->GetByteArrayElements(env, j_$var, 0);\n";
			$lock .= "\tif (!$var) return 0;\n";
			$unlock = "\t(*env)->ReleaseByteArrayElements(env,j_$var,$var,0);\n" . $unlock;
		}
		if ($dir eq 'C_OUT' && ($ptr))
		{
			# C_OUT CRYPT_QUERY_INFO C_PTR = QueryInfo[1]
			if ($type eq 'CRYPT_QUERY_INFO')
			{
				$cparams .= "jobjectArray p_algoName, jintArray j_sizes, ";
				$declare .= "\tCRYPT_QUERY_INFO qi;\n";
				$declare .= "\tCRYPT_QUERY_INFO *cryptQueryInfo = &qi;\n";
				$declare .= "\tint *sizes;\n";
				$declare .= "\tjstring j_algoName;\n";
				$lock .= "\tsizes = (*env)->GetIntArrayElements(env, j_sizes, 0);\n";
				$lock .= "\tif (!sizes) return 0;\n";
				$unlock	.= 

<<"END_C_CODE" . $unlock;
	j_algoName = (*env)->NewStringUTF(env, qi.algoName);
	if (!p_algoName) return 0;
	(*env)->SetObjectArrayElement(env, p_algoName, 0, j_algoName);
	sizes[0] = qi.blockSize;
	sizes[1] = qi.minKeySize;
	sizes[2] = qi.keySize;
	sizes[3] = qi.maxKeySize;
	(*env)->ReleaseIntArrayElements(env, j_sizes, sizes, 0);
END_C_CODE
	
			}
			# C_OUT CRYPT_BLAH C_PTR = int[1]
			elsif ($type =~ m/CRYPT_[A-Z_0-9]*/)
			{
				$cparams .= "jintArray j_$var, ";
				$declare .= "\tint *$var;\n";
				$lock .="\t$var = (*env)->GetIntArrayElements(env,j_$var,0);\n";
				$lock .="\tif (!$var) return 0;\n";
				$unlock = "\t(*env)->ReleaseIntArrayElements(env,j_$var,$var,0);\n".$unlock;
			}
			# C_OUT int C_PTR= int[1]
			if ($type eq 'int')
			{
				$cparams .= "jintArray j_$var, ";
				$declare .= "\tint *$var;\n";
				$lock .="\t$var = (*env)->GetIntArrayElements(env,j_$var,0);\n";
				$lock .="\tif (!$var) return 0;\n";
				$unlock = "\t(*env)->ReleaseIntArrayElements(env,j_$var,$var,0);\n".$unlock;
			}
			# C_OUT void C_PTR = byte[] always followed by COUT int C_PTR length = int[1]
			if ($type eq 'void')
			{
				$cparams .= "jbyteArray j_$var, ";
				$declare .= "\tchar *$var = NULL;\n";
				$lock .= "\tif (j_$var)\n\t{\n";
				$lock .= "\t\t$var = (*env)->GetByteArrayElements(env,j_$var,0);\n";
				$lock .= "\t\tif (!$var) return 0;\n";
				$lock .= "\t}\n";
				$unlock = "\tif (j_$var)\n\t{\n".
				          "\t\t(*env)->ReleaseByteArrayElements(env,j_$var,$var,0);\n".
				          "\t}\n" . $unlock;
			}
		}
	}
	$cparams =~ s/, $//;
	print H $c.$cparams.");\n\n";
	$c .= $cparams.")\n{\n\tint retval;\n$declare$lock\tretval = $cl;\n$unlock\treturn retval;\n}";
	print C "$c\n\n";
}
close F;

# end the H file
print H <<END_H;
#ifdef __cplusplus
}
#endif
#endif
END_H

close H;
close C;
# end the CryptLib class
print J "}\n";

close J;

# create the java CryptLibConstants class
open (J,'>CryptLibConstants.java') or die;
print J <<END_J;
package com.cryptlib;

public interface CryptLibConstants
{
END_J

# open the C constants file
open (G,'<cryptlib.h') or die;
{
	local $/ = undef;
	$_=<G>;
}
close G;
# simple strip c-style comments (doesn't deal with quotes)
s/\/\*(.|\r|\n)*?\*\///g;

# strip preprocessing
# iterate thru string
@str=split //;
$t=0; 
for ($i=0; $i<=$#str; $i++)
{
	# count #if 's and #endif's
	# record when count goes nonzero
	if ( ('#if ' eq (join '',@str[$i..($i+3)])) ||
	     ('#ifdef' eq (join '',@str[$i..($i+5)])) )
	{
		++$t;
		push @indx, $i if 1==$t;
	}
	# record when count goes zero
	elsif ( '#endif' eq (join '',@str[$i..($i+5)]) )
	{
		--$t;
		push @indx, ($i+5) if 0==$t;
	}
}
# delete everything in between
for ($i=0; $i<=$#indx; $i+=2)
{
	@str[$indx[$i]..$indx[$i+1]]=();
}

$_ = join '',@str;

while (m/enum\s*\{((.|\r|\n)*?)\}/g)
{
	$base='';
	$ctr=0;
	$enums = $1;
	@enums = split/,/,$enums;
	foreach $enum (@enums)
	{
		if ($enum=~m/(\s|\r|\n)*(CRYPT_[A-Z_0-9]+)(\s*=\s*(.*))?/)
		{
			do { $base="$4 + "; $ctr=0; } if $4;
			print J "\tint $2 = $base$ctr;\n";
			++$ctr;
		}
	}
	print J "\n";
}

while (m/#define ((CRYPT_[A-Z_0-9]+)\s+(\S*))/g)
{
	print J "\tint $2 = $3;\n";
}
# end the CryptLibConstants interface
print J "}\n";

close J;

