#include "cljni.h"
#include "crypt.h"
#include <malloc.h>

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptInit(JNIEnv *env, jobject thisObj)
{
	return cryptInit();
}

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptEnd(JNIEnv *env, jobject thisObj)
{
	return cryptEnd();
}

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptCreateContext(JNIEnv *env, jobject thisObj, jintArray j_cryptContext, jint cryptUser, jint cryptAlgo)
{
	int retval;
	int *cryptContext;
	cryptContext = (*env)->GetIntArrayElements(env,j_cryptContext,0);
	if (!cryptContext) return 0;
	retval = cryptCreateContext( cryptContext, cryptUser, cryptAlgo );
	(*env)->ReleaseIntArrayElements(env,j_cryptContext,cryptContext,0);
	return retval;
}

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptDeviceCreateContext(JNIEnv *env, jobject thisObj, jint device, jintArray j_cryptContext, jint cryptAlgo)
{
	int retval;
	int *cryptContext;
	cryptContext = (*env)->GetIntArrayElements(env,j_cryptContext,0);
	if (!cryptContext) return 0;
	retval = cryptDeviceCreateContext( device, cryptContext, cryptAlgo );
	(*env)->ReleaseIntArrayElements(env,j_cryptContext,cryptContext,0);
	return retval;
}

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptCreateCert(JNIEnv *env, jobject thisObj, jintArray j_certificate, jint cryptUser, jint certType)
{
	int retval;
	int *certificate;
	certificate = (*env)->GetIntArrayElements(env,j_certificate,0);
	if (!certificate) return 0;
	retval = cryptCreateCert( certificate, cryptUser, certType );
	(*env)->ReleaseIntArrayElements(env,j_certificate,certificate,0);
	return retval;
}

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptDeviceOpen(JNIEnv *env, jobject thisObj, jintArray j_device, jint cryptUser, jint deviceType, jstring j_name)
{
	int retval;
	int *device;
	char *name;
	const char *p_name;
	int nameLength;
	device = (*env)->GetIntArrayElements(env,j_device,0);
	if (!device) return 0;
	nameLength = (*env)->GetStringUTFLength(env,j_name);
	p_name = (*env)->GetStringUTFChars(env,j_name,0);
	if (!p_name) return 0;
	name = (char *)malloc(nameLength+1);
	memcpy(name, p_name, nameLength); name[nameLength] = 0;
	retval = cryptDeviceOpen( device, cryptUser, deviceType, name );
	free(name);
	(*env)->ReleaseStringUTFChars(env,j_name,p_name);
	(*env)->ReleaseIntArrayElements(env,j_device,device,0);
	return retval;
}

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptCreateEnvelope(JNIEnv *env, jobject thisObj, jintArray j_envelope, jint cryptUser, jint formatType)
{
	int retval;
	int *envelope;
	envelope = (*env)->GetIntArrayElements(env,j_envelope,0);
	if (!envelope) return 0;
	retval = cryptCreateEnvelope( envelope, cryptUser, formatType );
	(*env)->ReleaseIntArrayElements(env,j_envelope,envelope,0);
	return retval;
}

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptKeysetOpen(JNIEnv *env, jobject thisObj, jintArray j_keyset, jint cryptUser, jint keysetType, jstring j_name, jint options)
{
	int retval;
	int *keyset;
	char *name;
	const char *p_name;
	int nameLength;
	keyset = (*env)->GetIntArrayElements(env,j_keyset,0);
	if (!keyset) return 0;
	nameLength = (*env)->GetStringUTFLength(env,j_name);
	p_name = (*env)->GetStringUTFChars(env,j_name,0);
	if (!p_name) return 0;
	name = (char *)malloc(nameLength+1);
	memcpy(name, p_name, nameLength); name[nameLength] = 0;
	retval = cryptKeysetOpen( keyset, cryptUser, keysetType, name, options );
	free(name);
	(*env)->ReleaseStringUTFChars(env,j_name,p_name);
	(*env)->ReleaseIntArrayElements(env,j_keyset,keyset,0);
	return retval;
}

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptCreateSession(JNIEnv *env, jobject thisObj, jintArray j_session, jint cryptUser, jint sessionType)
{
	int retval;
	int *session;
	session = (*env)->GetIntArrayElements(env,j_session,0);
	if (!session) return 0;
	retval = cryptCreateSession( session, cryptUser, sessionType );
	(*env)->ReleaseIntArrayElements(env,j_session,session,0);
	return retval;
}

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptLogin(JNIEnv *env, jobject thisObj, jintArray j_user, jstring j_name, jstring j_password)
{
	int retval;
	int *user;
	char *name;
	const char *p_name;
	int nameLength;
	char *password;
	const char *p_password;
	int passwordLength;
	user = (*env)->GetIntArrayElements(env,j_user,0);
	if (!user) return 0;
	nameLength = (*env)->GetStringUTFLength(env,j_name);
	p_name = (*env)->GetStringUTFChars(env,j_name,0);
	if (!p_name) return 0;
	name = (char *)malloc(nameLength+1);
	memcpy(name, p_name, nameLength); name[nameLength] = 0;
	passwordLength = (*env)->GetStringUTFLength(env,j_password);
	p_password = (*env)->GetStringUTFChars(env,j_password,0);
	if (!p_password) return 0;
	password = (char *)malloc(passwordLength+1);
	memcpy(password, p_password, passwordLength); password[passwordLength] = 0;
	retval = cryptLogin( user, name, password );
	free(password);
	(*env)->ReleaseStringUTFChars(env,j_password,p_password);
	free(name);
	(*env)->ReleaseStringUTFChars(env,j_name,p_name);
	(*env)->ReleaseIntArrayElements(env,j_user,user,0);
	return retval;
}

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptDestroyObject(JNIEnv *env, jobject thisObj, jint cryptHandle)
{
	int retval;
	retval = cryptDestroyObject( cryptHandle );
	return retval;
}

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptDestroyCert(JNIEnv *env, jobject thisObj, jint certificate)
{
	int retval;
	retval = cryptDestroyCert( certificate );
	return retval;
}

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptDestroyContext(JNIEnv *env, jobject thisObj, jint cryptContext)
{
	int retval;
	retval = cryptDestroyContext( cryptContext );
	return retval;
}

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptDestroyEnvelope(JNIEnv *env, jobject thisObj, jint cryptEnvelope)
{
	int retval;
	retval = cryptDestroyEnvelope( cryptEnvelope );
	return retval;
}

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptDeviceClose(JNIEnv *env, jobject thisObj, jint device)
{
	int retval;
	retval = cryptDeviceClose( device );
	return retval;
}

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptKeysetClose(JNIEnv *env, jobject thisObj, jint keyset)
{
	int retval;
	retval = cryptKeysetClose( keyset );
	return retval;
}

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptDestroySession(JNIEnv *env, jobject thisObj, jint session)
{
	int retval;
	retval = cryptDestroySession( session );
	return retval;
}

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptLogout(JNIEnv *env, jobject thisObj, jint user)
{
	int retval;
	retval = cryptLogout( user );
	return retval;
}

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptGetAttribute(JNIEnv *env, jobject thisObj, jint cryptHandle, jint attributeType, jintArray j_value)
{
	int retval;
	int *value;
	value = (*env)->GetIntArrayElements(env,j_value,0);
	if (!value) return 0;
	retval = cryptGetAttribute( cryptHandle, attributeType, value );
	(*env)->ReleaseIntArrayElements(env,j_value,value,0);
	return retval;
}

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptGetAttributeString(JNIEnv *env, jobject thisObj, jint cryptHandle, jint attributeType, jbyteArray j_value, jintArray j_valueLength)
{
	int retval;
	char *value = NULL;
	int *valueLength;
	if (j_value)
	{
		value = (*env)->GetByteArrayElements(env,j_value,0);
		if (!value) return 0;
	}
	valueLength = (*env)->GetIntArrayElements(env,j_valueLength,0);
	if (!valueLength) return 0;
	retval = cryptGetAttributeString( cryptHandle, attributeType, value, valueLength );
	(*env)->ReleaseIntArrayElements(env,j_valueLength,valueLength,0);
	if (j_value)
	{
		(*env)->ReleaseByteArrayElements(env,j_value,value,0);
	}
	return retval;
}

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptSetAttribute(JNIEnv *env, jobject thisObj, jint cryptHandle, jint attributeType, jint value)
{
	int retval;
	retval = cryptSetAttribute( cryptHandle, attributeType, value );
	return retval;
}

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptSetAttributeString(JNIEnv *env, jobject thisObj, jint cryptHandle, jint attributeType, jbyteArray j_value, jint valueLength)
{
	int retval;
	unsigned char *value;
	value = (*env)->GetByteArrayElements(env,j_value,0);
	if (!value) return 0;
	retval = cryptSetAttributeString( cryptHandle, attributeType, value, valueLength );
	(*env)->ReleaseByteArrayElements(env,j_value,value,0);
	return retval;
}

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptDeleteAttribute(JNIEnv *env, jobject thisObj, jint cryptHandle, jint attributeType)
{
	int retval;
	retval = cryptDeleteAttribute( cryptHandle, attributeType );
	return retval;
}

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptGenerateKey(JNIEnv *env, jobject thisObj, jint cryptContext)
{
	int retval;
	retval = cryptGenerateKey( cryptContext );
	return retval;
}

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptGenerateKeyAsync(JNIEnv *env, jobject thisObj, jint cryptContext)
{
	int retval;
	retval = cryptGenerateKeyAsync( cryptContext );
	return retval;
}

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptAsyncQuery(JNIEnv *env, jobject thisObj, jint cryptContext)
{
	int retval;
	retval = cryptAsyncQuery( cryptContext );
	return retval;
}

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptAsyncCancel(JNIEnv *env, jobject thisObj, jint cryptContext)
{
	int retval;
	retval = cryptAsyncCancel( cryptContext );
	return retval;
}

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptEncrypt(JNIEnv *env, jobject thisObj, jint cryptContext, jbyteArray j_buffer, jint length)
{
	int retval;
	unsigned char *buffer;
	buffer = (*env)->GetByteArrayElements(env, j_buffer, 0);
	if (!buffer) return 0;
	retval = cryptEncrypt( cryptContext, OUT buffer, length );
	(*env)->ReleaseByteArrayElements(env,j_buffer,buffer,0);
	return retval;
}

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptDecrypt(JNIEnv *env, jobject thisObj, jint cryptContext, jbyteArray j_buffer, jint length)
{
	int retval;
	unsigned char *buffer;
	buffer = (*env)->GetByteArrayElements(env, j_buffer, 0);
	if (!buffer) return 0;
	retval = cryptDecrypt( cryptContext, OUT buffer, length );
	(*env)->ReleaseByteArrayElements(env,j_buffer,buffer,0);
	return retval;
}

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptSignCert(JNIEnv *env, jobject thisObj, jint certificate, jint signContext)
{
	int retval;
	retval = cryptSignCert( certificate, signContext );
	return retval;
}

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptCheckCert(JNIEnv *env, jobject thisObj, jint certificate, jint sigCheckKey)
{
	int retval;
	retval = cryptCheckCert( certificate, sigCheckKey );
	return retval;
}

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptImportCert(JNIEnv *env, jobject thisObj, jbyteArray j_certObject, jint certObjectLength, jint cryptUser, jintArray j_certificate)
{
	int retval;
	unsigned char *certObject;
	int *certificate;
	certObject = (*env)->GetByteArrayElements(env,j_certObject,0);
	if (!certObject) return 0;
	certificate = (*env)->GetIntArrayElements(env,j_certificate,0);
	if (!certificate) return 0;
	retval = cryptImportCert( certObject, certObjectLength, cryptUser, certificate );
	(*env)->ReleaseIntArrayElements(env,j_certificate,certificate,0);
	(*env)->ReleaseByteArrayElements(env,j_certObject,certObject,0);
	return retval;
}

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptExportCert(JNIEnv *env, jobject thisObj, jbyteArray j_certObject, jintArray j_certObjectLength, jint certFormatType, jint certificate)
{
	int retval;
	char *certObject = NULL;
	int *certObjectLength;
	if (j_certObject)
	{
		certObject = (*env)->GetByteArrayElements(env,j_certObject,0);
		if (!certObject) return 0;
	}
	certObjectLength = (*env)->GetIntArrayElements(env,j_certObjectLength,0);
	if (!certObjectLength) return 0;
	retval = cryptExportCert( certObject, certObjectLength, certFormatType, certificate );
	(*env)->ReleaseIntArrayElements(env,j_certObjectLength,certObjectLength,0);
	if (j_certObject)
	{
		(*env)->ReleaseByteArrayElements(env,j_certObject,certObject,0);
	}
	return retval;
}

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptCAAddItem(JNIEnv *env, jobject thisObj, jint keyset, jint certificate)
{
	int retval;
	retval = cryptCAAddItem( keyset, certificate );
	return retval;
}

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptCAGetItem(JNIEnv *env, jobject thisObj, jint keyset, jintArray j_certificate, jint certType, jint keyIDtype, jstring j_keyID)
{
	int retval;
	int *certificate;
	char *keyID;
	const char *p_keyID;
	int keyIDLength;
	certificate = (*env)->GetIntArrayElements(env,j_certificate,0);
	if (!certificate) return 0;
	keyIDLength = (*env)->GetStringUTFLength(env,j_keyID);
	p_keyID = (*env)->GetStringUTFChars(env,j_keyID,0);
	if (!p_keyID) return 0;
	keyID = (char *)malloc(keyIDLength+1);
	memcpy(keyID, p_keyID, keyIDLength); keyID[keyIDLength] = 0;
	retval = cryptCAGetItem( keyset, certificate, certType, keyIDtype, keyID );
	free(keyID);
	(*env)->ReleaseStringUTFChars(env,j_keyID,p_keyID);
	(*env)->ReleaseIntArrayElements(env,j_certificate,certificate,0);
	return retval;
}

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptCADeleteItem(JNIEnv *env, jobject thisObj, jint keyset, jint keyIDtype, jstring j_keyID)
{
	int retval;
	char *keyID;
	const char *p_keyID;
	int keyIDLength;
	keyIDLength = (*env)->GetStringUTFLength(env,j_keyID);
	p_keyID = (*env)->GetStringUTFChars(env,j_keyID,0);
	if (!p_keyID) return 0;
	keyID = (char *)malloc(keyIDLength+1);
	memcpy(keyID, p_keyID, keyIDLength); keyID[keyIDLength] = 0;
	retval = cryptCADeleteItem( keyset, keyIDtype, keyID );
	free(keyID);
	(*env)->ReleaseStringUTFChars(env,j_keyID,p_keyID);
	return retval;
}

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptCACertManagement(JNIEnv *env, jobject thisObj, jintArray j_certificate, jint action, jint keyset, jint caKey, jint certRequest)
{
	int retval;
	int *certificate;
	certificate = (*env)->GetIntArrayElements(env,j_certificate,0);
	if (!certificate) return 0;
	retval = cryptCACertManagement( certificate, action, keyset, caKey, certRequest );
	(*env)->ReleaseIntArrayElements(env,j_certificate,certificate,0);
	return retval;
}

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptPushData(JNIEnv *env, jobject thisObj, jint envelope, jbyteArray j_buffer, jint length, jintArray j_bytesCopied)
{
	int retval;
	unsigned char *buffer;
	int *bytesCopied;
	buffer = (*env)->GetByteArrayElements(env,j_buffer,0);
	if (!buffer) return 0;
	bytesCopied = (*env)->GetIntArrayElements(env,j_bytesCopied,0);
	if (!bytesCopied) return 0;
	retval = cryptPushData( envelope, buffer, length, bytesCopied );
	(*env)->ReleaseIntArrayElements(env,j_bytesCopied,bytesCopied,0);
	(*env)->ReleaseByteArrayElements(env,j_buffer,buffer,0);
	return retval;
}

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptPopData(JNIEnv *env, jobject thisObj, jint envelope, jbyteArray j_buffer, jint length, jintArray j_bytesCopied)
{
	int retval;
	char *buffer = NULL;
	int *bytesCopied;
	if (j_buffer)
	{
		buffer = (*env)->GetByteArrayElements(env,j_buffer,0);
		if (!buffer) return 0;
	}
	bytesCopied = (*env)->GetIntArrayElements(env,j_bytesCopied,0);
	if (!bytesCopied) return 0;
	retval = cryptPopData( envelope, buffer, length, bytesCopied );
	(*env)->ReleaseIntArrayElements(env,j_bytesCopied,bytesCopied,0);
	if (j_buffer)
	{
		(*env)->ReleaseByteArrayElements(env,j_buffer,buffer,0);
	}
	return retval;
}

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptFlushData(JNIEnv *env, jobject thisObj, jint envelope)
{
	int retval;
	retval = cryptFlushData( envelope );
	return retval;
}

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptGetPublicKey(JNIEnv *env, jobject thisObj, jint keyset, jintArray j_cryptKey, jint keyIDtype, jstring j_keyID)
{
	int retval;
	int *cryptKey;
	char *keyID;
	const char *p_keyID;
	int keyIDLength;
	cryptKey = (*env)->GetIntArrayElements(env,j_cryptKey,0);
	if (!cryptKey) return 0;
	keyIDLength = (*env)->GetStringUTFLength(env,j_keyID);
	p_keyID = (*env)->GetStringUTFChars(env,j_keyID,0);
	if (!p_keyID) return 0;
	keyID = (char *)malloc(keyIDLength+1);
	memcpy(keyID, p_keyID, keyIDLength); keyID[keyIDLength] = 0;
	retval = cryptGetPublicKey( keyset, cryptKey, keyIDtype, keyID );
	free(keyID);
	(*env)->ReleaseStringUTFChars(env,j_keyID,p_keyID);
	(*env)->ReleaseIntArrayElements(env,j_cryptKey,cryptKey,0);
	return retval;
}

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptGetPrivateKey(JNIEnv *env, jobject thisObj, jint keyset, jintArray j_cryptContext, jint keyIDtype, jstring j_keyID, jstring j_password)
{
	int retval;
	int *cryptContext;
	char *keyID;
	const char *p_keyID;
	int keyIDLength;
	char *password;
	const char *p_password;
	int passwordLength;
	cryptContext = (*env)->GetIntArrayElements(env,j_cryptContext,0);
	if (!cryptContext) return 0;
	keyIDLength = (*env)->GetStringUTFLength(env,j_keyID);
	p_keyID = (*env)->GetStringUTFChars(env,j_keyID,0);
	if (!p_keyID) return 0;
	keyID = (char *)malloc(keyIDLength+1);
	memcpy(keyID, p_keyID, keyIDLength); keyID[keyIDLength] = 0;
	passwordLength = (*env)->GetStringUTFLength(env,j_password);
	p_password = (*env)->GetStringUTFChars(env,j_password,0);
	if (!p_password) return 0;
	password = (char *)malloc(passwordLength+1);
	memcpy(password, p_password, passwordLength); password[passwordLength] = 0;
	retval = cryptGetPrivateKey( keyset, cryptContext, keyIDtype, keyID, password );
	free(password);
	(*env)->ReleaseStringUTFChars(env,j_password,p_password);
	free(keyID);
	(*env)->ReleaseStringUTFChars(env,j_keyID,p_keyID);
	(*env)->ReleaseIntArrayElements(env,j_cryptContext,cryptContext,0);
	return retval;
}

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptAddPublicKey(JNIEnv *env, jobject thisObj, jint keyset, jint certificate)
{
	int retval;
	retval = cryptAddPublicKey( keyset, certificate );
	return retval;
}

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptAddPrivateKey(JNIEnv *env, jobject thisObj, jint keyset, jint cryptKey, jstring j_password)
{
	int retval;
	char *password;
	const char *p_password;
	int passwordLength;
	passwordLength = (*env)->GetStringUTFLength(env,j_password);
	p_password = (*env)->GetStringUTFChars(env,j_password,0);
	if (!p_password) return 0;
	password = (char *)malloc(passwordLength+1);
	memcpy(password, p_password, passwordLength); password[passwordLength] = 0;
	retval = cryptAddPrivateKey( keyset, cryptKey, password );
	free(password);
	(*env)->ReleaseStringUTFChars(env,j_password,p_password);
	return retval;
}

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptDeleteKey(JNIEnv *env, jobject thisObj, jint keyset, jint keyIDtype, jstring j_keyID)
{
	int retval;
	char *keyID;
	const char *p_keyID;
	int keyIDLength;
	keyIDLength = (*env)->GetStringUTFLength(env,j_keyID);
	p_keyID = (*env)->GetStringUTFChars(env,j_keyID,0);
	if (!p_keyID) return 0;
	keyID = (char *)malloc(keyIDLength+1);
	memcpy(keyID, p_keyID, keyIDLength); keyID[keyIDLength] = 0;
	retval = cryptDeleteKey( keyset, keyIDtype, keyID );
	free(keyID);
	(*env)->ReleaseStringUTFChars(env,j_keyID,p_keyID);
	return retval;
}

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptQueryCapability(JNIEnv *env, jobject thisObj, jint cryptAlgo, jobjectArray p_algoName, jintArray j_sizes)
{
	int retval;
	CRYPT_QUERY_INFO qi;
	CRYPT_QUERY_INFO *cryptQueryInfo = &qi;
	int *sizes;
	jstring j_algoName;
	sizes = (*env)->GetIntArrayElements(env, j_sizes, 0);
	if (!sizes) return 0;
	retval = cryptQueryCapability( cryptAlgo, cryptQueryInfo );
	j_algoName = (*env)->NewStringUTF(env, qi.algoName);
	if (!p_algoName) return 0;
	(*env)->SetObjectArrayElement(env, p_algoName, 0, j_algoName);
	sizes[0] = qi.blockSize;
	sizes[1] = qi.minKeySize;
	sizes[2] = qi.keySize;
	sizes[3] = qi.maxKeySize;
	(*env)->ReleaseIntArrayElements(env, j_sizes, sizes, 0);
	return retval;
}

JNIEXPORT jint JNICALL Java_com_cryptlib_CryptLib_cryptDeviceQueryCapability(JNIEnv *env, jobject thisObj, jint device, jint cryptAlgo, jobjectArray p_algoName, jintArray j_sizes)
{
	int retval;
	CRYPT_QUERY_INFO qi;
	CRYPT_QUERY_INFO *cryptQueryInfo = &qi;
	int *sizes;
	jstring j_algoName;
	sizes = (*env)->GetIntArrayElements(env, j_sizes, 0);
	if (!sizes) return 0;
	retval = cryptDeviceQueryCapability( device, cryptAlgo, cryptQueryInfo );
	j_algoName = (*env)->NewStringUTF(env, qi.algoName);
	if (!p_algoName) return 0;
	(*env)->SetObjectArrayElement(env, p_algoName, 0, j_algoName);
	sizes[0] = qi.blockSize;
	sizes[1] = qi.minKeySize;
	sizes[2] = qi.keySize;
	sizes[3] = qi.maxKeySize;
	(*env)->ReleaseIntArrayElements(env, j_sizes, sizes, 0);
	return retval;
}

