/****************************************************************************
*																			*
*						 cryptlib External API Interface					*
*						Copyright Peter Gutmann 1997-2003					*
*																			*
****************************************************************************/

/* NSA motto: In God we trust... all others we monitor.
														-- Stanley Miller */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "crypt.h"
#if defined( INC_ALL )
  #include "rpc.h"
#else
  #include "misc/rpc.h"
#endif /* Compiler-specific includes */

/* Handlers for the various commands */

static int cmdAsyncOp( void *stateInfo, COMMAND_INFO *cmd )
	

static int cmdCertCheck( void *stateInfo, COMMAND_INFO *cmd )
	

static int cmdCertMgmt( void *stateInfo, COMMAND_INFO *cmd )
	

static int cmdCertSign( void *stateInfo, COMMAND_INFO *cmd )
	

static int cmdCreateObject( void *stateInfo, COMMAND_INFO *cmd )
	

static int cmdCreateObjectIndirect( void *stateInfo, COMMAND_INFO *cmd )
	

static int cmdDecrypt( void *stateInfo, COMMAND_INFO *cmd )
	

static int cmdDeleteAttribute( void *stateInfo, COMMAND_INFO *cmd )
	

static int cmdDeleteKey( void *stateInfo, COMMAND_INFO *cmd )
	

static int cmdDestroyObject( void *stateInfo, COMMAND_INFO *cmd )
	

static int cmdEncrypt( void *stateInfo, COMMAND_INFO *cmd )
	

static int cmdExportObject( void *stateInfo, COMMAND_INFO *cmd )
	

static int cmdFlushData( void *stateInfo, COMMAND_INFO *cmd )
	

static int cmdGenKey( void *stateInfo, COMMAND_INFO *cmd )
	

static int cmdGetAttribute( void *stateInfo, COMMAND_INFO *cmd )
	

static int cmdGetKey( void *stateInfo, COMMAND_INFO *cmd )
	

static int cmdPopData( void *stateInfo, COMMAND_INFO *cmd )
	

static int cmdPushData( void *stateInfo, COMMAND_INFO *cmd )
	

static int cmdQueryCapability( void *stateInfo, COMMAND_INFO *cmd )
	

#ifdef USE_RPCAPI

static int cmdServerQuery( void *stateInfo, COMMAND_INFO *cmd )
	
#endif /* USE_RPCAPI */

static int cmdSetAttribute( void *stateInfo, COMMAND_INFO *cmd )
	

static int cmdSetKey( void *stateInfo, COMMAND_INFO *cmd )
	

#ifdef USE_RPCAPI

/* Process a command from the client and send it to the appropriate handler */

static const COMMAND_HANDLER commandHandlers[] = ;

static void processCommand( BYTE *buffer )
	

/* Dummy forwarding procedure to take the place of the comms channel between
   client and server */

static void serverTransact( void *clientBuffer )
	

/* Dispatch a command to the server */

static int dispatchCommand( COMMAND_INFO *cmd )
	
#endif /* USE_RPCAPI */

/****************************************************************************
*																			*
*						Client-side Translation Handling					*
*																			*
****************************************************************************/

/* When the cryptlib client is using a different character set, we need to 
   map from the internal to the external character set.  The following 
   function checks for attribute values that contain text strings.  In 
   addition the functions cryptGetPrivateKey(), cryptAddPrivateKey(), and
   cryptLogin() use text strings that need to be mapped to the internal
   character set */

#ifdef EBCDIC_CHARS

static BOOLEAN needsTranslation( const CRYPT_ATTRIBUTE_TYPE attribute )
	
#endif /* EBCDIC_CHARS */

/****************************************************************************
*																			*
*								Utility Functions							*
*																			*
****************************************************************************/

/* Internal parameter errors are reported in terms of the parameter type (eg
   invalid object, invalid attribute), but externally they're reported in
   terms of parameter numbers.  Before we return error values to the caller,
   we have to map them from the internal representation to the position they
   occur in in the function parameter list.  The following function takes a
   list of parameter types and maps the returned parameter type error to a
   parameter position error */

typedef enum  ERRORMAP;

static int mapError( const ERRORMAP *errorMap, const int status )
	

/****************************************************************************
*																			*
*								Create/Destroy Objects						*
*																			*
****************************************************************************/

/* Create an encryption context */

C_RET cryptCreateContext( C_OUT CRYPT_CONTEXT C_PTR cryptContext,
						  C_IN CRYPT_USER cryptUser,
						  C_IN CRYPT_ALGO_TYPE cryptAlgo )
	

/* Create an encryption context via the device */

C_RET cryptDeviceCreateContext( C_IN CRYPT_DEVICE device,
							    C_OUT CRYPT_CONTEXT C_PTR cryptContext,
							    C_IN CRYPT_ALGO_TYPE cryptAlgo )
	

/* Create a certificate */

C_RET cryptCreateCert( C_OUT CRYPT_CERTIFICATE C_PTR certificate,
					   C_IN CRYPT_USER cryptUser,
					   C_IN CRYPT_CERTTYPE_TYPE certType )
	

/* Open a device */

C_RET cryptDeviceOpen( C_OUT CRYPT_DEVICE C_PTR device,
					   C_IN CRYPT_USER cryptUser,
					   C_IN CRYPT_DEVICE_TYPE deviceType,
					   C_IN char C_PTR name )
	

/* Create an envelope */

C_RET cryptCreateEnvelope( C_OUT CRYPT_ENVELOPE C_PTR envelope,
						   C_IN CRYPT_USER cryptUser,
						   C_IN CRYPT_FORMAT_TYPE formatType )
	

/* Open/create a keyset */

C_RET cryptKeysetOpen( C_OUT CRYPT_KEYSET C_PTR keyset,
					   C_IN CRYPT_USER cryptUser,
					   C_IN CRYPT_KEYSET_TYPE keysetType,
					   C_IN char C_PTR name, C_IN CRYPT_KEYOPT_TYPE options )
	

/* Create a session */

C_RET cryptCreateSession( C_OUT CRYPT_SESSION C_PTR session,
						  C_IN CRYPT_USER cryptUser,
						  C_IN CRYPT_SESSION_TYPE sessionType )
	

/* Log on/create a user object */

C_RET cryptLogin( C_OUT CRYPT_USER C_PTR user,
				  C_IN char C_PTR name, C_IN char C_PTR password )
	

/* Destroy object functions */

C_RET cryptDestroyObject( C_IN CRYPT_HANDLE cryptHandle )
	

C_RET cryptDestroyCert( C_IN CRYPT_CERTIFICATE certificate )
	
C_RET cryptDestroyContext( C_IN CRYPT_CONTEXT cryptContext )
	
C_RET cryptDestroyEnvelope( C_IN CRYPT_ENVELOPE cryptEnvelope )
	
C_RET cryptDeviceClose( C_IN CRYPT_DEVICE device )
	
C_RET cryptKeysetClose( C_IN CRYPT_KEYSET keyset )
	
C_RET cryptDestroySession( C_IN CRYPT_SESSION session )
	
C_RET cryptLogout( C_IN CRYPT_USER user )
	

/****************************************************************************
*																			*
*						Attribute Manipulation Functions					*
*																			*
****************************************************************************/

/* Get an attribute */

C_RET cryptGetAttribute( C_IN CRYPT_HANDLE cryptHandle,
						 C_IN CRYPT_ATTRIBUTE_TYPE attributeType,
						 C_OUT int C_PTR value )
	

C_RET cryptGetAttributeString( C_IN CRYPT_HANDLE cryptHandle,
							   C_IN CRYPT_ATTRIBUTE_TYPE attributeType,
							   C_OUT void C_PTR value,
							   C_OUT int C_PTR valueLength )
	

/* Set an attribute */

C_RET cryptSetAttribute( C_IN CRYPT_HANDLE cryptHandle,
						 C_IN CRYPT_ATTRIBUTE_TYPE attributeType,
						 C_IN int value )
	

C_RET cryptSetAttributeString( C_IN CRYPT_HANDLE cryptHandle,
							   C_IN CRYPT_ATTRIBUTE_TYPE attributeType,
							   C_IN void C_PTR value, C_IN int valueLength )
	

/* Delete an attribute */

C_RET cryptDeleteAttribute( C_IN CRYPT_HANDLE cryptHandle,
							C_IN CRYPT_ATTRIBUTE_TYPE attributeType )
	

/****************************************************************************
*																			*
*								Encryption Functions						*
*																			*
****************************************************************************/

/* Generate a key into an encryption context */

C_RET cryptGenerateKey( C_IN CRYPT_CONTEXT cryptContext )
	

/* Asynchronous key generate operations */

C_RET cryptGenerateKeyAsync( C_IN CRYPT_CONTEXT cryptContext )
	

/* Query the status of an asynchronous operation.  This has more or less the
   same effect as calling any other operation (both will return
   CRYPT_ERROR_TIMEOUT if the context is busy), but this is a pure query
   function with no other side effects */

C_RET cryptAsyncQuery( C_IN CRYPT_CONTEXT cryptContext )
	

/* Cancel an asynchronous operation on a context */

C_RET cryptAsyncCancel( C_IN CRYPT_CONTEXT cryptContext )
	

/* Encrypt/decrypt data */

C_RET cryptEncrypt( C_IN CRYPT_CONTEXT cryptContext,
					C_INOUT void C_PTR buffer,
					C_IN int length )
	

C_RET cryptDecrypt( C_IN CRYPT_CONTEXT cryptContext,
					C_INOUT void C_PTR buffer,
					C_IN int length )
	

/****************************************************************************
*																			*
*								Certificate Functions						*
*																			*
****************************************************************************/

/* Sign/sig.check a certificate object.  The possibilities for signing are as
   follows:

						Signer
	Type  |		Cert				Chain
	------+--------------------+---------------
	Cert  | Cert			   | Cert
		  |					   |
	Chain | Chain, length = 2  | Chain, length = n+1

   For sig.checking the cert object is checked against an issuing key/
   certificate or against a CRL, either as a raw CRL or a keyset contain
   revocation information */

C_RET cryptSignCert( C_IN CRYPT_CERTIFICATE certificate,
					 C_IN CRYPT_CONTEXT signContext )
	

C_RET cryptCheckCert( C_IN CRYPT_HANDLE certificate,
					  C_IN CRYPT_HANDLE sigCheckKey )
	

/* Import/export a certificate, CRL, certification request, or cert chain.
   In the export case this just copies the internal encoded object to an
   external buffer.  For cert/cert chain export the possibilities are as
   follows:

						Export
	Type  |		Cert				Chain
	------+--------------------+---------------
	Cert  | Cert			   | Cert as chain
		  |					   |
	Chain | Currently selected | Chain
		  | cert in chain	   | */

C_RET cryptImportCert( C_IN void C_PTR certObject,
					   C_IN int certObjectLength,
					   C_IN CRYPT_USER cryptUser,
					   C_OUT CRYPT_CERTIFICATE C_PTR certificate )
	

C_RET cryptExportCert( C_OUT void C_PTR certObject,
					   C_OUT int C_PTR certObjectLength,
					   C_IN CRYPT_CERTFORMAT_TYPE certFormatType,
					   C_IN CRYPT_HANDLE certificate )
	

/* CA management functions */

C_RET cryptCAAddItem( C_IN CRYPT_KEYSET keyset,
					  C_IN CRYPT_CERTIFICATE certificate )
	

C_RET cryptCAGetItem( C_IN CRYPT_KEYSET keyset,
					  C_OUT CRYPT_CERTIFICATE C_PTR certificate,
					  C_IN CRYPT_CERTTYPE_TYPE certType,
					  C_IN CRYPT_KEYID_TYPE keyIDtype,
					  C_IN char C_PTR keyID )
	

C_RET cryptCADeleteItem( C_IN CRYPT_KEYSET keyset,
						 C_IN CRYPT_KEYID_TYPE keyIDtype,
						 C_IN char C_PTR keyID )
	

C_RET cryptCACertManagement( C_OUT CRYPT_CERTIFICATE C_PTR certificate,
							 C_IN CRYPT_CERTACTION_TYPE action,
							 C_IN CRYPT_KEYSET keyset,
							 C_IN CRYPT_CONTEXT caKey,
							 C_IN CRYPT_CERTIFICATE certRequest )
	

/****************************************************************************
*																			*
*								Envelope Functions							*
*																			*
****************************************************************************/

/* Push data into an envelope/session object */

C_RET cryptPushData( C_IN CRYPT_HANDLE envelope, C_IN void C_PTR buffer,
					 C_IN int length, C_OUT int C_PTR bytesCopied )
	

/* Pop data from an envelope/session object */

C_RET cryptPopData( C_IN CRYPT_ENVELOPE envelope, C_OUT void C_PTR buffer,
					C_IN int length, C_OUT int C_PTR bytesCopied )
	

/* Flush data through an envelope/session object */

C_RET cryptFlushData( C_IN CRYPT_HANDLE envelope )
	

/****************************************************************************
*																			*
*								Keyset Functions							*
*																			*
****************************************************************************/

/* Retrieve a key from a keyset or equivalent object */

C_RET cryptGetPublicKey( C_IN CRYPT_KEYSET keyset,
						 C_OUT CRYPT_HANDLE C_PTR cryptKey,
						 C_IN CRYPT_KEYID_TYPE keyIDtype,
						 C_IN char C_PTR keyID )
	

C_RET cryptGetPrivateKey( C_IN CRYPT_HANDLE keyset,
						  C_OUT CRYPT_CONTEXT C_PTR cryptContext,
						  C_IN CRYPT_KEYID_TYPE keyIDtype,
						  C_IN char C_PTR keyID, C_IN char C_PTR password )
	

/* Add a key from a keyset or equivalent object */

C_RET cryptAddPublicKey( C_IN CRYPT_KEYSET keyset,
						 C_IN CRYPT_CERTIFICATE certificate )
	

C_RET cryptAddPrivateKey( C_IN CRYPT_KEYSET keyset,
						  C_IN CRYPT_HANDLE cryptKey,
						  C_IN char C_PTR password )
	

/* Delete a key from a keyset or equivalent object */

C_RET cryptDeleteKey( C_IN CRYPT_KEYSET keyset,
					  C_IN CRYPT_KEYID_TYPE keyIDtype,
					  C_IN char C_PTR keyID )
	

/****************************************************************************
*																			*
*							User Management Functions						*
*																			*
****************************************************************************/

/****************************************************************************
*																			*
*									Misc Functions							*
*																			*
****************************************************************************/

/* cryptlib/object query functions */

C_RET cryptQueryCapability( C_IN CRYPT_ALGO_TYPE cryptAlgo,
							C_OUT CRYPT_QUERY_INFO C_PTR cryptQueryInfo )
	

C_RET cryptDeviceQueryCapability( C_IN CRYPT_DEVICE device,
								  C_IN CRYPT_ALGO_TYPE cryptAlgo,
								  C_OUT CRYPT_QUERY_INFO C_PTR cryptQueryInfo )
	
