/*
 * Decompiled with CFR 0.152.
 */
package cryptlib;

import cryptlib.CryptException;
import java.nio.ByteBuffer;

public class crypt {
    public static final int ALGO_NONE = 0;
    public static final int ALGO_DES = 1;
    public static final int ALGO_3DES = 2;
    public static final int ALGO_IDEA = 3;
    public static final int ALGO_CAST = 4;
    public static final int ALGO_RC2 = 5;
    public static final int ALGO_RC4 = 6;
    public static final int ALGO_RC5 = 7;
    public static final int ALGO_AES = 8;
    public static final int ALGO_BLOWFISH = 9;
    public static final int ALGO_SKIPJACK = 10;
    public static final int ALGO_DH = 100;
    public static final int ALGO_RSA = 101;
    public static final int ALGO_DSA = 102;
    public static final int ALGO_ELGAMAL = 103;
    public static final int ALGO_KEA = 104;
    public static final int ALGO_MD2 = 200;
    public static final int ALGO_MD4 = 201;
    public static final int ALGO_MD5 = 202;
    public static final int ALGO_SHA = 203;
    public static final int ALGO_RIPEMD160 = 204;
    public static final int ALGO_HMAC_MD5 = 300;
    public static final int ALGO_HMAC_SHA = 301;
    public static final int ALGO_HMAC_RIPEMD160 = 302;
    public static final int ALGO_LAST = 303;
    public static final int ALGO_FIRST_CONVENTIONAL = 1;
    public static final int ALGO_LAST_CONVENTIONAL = 99;
    public static final int ALGO_FIRST_PKC = 100;
    public static final int ALGO_LAST_PKC = 199;
    public static final int ALGO_FIRST_HASH = 200;
    public static final int ALGO_LAST_HASH = 299;
    public static final int ALGO_FIRST_MAC = 300;
    public static final int ALGO_LAST_MAC = 399;
    public static final int MODE_NONE = 0;
    public static final int MODE_ECB = 1;
    public static final int MODE_CBC = 2;
    public static final int MODE_CFB = 3;
    public static final int MODE_OFB = 4;
    public static final int MODE_LAST = 5;
    public static final int KEYSET_NONE = 0;
    public static final int KEYSET_FILE = 1;
    public static final int KEYSET_HTTP = 2;
    public static final int KEYSET_LDAP = 3;
    public static final int KEYSET_ODBC = 4;
    public static final int KEYSET_MYSQL = 5;
    public static final int KEYSET_DATABASE = 6;
    public static final int KEYSET_ODBC_STORE = 7;
    public static final int KEYSET_MYSQL_STORE = 8;
    public static final int KEYSET_DATABASE_STORE = 9;
    public static final int KEYSET_LAST = 10;
    public static final int DEVICE_NONE = 0;
    public static final int DEVICE_FORTEZZA = 1;
    public static final int DEVICE_PKCS11 = 2;
    public static final int DEVICE_LAST = 3;
    public static final int CERTTYPE_NONE = 0;
    public static final int CERTTYPE_CERTIFICATE = 1;
    public static final int CERTTYPE_ATTRIBUTE_CERT = 2;
    public static final int CERTTYPE_CERTCHAIN = 3;
    public static final int CERTTYPE_CERTREQUEST = 4;
    public static final int CERTTYPE_REQUEST_CERT = 5;
    public static final int CERTTYPE_REQUEST_REVOCATION = 6;
    public static final int CERTTYPE_CRL = 7;
    public static final int CERTTYPE_CMS_ATTRIBUTES = 8;
    public static final int CERTTYPE_OCSP_REQUEST = 9;
    public static final int CERTTYPE_OCSP_RESPONSE = 10;
    public static final int CERTTYPE_PKIUSER = 11;
    public static final int CERTTYPE_LAST = 12;
    public static final int FORMAT_NONE = 0;
    public static final int FORMAT_AUTO = 1;
    public static final int FORMAT_CRYPTLIB = 2;
    public static final int FORMAT_CMS = 3;
    public static final int FORMAT_PKCS7 = 3;
    public static final int FORMAT_SMIME = 4;
    public static final int FORMAT_PGP = 5;
    public static final int FORMAT_LAST = 6;
    public static final int SESSION_NONE = 0;
    public static final int SESSION_SSH = 1;
    public static final int SESSION_SSH_SERVER = 2;
    public static final int SESSION_SSL = 3;
    public static final int SESSION_SSL_SERVER = 4;
    public static final int SESSION_OCSP = 5;
    public static final int SESSION_OCSP_SERVER = 6;
    public static final int SESSION_TSP = 7;
    public static final int SESSION_TSP_SERVER = 8;
    public static final int SESSION_CMP = 9;
    public static final int SESSION_CMP_SERVER = 10;
    public static final int SESSION_LAST = 11;
    public static final int USER_NONE = 0;
    public static final int USER_NORMAL = 1;
    public static final int USER_SO = 2;
    public static final int USER_CA = 3;
    public static final int USER_LAST = 4;
    public static final int ATTRIBUTE_NONE = 0;
    public static final int PROPERTY_FIRST = 1;
    public static final int PROPERTY_HIGHSECURITY = 2;
    public static final int PROPERTY_OWNER = 3;
    public static final int PROPERTY_FORWARDCOUNT = 4;
    public static final int PROPERTY_LOCKED = 5;
    public static final int PROPERTY_USAGECOUNT = 6;
    public static final int PROPERTY_NONEXPORTABLE = 7;
    public static final int PROPERTY_LAST = 8;
    public static final int GENERIC_FIRST = 9;
    public static final int ATTRIBUTE_ERRORTYPE = 10;
    public static final int ATTRIBUTE_ERRORLOCUS = 11;
    public static final int ATTRIBUTE_INT_ERRORCODE = 12;
    public static final int ATTRIBUTE_INT_ERRORMESSAGE = 13;
    public static final int ATTRIBUTE_BUFFERSIZE = 14;
    public static final int GENERIC_LAST = 15;
    public static final int OPTION_FIRST = 100;
    public static final int OPTION_INFO_DESCRIPTION = 101;
    public static final int OPTION_INFO_COPYRIGHT = 102;
    public static final int OPTION_INFO_MAJORVERSION = 103;
    public static final int OPTION_INFO_MINORVERSION = 104;
    public static final int OPTION_INFO_STEPPING = 105;
    public static final int OPTION_ENCR_ALGO = 106;
    public static final int OPTION_ENCR_HASH = 107;
    public static final int OPTION_ENCR_MAC = 108;
    public static final int OPTION_PKC_ALGO = 109;
    public static final int OPTION_PKC_KEYSIZE = 110;
    public static final int OPTION_SIG_ALGO = 111;
    public static final int OPTION_SIG_KEYSIZE = 112;
    public static final int OPTION_KEYING_ALGO = 113;
    public static final int OPTION_KEYING_ITERATIONS = 114;
    public static final int OPTION_CERT_SIGNUNRECOGNISEDATTRIBUTES = 115;
    public static final int OPTION_CERT_VALIDITY = 116;
    public static final int OPTION_CERT_UPDATEINTERVAL = 117;
    public static final int OPTION_CMS_DEFAULTATTRIBUTES = 118;
    public static final int OPTION_SMIME_DEFAULTATTRIBUTES = 118;
    public static final int OPTION_KEYS_LDAP_OBJECTCLASS = 119;
    public static final int OPTION_KEYS_LDAP_OBJECTTYPE = 120;
    public static final int OPTION_KEYS_LDAP_FILTER = 121;
    public static final int OPTION_KEYS_LDAP_CACERTNAME = 122;
    public static final int OPTION_KEYS_LDAP_CERTNAME = 123;
    public static final int OPTION_KEYS_LDAP_CRLNAME = 124;
    public static final int OPTION_KEYS_LDAP_EMAILNAME = 125;
    public static final int OPTION_DEVICE_PKCS11_DVR01 = 126;
    public static final int OPTION_DEVICE_PKCS11_DVR02 = 127;
    public static final int OPTION_DEVICE_PKCS11_DVR03 = 128;
    public static final int OPTION_DEVICE_PKCS11_DVR04 = 129;
    public static final int OPTION_DEVICE_PKCS11_DVR05 = 130;
    public static final int OPTION_DEVICE_PKCS11_HARDWAREONLY = 131;
    public static final int OPTION_NET_SOCKS_SERVER = 132;
    public static final int OPTION_NET_SOCKS_USERNAME = 133;
    public static final int OPTION_NET_HTTP_PROXY = 134;
    public static final int OPTION_NET_CONNECTTIMEOUT = 135;
    public static final int OPTION_NET_TIMEOUT = 136;
    public static final int OPTION_MISC_ASYNCINIT = 137;
    public static final int OPTION_CONFIGCHANGED = 138;
    public static final int OPTION_SELFTESTOK = 139;
    public static final int OPTION_LAST = 140;
    public static final int CTXINFO_FIRST = 1000;
    public static final int CTXINFO_ALGO = 1001;
    public static final int CTXINFO_MODE = 1002;
    public static final int CTXINFO_NAME_ALGO = 1003;
    public static final int CTXINFO_NAME_MODE = 1004;
    public static final int CTXINFO_KEYSIZE = 1005;
    public static final int CTXINFO_BLOCKSIZE = 1006;
    public static final int CTXINFO_IVSIZE = 1007;
    public static final int CTXINFO_KEYING_ALGO = 1008;
    public static final int CTXINFO_KEYING_ITERATIONS = 1009;
    public static final int CTXINFO_KEYING_SALT = 1010;
    public static final int CTXINFO_KEYING_VALUE = 1011;
    public static final int CTXINFO_KEY = 1012;
    public static final int CTXINFO_KEY_COMPONENTS = 1013;
    public static final int CTXINFO_IV = 1014;
    public static final int CTXINFO_HASHVALUE = 1015;
    public static final int CTXINFO_LABEL = 1016;
    public static final int CTXINFO_LAST = 1017;
    public static final int CERTINFO_FIRST = 2000;
    public static final int CERTINFO_SELFSIGNED = 2001;
    public static final int CERTINFO_IMMUTABLE = 2002;
    public static final int CERTINFO_XYZZY = 2003;
    public static final int CERTINFO_CERTTYPE = 2004;
    public static final int CERTINFO_FINGERPRINT = 2005;
    public static final int CERTINFO_FINGERPRINT_MD5 = 2005;
    public static final int CERTINFO_FINGERPRINT_SHA = 2006;
    public static final int CERTINFO_CURRENT_CERTIFICATE = 2007;
    public static final int CERTINFO_CURRENT_EXTENSION = 2008;
    public static final int CERTINFO_CURRENT_FIELD = 2009;
    public static final int CERTINFO_CURRENT_COMPONENT = 2010;
    public static final int CERTINFO_TRUSTED_USAGE = 2011;
    public static final int CERTINFO_TRUSTED_IMPLICIT = 2012;
    public static final int CERTINFO_SIGNATURELEVEL = 2013;
    public static final int CERTINFO_VERSION = 2014;
    public static final int CERTINFO_SERIALNUMBER = 2015;
    public static final int CERTINFO_SUBJECTPUBLICKEYINFO = 2016;
    public static final int CERTINFO_USERCERTIFICATE = 2017;
    public static final int CERTINFO_CERTIFICATE = 2017;
    public static final int CERTINFO_CACERTIFICATE = 2018;
    public static final int CERTINFO_ISSUERNAME = 2019;
    public static final int CERTINFO_VALIDFROM = 2020;
    public static final int CERTINFO_VALIDTO = 2021;
    public static final int CERTINFO_SUBJECTNAME = 2022;
    public static final int CERTINFO_ISSUERUNIQUEID = 2023;
    public static final int CERTINFO_SUBJECTUNIQUEID = 2024;
    public static final int CERTINFO_CERTREQUEST = 2025;
    public static final int CERTINFO_THISUPDATE = 2026;
    public static final int CERTINFO_NEXTUPDATE = 2027;
    public static final int CERTINFO_REVOCATIONDATE = 2028;
    public static final int CERTINFO_REVOCATIONSTATUS = 2029;
    public static final int CERTINFO_CERTSTATUS = 2030;
    public static final int CERTINFO_DN = 2031;
    public static final int CERTINFO_PKIUSER_ID = 2032;
    public static final int CERTINFO_PKIUSER_ISSUEPASSWORD = 2033;
    public static final int CERTINFO_PKIUSER_REVPASSWORD = 2034;
    public static final int CERTINFO_COUNTRYNAME = 2100;
    public static final int CERTINFO_STATEORPROVINCENAME = 2101;
    public static final int CERTINFO_LOCALITYNAME = 2102;
    public static final int CERTINFO_ORGANIZATIONNAME = 2103;
    public static final int CERTINFO_ORGANISATIONNAME = 2103;
    public static final int CERTINFO_ORGANIZATIONALUNITNAME = 2104;
    public static final int CERTINFO_ORGANISATIONALUNITNAME = 2104;
    public static final int CERTINFO_COMMONNAME = 2105;
    public static final int CERTINFO_OTHERNAME_TYPEID = 2106;
    public static final int CERTINFO_OTHERNAME_VALUE = 2107;
    public static final int CERTINFO_RFC822NAME = 2108;
    public static final int CERTINFO_EMAIL = 2108;
    public static final int CERTINFO_DNSNAME = 2109;
    public static final int CERTINFO_DIRECTORYNAME = 2110;
    public static final int CERTINFO_EDIPARTYNAME_NAMEASSIGNER = 2111;
    public static final int CERTINFO_EDIPARTYNAME_PARTYNAME = 2112;
    public static final int CERTINFO_UNIFORMRESOURCEIDENTIFIER = 2113;
    public static final int CERTINFO_IPADDRESS = 2114;
    public static final int CERTINFO_REGISTEREDID = 2115;
    public static final int CERTINFO_CRLEXTREASON = 2200;
    public static final int CERTINFO_KEYFEATURES = 2201;
    public static final int CERTINFO_AUTHORITYINFOACCESS = 2202;
    public static final int CERTINFO_AUTHORITYINFO_OCSP = 2203;
    public static final int CERTINFO_AUTHORITYINFO_CAISSUERS = 2204;
    public static final int CERTINFO_AUTHORITYINFO_TIMESTAMPING = 2205;
    public static final int CERTINFO_OCSP_NONCE = 2206;
    public static final int CERTINFO_OCSP_RESPONSE = 2207;
    public static final int CERTINFO_OCSP_RESPONSE_STANDARD = 2208;
    public static final int CERTINFO_OCSP_RESPONSE_BASIC = 2209;
    public static final int CERTINFO_OCSP_RESPONSE_FULL = 2210;
    public static final int CERTINFO_OCSP_NOCHECK = 2211;
    public static final int CERTINFO_OCSP_ARCHIVECUTOFF = 2212;
    public static final int CERTINFO_SUBJECTINFOACCESS = 2213;
    public static final int CERTINFO_SUBJECTINFO_CAREPOSITORY = 2214;
    public static final int CERTINFO_SUBJECTINFO_TIMESTAMPING = 2215;
    public static final int CERTINFO_SIGG_DATEOFCERTGEN = 2216;
    public static final int CERTINFO_SIGG_PROCURATION = 2217;
    public static final int CERTINFO_SIGG_PROCURE_COUNTRY = 2218;
    public static final int CERTINFO_SIGG_PROCURE_TYPEOFSUBSTITUTION = 2219;
    public static final int CERTINFO_SIGG_PROCURE_SIGNINGFOR = 2220;
    public static final int CERTINFO_SIGG_MONETARYLIMIT = 2221;
    public static final int CERTINFO_SIGG_MONETARY_CURRENCY = 2222;
    public static final int CERTINFO_SIGG_MONETARY_AMOUNT = 2223;
    public static final int CERTINFO_SIGG_MONETARY_EXPONENT = 2224;
    public static final int CERTINFO_SIGG_RESTRICTION = 2225;
    public static final int CERTINFO_STRONGEXTRANET = 2226;
    public static final int CERTINFO_STRONGEXTRANET_ZONE = 2227;
    public static final int CERTINFO_STRONGEXTRANET_ID = 2228;
    public static final int CERTINFO_SUBJECTDIRECTORYATTRIBUTES = 2229;
    public static final int CERTINFO_SUBJECTDIR_TYPE = 2230;
    public static final int CERTINFO_SUBJECTDIR_VALUES = 2231;
    public static final int CERTINFO_SUBJECTKEYIDENTIFIER = 2232;
    public static final int CERTINFO_KEYUSAGE = 2233;
    public static final int CERTINFO_PRIVATEKEYUSAGEPERIOD = 2234;
    public static final int CERTINFO_PRIVATEKEY_NOTBEFORE = 2235;
    public static final int CERTINFO_PRIVATEKEY_NOTAFTER = 2236;
    public static final int CERTINFO_SUBJECTALTNAME = 2237;
    public static final int CERTINFO_ISSUERALTNAME = 2238;
    public static final int CERTINFO_BASICCONSTRAINTS = 2239;
    public static final int CERTINFO_CA = 2240;
    public static final int CERTINFO_AUTHORITY = 2240;
    public static final int CERTINFO_PATHLENCONSTRAINT = 2241;
    public static final int CERTINFO_CRLNUMBER = 2242;
    public static final int CERTINFO_CRLREASON = 2243;
    public static final int CERTINFO_HOLDINSTRUCTIONCODE = 2244;
    public static final int CERTINFO_INVALIDITYDATE = 2245;
    public static final int CERTINFO_DELTACRLINDICATOR = 2246;
    public static final int CERTINFO_ISSUINGDISTRIBUTIONPOINT = 2247;
    public static final int CERTINFO_ISSUINGDIST_FULLNAME = 2248;
    public static final int CERTINFO_ISSUINGDIST_USERCERTSONLY = 2249;
    public static final int CERTINFO_ISSUINGDIST_CACERTSONLY = 2250;
    public static final int CERTINFO_ISSUINGDIST_SOMEREASONSONLY = 2251;
    public static final int CERTINFO_ISSUINGDIST_INDIRECTCRL = 2252;
    public static final int CERTINFO_CERTIFICATEISSUER = 2253;
    public static final int CERTINFO_NAMECONSTRAINTS = 2254;
    public static final int CERTINFO_PERMITTEDSUBTREES = 2255;
    public static final int CERTINFO_EXCLUDEDSUBTREES = 2256;
    public static final int CERTINFO_CRLDISTRIBUTIONPOINT = 2257;
    public static final int CERTINFO_CRLDIST_FULLNAME = 2258;
    public static final int CERTINFO_CRLDIST_REASONS = 2259;
    public static final int CERTINFO_CRLDIST_CRLISSUER = 2260;
    public static final int CERTINFO_CERTIFICATEPOLICIES = 2261;
    public static final int CERTINFO_CERTPOLICYID = 2262;
    public static final int CERTINFO_CERTPOLICY_CPSURI = 2263;
    public static final int CERTINFO_CERTPOLICY_ORGANIZATION = 2264;
    public static final int CERTINFO_CERTPOLICY_NOTICENUMBERS = 2265;
    public static final int CERTINFO_CERTPOLICY_EXPLICITTEXT = 2266;
    public static final int CERTINFO_POLICYMAPPINGS = 2267;
    public static final int CERTINFO_ISSUERDOMAINPOLICY = 2268;
    public static final int CERTINFO_SUBJECTDOMAINPOLICY = 2269;
    public static final int CERTINFO_AUTHORITYKEYIDENTIFIER = 2270;
    public static final int CERTINFO_AUTHORITY_KEYIDENTIFIER = 2271;
    public static final int CERTINFO_AUTHORITY_CERTISSUER = 2272;
    public static final int CERTINFO_AUTHORITY_CERTSERIALNUMBER = 2273;
    public static final int CERTINFO_POLICYCONSTRAINTS = 2274;
    public static final int CERTINFO_REQUIREEXPLICITPOLICY = 2275;
    public static final int CERTINFO_INHIBITPOLICYMAPPING = 2276;
    public static final int CERTINFO_EXTKEYUSAGE = 2277;
    public static final int CERTINFO_EXTKEY_MS_INDIVIDUALCODESIGNING = 2278;
    public static final int CERTINFO_EXTKEY_MS_COMMERCIALCODESIGNING = 2279;
    public static final int CERTINFO_EXTKEY_MS_CERTTRUSTLISTSIGNING = 2280;
    public static final int CERTINFO_EXTKEY_MS_TIMESTAMPSIGNING = 2281;
    public static final int CERTINFO_EXTKEY_MS_SERVERGATEDCRYPTO = 2282;
    public static final int CERTINFO_EXTKEY_MS_ENCRYPTEDFILESYSTEM = 2283;
    public static final int CERTINFO_EXTKEY_SERVERAUTH = 2284;
    public static final int CERTINFO_EXTKEY_CLIENTAUTH = 2285;
    public static final int CERTINFO_EXTKEY_CODESIGNING = 2286;
    public static final int CERTINFO_EXTKEY_EMAILPROTECTION = 2287;
    public static final int CERTINFO_EXTKEY_IPSECENDSYSTEM = 2288;
    public static final int CERTINFO_EXTKEY_IPSECTUNNEL = 2289;
    public static final int CERTINFO_EXTKEY_IPSECUSER = 2290;
    public static final int CERTINFO_EXTKEY_TIMESTAMPING = 2291;
    public static final int CERTINFO_EXTKEY_OCSPSIGNING = 2292;
    public static final int CERTINFO_EXTKEY_DIRECTORYSERVICE = 2293;
    public static final int CERTINFO_EXTKEY_NS_SERVERGATEDCRYPTO = 2294;
    public static final int CERTINFO_EXTKEY_VS_SERVERGATEDCRYPTO_CA = 2295;
    public static final int CERTINFO_FRESHESTCRL = 2296;
    public static final int CERTINFO_FRESHESTCRL_FULLNAME = 2297;
    public static final int CERTINFO_FRESHESTCRL_REASONS = 2298;
    public static final int CERTINFO_FRESHESTCRL_CRLISSUER = 2299;
    public static final int CERTINFO_INHIBITANYPOLICY = 2300;
    public static final int CERTINFO_NS_CERTTYPE = 2301;
    public static final int CERTINFO_NS_BASEURL = 2302;
    public static final int CERTINFO_NS_REVOCATIONURL = 2303;
    public static final int CERTINFO_NS_CAREVOCATIONURL = 2304;
    public static final int CERTINFO_NS_CERTRENEWALURL = 2305;
    public static final int CERTINFO_NS_CAPOLICYURL = 2306;
    public static final int CERTINFO_NS_SSLSERVERNAME = 2307;
    public static final int CERTINFO_NS_COMMENT = 2308;
    public static final int CERTINFO_SET_HASHEDROOTKEY = 2309;
    public static final int CERTINFO_SET_ROOTKEYTHUMBPRINT = 2310;
    public static final int CERTINFO_SET_CERTIFICATETYPE = 2311;
    public static final int CERTINFO_SET_MERCHANTDATA = 2312;
    public static final int CERTINFO_SET_MERID = 2313;
    public static final int CERTINFO_SET_MERACQUIRERBIN = 2314;
    public static final int CERTINFO_SET_MERCHANTLANGUAGE = 2315;
    public static final int CERTINFO_SET_MERCHANTNAME = 2316;
    public static final int CERTINFO_SET_MERCHANTCITY = 2317;
    public static final int CERTINFO_SET_MERCHANTSTATEPROVINCE = 2318;
    public static final int CERTINFO_SET_MERCHANTPOSTALCODE = 2319;
    public static final int CERTINFO_SET_MERCHANTCOUNTRYNAME = 2320;
    public static final int CERTINFO_SET_MERCOUNTRY = 2321;
    public static final int CERTINFO_SET_MERAUTHFLAG = 2322;
    public static final int CERTINFO_SET_CERTCARDREQUIRED = 2323;
    public static final int CERTINFO_SET_TUNNELING = 2324;
    public static final int CERTINFO_SET_TUNNELLING = 2324;
    public static final int CERTINFO_SET_TUNNELINGFLAG = 2325;
    public static final int CERTINFO_SET_TUNNELLINGFLAG = 2325;
    public static final int CERTINFO_SET_TUNNELINGALGID = 2326;
    public static final int CERTINFO_SET_TUNNELLINGALGID = 2326;
    public static final int CERTINFO_CMS_CONTENTTYPE = 2500;
    public static final int CERTINFO_CMS_MESSAGEDIGEST = 2501;
    public static final int CERTINFO_CMS_SIGNINGTIME = 2502;
    public static final int CERTINFO_CMS_COUNTERSIGNATURE = 2503;
    public static final int CERTINFO_CMS_SMIMECAPABILITIES = 2504;
    public static final int CERTINFO_CMS_SMIMECAP_3DES = 2505;
    public static final int CERTINFO_CMS_SMIMECAP_AES = 2506;
    public static final int CERTINFO_CMS_SMIMECAP_CAST128 = 2507;
    public static final int CERTINFO_CMS_SMIMECAP_IDEA = 2508;
    public static final int CERTINFO_CMS_SMIMECAP_RC2 = 2509;
    public static final int CERTINFO_CMS_SMIMECAP_RC5 = 2510;
    public static final int CERTINFO_CMS_SMIMECAP_SKIPJACK = 2511;
    public static final int CERTINFO_CMS_SMIMECAP_DES = 2512;
    public static final int CERTINFO_CMS_SMIMECAP_PREFERSIGNEDDATA = 2513;
    public static final int CERTINFO_CMS_SMIMECAP_CANNOTDECRYPTANY = 2514;
    public static final int CERTINFO_CMS_RECEIPTREQUEST = 2515;
    public static final int CERTINFO_CMS_RECEIPT_CONTENTIDENTIFIER = 2516;
    public static final int CERTINFO_CMS_RECEIPT_FROM = 2517;
    public static final int CERTINFO_CMS_RECEIPT_TO = 2518;
    public static final int CERTINFO_CMS_SECURITYLABEL = 2519;
    public static final int CERTINFO_CMS_SECLABEL_CLASSIFICATION = 2520;
    public static final int CERTINFO_CMS_SECLABEL_POLICY = 2521;
    public static final int CERTINFO_CMS_SECLABEL_PRIVACYMARK = 2522;
    public static final int CERTINFO_CMS_SECLABEL_CATTYPE = 2523;
    public static final int CERTINFO_CMS_SECLABEL_CATVALUE = 2524;
    public static final int CERTINFO_CMS_MLEXPANSIONHISTORY = 2525;
    public static final int CERTINFO_CMS_MLEXP_ENTITYIDENTIFIER = 2526;
    public static final int CERTINFO_CMS_MLEXP_TIME = 2527;
    public static final int CERTINFO_CMS_MLEXP_NONE = 2528;
    public static final int CERTINFO_CMS_MLEXP_INSTEADOF = 2529;
    public static final int CERTINFO_CMS_MLEXP_INADDITIONTO = 2530;
    public static final int CERTINFO_CMS_CONTENTHINTS = 2531;
    public static final int CERTINFO_CMS_CONTENTHINT_DESCRIPTION = 2532;
    public static final int CERTINFO_CMS_CONTENTHINT_TYPE = 2533;
    public static final int CERTINFO_CMS_EQUIVALENTLABEL = 2534;
    public static final int CERTINFO_CMS_EQVLABEL_POLICY = 2535;
    public static final int CERTINFO_CMS_EQVLABEL_CLASSIFICATION = 2536;
    public static final int CERTINFO_CMS_EQVLABEL_PRIVACYMARK = 2537;
    public static final int CERTINFO_CMS_EQVLABEL_CATTYPE = 2538;
    public static final int CERTINFO_CMS_EQVLABEL_CATVALUE = 2539;
    public static final int CERTINFO_CMS_SIGNINGCERTIFICATE = 2540;
    public static final int CERTINFO_CMS_SIGNINGCERT_ESSCERTID = 2541;
    public static final int CERTINFO_CMS_SIGNINGCERT_POLICIES = 2542;
    public static final int CERTINFO_CMS_SPCAGENCYINFO = 2543;
    public static final int CERTINFO_CMS_SPCAGENCYURL = 2544;
    public static final int CERTINFO_CMS_SPCSTATEMENTTYPE = 2545;
    public static final int CERTINFO_CMS_SPCSTMT_INDIVIDUALCODESIGNING = 2546;
    public static final int CERTINFO_CMS_SPCSTMT_COMMERCIALCODESIGNING = 2547;
    public static final int CERTINFO_CMS_SPCOPUSINFO = 2548;
    public static final int CERTINFO_LAST = 2549;
    public static final int KEYINFO_FIRST = 3000;
    public static final int KEYINFO_QUERY = 3001;
    public static final int KEYINFO_QUERY_REQUESTS = 3002;
    public static final int KEYINFO_LAST = 3003;
    public static final int DEVINFO_FIRST = 4000;
    public static final int DEVINFO_INITIALISE = 4001;
    public static final int DEVINFO_INITIALIZE = 4001;
    public static final int DEVINFO_AUTHENT_USER = 4002;
    public static final int DEVINFO_AUTHENT_SUPERVISOR = 4003;
    public static final int DEVINFO_SET_AUTHENT_USER = 4004;
    public static final int DEVINFO_SET_AUTHENT_SUPERVISOR = 4005;
    public static final int DEVINFO_ZEROISE = 4006;
    public static final int DEVINFO_ZEROIZE = 4006;
    public static final int DEVINFO_LOGGEDIN = 4007;
    public static final int DEVINFO_LABEL = 4008;
    public static final int DEVINFO_LAST = 4009;
    public static final int ENVINFO_FIRST = 5000;
    public static final int ENVINFO_DATASIZE = 5001;
    public static final int ENVINFO_COMPRESSION = 5002;
    public static final int ENVINFO_CONTENTTYPE = 5003;
    public static final int ENVINFO_DETACHEDSIGNATURE = 5004;
    public static final int ENVINFO_SIGNATURE_RESULT = 5005;
    public static final int ENVINFO_MAC = 5006;
    public static final int ENVINFO_CURRENT_COMPONENT = 5007;
    public static final int ENVINFO_PASSWORD = 5008;
    public static final int ENVINFO_KEY = 5009;
    public static final int ENVINFO_SIGNATURE = 5010;
    public static final int ENVINFO_SIGNATURE_EXTRADATA = 5011;
    public static final int ENVINFO_RECIPIENT = 5012;
    public static final int ENVINFO_PUBLICKEY = 5013;
    public static final int ENVINFO_PRIVATEKEY = 5014;
    public static final int ENVINFO_PRIVATEKEY_LABEL = 5015;
    public static final int ENVINFO_ORIGINATOR = 5016;
    public static final int ENVINFO_SESSIONKEY = 5017;
    public static final int ENVINFO_HASH = 5018;
    public static final int ENVINFO_TIMESTAMP_AUTHORITY = 5019;
    public static final int ENVINFO_KEYSET_SIGCHECK = 5020;
    public static final int ENVINFO_KEYSET_ENCRYPT = 5021;
    public static final int ENVINFO_KEYSET_DECRYPT = 5022;
    public static final int ENVINFO_LAST = 5023;
    public static final int SESSINFO_FIRST = 6000;
    public static final int SESSINFO_ACTIVE = 6001;
    public static final int SESSINFO_CONNECTIONACTIVE = 6002;
    public static final int SESSINFO_USERNAME = 6003;
    public static final int SESSINFO_PASSWORD = 6004;
    public static final int SESSINFO_PRIVATEKEY = 6005;
    public static final int SESSINFO_KEYSET = 6006;
    public static final int SESSINFO_SERVER_NAME = 6007;
    public static final int SESSINFO_SERVER_PORT = 6008;
    public static final int SESSINFO_CLIENT_NAME = 6009;
    public static final int SESSINFO_CLIENT_PORT = 6010;
    public static final int SESSINFO_SESSION = 6011;
    public static final int SESSINFO_VERSION = 6012;
    public static final int SESSINFO_REQUEST = 6013;
    public static final int SESSINFO_RESPONSE = 6014;
    public static final int SESSINFO_TSP_MSGIMPRINT = 6015;
    public static final int SESSINFO_CMP_CACERTIFICATE = 6016;
    public static final int SESSINFO_CMP_REQUESTTYPE = 6017;
    public static final int SESSINFO_SSH_FINGERPRINT = 6018;
    public static final int SESSINFO_LAST = 6019;
    public static final int USERINFO_FIRST = 7000;
    public static final int USERINFO_PASSWORD = 7001;
    public static final int USERINFO_CAKEY_CERTSIGN = 7002;
    public static final int USERINFO_CAKEY_CRLSIGN = 7003;
    public static final int USERINFO_CAKEY_OCSPSIGN = 7004;
    public static final int USERINFO_LAST = 7005;
    public static final int ATTRIBUTE_LAST = 7005;
    public static final int KEYUSAGE_NONE = 0;
    public static final int KEYUSAGE_DIGITALSIGNATURE = 1;
    public static final int KEYUSAGE_NONREPUDIATION = 2;
    public static final int KEYUSAGE_KEYENCIPHERMENT = 4;
    public static final int KEYUSAGE_DATAENCIPHERMENT = 8;
    public static final int KEYUSAGE_KEYAGREEMENT = 16;
    public static final int KEYUSAGE_KEYCERTSIGN = 32;
    public static final int KEYUSAGE_CRLSIGN = 64;
    public static final int KEYUSAGE_ENCIPHERONLY = 128;
    public static final int KEYUSAGE_DECIPHERONLY = 256;
    public static final int KEYUSAGE_LAST = 512;
    public static final int CRLREASON_UNSPECIFIED = 0;
    public static final int CRLREASON_KEYCOMPROMISE = 1;
    public static final int CRLREASON_CACOMPROMISE = 2;
    public static final int CRLREASON_AFFILIATIONCHANGED = 3;
    public static final int CRLREASON_SUPERSEDED = 4;
    public static final int CRLREASON_CESSATIONOFOPERATION = 5;
    public static final int CRLREASON_CERTIFICATEHOLD = 6;
    public static final int CRLREASON_REMOVEFROMCRL = 8;
    public static final int CRLREASON_LAST = 9;
    public static final int CRLREASON_NEVERVALID = 10;
    public static final int CRLEXTREASON_LAST = 11;
    public static final int CRLREASONFLAG_UNUSED = 1;
    public static final int CRLREASONFLAG_KEYCOMPROMISE = 2;
    public static final int CRLREASONFLAG_CACOMPROMISE = 4;
    public static final int CRLREASONFLAG_AFFILIATIONCHANGED = 8;
    public static final int CRLREASONFLAG_SUPERSEDED = 16;
    public static final int CRLREASONFLAG_CESSATIONOFOPERATION = 32;
    public static final int CRLREASONFLAG_CERTIFICATEHOLD = 64;
    public static final int CRLREASONFLAG_LAST = 128;
    public static final int HOLDINSTRUCTION_NONE = 0;
    public static final int HOLDINSTRUCTION_CALLISSUER = 1;
    public static final int HOLDINSTRUCTION_REJECT = 2;
    public static final int HOLDINSTRUCTION_PICKUPTOKEN = 3;
    public static final int HOLDINSTRUCTION_LAST = 4;
    public static final int NS_CERTTYPE_SSLCLIENT = 1;
    public static final int NS_CERTTYPE_SSLSERVER = 2;
    public static final int NS_CERTTYPE_SMIME = 4;
    public static final int NS_CERTTYPE_OBJECTSIGNING = 8;
    public static final int NS_CERTTYPE_RESERVED = 16;
    public static final int NS_CERTTYPE_SSLCA = 32;
    public static final int NS_CERTTYPE_SMIMECA = 64;
    public static final int NS_CERTTYPE_OBJECTSIGNINGCA = 128;
    public static final int NS_CERTTYPE_LAST = 256;
    public static final int SET_CERTTYPE_CARD = 1;
    public static final int SET_CERTTYPE_MER = 2;
    public static final int SET_CERTTYPE_PGWY = 4;
    public static final int SET_CERTTYPE_CCA = 8;
    public static final int SET_CERTTYPE_MCA = 16;
    public static final int SET_CERTTYPE_PCA = 32;
    public static final int SET_CERTTYPE_GCA = 64;
    public static final int SET_CERTTYPE_BCA = 128;
    public static final int SET_CERTTYPE_RCA = 256;
    public static final int SET_CERTTYPE_ACQ = 512;
    public static final int SET_CERTTYPE_LAST = 1024;
    public static final int CONTENT_NONE = 0;
    public static final int CONTENT_DATA = 1;
    public static final int CONTENT_SIGNEDDATA = 2;
    public static final int CONTENT_ENVELOPEDDATA = 3;
    public static final int CONTENT_SIGNEDANDENVELOPEDDATA = 4;
    public static final int CONTENT_DIGESTEDDATA = 5;
    public static final int CONTENT_ENCRYPTEDDATA = 6;
    public static final int CONTENT_COMPRESSEDDATA = 7;
    public static final int CONTENT_TSTINFO = 8;
    public static final int CONTENT_SPCINDIRECTDATACONTEXT = 9;
    public static final int CONTENT_LAST = 10;
    public static final int CLASSIFICATION_UNMARKED = 0;
    public static final int CLASSIFICATION_UNCLASSIFIED = 1;
    public static final int CLASSIFICATION_RESTRICTED = 2;
    public static final int CLASSIFICATION_CONFIDENTIAL = 3;
    public static final int CLASSIFICATION_SECRET = 4;
    public static final int CLASSIFICATION_TOP_SECRET = 5;
    public static final int CLASSIFICATION_LAST = 255;
    public static final int OCSPSTATUS_NOTREVOKED = 0;
    public static final int OCSPSTATUS_REVOKED = 1;
    public static final int OCSPSTATUS_UNKNOWN = 2;
    public static final int OCSPEXTSTATUS_VALID = 3;
    public static final int OCSPEXTSTATUS_NOTVALID = 4;
    public static final int OCSPEXTSTATUS_NEWCERT = 5;
    public static final int OCSPEXTSTATUS_UNKNOWN = 6;
    public static final int CMPSTATUS_OK = 0;
    public static final int CMPSTATUS_GRANTED = 0;
    public static final int CMPSTATUS_GRANTEDWITHMODS = 1;
    public static final int CMPSTATUS_REJECTION = 2;
    public static final int CMPSTATUS_WAITING = 3;
    public static final int CMPSTATUS_REVOCATIONWARNING = 4;
    public static final int CMPSTATUS_REVOCATIONNOTIFICATION = 5;
    public static final int CMPSTATUS_KEYUPDATEWARNING = 6;
    public static final int CMPSTATUS_LAST = 7;
    public static final int CMPSTATUS_EXT_BADALG = 1;
    public static final int CMPSTATUS_EXT_BADMESSAGECHECK = 2;
    public static final int CMPSTATUS_EXT_BADREQUEST = 4;
    public static final int CMPSTATUS_EXT_BADTIME = 8;
    public static final int CMPSTATUS_EXT_BADCERTID = 16;
    public static final int CMPSTATUS_EXT_BADDATAFORMAT = 32;
    public static final int CMPSTATUS_EXT_WRONGAUTHORITY = 64;
    public static final int CMPSTATUS_EXT_INCORRECTDATA = 128;
    public static final int CMPSTATUS_EXT_MISSINGTIMESTAMP = 256;
    public static final int CMPSTATUS_EXT_BADPOP = 512;
    public static final int CMPSTATUS_EXT_LAST = 1024;
    public static final int SIGNATURELEVEL_NONE = 0;
    public static final int SIGNATURELEVEL_SIGNERCERT = 1;
    public static final int SIGNATURELEVEL_ALL = 2;
    public static final int SIGNATURELEVEL_LAST = 3;
    public static final int CERTFORMAT_NONE = 0;
    public static final int CERTFORMAT_CERTIFICATE = 1;
    public static final int CERTFORMAT_CERTCHAIN = 2;
    public static final int CERTFORMAT_TEXT_CERTIFICATE = 3;
    public static final int CERTFORMAT_TEXT_CERTCHAIN = 4;
    public static final int CERTFORMAT_LAST = 5;
    public static final int REQUESTTYPE_NONE = 0;
    public static final int REQUESTTYPE_INITIALISATION = 1;
    public static final int REQUESTTYPE_INITIALIZATION = 1;
    public static final int REQUESTTYPE_CERTIFICATE = 2;
    public static final int REQUESTTYPE_KEYUPDATE = 3;
    public static final int REQUESTTYPE_REVOCATION = 4;
    public static final int REQUESTTYPE_LAST = 5;
    public static final int KEYID_NONE = 0;
    public static final int KEYID_NAME = 1;
    public static final int KEYID_EMAIL = 2;
    public static final int KEYID_LAST = 3;
    public static final int OBJECT_NONE = 0;
    public static final int OBJECT_ENCRYPTED_KEY = 1;
    public static final int OBJECT_PKCENCRYPTED_KEY = 2;
    public static final int OBJECT_KEYAGREEMENT = 3;
    public static final int OBJECT_SIGNATURE = 4;
    public static final int OBJECT_LAST = 5;
    public static final int ERRTYPE_NONE = 0;
    public static final int ERRTYPE_ATTR_SIZE = 1;
    public static final int ERRTYPE_ATTR_VALUE = 2;
    public static final int ERRTYPE_ATTR_ABSENT = 3;
    public static final int ERRTYPE_ATTR_PRESENT = 4;
    public static final int ERRTYPE_CONSTRAINT = 5;
    public static final int ERRTYPE_ISSUERCONSTRAINT = 6;
    public static final int ERRTYPE_LAST = 7;
    public static final int CERTACTION_NONE = 0;
    public static final int CERTACTION_CREATE = 1;
    public static final int CERTACTION_CONNECT = 2;
    public static final int CERTACTION_DISCONNECT = 3;
    public static final int CERTACTION_ERROR = 4;
    public static final int CERTACTION_ADDUSER = 5;
    public static final int CERTACTION_REQUEST_CERT = 6;
    public static final int CERTACTION_REQUEST_RENEWAL = 7;
    public static final int CERTACTION_REQUEST_REVOCATION = 8;
    public static final int CERTACTION_CERT_CREATION = 9;
    public static final int CERTACTION_CERT_CREATION_COMPLETE = 10;
    public static final int CERTACTION_CERT_CREATION_DROP = 11;
    public static final int CERTACTION_CERT_CREATION_REVERSE = 12;
    public static final int CERTACTION_RESTART_CLEANUP = 13;
    public static final int CERTACTION_RESTART_REVOKE_CERT = 14;
    public static final int CERTACTION_ISSUE_CERT = 15;
    public static final int CERTACTION_ISSUE_CRL = 16;
    public static final int CERTACTION_REVOKE_CERT = 17;
    public static final int CERTACTION_EXPIRE_CERT = 18;
    public static final int CERTACTION_CLEANUP = 19;
    public static final int CERTACTION_LAST = 20;
    public static final int MAX_KEYSIZE = 256;
    public static final int MAX_IVSIZE = 32;
    public static final int MAX_PKCSIZE = 512;
    public static final int MAX_HASHSIZE = 32;
    public static final int MAX_TEXTSIZE = 64;
    public static final int USE_DEFAULT = -10;
    public static final int UNUSED = -11;
    public static final int KEYTYPE_PRIVATE = 0;
    public static final int KEYTYPE_PUBLIC = 1;
    public static final int RANDOM_FASTPOLL = -10;
    public static final int RANDOM_SLOWPOLL = -11;
    public static final int CURSOR_FIRST = -20;
    public static final int CURSOR_PREVIOUS = -21;
    public static final int CURSOR_NEXT = -22;
    public static final int CURSOR_LAST = -23;
    public static final int KEYOPT_NONE = 0;
    public static final int KEYOPT_READONLY = 1;
    public static final int KEYOPT_CREATE = 2;
    public static final int KEYOPT_LAST = 3;
    public static final int OK = 0;
    public static final int ERROR_PARAM1 = -1;
    public static final int ERROR_PARAM2 = -2;
    public static final int ERROR_PARAM3 = -3;
    public static final int ERROR_PARAM4 = -4;
    public static final int ERROR_PARAM5 = -5;
    public static final int ERROR_PARAM6 = -6;
    public static final int ERROR_PARAM7 = -7;
    public static final int ERROR_MEMORY = -10;
    public static final int ERROR_NOTINITED = -11;
    public static final int ERROR_INITED = -12;
    public static final int ERROR_NOSECURE = -13;
    public static final int ERROR_RANDOM = -14;
    public static final int ERROR_FAILED = -15;
    public static final int ERROR_NOTAVAIL = -20;
    public static final int ERROR_PERMISSION = -21;
    public static final int ERROR_WRONGKEY = -22;
    public static final int ERROR_INCOMPLETE = -23;
    public static final int ERROR_COMPLETE = -24;
    public static final int ERROR_BUSY = -25;
    public static final int ERROR_INVALID = -26;
    public static final int ERROR_SIGNALLED = -27;
    public static final int ERROR_OVERFLOW = -30;
    public static final int ERROR_UNDERFLOW = -31;
    public static final int ERROR_BADDATA = -32;
    public static final int ERROR_SIGNATURE = -33;
    public static final int ERROR_OPEN = -40;
    public static final int ERROR_READ = -41;
    public static final int ERROR_WRITE = -42;
    public static final int ERROR_NOTFOUND = -43;
    public static final int ERROR_DUPLICATE = -44;
    public static final int ENVELOPE_RESOURCE = -50;

    public static native void Init() throws CryptException;

    public static native void End() throws CryptException;

    public static native int CreateContext(int var0, int var1) throws CryptException;

    public static native void DestroyContext(int var0) throws CryptException;

    public static native void DestroyObject(int var0) throws CryptException;

    public static native void GenerateKey(int var0) throws CryptException;

    public static native void GenerateKeyAsync(int var0) throws CryptException;

    public static native void AsyncQuery(int var0) throws CryptException;

    public static native void AsyncCancel(int var0) throws CryptException;

    public static native void Encrypt(int var0, ByteBuffer var1, int var2, int var3) throws CryptException;

    public static native void Encrypt(int var0, byte[] var1, int var2, int var3) throws CryptException;

    public static void Encrypt(int n, ByteBuffer byteBuffer) throws CryptException {
        crypt.Encrypt(n, byteBuffer, 0, byteBuffer.capacity());
    }

    public static void Encrypt(int n, byte[] byArray) throws CryptException {
        crypt.Encrypt(n, byArray, 0, byArray.length);
    }

    public static native void Decrypt(int var0, ByteBuffer var1, int var2, int var3) throws CryptException;

    public static native void Decrypt(int var0, byte[] var1, int var2, int var3) throws CryptException;

    public static void Decrypt(int n, ByteBuffer byteBuffer) throws CryptException {
        crypt.Decrypt(n, byteBuffer, 0, byteBuffer.capacity());
    }

    public static void Decrypt(int n, byte[] byArray) throws CryptException {
        crypt.Decrypt(n, byArray, 0, byArray.length);
    }

    public static native void SetAttribute(int var0, int var1, int var2) throws CryptException;

    public static native void SetAttributeString(int var0, int var1, ByteBuffer var2, int var3, int var4) throws CryptException;

    public static native void SetAttributeString(int var0, int var1, byte[] var2, int var3, int var4) throws CryptException;

    public static void SetAttributeString(int n, int n2, ByteBuffer byteBuffer) throws CryptException {
        crypt.SetAttributeString(n, n2, byteBuffer, 0, byteBuffer.capacity());
    }

    public static void SetAttributeString(int n, int n2, byte[] byArray) throws CryptException {
        crypt.SetAttributeString(n, n2, byArray, 0, byArray.length);
    }

    public static void SetAttributeString(int n, int n2, String string) throws CryptException {
        crypt.SetAttributeString(n, n2, string.getBytes(), 0, string.length());
    }

    public static native int GetAttribute(int var0, int var1) throws CryptException;

    public static native int GetAttributeString(int var0, int var1, ByteBuffer var2, int var3) throws CryptException;

    public static native int GetAttributeString(int var0, int var1, byte[] var2, int var3) throws CryptException;

    public static int GetAttributeString(int n, int n2, ByteBuffer byteBuffer) throws CryptException {
        return crypt.GetAttributeString(n, n2, byteBuffer, 0);
    }

    public static int GetAttributeString(int n, int n2, byte[] byArray) throws CryptException {
        return crypt.GetAttributeString(n, n2, byArray, 0);
    }

    public static String GetAttributeString(int n, int n2) throws CryptException {
        int n3 = crypt.GetAttributeString(n, n2, (byte[])null);
        byte[] byArray = new byte[n3];
        n3 = crypt.GetAttributeString(n, n2, byArray);
        return new String(byArray, 0, n3);
    }

    public static native void DeleteAttribute(int var0, int var1) throws CryptException;

    public static native void AddRandom(ByteBuffer var0, int var1, int var2) throws CryptException;

    public static native void AddRandom(byte[] var0, int var1, int var2) throws CryptException;

    public static void AddRandom(ByteBuffer byteBuffer) throws CryptException {
        crypt.AddRandom(byteBuffer, 0, byteBuffer.capacity());
    }

    public static void AddRandom(byte[] byArray) throws CryptException {
        crypt.AddRandom(byArray, 0, byArray.length);
    }

    public static void AddRandom(String string) throws CryptException {
        crypt.AddRandom(string.getBytes(), 0, string.length());
    }

    public static native int ExportKey(ByteBuffer var0, int var1, int var2, int var3) throws CryptException;

    public static native int ExportKey(byte[] var0, int var1, int var2, int var3) throws CryptException;

    public static int ExportKey(ByteBuffer byteBuffer, int n, int n2) throws CryptException {
        return crypt.ExportKey(byteBuffer, 0, n, n2);
    }

    public static int ExportKey(byte[] byArray, int n, int n2) throws CryptException {
        return crypt.ExportKey(byArray, 0, n, n2);
    }

    public static native int ExportKeyEx(ByteBuffer var0, int var1, int var2, int var3, int var4) throws CryptException;

    public static native int ExportKeyEx(byte[] var0, int var1, int var2, int var3, int var4) throws CryptException;

    public static int ExportKeyEx(ByteBuffer byteBuffer, int n, int n2, int n3) throws CryptException {
        return crypt.ExportKeyEx(byteBuffer, 0, n, n2, n3);
    }

    public static int ExportKeyEx(byte[] byArray, int n, int n2, int n3) throws CryptException {
        return crypt.ExportKeyEx(byArray, 0, n, n2, n3);
    }

    public static native void ImportKey(ByteBuffer var0, int var1, int var2, int var3) throws CryptException;

    public static native void ImportKey(byte[] var0, int var1, int var2, int var3) throws CryptException;

    public static void ImportKey(ByteBuffer byteBuffer, int n, int n2) throws CryptException {
        crypt.ImportKey(byteBuffer, 0, n, n2);
    }

    public static void ImportKey(byte[] byArray, int n, int n2) throws CryptException {
        crypt.ImportKey(byArray, 0, n, n2);
    }

    public static native void ImportKeyEx(ByteBuffer var0, int var1, int var2, int var3) throws CryptException;

    public static native void ImportKeyEx(byte[] var0, int var1, int var2, int var3) throws CryptException;

    public static void ImportKeyEx(ByteBuffer byteBuffer, int n, int n2) throws CryptException {
        crypt.ImportKeyEx(byteBuffer, 0, n, n2);
    }

    public static void ImportKeyEx(byte[] byArray, int n, int n2) throws CryptException {
        crypt.ImportKeyEx(byArray, 0, n, n2);
    }

    public static native int CreateSignature(ByteBuffer var0, int var1, int var2, int var3) throws CryptException;

    public static native int CreateSignature(byte[] var0, int var1, int var2, int var3) throws CryptException;

    public static int CreateSignature(ByteBuffer byteBuffer, int n, int n2) throws CryptException {
        return crypt.CreateSignature(byteBuffer, 0, n, n2);
    }

    public static int CreateSignature(byte[] byArray, int n, int n2) throws CryptException {
        return crypt.CreateSignature(byArray, 0, n, n2);
    }

    public static native int CreateSignatureEx(ByteBuffer var0, int var1, int var2, int var3, int var4, int var5) throws CryptException;

    public static native int CreateSignatureEx(byte[] var0, int var1, int var2, int var3, int var4, int var5) throws CryptException;

    public static int CreateSignatureEx(ByteBuffer byteBuffer, int n, int n2, int n3, int n4) throws CryptException {
        return crypt.CreateSignatureEx(byteBuffer, 0, n, n2, n3, n4);
    }

    public static int CreateSignatureEx(byte[] byArray, int n, int n2, int n3, int n4) throws CryptException {
        return crypt.CreateSignatureEx(byArray, 0, n, n2, n3, n4);
    }

    public static native void CheckSignature(ByteBuffer var0, int var1, int var2, int var3) throws CryptException;

    public static native void CheckSignature(byte[] var0, int var1, int var2, int var3) throws CryptException;

    public static void CheckSignature(ByteBuffer byteBuffer, int n, int n2) throws CryptException {
        crypt.CheckSignature(byteBuffer, 0, n, n2);
    }

    public static void CheckSignature(byte[] byArray, int n, int n2) throws CryptException {
        crypt.CheckSignature(byArray, 0, n, n2);
    }

    public static native int CheckSignatureEx(ByteBuffer var0, int var1, int var2, int var3) throws CryptException;

    public static native int CheckSignatureEx(byte[] var0, int var1, int var2, int var3) throws CryptException;

    public static int CheckSignatureEx(ByteBuffer byteBuffer, int n, int n2) throws CryptException {
        return crypt.CheckSignatureEx(byteBuffer, 0, n, n2);
    }

    public static int CheckSignatureEx(byte[] byArray, int n, int n2) throws CryptException {
        return crypt.CheckSignatureEx(byArray, 0, n, n2);
    }

    public static native int KeysetOpen(int var0, int var1, String var2, int var3) throws CryptException;

    public static native void KeysetClose(int var0) throws CryptException;

    public static native int GetPublicKey(int var0, int var1, String var2) throws CryptException;

    public static native int GetPrivateKey(int var0, int var1, String var2, String var3) throws CryptException;

    public static native void AddPublicKey(int var0, int var1) throws CryptException;

    public static native void AddPrivateKey(int var0, int var1, String var2) throws CryptException;

    public static native void DeleteKey(int var0, int var1, String var2) throws CryptException;

    public static native int CreateCert(int var0, int var1) throws CryptException;

    public static native void DestroyCert(int var0) throws CryptException;

    public static native int GetCertExtension(int var0, String var1, ByteBuffer var2, int var3) throws CryptException;

    public static native int GetCertExtension(int var0, String var1, byte[] var2, int var3) throws CryptException;

    public static int GetCertExtension(int n, String string, ByteBuffer byteBuffer) throws CryptException {
        return crypt.GetCertExtension(n, string, byteBuffer, 0);
    }

    public static int GetCertExtension(int n, String string, byte[] byArray) throws CryptException {
        return crypt.GetCertExtension(n, string, byArray, 0);
    }

    public static native void AddCertExtension(int var0, String var1, int var2, ByteBuffer var3, int var4, int var5) throws CryptException;

    public static native void AddCertExtension(int var0, String var1, int var2, byte[] var3, int var4, int var5) throws CryptException;

    public static void AddCertExtension(int n, String string, int n2, ByteBuffer byteBuffer) throws CryptException {
        crypt.AddCertExtension(n, string, n2, byteBuffer, 0, byteBuffer.capacity());
    }

    public static void AddCertExtension(int n, String string, int n2, byte[] byArray) throws CryptException {
        crypt.AddCertExtension(n, string, n2, byArray, 0, byArray.length);
    }

    public static void AddCertExtension(int n, String string, int n2, String string2) throws CryptException {
        crypt.AddCertExtension(n, string, n2, string2.getBytes(), 0, string2.length());
    }

    public static native void DeleteCertExtension(int var0, String var1) throws CryptException;

    public static native void SignCert(int var0, int var1) throws CryptException;

    public static native void CheckCert(int var0, int var1) throws CryptException;

    public static native int ImportCert(ByteBuffer var0, int var1, int var2, int var3) throws CryptException;

    public static native int ImportCert(byte[] var0, int var1, int var2, int var3) throws CryptException;

    public static int ImportCert(ByteBuffer byteBuffer, int n) throws CryptException {
        return crypt.ImportCert(byteBuffer, 0, byteBuffer.capacity(), n);
    }

    public static int ImportCert(byte[] byArray, int n) throws CryptException {
        return crypt.ImportCert(byArray, 0, byArray.length, n);
    }

    public static int ImportCert(String string, int n) throws CryptException {
        return crypt.ImportCert(string.getBytes(), 0, string.length(), n);
    }

    public static native int ExportCert(ByteBuffer var0, int var1, int var2, int var3) throws CryptException;

    public static native int ExportCert(byte[] var0, int var1, int var2, int var3) throws CryptException;

    public static int ExportCert(ByteBuffer byteBuffer, int n, int n2) throws CryptException {
        return crypt.ExportCert(byteBuffer, 0, n, n2);
    }

    public static int ExportCert(byte[] byArray, int n, int n2) throws CryptException {
        return crypt.ExportCert(byArray, 0, n, n2);
    }

    public static native void CAAddItem(int var0, int var1) throws CryptException;

    public static native int CAGetItem(int var0, int var1, int var2, String var3) throws CryptException;

    public static native void CADeleteItem(int var0, int var1, String var2) throws CryptException;

    public static native int CACertManagement(int var0, int var1, int var2, int var3) throws CryptException;

    public static native int CreateEnvelope(int var0, int var1) throws CryptException;

    public static native void DestroyEnvelope(int var0) throws CryptException;

    public static native int CreateSession(int var0, int var1) throws CryptException;

    public static native void DestroySession(int var0) throws CryptException;

    public static native int PushData(int var0, ByteBuffer var1, int var2, int var3) throws CryptException;

    public static native int PushData(int var0, byte[] var1, int var2, int var3) throws CryptException;

    public static int PushData(int n, ByteBuffer byteBuffer) throws CryptException {
        return crypt.PushData(n, byteBuffer, 0, byteBuffer.capacity());
    }

    public static int PushData(int n, byte[] byArray) throws CryptException {
        return crypt.PushData(n, byArray, 0, byArray.length);
    }

    public static int PushData(int n, String string) throws CryptException {
        return crypt.PushData(n, string.getBytes(), 0, string.length());
    }

    public static native void FlushData(int var0) throws CryptException;

    public static native int PopData(int var0, ByteBuffer var1, int var2, int var3) throws CryptException;

    public static native int PopData(int var0, byte[] var1, int var2, int var3) throws CryptException;

    public static int PopData(int n, ByteBuffer byteBuffer, int n2) throws CryptException {
        return crypt.PopData(n, byteBuffer, 0, n2);
    }

    public static int PopData(int n, byte[] byArray, int n2) throws CryptException {
        return crypt.PopData(n, byArray, 0, n2);
    }

    public static native int DeviceOpen(int var0, int var1, String var2) throws CryptException;

    public static native void DeviceClose(int var0) throws CryptException;

    public static native int DeviceCreateContext(int var0, int var1) throws CryptException;

    public static native void DeviceControlEx(int var0, int var1, ByteBuffer var2, int var3, int var4, ByteBuffer var5, int var6, int var7) throws CryptException;

    public static native void DeviceControlEx(int var0, int var1, byte[] var2, int var3, int var4, byte[] var5, int var6, int var7) throws CryptException;

    public static void DeviceControlEx(int n, int n2, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws CryptException {
        crypt.DeviceControlEx(n, n2, byteBuffer, 0, byteBuffer.capacity(), byteBuffer2, 0, byteBuffer2.capacity());
    }

    public static void DeviceControlEx(int n, int n2, byte[] byArray, byte[] byArray2) throws CryptException {
        crypt.DeviceControlEx(n, n2, byArray, 0, byArray.length, byArray2, 0, byArray2.length);
    }

    public static void DeviceControlEx(int n, int n2, String string, String string2) throws CryptException {
        crypt.DeviceControlEx(n, n2, string.getBytes(), 0, string.length(), string2.getBytes(), 0, string2.length());
    }

    public static native int Login(String var0, String var1) throws CryptException;

    public static native void Logout(int var0) throws CryptException;
}

