
package cryptlib;

public class CryptException extends Exception
{
    private int m_status;
    private String m_message;
    public CryptException(int status)
    {
        m_status = status;
        String prefix = Integer.toString(status) + ": ";
        
        if (m_status == crypt.ERROR_PARAM1) {
			m_message = prefix + "Bad argument, parameter 1";
			return; }
        if (m_status == crypt.ERROR_PARAM2) {
			m_message = prefix + "Bad argument, parameter 2";
			return; }
        if (m_status == crypt.ERROR_PARAM3) {
			m_message = prefix + "Bad argument, parameter 3";
			return; }
        if (m_status == crypt.ERROR_PARAM4) {
			m_message = prefix + "Bad argument, parameter 4";
			return; }
        if (m_status == crypt.ERROR_PARAM5) {
			m_message = prefix + "Bad argument, parameter 5";
			return; }
        if (m_status == crypt.ERROR_PARAM6) {
			m_message = prefix + "Bad argument, parameter 6";
			return; }
        if (m_status == crypt.ERROR_PARAM7) {
			m_message = prefix + "Bad argument, parameter 7";
			return; }
        if (m_status == crypt.ERROR_MEMORY) {
			m_message = prefix + "Out of memory";
			return; }
        if (m_status == crypt.ERROR_NOTINITED) {
			m_message = prefix + "Data has not been initialised";
			return; }
        if (m_status == crypt.ERROR_INITED) {
			m_message = prefix + "Data has already been init'd";
			return; }
        if (m_status == crypt.ERROR_NOSECURE) {
			m_message = prefix + "Opn.not avail.at requested sec.level";
			return; }
        if (m_status == crypt.ERROR_RANDOM) {
			m_message = prefix + "No reliable random data available";
			return; }
        if (m_status == crypt.ERROR_FAILED) {
			m_message = prefix + "Operation failed";
			return; }
        if (m_status == crypt.ERROR_NOTAVAIL) {
			m_message = prefix + "This type of opn.not available";
			return; }
        if (m_status == crypt.ERROR_PERMISSION) {
			m_message = prefix + "No permiss.to perform this operation";
			return; }
        if (m_status == crypt.ERROR_WRONGKEY) {
			m_message = prefix + "Incorrect key used to decrypt data";
			return; }
        if (m_status == crypt.ERROR_INCOMPLETE) {
			m_message = prefix + "Operation incomplete/still in progress";
			return; }
        if (m_status == crypt.ERROR_COMPLETE) {
			m_message = prefix + "Operation complete/can't continue";
			return; }
        if (m_status == crypt.ERROR_BUSY) {
			m_message = prefix + "Resource in use by async operation";
			return; }
        if (m_status == crypt.ERROR_INVALID) {
			m_message = prefix + "Invalid/inconsistent information";
			return; }
        if (m_status == crypt.ERROR_SIGNALLED) {
			m_message = prefix + "Resource destroyed by extnl.event";
			return; }
        if (m_status == crypt.ERROR_OVERFLOW) {
			m_message = prefix + "Resources/space exhausted";
			return; }
        if (m_status == crypt.ERROR_UNDERFLOW) {
			m_message = prefix + "Not enough data available";
			return; }
        if (m_status == crypt.ERROR_BADDATA) {
			m_message = prefix + "Bad/unrecognised data format";
			return; }
        if (m_status == crypt.ERROR_SIGNATURE) {
			m_message = prefix + "Signature/integrity check failed";
			return; }
        if (m_status == crypt.ERROR_OPEN) {
			m_message = prefix + "Cannot open object";
			return; }
        if (m_status == crypt.ERROR_READ) {
			m_message = prefix + "Cannot read item from object";
			return; }
        if (m_status == crypt.ERROR_WRITE) {
			m_message = prefix + "Cannot write item to object";
			return; }
        if (m_status == crypt.ERROR_NOTFOUND) {
			m_message = prefix + "Requested item not found in object";
			return; }
        if (m_status == crypt.ERROR_DUPLICATE) {
			m_message = prefix + "Item already present in object";
			return; }
        if (m_status == crypt.ENVELOPE_RESOURCE) {
			m_message = prefix + "Need resource to proceed";
			return; }
        m_message = prefix + "Unknown Exception ?!?!";
    }

    public int getStatus()
    {
        return m_status;
    }

    public String getMessage()
    {
        return m_message;
    }
};