package cryptlib;

import java.nio.*;

public class crypt
{

	/* Alongside the externally visible types, cryptlib also has various internal
	   types which are extended forms of the external types which are invisible
	   to the user (eg SignedPublicKeyAndChallenge == certRequest).  These can
	   only be used internally and are blocked by the security kernel, so they
	   can never be accessed from outside cryptlib (in fact for good measure
	   they're blocked before they even get to the kernel by preliminary range
	   checks in the API wrapper functions).  The only reason they're defined
	   here is because it's not possible to extend an enum outside the point
	   where it's originally defined */
	
	/****************************************************************************
	*																			*
	*							Algorithm and Object Types						*
	*																			*
	****************************************************************************/
	
	/* Algorithm and mode types */
	
	// CRYPT_ALGO_TYPE
	public static final int ALGO_NONE               = 0  ; // No encryption
	public static final int ALGO_DES                = 1  ; // DES
	public static final int ALGO_3DES               = 2  ; // Triple DES
	public static final int ALGO_IDEA               = 3  ; // IDEA
	public static final int ALGO_CAST               = 4  ; // CAST-128
	public static final int ALGO_RC2                = 5  ; // RC2
	public static final int ALGO_RC4                = 6  ; // RC4
	public static final int ALGO_RC5                = 7  ; // RC5
	public static final int ALGO_AES                = 8  ; // AES
	public static final int ALGO_BLOWFISH           = 9  ; // Blowfish
	public static final int ALGO_SKIPJACK           = 10 ; // Skipjack
	public static final int ALGO_DH                 = 100; // Diffie-Hellman
	public static final int ALGO_RSA                = 101; // RSA
	public static final int ALGO_DSA                = 102; // DSA
	public static final int ALGO_ELGAMAL            = 103; // ElGamal
	public static final int ALGO_KEA                = 104; // KEA
	public static final int ALGO_MD2                = 200; // MD2
	public static final int ALGO_MD4                = 201; // MD4
	public static final int ALGO_MD5                = 202; // MD5
	public static final int ALGO_SHA                = 203; // SHA/SHA1
	public static final int ALGO_RIPEMD160          = 204; // RIPE-MD 160
	public static final int ALGO_HMAC_MD5           = 300; // HMAC-MD5
	public static final int ALGO_HMAC_SHA           = 301; // HMAC-SHA
	public static final int ALGO_HMAC_RIPEMD160     = 302; // HMAC-RIPEMD-160
	public static final int ALGO_LAST               = 303; // Last possible crypt algo value
	public static final int ALGO_FIRST_CONVENTIONAL = 1  ;
	public static final int ALGO_LAST_CONVENTIONAL  = 99 ;
	public static final int ALGO_FIRST_PKC          = 100;
	public static final int ALGO_LAST_PKC           = 199;
	public static final int ALGO_FIRST_HASH         = 200;
	public static final int ALGO_LAST_HASH          = 299;
	public static final int ALGO_FIRST_MAC          = 300;
	public static final int ALGO_LAST_MAC           = 399; // End of mac algo.range
	
	// CRYPT_MODE_TYPE
	public static final int MODE_NONE = 0; // No encryption mode
	public static final int MODE_ECB  = 1; // ECB
	public static final int MODE_CBC  = 2; // CBC
	public static final int MODE_CFB  = 3; // CFB
	public static final int MODE_OFB  = 4; // OFB
	public static final int MODE_LAST = 5; // Last possible crypt mode value
	
	/* Keyset subtypes */
	
	// CRYPT_KEYSET_TYPE
	public static final int KEYSET_NONE           = 0 ; // No keyset type
	public static final int KEYSET_FILE           = 1 ; // Generic flat file keyset
	public static final int KEYSET_HTTP           = 2 ; // Web page containing cert/CRL
	public static final int KEYSET_LDAP           = 3 ; // LDAP directory service
	public static final int KEYSET_ODBC           = 4 ; // Generic ODBC interface
	public static final int KEYSET_MYSQL          = 5 ; // MySQL RDBMS
	public static final int KEYSET_DATABASE       = 6 ; // Generic database plugin
	public static final int KEYSET_ODBC_STORE     = 7 ; // ODBC certificate store
	public static final int KEYSET_MYSQL_STORE    = 8 ; // MySQL certificate store
	public static final int KEYSET_DATABASE_STORE = 9 ; // Database certificate store
	public static final int KEYSET_LAST           = 10; // Last possible keyset type
	
	/* Device subtypes */
	
	// CRYPT_DEVICE_TYPE
	public static final int DEVICE_NONE     = 0; // No crypto device
	public static final int DEVICE_FORTEZZA = 1; // Fortezza card
	public static final int DEVICE_PKCS11   = 2; // PKCS #11 crypto token
	public static final int DEVICE_LAST     = 3; // Last possible crypto device type
	
	/* Certificate subtypes */
	
	// CRYPT_CERTTYPE_TYPE
	public static final int CERTTYPE_NONE               = 0 ; // No certificate type
	public static final int CERTTYPE_CERTIFICATE        = 1 ; // Certificate
	public static final int CERTTYPE_ATTRIBUTE_CERT     = 2 ; // Attribute certificate
	public static final int CERTTYPE_CERTCHAIN          = 3 ; // PKCS #7 certificate chain
	public static final int CERTTYPE_CERTREQUEST        = 4 ; // PKCS #10 certification request
	public static final int CERTTYPE_REQUEST_CERT       = 5 ; // CRMF certification request
	public static final int CERTTYPE_REQUEST_REVOCATION = 6 ; // CRMF revocation request
	public static final int CERTTYPE_CRL                = 7 ; // CRL
	public static final int CERTTYPE_CMS_ATTRIBUTES     = 8 ; // CMS attributes
	public static final int CERTTYPE_OCSP_REQUEST       = 9 ; // OCSP request
	public static final int CERTTYPE_OCSP_RESPONSE      = 10; // OCSP response
	public static final int CERTTYPE_PKIUSER            = 11; // PKI user information
	public static final int CERTTYPE_LAST               = 12; // Last possible cert.type
	
	/* Envelope/data format subtypes */
	
	// CRYPT_FORMAT_TYPE
	public static final int FORMAT_NONE     = 0; // No format type
	public static final int FORMAT_AUTO     = 1; // Deenv, auto-determine type
	public static final int FORMAT_CRYPTLIB = 2; // cryptlib native format
	public static final int FORMAT_CMS      = 3; // PKCS #7 / CMS / S/MIME fmt.
	public static final int FORMAT_PKCS7    = 3;
	public static final int FORMAT_SMIME    = 4; // As CMS with MSG-style behaviour
	public static final int FORMAT_PGP      = 5; // PGP format
	public static final int FORMAT_LAST     = 6; // Last possible format type
	
	/* Session subtypes */
	
	// CRYPT_SESSION_TYPE
	public static final int SESSION_NONE        = 0 ; // No session type
	public static final int SESSION_SSH         = 1 ; // SSH
	public static final int SESSION_SSH_SERVER  = 2 ; // SSH server
	public static final int SESSION_SSL         = 3 ; // SSL/TLS
	public static final int SESSION_SSL_SERVER  = 4 ; // SSL/TLS server
	public static final int SESSION_OCSP        = 5 ; // OCSP
	public static final int SESSION_OCSP_SERVER = 6 ; // OCSP server
	public static final int SESSION_TSP         = 7 ; // TSP
	public static final int SESSION_TSP_SERVER  = 8 ; // TSP server
	public static final int SESSION_CMP         = 9 ; // PKIX CMP
	public static final int SESSION_CMP_SERVER  = 10; // PKIX CMP server
	public static final int SESSION_LAST        = 11; // Last possible session type
	
	/* User subtypes */
	
	// CRYPT_USER_TYPE
	public static final int USER_NONE   = 0; // No user type
	public static final int USER_NORMAL = 1; // Normal user
	public static final int USER_SO     = 2; // Security officer
	public static final int USER_CA     = 3; // CA user
	public static final int USER_LAST   = 4; // Last possible user type
	
	/****************************************************************************
	*																			*
	*								Attribute Types								*
	*																			*
	****************************************************************************/
	
	/* Attribute types.  These are arranged in the following order:
	
		PROPERTY	- Object property
		ATTRIBUTE	- Generic attributes
		OPTION		- Global or object-specific config.option
		CTXINFO		- Context-specific attribute
		CERTINFO	- Certificate-specific attribute
		KEYINFO		- Keyset-specific attribute
		DEVINFO		- Device-specific attribute
		ENVINFO		- Envelope-specific attribute
		SESSINFO	- Session-specific attribute
		USERINFO	- User-specific attribute */
	
	// CRYPT_ATTRIBUTE_TYPE
	public static final int ATTRIBUTE_NONE                             = 0   ; // Non-value
	public static final int PROPERTY_FIRST                             = 1   ; // *******************
	public static final int PROPERTY_HIGHSECURITY                      = 2   ; // Owned+non-forwardcount+locked
	public static final int PROPERTY_OWNER                             = 3   ; // Object owner
	public static final int PROPERTY_FORWARDCOUNT                      = 4   ; // No.of times object can be forwarded
	public static final int PROPERTY_LOCKED                            = 5   ; // Whether properties can be chged/read
	public static final int PROPERTY_USAGECOUNT                        = 6   ; // Usage count before object expires
	public static final int PROPERTY_NONEXPORTABLE                     = 7   ; // Whether key is nonexp.from context
	public static final int PROPERTY_LAST                              = 8   ;
	public static final int GENERIC_FIRST                              = 9   ; // Extended error information
	public static final int ATTRIBUTE_ERRORTYPE                        = 10  ; // Type of last error
	public static final int ATTRIBUTE_ERRORLOCUS                       = 11  ; // Locus of last error
	public static final int ATTRIBUTE_INT_ERRORCODE                    = 12  ; // Low-level software-specific
	public static final int ATTRIBUTE_INT_ERRORMESSAGE                 = 13  ; // error code and message
	public static final int ATTRIBUTE_BUFFERSIZE                       = 14  ; // Internal data buffer size
	public static final int GENERIC_LAST                               = 15  ;
	public static final int OPTION_FIRST                               = 100 ; // **************************
	public static final int OPTION_INFO_DESCRIPTION                    = 101 ; // Text description
	public static final int OPTION_INFO_COPYRIGHT                      = 102 ; // Copyright notice
	public static final int OPTION_INFO_MAJORVERSION                   = 103 ; // Major release version
	public static final int OPTION_INFO_MINORVERSION                   = 104 ; // Minor release version
	public static final int OPTION_INFO_STEPPING                       = 105 ; // Release stepping
	public static final int OPTION_ENCR_ALGO                           = 106 ; // Encryption algorithm
	public static final int OPTION_ENCR_HASH                           = 107 ; // Hash algorithm
	public static final int OPTION_ENCR_MAC                            = 108 ; // MAC algorithm
	public static final int OPTION_PKC_ALGO                            = 109 ; // Public-key encryption algorithm
	public static final int OPTION_PKC_KEYSIZE                         = 110 ; // Public-key encryption key size
	public static final int OPTION_SIG_ALGO                            = 111 ; // Signature algorithm
	public static final int OPTION_SIG_KEYSIZE                         = 112 ; // Signature keysize
	public static final int OPTION_KEYING_ALGO                         = 113 ; // Key processing algorithm
	public static final int OPTION_KEYING_ITERATIONS                   = 114 ; // Key processing iterations
	public static final int OPTION_CERT_SIGNUNRECOGNISEDATTRIBUTES     = 115 ; // Whether to sign unrecog.attrs
	public static final int OPTION_CERT_VALIDITY                       = 116 ; // Certificate validity period
	public static final int OPTION_CERT_UPDATEINTERVAL                 = 117 ; // CRL update interval
	public static final int OPTION_CMS_DEFAULTATTRIBUTES               = 118 ; // Add default CMS attributes
	public static final int OPTION_SMIME_DEFAULTATTRIBUTES             = 118 ; // LDAP keyset options
	public static final int OPTION_KEYS_LDAP_OBJECTCLASS               = 119 ; // Object class
	public static final int OPTION_KEYS_LDAP_OBJECTTYPE                = 120 ; // Object type to fetch
	public static final int OPTION_KEYS_LDAP_FILTER                    = 121 ; // Query filter
	public static final int OPTION_KEYS_LDAP_CACERTNAME                = 122 ; // CA certificate attribute name
	public static final int OPTION_KEYS_LDAP_CERTNAME                  = 123 ; // Certificate attribute name
	public static final int OPTION_KEYS_LDAP_CRLNAME                   = 124 ; // CRL attribute name
	public static final int OPTION_KEYS_LDAP_EMAILNAME                 = 125 ; // Email attribute name
	public static final int OPTION_DEVICE_PKCS11_DVR01                 = 126 ; // Name of first PKCS #11 driver
	public static final int OPTION_DEVICE_PKCS11_DVR02                 = 127 ; // Name of second PKCS #11 driver
	public static final int OPTION_DEVICE_PKCS11_DVR03                 = 128 ; // Name of third PKCS #11 driver
	public static final int OPTION_DEVICE_PKCS11_DVR04                 = 129 ; // Name of fourth PKCS #11 driver
	public static final int OPTION_DEVICE_PKCS11_DVR05                 = 130 ; // Name of fifth PKCS #11 driver
	public static final int OPTION_DEVICE_PKCS11_HARDWAREONLY          = 131 ; // Use only hardware mechanisms
	public static final int OPTION_NET_SOCKS_SERVER                    = 132 ; // Socks server name
	public static final int OPTION_NET_SOCKS_USERNAME                  = 133 ; // Socks user name
	public static final int OPTION_NET_HTTP_PROXY                      = 134 ; // Web proxy server
	public static final int OPTION_NET_CONNECTTIMEOUT                  = 135 ; // Timeout for network connection setup
	public static final int OPTION_NET_TIMEOUT                         = 136 ; // Timeout for network read/write
	public static final int OPTION_MISC_ASYNCINIT                      = 137 ; // Whether to init cryptlib async'ly
	public static final int OPTION_CONFIGCHANGED                       = 138 ; // Whether in-mem.opts match on-disk ones
	public static final int OPTION_SELFTESTOK                          = 139 ; // Whether self-test was completed and OK
	public static final int OPTION_LAST                                = 140 ;
	public static final int CTXINFO_FIRST                              = 1000; // ********************
	public static final int CTXINFO_ALGO                               = 1001; // Algorithm
	public static final int CTXINFO_MODE                               = 1002; // Mode
	public static final int CTXINFO_NAME_ALGO                          = 1003; // Algorithm name
	public static final int CTXINFO_NAME_MODE                          = 1004; // Mode name
	public static final int CTXINFO_KEYSIZE                            = 1005; // Key size in bytes
	public static final int CTXINFO_BLOCKSIZE                          = 1006; // Block size
	public static final int CTXINFO_IVSIZE                             = 1007; // IV size
	public static final int CTXINFO_KEYING_ALGO                        = 1008; // Key processing algorithm
	public static final int CTXINFO_KEYING_ITERATIONS                  = 1009; // Key processing iterations
	public static final int CTXINFO_KEYING_SALT                        = 1010; // Key processing salt
	public static final int CTXINFO_KEYING_VALUE                       = 1011; // Value used to derive key
	public static final int CTXINFO_KEY                                = 1012; // Key
	public static final int CTXINFO_KEY_COMPONENTS                     = 1013; // Public-key components
	public static final int CTXINFO_IV                                 = 1014; // IV
	public static final int CTXINFO_HASHVALUE                          = 1015; // Hash value
	public static final int CTXINFO_LABEL                              = 1016; // Label for private/secret key
	public static final int CTXINFO_LAST                               = 1017;
	public static final int CERTINFO_FIRST                             = 2000; // ************************
	public static final int CERTINFO_SELFSIGNED                        = 2001; // Cert is self-signed
	public static final int CERTINFO_IMMUTABLE                         = 2002; // Cert is signed and immutable
	public static final int CERTINFO_XYZZY                             = 2003; // Cert is a magic just-works cert
	public static final int CERTINFO_CERTTYPE                          = 2004; // Certificate object type
	public static final int CERTINFO_FINGERPRINT                       = 2005; // Certificate fingerprints
	public static final int CERTINFO_FINGERPRINT_MD5                   = 2005;
	public static final int CERTINFO_FINGERPRINT_SHA                   = 2006;
	public static final int CERTINFO_CURRENT_CERTIFICATE               = 2007; // Cursor mgt: Rel.pos in chain/CRL/OCSP
	public static final int CERTINFO_CURRENT_EXTENSION                 = 2008; // Cursor mgt: Rel.pos.or abs.extension
	public static final int CERTINFO_CURRENT_FIELD                     = 2009; // Cursor mgt: Rel.pos.or abs.field in ext
	public static final int CERTINFO_CURRENT_COMPONENT                 = 2010; // Cursor mgt: Rel.pos in multival.field
	public static final int CERTINFO_TRUSTED_USAGE                     = 2011; // Usage which cert is trusted for
	public static final int CERTINFO_TRUSTED_IMPLICIT                  = 2012; // Whether cert is implicitly trusted
	public static final int CERTINFO_SIGNATURELEVEL                    = 2013; // Amount of detail to include in sigs.
	public static final int CERTINFO_VERSION                           = 2014; // Cert.format version
	public static final int CERTINFO_SERIALNUMBER                      = 2015; // Serial number
	public static final int CERTINFO_SUBJECTPUBLICKEYINFO              = 2016; // Public key
	public static final int CERTINFO_USERCERTIFICATE                   = 2017; // User certificate
	public static final int CERTINFO_CERTIFICATE                       = 2017;
	public static final int CERTINFO_CACERTIFICATE                     = 2018; // CA certificate
	public static final int CERTINFO_ISSUERNAME                        = 2019; // Issuer DN
	public static final int CERTINFO_VALIDFROM                         = 2020; // Cert valid-from time
	public static final int CERTINFO_VALIDTO                           = 2021; // Cert valid-to time
	public static final int CERTINFO_SUBJECTNAME                       = 2022; // Subject DN
	public static final int CERTINFO_ISSUERUNIQUEID                    = 2023; // Issuer unique ID
	public static final int CERTINFO_SUBJECTUNIQUEID                   = 2024; // Subject unique ID
	public static final int CERTINFO_CERTREQUEST                       = 2025; // Cert.request (DN + public key)
	public static final int CERTINFO_THISUPDATE                        = 2026; // CRL/OCSP current-update time
	public static final int CERTINFO_NEXTUPDATE                        = 2027; // CRL/OCSP next-update time
	public static final int CERTINFO_REVOCATIONDATE                    = 2028; // CRL/OCSP cert-revocation time
	public static final int CERTINFO_REVOCATIONSTATUS                  = 2029; // OCSP revocation status
	public static final int CERTINFO_CERTSTATUS                        = 2030; // Cryptlib OCSP certificate status
	public static final int CERTINFO_DN                                = 2031; // Currently selected DN in string form
	public static final int CERTINFO_PKIUSER_ID                        = 2032; // PKI user ID
	public static final int CERTINFO_PKIUSER_ISSUEPASSWORD             = 2033; // PKI user issue password
	public static final int CERTINFO_PKIUSER_REVPASSWORD               = 2034; // PKI user revocation password
	public static final int CERTINFO_COUNTRYNAME                       = 2100; // countryName
	public static final int CERTINFO_STATEORPROVINCENAME               = 2101; // stateOrProvinceName
	public static final int CERTINFO_LOCALITYNAME                      = 2102; // localityName
	public static final int CERTINFO_ORGANIZATIONNAME                  = 2103; // organizationName
	public static final int CERTINFO_ORGANISATIONNAME                  = 2103;
	public static final int CERTINFO_ORGANIZATIONALUNITNAME            = 2104; // organizationalUnitName
	public static final int CERTINFO_ORGANISATIONALUNITNAME            = 2104;
	public static final int CERTINFO_COMMONNAME                        = 2105; // commonName
	public static final int CERTINFO_OTHERNAME_TYPEID                  = 2106; // otherName.typeID
	public static final int CERTINFO_OTHERNAME_VALUE                   = 2107; // otherName.value
	public static final int CERTINFO_RFC822NAME                        = 2108; // rfc822Name
	public static final int CERTINFO_EMAIL                             = 2108;
	public static final int CERTINFO_DNSNAME                           = 2109; // dNSName
	public static final int CERTINFO_DIRECTORYNAME                     = 2110; // directoryName
	public static final int CERTINFO_EDIPARTYNAME_NAMEASSIGNER         = 2111; // ediPartyName.nameAssigner
	public static final int CERTINFO_EDIPARTYNAME_PARTYNAME            = 2112; // ediPartyName.partyName
	public static final int CERTINFO_UNIFORMRESOURCEIDENTIFIER         = 2113; // uniformResourceIdentifier
	public static final int CERTINFO_IPADDRESS                         = 2114; // iPAddress
	public static final int CERTINFO_REGISTEREDID                      = 2115; // registeredID
	public static final int CERTINFO_CRLEXTREASON                      = 2200; // 1 3 6 1 4 1 3029 3 1 5 keyFeatures
	public static final int CERTINFO_KEYFEATURES                       = 2201; // 1 3 6 1 5 5 7 1 1 authorityInfoAccess
	public static final int CERTINFO_AUTHORITYINFOACCESS               = 2202;
	public static final int CERTINFO_AUTHORITYINFO_OCSP                = 2203; // accessDescription.accessLocation
	public static final int CERTINFO_AUTHORITYINFO_CAISSUERS           = 2204; // accessDescription.accessLocation
	public static final int CERTINFO_AUTHORITYINFO_TIMESTAMPING        = 2205; // accessDescription.accessLocation
	public static final int CERTINFO_OCSP_NONCE                        = 2206; // nonce
	public static final int CERTINFO_OCSP_RESPONSE                     = 2207;
	public static final int CERTINFO_OCSP_RESPONSE_STANDARD            = 2208; // Standard RFC 2560 response
	public static final int CERTINFO_OCSP_RESPONSE_BASIC               = 2209; // Basic OK/not OK response
	public static final int CERTINFO_OCSP_RESPONSE_FULL                = 2210; // Full response
	public static final int CERTINFO_OCSP_NOCHECK                      = 2211; // 1 3 6 1 5 5 7 48 1 6 ocspArchiveCutoff
	public static final int CERTINFO_OCSP_ARCHIVECUTOFF                = 2212; // 1 3 6 1 5 5 7 48 1 11 subjectInfoAccess
	public static final int CERTINFO_SUBJECTINFOACCESS                 = 2213;
	public static final int CERTINFO_SUBJECTINFO_CAREPOSITORY          = 2214; // accessDescription.accessLocation
	public static final int CERTINFO_SUBJECTINFO_TIMESTAMPING          = 2215; // accessDescription.accessLocation
	public static final int CERTINFO_SIGG_DATEOFCERTGEN                = 2216; // 1 3 36 8 3 2 siggProcuration
	public static final int CERTINFO_SIGG_PROCURATION                  = 2217;
	public static final int CERTINFO_SIGG_PROCURE_COUNTRY              = 2218; // country
	public static final int CERTINFO_SIGG_PROCURE_TYPEOFSUBSTITUTION   = 2219; // typeOfSubstitution
	public static final int CERTINFO_SIGG_PROCURE_SIGNINGFOR           = 2220; // signingFor.thirdPerson
	public static final int CERTINFO_SIGG_MONETARYLIMIT                = 2221;
	public static final int CERTINFO_SIGG_MONETARY_CURRENCY            = 2222; // currency
	public static final int CERTINFO_SIGG_MONETARY_AMOUNT              = 2223; // amount
	public static final int CERTINFO_SIGG_MONETARY_EXPONENT            = 2224; // exponent
	public static final int CERTINFO_SIGG_RESTRICTION                  = 2225; // 1 3 101 1 4 1 strongExtranet
	public static final int CERTINFO_STRONGEXTRANET                    = 2226;
	public static final int CERTINFO_STRONGEXTRANET_ZONE               = 2227; // sxNetIDList.sxNetID.zone
	public static final int CERTINFO_STRONGEXTRANET_ID                 = 2228; // sxNetIDList.sxNetID.id
	public static final int CERTINFO_SUBJECTDIRECTORYATTRIBUTES        = 2229;
	public static final int CERTINFO_SUBJECTDIR_TYPE                   = 2230; // attribute.type
	public static final int CERTINFO_SUBJECTDIR_VALUES                 = 2231; // attribute.values
	public static final int CERTINFO_SUBJECTKEYIDENTIFIER              = 2232; // 2 5 29 15 keyUsage
	public static final int CERTINFO_KEYUSAGE                          = 2233; // 2 5 29 16 privateKeyUsagePeriod
	public static final int CERTINFO_PRIVATEKEYUSAGEPERIOD             = 2234;
	public static final int CERTINFO_PRIVATEKEY_NOTBEFORE              = 2235; // notBefore
	public static final int CERTINFO_PRIVATEKEY_NOTAFTER               = 2236; // notAfter
	public static final int CERTINFO_SUBJECTALTNAME                    = 2237; // 2 5 29 18 issuerAltName
	public static final int CERTINFO_ISSUERALTNAME                     = 2238; // 2 5 29 19 basicConstraints
	public static final int CERTINFO_BASICCONSTRAINTS                  = 2239;
	public static final int CERTINFO_CA                                = 2240; // cA
	public static final int CERTINFO_AUTHORITY                         = 2240;
	public static final int CERTINFO_PATHLENCONSTRAINT                 = 2241; // pathLenConstraint
	public static final int CERTINFO_CRLNUMBER                         = 2242; // 2 5 29 21 cRLReason
	public static final int CERTINFO_CRLREASON                         = 2243; // 2 5 29 23 holdInstructionCode
	public static final int CERTINFO_HOLDINSTRUCTIONCODE               = 2244; // 2 5 29 24 invalidityDate
	public static final int CERTINFO_INVALIDITYDATE                    = 2245; // 2 5 29 27 deltaCRLIndicator
	public static final int CERTINFO_DELTACRLINDICATOR                 = 2246; // 2 5 29 28 issuingDistributionPoint
	public static final int CERTINFO_ISSUINGDISTRIBUTIONPOINT          = 2247;
	public static final int CERTINFO_ISSUINGDIST_FULLNAME              = 2248; // distributionPointName.fullName
	public static final int CERTINFO_ISSUINGDIST_USERCERTSONLY         = 2249; // onlyContainsUserCerts
	public static final int CERTINFO_ISSUINGDIST_CACERTSONLY           = 2250; // onlyContainsCACerts
	public static final int CERTINFO_ISSUINGDIST_SOMEREASONSONLY       = 2251; // onlySomeReasons
	public static final int CERTINFO_ISSUINGDIST_INDIRECTCRL           = 2252; // indirectCRL
	public static final int CERTINFO_CERTIFICATEISSUER                 = 2253; // 2 5 29 30 nameConstraints
	public static final int CERTINFO_NAMECONSTRAINTS                   = 2254;
	public static final int CERTINFO_PERMITTEDSUBTREES                 = 2255; // permittedSubtrees
	public static final int CERTINFO_EXCLUDEDSUBTREES                  = 2256; // excludedSubtrees
	public static final int CERTINFO_CRLDISTRIBUTIONPOINT              = 2257;
	public static final int CERTINFO_CRLDIST_FULLNAME                  = 2258; // distributionPointName.fullName
	public static final int CERTINFO_CRLDIST_REASONS                   = 2259; // reasons
	public static final int CERTINFO_CRLDIST_CRLISSUER                 = 2260; // cRLIssuer
	public static final int CERTINFO_CERTIFICATEPOLICIES               = 2261;
	public static final int CERTINFO_CERTPOLICYID                      = 2262; // policyInformation.policyIdentifier
	public static final int CERTINFO_CERTPOLICY_CPSURI                 = 2263; // policyInformation.policyQualifiers.qualifier.cPSuri
	public static final int CERTINFO_CERTPOLICY_ORGANIZATION           = 2264; // policyInformation.policyQualifiers.qualifier.userNotice.noticeRef.organization
	public static final int CERTINFO_CERTPOLICY_NOTICENUMBERS          = 2265; // policyInformation.policyQualifiers.qualifier.userNotice.noticeRef.noticeNumbers
	public static final int CERTINFO_CERTPOLICY_EXPLICITTEXT           = 2266; // policyInformation.policyQualifiers.qualifier.userNotice.explicitText
	public static final int CERTINFO_POLICYMAPPINGS                    = 2267;
	public static final int CERTINFO_ISSUERDOMAINPOLICY                = 2268; // policyMappings.issuerDomainPolicy
	public static final int CERTINFO_SUBJECTDOMAINPOLICY               = 2269; // policyMappings.subjectDomainPolicy
	public static final int CERTINFO_AUTHORITYKEYIDENTIFIER            = 2270;
	public static final int CERTINFO_AUTHORITY_KEYIDENTIFIER           = 2271; // keyIdentifier
	public static final int CERTINFO_AUTHORITY_CERTISSUER              = 2272; // authorityCertIssuer
	public static final int CERTINFO_AUTHORITY_CERTSERIALNUMBER        = 2273; // authorityCertSerialNumber
	public static final int CERTINFO_POLICYCONSTRAINTS                 = 2274;
	public static final int CERTINFO_REQUIREEXPLICITPOLICY             = 2275; // policyConstraints.requireExplicitPolicy
	public static final int CERTINFO_INHIBITPOLICYMAPPING              = 2276; // policyConstraints.inhibitPolicyMapping
	public static final int CERTINFO_EXTKEYUSAGE                       = 2277;
	public static final int CERTINFO_EXTKEY_MS_INDIVIDUALCODESIGNING   = 2278; // individualCodeSigning
	public static final int CERTINFO_EXTKEY_MS_COMMERCIALCODESIGNING   = 2279; // commercialCodeSigning
	public static final int CERTINFO_EXTKEY_MS_CERTTRUSTLISTSIGNING    = 2280; // certTrustListSigning
	public static final int CERTINFO_EXTKEY_MS_TIMESTAMPSIGNING        = 2281; // timeStampSigning
	public static final int CERTINFO_EXTKEY_MS_SERVERGATEDCRYPTO       = 2282; // serverGatedCrypto
	public static final int CERTINFO_EXTKEY_MS_ENCRYPTEDFILESYSTEM     = 2283; // encrypedFileSystem
	public static final int CERTINFO_EXTKEY_SERVERAUTH                 = 2284; // serverAuth
	public static final int CERTINFO_EXTKEY_CLIENTAUTH                 = 2285; // clientAuth
	public static final int CERTINFO_EXTKEY_CODESIGNING                = 2286; // codeSigning
	public static final int CERTINFO_EXTKEY_EMAILPROTECTION            = 2287; // emailProtection
	public static final int CERTINFO_EXTKEY_IPSECENDSYSTEM             = 2288; // ipsecEndSystem
	public static final int CERTINFO_EXTKEY_IPSECTUNNEL                = 2289; // ipsecTunnel
	public static final int CERTINFO_EXTKEY_IPSECUSER                  = 2290; // ipsecUser
	public static final int CERTINFO_EXTKEY_TIMESTAMPING               = 2291; // timeStamping
	public static final int CERTINFO_EXTKEY_OCSPSIGNING                = 2292; // ocspSigning
	public static final int CERTINFO_EXTKEY_DIRECTORYSERVICE           = 2293; // directoryService
	public static final int CERTINFO_EXTKEY_NS_SERVERGATEDCRYPTO       = 2294; // serverGatedCrypto
	public static final int CERTINFO_EXTKEY_VS_SERVERGATEDCRYPTO_CA    = 2295; // serverGatedCrypto CA
	public static final int CERTINFO_FRESHESTCRL                       = 2296;
	public static final int CERTINFO_FRESHESTCRL_FULLNAME              = 2297; // distributionPointName.fullName
	public static final int CERTINFO_FRESHESTCRL_REASONS               = 2298; // reasons
	public static final int CERTINFO_FRESHESTCRL_CRLISSUER             = 2299; // cRLIssuer
	public static final int CERTINFO_INHIBITANYPOLICY                  = 2300; // 2 16 840 1 113730 1 x Netscape extensions
	public static final int CERTINFO_NS_CERTTYPE                       = 2301; // netscape-cert-type
	public static final int CERTINFO_NS_BASEURL                        = 2302; // netscape-base-url
	public static final int CERTINFO_NS_REVOCATIONURL                  = 2303; // netscape-revocation-url
	public static final int CERTINFO_NS_CAREVOCATIONURL                = 2304; // netscape-ca-revocation-url
	public static final int CERTINFO_NS_CERTRENEWALURL                 = 2305; // netscape-cert-renewal-url
	public static final int CERTINFO_NS_CAPOLICYURL                    = 2306; // netscape-ca-policy-url
	public static final int CERTINFO_NS_SSLSERVERNAME                  = 2307; // netscape-ssl-server-name
	public static final int CERTINFO_NS_COMMENT                        = 2308; // netscape-comment
	public static final int CERTINFO_SET_HASHEDROOTKEY                 = 2309;
	public static final int CERTINFO_SET_ROOTKEYTHUMBPRINT             = 2310; // rootKeyThumbPrint
	public static final int CERTINFO_SET_CERTIFICATETYPE               = 2311; // 2 23 42 7 2 SET merchantData
	public static final int CERTINFO_SET_MERCHANTDATA                  = 2312;
	public static final int CERTINFO_SET_MERID                         = 2313; // merID
	public static final int CERTINFO_SET_MERACQUIRERBIN                = 2314; // merAcquirerBIN
	public static final int CERTINFO_SET_MERCHANTLANGUAGE              = 2315; // merNames.language
	public static final int CERTINFO_SET_MERCHANTNAME                  = 2316; // merNames.name
	public static final int CERTINFO_SET_MERCHANTCITY                  = 2317; // merNames.city
	public static final int CERTINFO_SET_MERCHANTSTATEPROVINCE         = 2318; // merNames.stateProvince
	public static final int CERTINFO_SET_MERCHANTPOSTALCODE            = 2319; // merNames.postalCode
	public static final int CERTINFO_SET_MERCHANTCOUNTRYNAME           = 2320; // merNames.countryName
	public static final int CERTINFO_SET_MERCOUNTRY                    = 2321; // merCountry
	public static final int CERTINFO_SET_MERAUTHFLAG                   = 2322; // merAuthFlag
	public static final int CERTINFO_SET_CERTCARDREQUIRED              = 2323; // 2 23 42 7 4 SET tunneling
	public static final int CERTINFO_SET_TUNNELING                     = 2324;
	public static final int CERTINFO_SET_TUNNELLING                    = 2324;
	public static final int CERTINFO_SET_TUNNELINGFLAG                 = 2325; // tunneling
	public static final int CERTINFO_SET_TUNNELLINGFLAG                = 2325;
	public static final int CERTINFO_SET_TUNNELINGALGID                = 2326; // tunnelingAlgID
	public static final int CERTINFO_SET_TUNNELLINGALGID               = 2326; // S/MIME attributes
	public static final int CERTINFO_CMS_CONTENTTYPE                   = 2500; // 1 2 840 113549 1 9 4 messageDigest
	public static final int CERTINFO_CMS_MESSAGEDIGEST                 = 2501; // 1 2 840 113549 1 9 5 signingTime
	public static final int CERTINFO_CMS_SIGNINGTIME                   = 2502; // 1 2 840 113549 1 9 6 counterSignature
	public static final int CERTINFO_CMS_COUNTERSIGNATURE              = 2503; // counterSignature
	public static final int CERTINFO_CMS_SMIMECAPABILITIES             = 2504;
	public static final int CERTINFO_CMS_SMIMECAP_3DES                 = 2505; // 3DES encryption
	public static final int CERTINFO_CMS_SMIMECAP_AES                  = 2506; // AES encryption
	public static final int CERTINFO_CMS_SMIMECAP_CAST128              = 2507; // CAST-128 encryption
	public static final int CERTINFO_CMS_SMIMECAP_IDEA                 = 2508; // IDEA encryption
	public static final int CERTINFO_CMS_SMIMECAP_RC2                  = 2509; // RC2 encryption (w.128 key)
	public static final int CERTINFO_CMS_SMIMECAP_RC5                  = 2510; // RC5 encryption (w.128 key)
	public static final int CERTINFO_CMS_SMIMECAP_SKIPJACK             = 2511; // Skipjack encryption
	public static final int CERTINFO_CMS_SMIMECAP_DES                  = 2512; // DES encryption
	public static final int CERTINFO_CMS_SMIMECAP_PREFERSIGNEDDATA     = 2513; // preferSignedData
	public static final int CERTINFO_CMS_SMIMECAP_CANNOTDECRYPTANY     = 2514; // canNotDecryptAny
	public static final int CERTINFO_CMS_RECEIPTREQUEST                = 2515;
	public static final int CERTINFO_CMS_RECEIPT_CONTENTIDENTIFIER     = 2516; // contentIdentifier
	public static final int CERTINFO_CMS_RECEIPT_FROM                  = 2517; // receiptsFrom
	public static final int CERTINFO_CMS_RECEIPT_TO                    = 2518; // receiptsTo
	public static final int CERTINFO_CMS_SECURITYLABEL                 = 2519;
	public static final int CERTINFO_CMS_SECLABEL_CLASSIFICATION       = 2520; // securityClassification
	public static final int CERTINFO_CMS_SECLABEL_POLICY               = 2521; // securityPolicyIdentifier
	public static final int CERTINFO_CMS_SECLABEL_PRIVACYMARK          = 2522; // privacyMark
	public static final int CERTINFO_CMS_SECLABEL_CATTYPE              = 2523; // securityCategories.securityCategory.type
	public static final int CERTINFO_CMS_SECLABEL_CATVALUE             = 2524; // securityCategories.securityCategory.value
	public static final int CERTINFO_CMS_MLEXPANSIONHISTORY            = 2525;
	public static final int CERTINFO_CMS_MLEXP_ENTITYIDENTIFIER        = 2526; // mlData.mailListIdentifier.issuerAndSerialNumber
	public static final int CERTINFO_CMS_MLEXP_TIME                    = 2527; // mlData.expansionTime
	public static final int CERTINFO_CMS_MLEXP_NONE                    = 2528; // mlData.mlReceiptPolicy.none
	public static final int CERTINFO_CMS_MLEXP_INSTEADOF               = 2529; // mlData.mlReceiptPolicy.insteadOf.generalNames.generalName
	public static final int CERTINFO_CMS_MLEXP_INADDITIONTO            = 2530; // mlData.mlReceiptPolicy.inAdditionTo.generalNames.generalName
	public static final int CERTINFO_CMS_CONTENTHINTS                  = 2531;
	public static final int CERTINFO_CMS_CONTENTHINT_DESCRIPTION       = 2532; // contentDescription
	public static final int CERTINFO_CMS_CONTENTHINT_TYPE              = 2533; // contentType
	public static final int CERTINFO_CMS_EQUIVALENTLABEL               = 2534;
	public static final int CERTINFO_CMS_EQVLABEL_POLICY               = 2535; // securityPolicyIdentifier
	public static final int CERTINFO_CMS_EQVLABEL_CLASSIFICATION       = 2536; // securityClassification
	public static final int CERTINFO_CMS_EQVLABEL_PRIVACYMARK          = 2537; // privacyMark
	public static final int CERTINFO_CMS_EQVLABEL_CATTYPE              = 2538; // securityCategories.securityCategory.type
	public static final int CERTINFO_CMS_EQVLABEL_CATVALUE             = 2539; // securityCategories.securityCategory.value
	public static final int CERTINFO_CMS_SIGNINGCERTIFICATE            = 2540;
	public static final int CERTINFO_CMS_SIGNINGCERT_ESSCERTID         = 2541; // certs.essCertID
	public static final int CERTINFO_CMS_SIGNINGCERT_POLICIES          = 2542; // policies.policyInformation.policyIdentifier
	public static final int CERTINFO_CMS_SPCAGENCYINFO                 = 2543;
	public static final int CERTINFO_CMS_SPCAGENCYURL                  = 2544; // spcAgencyInfo.url
	public static final int CERTINFO_CMS_SPCSTATEMENTTYPE              = 2545;
	public static final int CERTINFO_CMS_SPCSTMT_INDIVIDUALCODESIGNING = 2546; // individualCodeSigning
	public static final int CERTINFO_CMS_SPCSTMT_COMMERCIALCODESIGNING = 2547; // commercialCodeSigning
	public static final int CERTINFO_CMS_SPCOPUSINFO                   = 2548; // Used internally
	public static final int CERTINFO_LAST                              = 2549;
	public static final int KEYINFO_FIRST                              = 3000; // *******************
	public static final int KEYINFO_QUERY                              = 3001; // Keyset query
	public static final int KEYINFO_QUERY_REQUESTS                     = 3002; // Query of requests in cert store
	public static final int KEYINFO_LAST                               = 3003;
	public static final int DEVINFO_FIRST                              = 4000; // *******************
	public static final int DEVINFO_INITIALISE                         = 4001; // Initialise device for use
	public static final int DEVINFO_INITIALIZE                         = 4001;
	public static final int DEVINFO_AUTHENT_USER                       = 4002; // Authenticate user to device
	public static final int DEVINFO_AUTHENT_SUPERVISOR                 = 4003; // Authenticate supervisor to dev.
	public static final int DEVINFO_SET_AUTHENT_USER                   = 4004; // Set user authent.value
	public static final int DEVINFO_SET_AUTHENT_SUPERVISOR             = 4005; // Set supervisor auth.val.
	public static final int DEVINFO_ZEROISE                            = 4006; // Zeroise device
	public static final int DEVINFO_ZEROIZE                            = 4006;
	public static final int DEVINFO_LOGGEDIN                           = 4007; // Whether user is logged in
	public static final int DEVINFO_LABEL                              = 4008; // Device/token label
	public static final int DEVINFO_LAST                               = 4009;
	public static final int ENVINFO_FIRST                              = 5000; // *********************
	public static final int ENVINFO_DATASIZE                           = 5001; // Data size information
	public static final int ENVINFO_COMPRESSION                        = 5002; // Compression information
	public static final int ENVINFO_CONTENTTYPE                        = 5003; // Inner CMS content type
	public static final int ENVINFO_DETACHEDSIGNATURE                  = 5004; // Generate CMS detached signature
	public static final int ENVINFO_SIGNATURE_RESULT                   = 5005; // Signature check result
	public static final int ENVINFO_MAC                                = 5006; // Use MAC instead of encrypting
	public static final int ENVINFO_CURRENT_COMPONENT                  = 5007; // Cursor management: Relative pos.
	public static final int ENVINFO_PASSWORD                           = 5008; // User password
	public static final int ENVINFO_KEY                                = 5009; // Conventional encryption key
	public static final int ENVINFO_SIGNATURE                          = 5010; // Signature/signature check key
	public static final int ENVINFO_SIGNATURE_EXTRADATA                = 5011; // Extra information added to CMS sigs
	public static final int ENVINFO_RECIPIENT                          = 5012; // Recipient email address
	public static final int ENVINFO_PUBLICKEY                          = 5013; // PKC encryption key
	public static final int ENVINFO_PRIVATEKEY                         = 5014; // PKC decryption key
	public static final int ENVINFO_PRIVATEKEY_LABEL                   = 5015; // Label of PKC decryption key
	public static final int ENVINFO_ORIGINATOR                         = 5016; // Originator info/key
	public static final int ENVINFO_SESSIONKEY                         = 5017; // Session key
	public static final int ENVINFO_HASH                               = 5018; // Hash value
	public static final int ENVINFO_TIMESTAMP_AUTHORITY                = 5019; // Timestamp authority
	public static final int ENVINFO_KEYSET_SIGCHECK                    = 5020; // Signature check keyset
	public static final int ENVINFO_KEYSET_ENCRYPT                     = 5021; // PKC encryption keyset
	public static final int ENVINFO_KEYSET_DECRYPT                     = 5022; // PKC decryption keyset
	public static final int ENVINFO_LAST                               = 5023;
	public static final int SESSINFO_FIRST                             = 6000; // ********************
	public static final int SESSINFO_ACTIVE                            = 6001; // Whether session is active
	public static final int SESSINFO_CONNECTIONACTIVE                  = 6002; // Whether network connection is active
	public static final int SESSINFO_USERNAME                          = 6003; // User name
	public static final int SESSINFO_PASSWORD                          = 6004; // Password
	public static final int SESSINFO_PRIVATEKEY                        = 6005; // Server/client private key
	public static final int SESSINFO_KEYSET                            = 6006; // Certificate store
	public static final int SESSINFO_SERVER_NAME                       = 6007; // Server name
	public static final int SESSINFO_SERVER_PORT                       = 6008; // Server port number
	public static final int SESSINFO_CLIENT_NAME                       = 6009; // Client name
	public static final int SESSINFO_CLIENT_PORT                       = 6010; // Client port number
	public static final int SESSINFO_SESSION                           = 6011; // Transport mechanism
	public static final int SESSINFO_VERSION                           = 6012; // Protocol version
	public static final int SESSINFO_REQUEST                           = 6013; // Cert.request object
	public static final int SESSINFO_RESPONSE                          = 6014; // Cert.response object
	public static final int SESSINFO_TSP_MSGIMPRINT                    = 6015; // TSP message imprint
	public static final int SESSINFO_CMP_CACERTIFICATE                 = 6016; // Issuing CA certificate
	public static final int SESSINFO_CMP_REQUESTTYPE                   = 6017; // Request type
	public static final int SESSINFO_SSH_FINGERPRINT                   = 6018; // Server key fingerprint
	public static final int SESSINFO_LAST                              = 6019;
	public static final int USERINFO_FIRST                             = 7000; // ********************
	public static final int USERINFO_PASSWORD                          = 7001; // Password
	public static final int USERINFO_CAKEY_CERTSIGN                    = 7002; // CA cert signing key
	public static final int USERINFO_CAKEY_CRLSIGN                     = 7003; // CA CRL signing key
	public static final int USERINFO_CAKEY_OCSPSIGN                    = 7004; // CA OCSP signing key
	public static final int USERINFO_LAST                              = 7005;
	public static final int ATTRIBUTE_LAST                             = 7005;
	
	/****************************************************************************
	*																			*
	*						Attribute Subtypes and Related Values				*
	*																			*
	****************************************************************************/
	
	/* Flags for the X.509 keyUsage extension */
	
	public static final int KEYUSAGE_NONE                            = 0x000;
	public static final int KEYUSAGE_DIGITALSIGNATURE                = 0x001;
	public static final int KEYUSAGE_NONREPUDIATION                  = 0x002;
	public static final int KEYUSAGE_KEYENCIPHERMENT                 = 0x004;
	public static final int KEYUSAGE_DATAENCIPHERMENT                = 0x008;
	public static final int KEYUSAGE_KEYAGREEMENT                    = 0x010;
	public static final int KEYUSAGE_KEYCERTSIGN                     = 0x020;
	public static final int KEYUSAGE_CRLSIGN                         = 0x040;
	public static final int KEYUSAGE_ENCIPHERONLY                    = 0x080;
	public static final int KEYUSAGE_DECIPHERONLY                    = 0x100;
	public static final int KEYUSAGE_LAST                            = 0x200; // Last possible value
	
	/* X.509 cRLReason and cryptlib cRLExtReason codes */
	
	public static final int CRLREASON_UNSPECIFIED          = 0 ;
	public static final int CRLREASON_KEYCOMPROMISE        = 1 ;
	public static final int CRLREASON_CACOMPROMISE         = 2 ;
	public static final int CRLREASON_AFFILIATIONCHANGED   = 3 ;
	public static final int CRLREASON_SUPERSEDED           = 4 ;
	public static final int CRLREASON_CESSATIONOFOPERATION = 5 ;
	public static final int CRLREASON_CERTIFICATEHOLD      = 6 ;
	public static final int CRLREASON_REMOVEFROMCRL        = 8 ;
	public static final int CRLREASON_LAST                 = 9 ; // End of standard CRL reasons
	public static final int CRLREASON_NEVERVALID           = 10;
	public static final int CRLEXTREASON_LAST              = 11;
	
	/* X.509 CRL reason flags.  These identify the same thing as the cRLReason
	   codes but allow for multiple reasons to be specified.  Note that these
	   don't follow the X.509 naming since in that scheme the enumerated types
	   and bitflags have the same names */
	
	public static final int CRLREASONFLAG_UNUSED                     = 0x001;
	public static final int CRLREASONFLAG_KEYCOMPROMISE              = 0x002;
	public static final int CRLREASONFLAG_CACOMPROMISE               = 0x004;
	public static final int CRLREASONFLAG_AFFILIATIONCHANGED         = 0x008;
	public static final int CRLREASONFLAG_SUPERSEDED                 = 0x010;
	public static final int CRLREASONFLAG_CESSATIONOFOPERATION       = 0x020;
	public static final int CRLREASONFLAG_CERTIFICATEHOLD            = 0x040;
	public static final int CRLREASONFLAG_LAST                       = 0x080; // Last poss.value
	
	/* X.509 CRL holdInstruction codes */
	
	public static final int HOLDINSTRUCTION_NONE        = 0;
	public static final int HOLDINSTRUCTION_CALLISSUER  = 1;
	public static final int HOLDINSTRUCTION_REJECT      = 2;
	public static final int HOLDINSTRUCTION_PICKUPTOKEN = 3;
	public static final int HOLDINSTRUCTION_LAST        = 4;
	
	/* Flags for the Netscape netscape-cert-type extension */
	
	public static final int NS_CERTTYPE_SSLCLIENT                    = 0x001;
	public static final int NS_CERTTYPE_SSLSERVER                    = 0x002;
	public static final int NS_CERTTYPE_SMIME                        = 0x004;
	public static final int NS_CERTTYPE_OBJECTSIGNING                = 0x008;
	public static final int NS_CERTTYPE_RESERVED                     = 0x010;
	public static final int NS_CERTTYPE_SSLCA                        = 0x020;
	public static final int NS_CERTTYPE_SMIMECA                      = 0x040;
	public static final int NS_CERTTYPE_OBJECTSIGNINGCA              = 0x080;
	public static final int NS_CERTTYPE_LAST                         = 0x100; // Last possible value
	
	/* Flags for the SET certificate-type extension */
	
	public static final int SET_CERTTYPE_CARD                        = 0x001;
	public static final int SET_CERTTYPE_MER                         = 0x002;
	public static final int SET_CERTTYPE_PGWY                        = 0x004;
	public static final int SET_CERTTYPE_CCA                         = 0x008;
	public static final int SET_CERTTYPE_MCA                         = 0x010;
	public static final int SET_CERTTYPE_PCA                         = 0x020;
	public static final int SET_CERTTYPE_GCA                         = 0x040;
	public static final int SET_CERTTYPE_BCA                         = 0x080;
	public static final int SET_CERTTYPE_RCA                         = 0x100;
	public static final int SET_CERTTYPE_ACQ                         = 0x200;
	public static final int SET_CERTTYPE_LAST                        = 0x400; // Last possible value
	
	/* CMS contentType values */
	
	// CRYPT_CONTENT_TYPE
	public static final int CONTENT_NONE                   = 0 ;
	public static final int CONTENT_DATA                   = 1 ;
	public static final int CONTENT_SIGNEDDATA             = 2 ;
	public static final int CONTENT_ENVELOPEDDATA          = 3 ;
	public static final int CONTENT_SIGNEDANDENVELOPEDDATA = 4 ;
	public static final int CONTENT_DIGESTEDDATA           = 5 ;
	public static final int CONTENT_ENCRYPTEDDATA          = 6 ;
	public static final int CONTENT_COMPRESSEDDATA         = 7 ;
	public static final int CONTENT_TSTINFO                = 8 ;
	public static final int CONTENT_SPCINDIRECTDATACONTEXT = 9 ;
	public static final int CONTENT_LAST                   = 10;
	
	/* ESS securityClassification codes */
	
	public static final int CLASSIFICATION_UNMARKED     = 0  ;
	public static final int CLASSIFICATION_UNCLASSIFIED = 1  ;
	public static final int CLASSIFICATION_RESTRICTED   = 2  ;
	public static final int CLASSIFICATION_CONFIDENTIAL = 3  ;
	public static final int CLASSIFICATION_SECRET       = 4  ;
	public static final int CLASSIFICATION_TOP_SECRET   = 5  ;
	public static final int CLASSIFICATION_LAST         = 255;
	
	/* OCSP certificate status and extended status */
	
	public static final int OCSPSTATUS_NOTREVOKED  = 0;
	public static final int OCSPSTATUS_REVOKED     = 1;
	public static final int OCSPSTATUS_UNKNOWN     = 2;
	public static final int OCSPEXTSTATUS_VALID    = 3;
	public static final int OCSPEXTSTATUS_NOTVALID = 4;
	public static final int OCSPEXTSTATUS_NEWCERT  = 5;
	public static final int OCSPEXTSTATUS_UNKNOWN  = 6;
	
	/* CMP status and extended status info values */
	
	public static final int CMPSTATUS_OK                     = 0;
	public static final int CMPSTATUS_GRANTED                = 0;
	public static final int CMPSTATUS_GRANTEDWITHMODS        = 1;
	public static final int CMPSTATUS_REJECTION              = 2;
	public static final int CMPSTATUS_WAITING                = 3;
	public static final int CMPSTATUS_REVOCATIONWARNING      = 4;
	public static final int CMPSTATUS_REVOCATIONNOTIFICATION = 5;
	public static final int CMPSTATUS_KEYUPDATEWARNING       = 6;
	public static final int CMPSTATUS_LAST                   = 7;
	
	public static final int CMPSTATUS_EXT_BADALG                     = 0x001;
	public static final int CMPSTATUS_EXT_BADMESSAGECHECK            = 0x002;
	public static final int CMPSTATUS_EXT_BADREQUEST                 = 0x004;
	public static final int CMPSTATUS_EXT_BADTIME                    = 0x008;
	public static final int CMPSTATUS_EXT_BADCERTID                  = 0x010;
	public static final int CMPSTATUS_EXT_BADDATAFORMAT              = 0x020;
	public static final int CMPSTATUS_EXT_WRONGAUTHORITY             = 0x040;
	public static final int CMPSTATUS_EXT_INCORRECTDATA              = 0x080;
	public static final int CMPSTATUS_EXT_MISSINGTIMESTAMP           = 0x100;
	public static final int CMPSTATUS_EXT_BADPOP                     = 0x200;
	public static final int CMPSTATUS_EXT_LAST                       = 0x400; // Last possible value
	
	/* The amount of detail to include in signatures when signing certificate
	   objects */
	
	// CRYPT_SIGNATURELEVEL_TYPE
	public static final int SIGNATURELEVEL_NONE       = 0; // Include only signature
	public static final int SIGNATURELEVEL_SIGNERCERT = 1; // Include signer cert
	public static final int SIGNATURELEVEL_ALL        = 2; // Include all relevant info
	public static final int SIGNATURELEVEL_LAST       = 3; // Last possible sig.level type
	
	/* The certificate export format type, which defines the format in which a
	   certificate object is exported */
	
	// CRYPT_CERTFORMAT_TYPE
	public static final int CERTFORMAT_NONE             = 0; // No certificate format
	public static final int CERTFORMAT_CERTIFICATE      = 1; // DER-encoded certificate
	public static final int CERTFORMAT_CERTCHAIN        = 2; // PKCS #7 certificate chain
	public static final int CERTFORMAT_TEXT_CERTIFICATE = 3; // base-64 wrapped cert
	public static final int CERTFORMAT_TEXT_CERTCHAIN   = 4; // base-64 wrapped cert chain
	public static final int CERTFORMAT_LAST             = 5; // Last possible cert.format type
	
	/* CMP request types */
	
	// CRYPT_REQUESTTYPE_TYPE
	public static final int REQUESTTYPE_NONE           = 0; // No request type
	public static final int REQUESTTYPE_INITIALISATION = 1; // Initialisation request
	public static final int REQUESTTYPE_INITIALIZATION = 1;
	public static final int REQUESTTYPE_CERTIFICATE    = 2; // Certification request
	public static final int REQUESTTYPE_KEYUPDATE      = 3; // Key update request
	public static final int REQUESTTYPE_REVOCATION     = 4; // Cert revocation request
	public static final int REQUESTTYPE_LAST           = 5; // Last possible request type
	
	/* Key ID types */
	
	// CRYPT_KEYID_TYPE
	public static final int KEYID_NONE  = 0; // No key ID type
	public static final int KEYID_NAME  = 1; // Key owner name
	public static final int KEYID_EMAIL = 2; // Key owner email address
	public static final int KEYID_LAST  = 3; // Last possible key ID type
	
	/* The encryption object types */
	
	// CRYPT_OBJECT_TYPE
	public static final int OBJECT_NONE             = 0; // No object type
	public static final int OBJECT_ENCRYPTED_KEY    = 1; // Conventionally encrypted key
	public static final int OBJECT_PKCENCRYPTED_KEY = 2; // PKC-encrypted key
	public static final int OBJECT_KEYAGREEMENT     = 3; // Key agreement information
	public static final int OBJECT_SIGNATURE        = 4; // Signature
	public static final int OBJECT_LAST             = 5; // Last possible object type
	
	/* Object/attribute error type information */
	
	// CRYPT_ERRTYPE_TYPE
	public static final int ERRTYPE_NONE             = 0; // No error information
	public static final int ERRTYPE_ATTR_SIZE        = 1; // Attribute data too small or large
	public static final int ERRTYPE_ATTR_VALUE       = 2; // Attribute value is invalid
	public static final int ERRTYPE_ATTR_ABSENT      = 3; // Required attribute missing
	public static final int ERRTYPE_ATTR_PRESENT     = 4; // Non-allowed attribute present
	public static final int ERRTYPE_CONSTRAINT       = 5; // Cert: Constraint violation in object
	public static final int ERRTYPE_ISSUERCONSTRAINT = 6; // Cert: Constraint viol.in issuing cert
	public static final int ERRTYPE_LAST             = 7; // Last possible error info type
	
	/* Cert store management action type */
	
	// CRYPT_CERTACTION_TYPE
	public static final int CERTACTION_NONE                   = 0 ; // No log action
	public static final int CERTACTION_CREATE                 = 1 ; // Create cert store
	public static final int CERTACTION_CONNECT                = 2 ; // Connect to cert store
	public static final int CERTACTION_DISCONNECT             = 3 ; // Disconnect from cert store
	public static final int CERTACTION_ERROR                  = 4 ; // Error information
	public static final int CERTACTION_ADDUSER                = 5 ; // Add PKI user
	public static final int CERTACTION_REQUEST_CERT           = 6 ; // Cert request
	public static final int CERTACTION_REQUEST_RENEWAL        = 7 ; // Cert renewal request
	public static final int CERTACTION_REQUEST_REVOCATION     = 8 ; // Cert revocation request
	public static final int CERTACTION_CERT_CREATION          = 9 ; // Cert creation
	public static final int CERTACTION_CERT_CREATION_COMPLETE = 10; // Confirmation of cert creation
	public static final int CERTACTION_CERT_CREATION_DROP     = 11; // Cancellation of cert creation
	public static final int CERTACTION_CERT_CREATION_REVERSE  = 12; // Cancel of creation w.revocation
	public static final int CERTACTION_RESTART_CLEANUP        = 13; // Delete reqs after restart
	public static final int CERTACTION_RESTART_REVOKE_CERT    = 14; // Complete revocation after restart
	public static final int CERTACTION_ISSUE_CERT             = 15; // Cert issue
	public static final int CERTACTION_ISSUE_CRL              = 16; // CRL issue
	public static final int CERTACTION_REVOKE_CERT            = 17; // Cert revocation
	public static final int CERTACTION_EXPIRE_CERT            = 18; // Cert expiry
	public static final int CERTACTION_CLEANUP                = 19; // Clean up on restart
	public static final int CERTACTION_LAST                   = 20; // Last possible cert store log action
	
	/****************************************************************************
	*																			*
	*								General Constants							*
	*																			*
	****************************************************************************/
	
	/* The maximum user key size - 2048 bits */
	
	public static final int MAX_KEYSIZE                              = 256 ;
	
	/* The maximum IV size - 256 bits */
	
	public static final int MAX_IVSIZE                               = 32  ;
	
	/* The maximum public-key component size - 4096 bits */
	
	public static final int MAX_PKCSIZE                              = 512 ;
	
	/* The maximum hash size - 256 bits */
	
	public static final int MAX_HASHSIZE                             = 32  ;
	
	/* The maximum size of a text string (eg key owner name) */
	
	public static final int MAX_TEXTSIZE                             = 64  ;
	
	/* A magic value indicating that the default setting for this parameter
	   should be used */
	
	public static final int USE_DEFAULT                              = -10 ;
	
	/* A magic value for unused parameters */
	
	public static final int UNUSED                                   = -11 ;
	
	/* Whether the PKC key is a public or private key */
	
	public static final int KEYTYPE_PRIVATE                          = 0   ;
	public static final int KEYTYPE_PUBLIC                           = 1   ;
	
	/* The type of information polling to perform to get random seed information */
	
	public static final int RANDOM_FASTPOLL                          = -10 ;
	public static final int RANDOM_SLOWPOLL                          = -11 ;
	
	/* Cursor positioning codes for certificate/CRL extensions */
	
	public static final int CURSOR_FIRST                             = -20 ;
	public static final int CURSOR_PREVIOUS                          = -21 ;
	public static final int CURSOR_NEXT                              = -22 ;
	public static final int CURSOR_LAST                              = -23 ;
	
	/* Options passed to cryptOpenKeyset() */
	
	// CRYPT_KEYOPT_TYPE
	public static final int KEYOPT_NONE     = 0; // No options
	public static final int KEYOPT_READONLY = 1; // Open keyset in read-only mode
	public static final int KEYOPT_CREATE   = 2; // Create a new keyset
	public static final int KEYOPT_LAST     = 3; // Last possible key option type
	
	/* The various cryptlib objects - these are just integer handles */
	
	//CRYPTLIBCONVERTER - NOT NEEDED: typedef int CRYPT_CERTIFICATE;
	//CRYPTLIBCONVERTER - NOT NEEDED: typedef int CRYPT_CONTEXT;
	//CRYPTLIBCONVERTER - NOT NEEDED: typedef int CRYPT_DEVICE;
	//CRYPTLIBCONVERTER - NOT NEEDED: typedef int CRYPT_ENVELOPE;
	//CRYPTLIBCONVERTER - NOT NEEDED: typedef int CRYPT_KEYSET;
	//CRYPTLIBCONVERTER - NOT NEEDED: typedef int CRYPT_SESSION;
	//CRYPTLIBCONVERTER - NOT NEEDED: typedef int CRYPT_USER;
	
	/* Sometimes we don't know the exact type of a cryptlib object, so we use a
	   generic handle type to identify it */
	
	//CRYPTLIBCONVERTER - NOT NEEDED: typedef int CRYPT_HANDLE;
	
	/****************************************************************************
	*																			*
	*							Encryption Data Structures						*
	*																			*
	****************************************************************************/
	
	/* Results returned from the encryption capability query */
	
	//CRYPTLIBCONVERTER - NOT SUPPORTED:
	//typedef struct {
	//	/* Algorithm information */
	//	char algoName[ CRYPT_MAX_TEXTSIZE ];/* The algorithm name */
	//	int blockSize;					/* The block size of the algorithm */
	//	int minKeySize;					/* Minimum key size in bytes */
	//	int keySize;					/* Recommended key size in bytes */
	//	int maxKeySize;					/* Maximum key size in bytes */
	//	} CRYPT_QUERY_INFO;
	
	/* Results returned from the encryption object query.  These provide
	   information on the objects created by cryptExportKey()/
	   cryptCreateSignature() */
	
	//CRYPTLIBCONVERTER - NOT SUPPORTED:
	//typedef struct {
	//	/* The object type */
	//	CRYPT_OBJECT_TYPE objectType;	/* The object type */
	//
	//	/* The encryption algorithm and mode */
	//	CRYPT_ALGO_TYPE cryptAlgo;		/* The encryption algorithm */
	//	CRYPT_MODE_TYPE cryptMode;		/* The encryption mode */
	//
	//	/* The hash algorithm for Signature objects */
	//	CRYPT_ALGO_TYPE hashAlgo;		/* Hash algorithm */
	//
	//	/* The salt for derived keys */
	//	unsigned char salt[ CRYPT_MAX_HASHSIZE ];
	//	int saltSize;
	//	} CRYPT_OBJECT_INFO;
	
	/* Key information for the public-key encryption algorithms.  These fields
	   are not accessed directly, but can be manipulated with the init/set/
	   destroyComponents() macros */
	
	//CRYPTLIBCONVERTER - NOT SUPPORTED:
	//typedef struct {
	//	/* Status information */
	//	int isPublicKey;			/* Whether this is a public or private key */
	//
	//	/* Public components */
	//	unsigned char n[ CRYPT_MAX_PKCSIZE ];	/* Modulus */
	//	int nLen;					/* Length of modulus in bits */
	//	unsigned char e[ CRYPT_MAX_PKCSIZE ];	/* Public exponent */
	//	int eLen;					/* Length of public exponent in bits */
	//
	//	/* Private components */
	//	unsigned char d[ CRYPT_MAX_PKCSIZE ];	/* Private exponent */
	//	int dLen;					/* Length of private exponent in bits */
	//	unsigned char p[ CRYPT_MAX_PKCSIZE ];	/* Prime factor 1 */
	//	int pLen;					/* Length of prime factor 1 in bits */
	//	unsigned char q[ CRYPT_MAX_PKCSIZE ];	/* Prime factor 2 */
	//	int qLen;					/* Length of prime factor 2 in bits */
	//	unsigned char u[ CRYPT_MAX_PKCSIZE ];	/* Mult.inverse of q, mod p */
	//	int uLen;					/* Length of private exponent in bits */
	//	unsigned char e1[ CRYPT_MAX_PKCSIZE ];	/* Private exponent 1 (PKCS) */
	//	int e1Len;					/* Length of private exponent in bits */
	//	unsigned char e2[ CRYPT_MAX_PKCSIZE ];	/* Private exponent 2 (PKCS) */
	//	int e2Len;					/* Length of private exponent in bits */
	//	} CRYPT_PKCINFO_RSA;
	
	//CRYPTLIBCONVERTER - NOT SUPPORTED:
	//typedef struct {
	//	/* Status information */
	//	int isPublicKey;			/* Whether this is a public or private key */
	//
	//	/* Public components */
	//	unsigned char p[ CRYPT_MAX_PKCSIZE ];	/* Prime modulus */
	//	int pLen;					/* Length of prime modulus in bits */
	//	unsigned char q[ CRYPT_MAX_PKCSIZE ];	/* Prime divisor */
	//	int qLen;					/* Length of prime divisor in bits */
	//	unsigned char g[ CRYPT_MAX_PKCSIZE ];	/* h^( ( p - 1 ) / q ) mod p */
	//	int gLen;					/* Length of g in bits */
	//	unsigned char y[ CRYPT_MAX_PKCSIZE ];	/* Public random integer */
	//	int yLen;					/* Length of public integer in bits */
	//
	//	/* Private components */
	//	unsigned char x[ CRYPT_MAX_PKCSIZE ];	/* Private random integer */
	//	int xLen;					/* Length of private integer in bits */
	//	} CRYPT_PKCINFO_DLP;
	
	/* Macros to initialise and destroy the structure which stores the components
	   of a public key */
	
	//CRYPTLIBCONVERTER - NOT SUPPORTED:
	//#define cryptInitComponents( componentInfo, componentKeyType ) \
	//	{ memset( ( componentInfo ), 0, sizeof( *componentInfo ) ); \
	//	  ( componentInfo )->isPublicKey = ( ( componentKeyType ) ? 1 : 0 ); }
	
	//CRYPTLIBCONVERTER - NOT SUPPORTED:
	//#define cryptDestroyComponents( componentInfo ) \
	//	memset( ( componentInfo ), 0, sizeof( *componentInfo ) )
	
	/* Macros to set a component of a public key */
	
	//CRYPTLIBCONVERTER - NOT SUPPORTED:
	//#define cryptSetComponent( destination, source, length ) \
	//	{ memcpy( ( destination ), ( source ), ( ( length ) + 7 ) >> 3 ); \
	//	  ( destination##Len ) = length; }
	
	/****************************************************************************
	*																			*
	*								Status Codes								*
	*																			*
	****************************************************************************/
	
	/* No error in function call */
	
	public static final int OK                                       = 0   ; // No error
	
	/* Error in parameters passed to function */
	
	public static final int ERROR_PARAM1                             = -1  ; // Bad argument, parameter 1
	public static final int ERROR_PARAM2                             = -2  ; // Bad argument, parameter 2
	public static final int ERROR_PARAM3                             = -3  ; // Bad argument, parameter 3
	public static final int ERROR_PARAM4                             = -4  ; // Bad argument, parameter 4
	public static final int ERROR_PARAM5                             = -5  ; // Bad argument, parameter 5
	public static final int ERROR_PARAM6                             = -6  ; // Bad argument, parameter 6
	public static final int ERROR_PARAM7                             = -7  ; // Bad argument, parameter 7
	
	/* Errors due to insufficient resources */
	
	public static final int ERROR_MEMORY                             = -10 ; // Out of memory
	public static final int ERROR_NOTINITED                          = -11 ; // Data has not been initialised
	public static final int ERROR_INITED                             = -12 ; // Data has already been init'd
	public static final int ERROR_NOSECURE                           = -13 ; // Opn.not avail.at requested sec.level
	public static final int ERROR_RANDOM                             = -14 ; // No reliable random data available
	public static final int ERROR_FAILED                             = -15 ; // Operation failed
	
	/* Security violations */
	
	public static final int ERROR_NOTAVAIL                           = -20 ; // This type of opn.not available
	public static final int ERROR_PERMISSION                         = -21 ; // No permiss.to perform this operation
	public static final int ERROR_WRONGKEY                           = -22 ; // Incorrect key used to decrypt data
	public static final int ERROR_INCOMPLETE                         = -23 ; // Operation incomplete/still in progress
	public static final int ERROR_COMPLETE                           = -24 ; // Operation complete/can't continue
	public static final int ERROR_BUSY                               = -25 ; // Resource in use by async operation
	public static final int ERROR_INVALID                            = -26 ; // Invalid/inconsistent information
	public static final int ERROR_SIGNALLED                          = -27 ; // Resource destroyed by extnl.event
	
	/* High-level function errors */
	
	public static final int ERROR_OVERFLOW                           = -30 ; // Resources/space exhausted
	public static final int ERROR_UNDERFLOW                          = -31 ; // Not enough data available
	public static final int ERROR_BADDATA                            = -32 ; // Bad/unrecognised data format
	public static final int ERROR_SIGNATURE                          = -33 ; // Signature/integrity check failed
	
	/* Data access function errors */
	
	public static final int ERROR_OPEN                               = -40 ; // Cannot open object
	public static final int ERROR_READ                               = -41 ; // Cannot read item from object
	public static final int ERROR_WRITE                              = -42 ; // Cannot write item to object
	public static final int ERROR_NOTFOUND                           = -43 ; // Requested item not found in object
	public static final int ERROR_DUPLICATE                          = -44 ; // Item already present in object
	
	/* Data enveloping errors */
	
	public static final int ENVELOPE_RESOURCE                        = -50 ; // Need resource to proceed
	
	/* Macros to examine return values */
	
	//CRYPTLIBCONVERTER - NOT SUPPORTED:
	//#define cryptStatusError( status )	( ( status ) < CRYPT_OK )
	//CRYPTLIBCONVERTER - NOT SUPPORTED:
	//#define cryptStatusOK( status )		( ( status ) == CRYPT_OK )
	
	/****************************************************************************
	*																			*
	*									General Functions						*
	*																			*
	****************************************************************************/
	
	/* The following is necessary to stop C++ name mangling */
	
	
	/* Initialise and shut down cryptlib */
	
	public static native void Init() throws CryptException;
	
	public static native void End() throws CryptException;
	
	/* Query cryptlibs capabilities */
	
	//CRYPTLIBCONVERTER - NOT SUPPORTED (BECAUSE IT USES A STRUCT):
	//C_RET cryptQueryCapability( C_IN CRYPT_ALGO_TYPE cryptAlgo,
	//							C_OUT CRYPT_QUERY_INFO C_PTR cryptQueryInfo );
	
	/* Create and destroy an encryption context */
	
	public static native int CreateContext(
							int cryptUser, // CRYPT_USER
							int cryptAlgo // CRYPT_ALGO_TYPE
							) throws CryptException;
	
	public static native void DestroyContext(
							int cryptContext // CRYPT_CONTEXT
							) throws CryptException;
	
	/* Generic "destroy an object" function */
	
	public static native void DestroyObject(
							int cryptObject // CRYPT_HANDLE
							) throws CryptException;
	
	/* Generate a key into a context */
	
	public static native void GenerateKey(
							int cryptContext // CRYPT_CONTEXT
							) throws CryptException;
	
	public static native void GenerateKeyAsync(
							int cryptContext // CRYPT_CONTEXT
							) throws CryptException;
	
	public static native void AsyncQuery(
							int cryptObject // CRYPT_HANDLE
							) throws CryptException;
	
	public static native void AsyncCancel(
							int cryptObject // CRYPT_HANDLE
							) throws CryptException;
	
	/* Encrypt/decrypt/hash a block of memory */
	
	public static native void Encrypt(
							int cryptContext, // CRYPT_CONTEXT
							java.nio.ByteBuffer buffer,
							int bufferOffset,
							int length
							) throws CryptException;
	public static native void Encrypt(
							int cryptContext, // CRYPT_CONTEXT
							byte[] buffer,
							int bufferOffset,
							int length
							) throws CryptException;
	public static void Encrypt(
							int cryptContext, // CRYPT_CONTEXT
							java.nio.ByteBuffer buffer
							) throws CryptException { Encrypt(cryptContext, buffer, 0, buffer.capacity()); }
	public static void Encrypt(
							int cryptContext, // CRYPT_CONTEXT
							byte[] buffer
							) throws CryptException { Encrypt(cryptContext, buffer, 0, buffer.length); }
	
	public static native void Decrypt(
							int cryptContext, // CRYPT_CONTEXT
							java.nio.ByteBuffer buffer,
							int bufferOffset,
							int length
							) throws CryptException;
	public static native void Decrypt(
							int cryptContext, // CRYPT_CONTEXT
							byte[] buffer,
							int bufferOffset,
							int length
							) throws CryptException;
	public static void Decrypt(
							int cryptContext, // CRYPT_CONTEXT
							java.nio.ByteBuffer buffer
							) throws CryptException { Decrypt(cryptContext, buffer, 0, buffer.capacity()); }
	public static void Decrypt(
							int cryptContext, // CRYPT_CONTEXT
							byte[] buffer
							) throws CryptException { Decrypt(cryptContext, buffer, 0, buffer.length); }
	
	/* Get/set/delete attribute functions */
	
	public static native void SetAttribute(
							int cryptHandle, // CRYPT_HANDLE
							int attributeType, // CRYPT_ATTRIBUTE_TYPE
							int value
							) throws CryptException;
	
	public static native void SetAttributeString(
							int cryptHandle, // CRYPT_HANDLE
							int attributeType, // CRYPT_ATTRIBUTE_TYPE
							java.nio.ByteBuffer value,
							int valueOffset,
							int valueLength
							) throws CryptException;
	public static native void SetAttributeString(
							int cryptHandle, // CRYPT_HANDLE
							int attributeType, // CRYPT_ATTRIBUTE_TYPE
							byte[] value,
							int valueOffset,
							int valueLength
							) throws CryptException;
	public static void SetAttributeString(
							int cryptHandle, // CRYPT_HANDLE
							int attributeType, // CRYPT_ATTRIBUTE_TYPE
							java.nio.ByteBuffer value
							) throws CryptException { SetAttributeString(cryptHandle, attributeType, value, 0, value.capacity()); }
	public static void SetAttributeString(
							int cryptHandle, // CRYPT_HANDLE
							int attributeType, // CRYPT_ATTRIBUTE_TYPE
							byte[] value
							) throws CryptException { SetAttributeString(cryptHandle, attributeType, value, 0, value.length); }
	public static void SetAttributeString(
							int cryptHandle, // CRYPT_HANDLE
							int attributeType, // CRYPT_ATTRIBUTE_TYPE
							String value
							) throws CryptException { SetAttributeString(cryptHandle, attributeType, value.getBytes(), 0, value.length()); }
	
	public static native int GetAttribute(
							int cryptHandle, // CRYPT_HANDLE
							int attributeType // CRYPT_ATTRIBUTE_TYPE
							) throws CryptException;
	
	public static native int GetAttributeString(
							int cryptHandle, // CRYPT_HANDLE
							int attributeType, // CRYPT_ATTRIBUTE_TYPE
							java.nio.ByteBuffer value,
							int valueOffset
							) throws CryptException;
	public static native int GetAttributeString(
							int cryptHandle, // CRYPT_HANDLE
							int attributeType, // CRYPT_ATTRIBUTE_TYPE
							byte[] value,
							int valueOffset
							) throws CryptException;
	public static int GetAttributeString(
							int cryptHandle, // CRYPT_HANDLE
							int attributeType, // CRYPT_ATTRIBUTE_TYPE
							java.nio.ByteBuffer value
							) throws CryptException { return GetAttributeString(cryptHandle, attributeType, value, 0); }
	public static int GetAttributeString(
							int cryptHandle, // CRYPT_HANDLE
							int attributeType, // CRYPT_ATTRIBUTE_TYPE
							byte[] value
							) throws CryptException { return GetAttributeString(cryptHandle, attributeType, value, 0); }
	public static String GetAttributeString(
	                        int cryptHandle, // CRYPT_HANDLE
	                        int attributeType // CRYPT_ATTRIBUTE_TYPE
	                        ) throws CryptException
	                        {
	                            int length = GetAttributeString(cryptHandle, attributeType, (byte[])null);
	                            byte[] bytes = new byte[length];
	                            length = GetAttributeString(cryptHandle, attributeType, bytes);
	                            return new String(bytes, 0, length);
	                        }
	
	
	public static native void DeleteAttribute(
							int cryptHandle, // CRYPT_HANDLE
							int attributeType // CRYPT_ATTRIBUTE_TYPE
							) throws CryptException;
	
	/* Oddball functions: Add random data to the pool, query an encoded signature
	   or key data.  These are due to be replaced once a suitable alternative can
	   be found */
	
	public static native void AddRandom(
							java.nio.ByteBuffer randomData,
							int randomDataOffset,
							int randomDataLength
							) throws CryptException;
	public static native void AddRandom(
							byte[] randomData,
							int randomDataOffset,
							int randomDataLength
							) throws CryptException;
	public static void AddRandom(
							java.nio.ByteBuffer randomData
							) throws CryptException { AddRandom(randomData, 0, randomData.capacity()); }
	public static void AddRandom(
							byte[] randomData
							) throws CryptException { AddRandom(randomData, 0, randomData.length); }
	public static void AddRandom(
							String randomData
							) throws CryptException { AddRandom(randomData.getBytes(), 0, randomData.length()); }
	
	//CRYPTLIBCONVERTER - NOT SUPPORTED (BECAUSE IT USES A STRUCT):
	//C_RET cryptQueryObject( C_IN void C_PTR objectData,
	//					    C_OUT CRYPT_OBJECT_INFO C_PTR cryptObjectInfo );
	
	/****************************************************************************
	*																			*
	*							Mid-level Encryption Functions					*
	*																			*
	****************************************************************************/
	
	/* Export and import an encrypted session key */
	
	public static native int ExportKey(
							java.nio.ByteBuffer encryptedKey,
							int encryptedKeyOffset,
							int exportKey, // CRYPT_HANDLE
							int sessionKeyContext // CRYPT_CONTEXT
							) throws CryptException;
	public static native int ExportKey(
							byte[] encryptedKey,
							int encryptedKeyOffset,
							int exportKey, // CRYPT_HANDLE
							int sessionKeyContext // CRYPT_CONTEXT
							) throws CryptException;
	public static int ExportKey(
							java.nio.ByteBuffer encryptedKey,
							int exportKey, // CRYPT_HANDLE
							int sessionKeyContext // CRYPT_CONTEXT
							) throws CryptException { return ExportKey(encryptedKey, 0, exportKey, sessionKeyContext); }
	public static int ExportKey(
							byte[] encryptedKey,
							int exportKey, // CRYPT_HANDLE
							int sessionKeyContext // CRYPT_CONTEXT
							) throws CryptException { return ExportKey(encryptedKey, 0, exportKey, sessionKeyContext); }
	
	public static native int ExportKeyEx(
							java.nio.ByteBuffer encryptedKey,
							int encryptedKeyOffset,
							int formatType, // CRYPT_FORMAT_TYPE
							int exportKey, // CRYPT_HANDLE
							int sessionKeyContext // CRYPT_CONTEXT
							) throws CryptException;
	public static native int ExportKeyEx(
							byte[] encryptedKey,
							int encryptedKeyOffset,
							int formatType, // CRYPT_FORMAT_TYPE
							int exportKey, // CRYPT_HANDLE
							int sessionKeyContext // CRYPT_CONTEXT
							) throws CryptException;
	public static int ExportKeyEx(
							java.nio.ByteBuffer encryptedKey,
							int formatType, // CRYPT_FORMAT_TYPE
							int exportKey, // CRYPT_HANDLE
							int sessionKeyContext // CRYPT_CONTEXT
							) throws CryptException { return ExportKeyEx(encryptedKey, 0, formatType, exportKey, sessionKeyContext); }
	public static int ExportKeyEx(
							byte[] encryptedKey,
							int formatType, // CRYPT_FORMAT_TYPE
							int exportKey, // CRYPT_HANDLE
							int sessionKeyContext // CRYPT_CONTEXT
							) throws CryptException { return ExportKeyEx(encryptedKey, 0, formatType, exportKey, sessionKeyContext); }
	
	public static native void ImportKey(
							java.nio.ByteBuffer encryptedKey,
							int encryptedKeyOffset,
							int importKey, // CRYPT_CONTEXT
							int sessionKeyContext // CRYPT_CONTEXT
							) throws CryptException;
	public static native void ImportKey(
							byte[] encryptedKey,
							int encryptedKeyOffset,
							int importKey, // CRYPT_CONTEXT
							int sessionKeyContext // CRYPT_CONTEXT
							) throws CryptException;
	public static void ImportKey(
							java.nio.ByteBuffer encryptedKey,
							int importKey, // CRYPT_CONTEXT
							int sessionKeyContext // CRYPT_CONTEXT
							) throws CryptException { ImportKey(encryptedKey, 0, importKey, sessionKeyContext); }
	public static void ImportKey(
							byte[] encryptedKey,
							int importKey, // CRYPT_CONTEXT
							int sessionKeyContext // CRYPT_CONTEXT
							) throws CryptException { ImportKey(encryptedKey, 0, importKey, sessionKeyContext); }
	
	public static native void ImportKeyEx(
							java.nio.ByteBuffer encryptedKey,
							int encryptedKeyOffset,
							int importKey, // CRYPT_CONTEXT
							int sessionKeyContext // CRYPT_CONTEXT
							) throws CryptException;
	public static native void ImportKeyEx(
							byte[] encryptedKey,
							int encryptedKeyOffset,
							int importKey, // CRYPT_CONTEXT
							int sessionKeyContext // CRYPT_CONTEXT
							) throws CryptException;
	public static void ImportKeyEx(
							java.nio.ByteBuffer encryptedKey,
							int importKey, // CRYPT_CONTEXT
							int sessionKeyContext // CRYPT_CONTEXT
							) throws CryptException { ImportKeyEx(encryptedKey, 0, importKey, sessionKeyContext); }
	public static void ImportKeyEx(
							byte[] encryptedKey,
							int importKey, // CRYPT_CONTEXT
							int sessionKeyContext // CRYPT_CONTEXT
							) throws CryptException { ImportKeyEx(encryptedKey, 0, importKey, sessionKeyContext); }
	
	/* Create and check a digital signature */
	
	public static native int CreateSignature(
							java.nio.ByteBuffer signature,
							int signatureOffset,
							int signContext, // CRYPT_CONTEXT
							int hashContext // CRYPT_CONTEXT
							) throws CryptException;
	public static native int CreateSignature(
							byte[] signature,
							int signatureOffset,
							int signContext, // CRYPT_CONTEXT
							int hashContext // CRYPT_CONTEXT
							) throws CryptException;
	public static int CreateSignature(
							java.nio.ByteBuffer signature,
							int signContext, // CRYPT_CONTEXT
							int hashContext // CRYPT_CONTEXT
							) throws CryptException { return CreateSignature(signature, 0, signContext, hashContext); }
	public static int CreateSignature(
							byte[] signature,
							int signContext, // CRYPT_CONTEXT
							int hashContext // CRYPT_CONTEXT
							) throws CryptException { return CreateSignature(signature, 0, signContext, hashContext); }
	
	public static native int CreateSignatureEx(
							java.nio.ByteBuffer signature,
							int signatureOffset,
							int formatType, // CRYPT_FORMAT_TYPE
							int signContext, // CRYPT_CONTEXT
							int hashContext, // CRYPT_CONTEXT
							int extraData // CRYPT_CERTIFICATE
							) throws CryptException;
	public static native int CreateSignatureEx(
							byte[] signature,
							int signatureOffset,
							int formatType, // CRYPT_FORMAT_TYPE
							int signContext, // CRYPT_CONTEXT
							int hashContext, // CRYPT_CONTEXT
							int extraData // CRYPT_CERTIFICATE
							) throws CryptException;
	public static int CreateSignatureEx(
							java.nio.ByteBuffer signature,
							int formatType, // CRYPT_FORMAT_TYPE
							int signContext, // CRYPT_CONTEXT
							int hashContext, // CRYPT_CONTEXT
							int extraData // CRYPT_CERTIFICATE
							) throws CryptException { return CreateSignatureEx(signature, 0, formatType, signContext, hashContext, extraData); }
	public static int CreateSignatureEx(
							byte[] signature,
							int formatType, // CRYPT_FORMAT_TYPE
							int signContext, // CRYPT_CONTEXT
							int hashContext, // CRYPT_CONTEXT
							int extraData // CRYPT_CERTIFICATE
							) throws CryptException { return CreateSignatureEx(signature, 0, formatType, signContext, hashContext, extraData); }
	
	public static native void CheckSignature(
							java.nio.ByteBuffer signature,
							int signatureOffset,
							int sigCheckKey, // CRYPT_HANDLE
							int hashContext // CRYPT_CONTEXT
							) throws CryptException;
	public static native void CheckSignature(
							byte[] signature,
							int signatureOffset,
							int sigCheckKey, // CRYPT_HANDLE
							int hashContext // CRYPT_CONTEXT
							) throws CryptException;
	public static void CheckSignature(
							java.nio.ByteBuffer signature,
							int sigCheckKey, // CRYPT_HANDLE
							int hashContext // CRYPT_CONTEXT
							) throws CryptException { CheckSignature(signature, 0, sigCheckKey, hashContext); }
	public static void CheckSignature(
							byte[] signature,
							int sigCheckKey, // CRYPT_HANDLE
							int hashContext // CRYPT_CONTEXT
							) throws CryptException { CheckSignature(signature, 0, sigCheckKey, hashContext); }
	
	public static native int CheckSignatureEx(
							java.nio.ByteBuffer signature,
							int signatureOffset,
							int sigCheckKey, // CRYPT_HANDLE
							int hashContext // CRYPT_CONTEXT
							) throws CryptException;
	public static native int CheckSignatureEx(
							byte[] signature,
							int signatureOffset,
							int sigCheckKey, // CRYPT_HANDLE
							int hashContext // CRYPT_CONTEXT
							) throws CryptException;
	public static int CheckSignatureEx(
							java.nio.ByteBuffer signature,
							int sigCheckKey, // CRYPT_HANDLE
							int hashContext // CRYPT_CONTEXT
							) throws CryptException { return CheckSignatureEx(signature, 0, sigCheckKey, hashContext); }
	public static int CheckSignatureEx(
							byte[] signature,
							int sigCheckKey, // CRYPT_HANDLE
							int hashContext // CRYPT_CONTEXT
							) throws CryptException { return CheckSignatureEx(signature, 0, sigCheckKey, hashContext); }
	
	/****************************************************************************
	*																			*
	*									Keyset Functions						*
	*																			*
	****************************************************************************/
	
	/* Open and close a keyset */
	
	public static native int KeysetOpen(
							int cryptUser, // CRYPT_USER
							int keysetType, // CRYPT_KEYSET_TYPE
							String name,
							int options // CRYPT_KEYOPT_TYPE
							) throws CryptException;
	
	public static native void KeysetClose(
							int keyset // CRYPT_KEYSET
							) throws CryptException;
	
	/* Get a key from a keyset */
	
	public static native int GetPublicKey(
							int keyset, // CRYPT_KEYSET
							int keyIDtype, // CRYPT_KEYID_TYPE
							String keyID
							) throws CryptException;
	
	public static native int GetPrivateKey(
							int keyset, // CRYPT_KEYSET
							int keyIDtype, // CRYPT_KEYID_TYPE
							String keyID,
							String password
							) throws CryptException;
	
	/* Add/delete a key to/from a keyset */
	
	public static native void AddPublicKey(
							int keyset, // CRYPT_KEYSET
							int certificate // CRYPT_CERTIFICATE
							) throws CryptException;
	
	public static native void AddPrivateKey(
							int keyset, // CRYPT_KEYSET
							int cryptKey, // CRYPT_HANDLE
							String password
							) throws CryptException;
	
	public static native void DeleteKey(
							int keyset, // CRYPT_KEYSET
							int keyIDtype, // CRYPT_KEYID_TYPE
							String keyID
							) throws CryptException;
	
	/****************************************************************************
	*																			*
	*								Certificate Functions						*
	*																			*
	****************************************************************************/
	
	/* Create/destroy a certificate */
	
	public static native int CreateCert(
							int cryptUser, // CRYPT_USER
							int certType // CRYPT_CERTTYPE_TYPE
							) throws CryptException;
	
	public static native void DestroyCert(
							int certificate // CRYPT_CERTIFICATE
							) throws CryptException;
	
	/* Get/add/delete certificate extensions */
	
	public static native int GetCertExtension(
							int cryptHandle, // CRYPT_HANDLE
							String oid,
							java.nio.ByteBuffer extension,
							int extensionOffset
							) throws CryptException;
	public static native int GetCertExtension(
							int cryptHandle, // CRYPT_HANDLE
							String oid,
							byte[] extension,
							int extensionOffset
							) throws CryptException;
	public static int GetCertExtension(
							int cryptHandle, // CRYPT_HANDLE
							String oid,
							java.nio.ByteBuffer extension
							) throws CryptException { return GetCertExtension(cryptHandle, oid, extension, 0); }
	public static int GetCertExtension(
							int cryptHandle, // CRYPT_HANDLE
							String oid,
							byte[] extension
							) throws CryptException { return GetCertExtension(cryptHandle, oid, extension, 0); }
	
	public static native void AddCertExtension(
							int certificate, // CRYPT_CERTIFICATE
							String oid,
							int criticalFlag,
							java.nio.ByteBuffer extension,
							int extensionOffset,
							int extensionLength
							) throws CryptException;
	public static native void AddCertExtension(
							int certificate, // CRYPT_CERTIFICATE
							String oid,
							int criticalFlag,
							byte[] extension,
							int extensionOffset,
							int extensionLength
							) throws CryptException;
	public static void AddCertExtension(
							int certificate, // CRYPT_CERTIFICATE
							String oid,
							int criticalFlag,
							java.nio.ByteBuffer extension
							) throws CryptException { AddCertExtension(certificate, oid, criticalFlag, extension, 0, extension.capacity()); }
	public static void AddCertExtension(
							int certificate, // CRYPT_CERTIFICATE
							String oid,
							int criticalFlag,
							byte[] extension
							) throws CryptException { AddCertExtension(certificate, oid, criticalFlag, extension, 0, extension.length); }
	public static void AddCertExtension(
							int certificate, // CRYPT_CERTIFICATE
							String oid,
							int criticalFlag,
							String extension
							) throws CryptException { AddCertExtension(certificate, oid, criticalFlag, extension.getBytes(), 0, extension.length()); }
	
	public static native void DeleteCertExtension(
							int certificate, // CRYPT_CERTIFICATE
							String oid
							) throws CryptException;
	
	/* Sign/sig.check a certificate/certification request */
	
	public static native void SignCert(
							int certificate, // CRYPT_CERTIFICATE
							int signContext // CRYPT_CONTEXT
							) throws CryptException;
	
	public static native void CheckCert(
							int certificate, // CRYPT_CERTIFICATE
							int sigCheckKey // CRYPT_HANDLE
							) throws CryptException;
	
	/* Import/export a certificate/certification request */
	
	public static native int ImportCert(
							java.nio.ByteBuffer certObject,
							int certObjectOffset,
							int certObjectLength,
							int cryptUser // CRYPT_USER
							) throws CryptException;
	public static native int ImportCert(
							byte[] certObject,
							int certObjectOffset,
							int certObjectLength,
							int cryptUser // CRYPT_USER
							) throws CryptException;
	public static int ImportCert(
							java.nio.ByteBuffer certObject,
							int cryptUser // CRYPT_USER
							) throws CryptException { return ImportCert(certObject, 0, certObject.capacity(), cryptUser); }
	public static int ImportCert(
							byte[] certObject,
							int cryptUser // CRYPT_USER
							) throws CryptException { return ImportCert(certObject, 0, certObject.length, cryptUser); }
	public static int ImportCert(
							String certObject,
							int cryptUser // CRYPT_USER
							) throws CryptException { return ImportCert(certObject.getBytes(), 0, certObject.length(), cryptUser); }
	
	public static native int ExportCert(
							java.nio.ByteBuffer certObject,
							int certObjectOffset,
							int certFormatType, // CRYPT_CERTFORMAT_TYPE
							int certificate // CRYPT_CERTIFICATE
							) throws CryptException;
	public static native int ExportCert(
							byte[] certObject,
							int certObjectOffset,
							int certFormatType, // CRYPT_CERTFORMAT_TYPE
							int certificate // CRYPT_CERTIFICATE
							) throws CryptException;
	public static int ExportCert(
							java.nio.ByteBuffer certObject,
							int certFormatType, // CRYPT_CERTFORMAT_TYPE
							int certificate // CRYPT_CERTIFICATE
							) throws CryptException { return ExportCert(certObject, 0, certFormatType, certificate); }
	public static int ExportCert(
							byte[] certObject,
							int certFormatType, // CRYPT_CERTFORMAT_TYPE
							int certificate // CRYPT_CERTIFICATE
							) throws CryptException { return ExportCert(certObject, 0, certFormatType, certificate); }
	
	/* CA management functions */
	
	public static native void CAAddItem(
							int keyset, // CRYPT_KEYSET
							int certificate // CRYPT_CERTIFICATE
							) throws CryptException;
	
	public static native int CAGetItem(
							int keyset, // CRYPT_KEYSET
							int certType, // CRYPT_CERTTYPE_TYPE
							int keyIDtype, // CRYPT_KEYID_TYPE
							String keyID
							) throws CryptException;
	
	public static native void CADeleteItem(
							int keyset, // CRYPT_KEYSET
							int keyIDtype, // CRYPT_KEYID_TYPE
							String keyID
							) throws CryptException;
	
	public static native int CACertManagement(
							int action, // CRYPT_CERTACTION_TYPE
							int keyset, // CRYPT_KEYSET
							int caKey, // CRYPT_CONTEXT
							int certRequest // CRYPT_CERTIFICATE
							) throws CryptException;
	
	/****************************************************************************
	*																			*
	*							Envelope and Session Functions					*
	*																			*
	****************************************************************************/
	
	/* Create/destroy an envelope */
	
	public static native int CreateEnvelope(
							int cryptUser, // CRYPT_USER
							int formatType // CRYPT_FORMAT_TYPE
							) throws CryptException;
	
	public static native void DestroyEnvelope(
							int envelope // CRYPT_ENVELOPE
							) throws CryptException;
	
	/* Create/destroy a session */
	
	public static native int CreateSession(
							int cryptUser, // CRYPT_USER
							int formatType // CRYPT_SESSION_TYPE
							) throws CryptException;
	
	public static native void DestroySession(
							int session // CRYPT_SESSION
							) throws CryptException;
	
	/* Add/remove data to/from and envelope or session */
	
	public static native int PushData(
							int envelope, // CRYPT_HANDLE
							java.nio.ByteBuffer buffer,
							int bufferOffset,
							int length
							) throws CryptException;
	public static native int PushData(
							int envelope, // CRYPT_HANDLE
							byte[] buffer,
							int bufferOffset,
							int length
							) throws CryptException;
	public static int PushData(
							int envelope, // CRYPT_HANDLE
							java.nio.ByteBuffer buffer
							) throws CryptException { return PushData(envelope, buffer, 0, buffer.capacity()); }
	public static int PushData(
							int envelope, // CRYPT_HANDLE
							byte[] buffer
							) throws CryptException { return PushData(envelope, buffer, 0, buffer.length); }
	public static int PushData(
							int envelope, // CRYPT_HANDLE
							String buffer
							) throws CryptException { return PushData(envelope, buffer.getBytes(), 0, buffer.length()); }
	
	public static native void FlushData(
							int envelope // CRYPT_HANDLE
							) throws CryptException;
	
	public static native int PopData(
							int envelope, // CRYPT_HANDLE
							java.nio.ByteBuffer buffer,
							int bufferOffset,
							int length
							) throws CryptException;
	public static native int PopData(
							int envelope, // CRYPT_HANDLE
							byte[] buffer,
							int bufferOffset,
							int length
							) throws CryptException;
	public static int PopData(
							int envelope, // CRYPT_HANDLE
							java.nio.ByteBuffer buffer,
							int length
							) throws CryptException { return PopData(envelope, buffer, 0, length); }
	public static int PopData(
							int envelope, // CRYPT_HANDLE
							byte[] buffer,
							int length
							) throws CryptException { return PopData(envelope, buffer, 0, length); }
	
	/****************************************************************************
	*																			*
	*								Device Functions							*
	*																			*
	****************************************************************************/
	
	/* Open and close a device */
	
	public static native int DeviceOpen(
							int cryptUser, // CRYPT_USER
							int deviceType, // CRYPT_DEVICE_TYPE
							String name
							) throws CryptException;
	
	public static native void DeviceClose(
							int device // CRYPT_DEVICE
							) throws CryptException;
	
	/* Query a devices capabilities */
	
	//CRYPTLIBCONVERTER - NOT SUPPORTED (BECAUSE IT USES A STRUCT):
	//C_RET cryptDeviceQueryCapability( C_IN CRYPT_DEVICE device,
	//								  C_IN CRYPT_ALGO_TYPE cryptAlgo,
	//								  C_OUT CRYPT_QUERY_INFO C_PTR cryptQueryInfo );
	
	/* Create an encryption context via the device */
	
	public static native int DeviceCreateContext(
							int device, // CRYPT_DEVICE
							int cryptAlgo // CRYPT_ALGO_TYPE
							) throws CryptException;
	
	/* Peform a control function on the device.  This is a kludge extension to
	   cryptSetAttributeString() which will be replaced by that function once
	   a clean means of passing two sets of parameters is found */
	
	public static native void DeviceControlEx(
							int device, // CRYPT_DEVICE
							int controlType, // CRYPT_ATTRIBUTE_TYPE
							java.nio.ByteBuffer data1,
							int data1Offset,
							int data1Length,
							java.nio.ByteBuffer data2,
							int data2Offset,
							int data2Length
							) throws CryptException;
	public static native void DeviceControlEx(
							int device, // CRYPT_DEVICE
							int controlType, // CRYPT_ATTRIBUTE_TYPE
							byte[] data1,
							int data1Offset,
							int data1Length,
							byte[] data2,
							int data2Offset,
							int data2Length
							) throws CryptException;
	public static void DeviceControlEx(
							int device, // CRYPT_DEVICE
							int controlType, // CRYPT_ATTRIBUTE_TYPE
							java.nio.ByteBuffer data1,
							java.nio.ByteBuffer data2
							) throws CryptException { DeviceControlEx(device, controlType, data1, 0, data1.capacity(), data2, 0, data2.capacity()); }
	public static void DeviceControlEx(
							int device, // CRYPT_DEVICE
							int controlType, // CRYPT_ATTRIBUTE_TYPE
							byte[] data1,
							byte[] data2
							) throws CryptException { DeviceControlEx(device, controlType, data1, 0, data1.length, data2, 0, data2.length); }
	public static void DeviceControlEx(
							int device, // CRYPT_DEVICE
							int controlType, // CRYPT_ATTRIBUTE_TYPE
							String data1,
							String data2
							) throws CryptException { DeviceControlEx(device, controlType, data1.getBytes(), 0, data1.length(), data2.getBytes(), 0, data2.length()); }
	
	/****************************************************************************
	*																			*
	*							User Management Functions						*
	*																			*
	****************************************************************************/
	
	/* Log on and off (create/destroy a user object) */
	
	public static native int Login(
							String name,
							String password
							) throws CryptException;
	
	public static native void Logout(
							int user // CRYPT_USER
							) throws CryptException;
	
	/****************************************************************************
	*																			*
	*							User Interface Functions						*
	*																			*
	****************************************************************************/
	
	/* User interface functions, only available under Win32 */
	
	
	
};