#if 1
#include "filters.h"
#include "files.h"
#include "base64.h"
#include "hex.h"
#include "osrng.h"
#include "hrtimer.h"
#include "zdeflate.h"
#include "rsa.h"
#include "validate.h"
#include "rsa.h"
#include "zlib.h"
#include <iostream>

#include "haval.h"
#include "panama.h"
#include "hmac.h"
#include "modes.h"
#include "aes.h"
#include "dsa.h"
#include "pssr.h"
#include "panama.h"
#include "wake.h"

USING_NAMESPACE(CryptoPP)
USING_NAMESPACE(std)

template <class KEYS>
class ReverseTrapdoorFunctionPublic : public KEYS::PublicKey, public TrapdoorFunctionInverse, public PrivateKey
{
public:
	Integer CalculateInverse (RandomNumberGenerator &rng, const Integer &x) const {return this->ApplyRandomizedFunction(rng, x);}
};

template <class KEYS>
class ReverseTrapdoorFunctionPrivate : public KEYS::PrivateKey
{
public:
	Integer ApplyRandomizedFunction (RandomNumberGenerator &rng, const Integer &x) const {return this->CalculateInverse(rng, x);}
	void operator=(const ReverseTrapdoorFunctionPublic<KEYS> &) {throw NotImplemented("ReverseTrapdoorFunctionPrivate: cannot convert a public key to a private key");}
};

template <class KEYS>
struct ReverseKeys
{
	static std::string StaticAlgorithmName() {return std::string("Reverse") + KEYS::StaticAlgorithmName();}
	typedef ReverseTrapdoorFunctionPrivate<KEYS> PublicKey;
	typedef ReverseTrapdoorFunctionPublic<KEYS> PrivateKey;
};

template <class STANDARD>
struct ReverseRSAES : public TF_ES<STANDARD, ReverseKeys<RSA> >
{
};

template <unsigned int L>
class TransparentHash : public HashTransformation
{
public:
	enum {DIGESTSIZE = L};

	static std::string CRYPTOPP_API StaticAlgorithmName() {return "TransparentHash";}

	void Update(const byte *input, unsigned int length)
	{
		if (m_hash.size() + length > L)
			throw HashInputTooLong("TransparentHash");
		m_hash.append((const char *)input, length);
	}

	unsigned int DigestSize() const
		{return L;}

	void TruncatedFinal(byte *digest, unsigned int digestSize)
	{
		m_hash.copy((char *)digest, digestSize);
	}

protected:
	std::string m_hash;
};

template<> const byte PKCS_DigestDecoration<TransparentHash<16> >::decoration[] = {0};
template<> const unsigned int PKCS_DigestDecoration<TransparentHash<16> >::length = 0;


int MyAdhocTest(int argc, char *argv[])
{
		RSASS_ISO<SHA>::Signer signer(GlobalRNG(), 1024);
		signer.AccessPrivateKey().Save(HexEncoder(new FileSink(cout)).Ref());
		cout << endl << endl;
		StringSource("test", true, new SignerFilter(GlobalRNG(), signer, new HexEncoder(new FileSink(cout))));

	/*
        try
        {
			string a = "305C300D 06092A86 4886F70D 01010105 00034B00 30480241 00C9303D D58D4EE0"
"12445584 3EB615F8 5CF79695 A2C3DC56 0249683D E63FF490 4CF4FAB0 5F3F109E"
"6BFAA619 A3BBA368 E745BC58 015EEF04 639D7CB2 930BFCEE 11020301 0001";

			string signature = "133BAE7964AF3E65377DFDB2F9DB7078DED219D8C56020333134EBF5689CF729D9E7C296F88ABF2F48322B68AF7588F3669F7644B84C5B4BF5F5419B97AFF60C";
			string digest = "9E D7 8A 52 29 9A 84 5A 00 51 A5 69 D7 FA 3D C7";

			std::string timeSeed;
                timeSeed = IntToString(time(NULL));
                const char* seed = timeSeed.c_str();

                RandomPool randPool;
                randPool.Put((byte *)seed, strlen(seed));

                cout << "Using seed: " << seed << endl << endl;
        //      GlobalRNG().Put((const byte *)seed, strlen(seed));

                StringSource pubFile(a, true, new HexDecoder);
				RSA::PublicKey pub;
                pub.BERDecode(pubFile);

                RSASS<PKCS1v15, TransparentHash<16> >::Verifier v(pub);
				HexDecoder f(new SignatureVerificationFilter(v));
				f.Put((byte *)signature.data(), signature.size());
				f.Put((byte *)digest.data(), digest.size());
				f.MessageEnd();

				byte verified;
				f.Get(verified);
				cout << "Verified: " << (int)verified << endl;

				FileSource privFile(argv[2], true, new HexDecoder);
                RSA::PrivateKey priv;
                priv.BERDecode(privFile);
                RSASS<PKCS1v15, TransparentHash<16> >::Signer s(priv);

				byte sig[1024];
				s.SignMessage(GlobalRNG(), (byte *)digest.data(), 16, sig);
        }
        catch(CryptoPP::Exception &e)
        {
                cout << "\nCryptoPP::Exception caught: " << e.what() << endl;
                return -1;
        }
*/
/*
	ReverseTrapdoorFunctionPrivate<RSA> priv;
	priv.Initialize(GlobalRNG(), 512);
	ReverseTrapdoorFunctionPublic<RSA> pub;
	pub.AssignFrom(priv);
	ReverseRSAES<PKCS1v15>::Encryptor e(priv);
	ReverseRSAES<PKCS1v15>::Decryptor d(pub);

	SecByteBlock ciphertext(e.FixedCiphertextLength()), plaintext(e.FixedMaxPlaintextLength());
	e.Encrypt(GlobalRNG(), (byte *)"test", 4, ciphertext);
	d.Decrypt(GlobalRNG(), ciphertext, ciphertext.size(), plaintext);
*/
	/*
	AutoSeededRandomPool rng;
	WAKE_CFB<>::Encryption encoder;
	SecByteBlock sbbKey(encoder.DefaultKeyLength());
	rng.GenerateBlock(sbbKey.begin(), sbbKey.size());
	encoder.SetKey(sbbKey, sbbKey.size());
	std::string a;
	StringSource("sample.txt", true, new StreamTransformationFilter(encoder, 
new StringSink(a)));
*/

/*
	PanamaMAC<> t;

	FileSource f("rsa1024.dat", true, new HexDecoder);
	RSASS<PSSR, SHA>::Signer signer(f);
	RSASS<PSSR, SHA>::Verifier verifier(signer);

	// sign
	byte message[] = "test";
	unsigned int messageLen = sizeof(message);
	SecByteBlock signature(signer.MaxSignatureLength(messageLen));
	AutoSeededRandomPool rng;
	unsigned int signatureLen = signer.SignMessageWithRecovery(rng, message, messageLen, NULL, 0, signature);

	// verify and recover
	SecByteBlock recovered(verifier.MaxRecoverableLengthFromSignatureLength(signatureLen));
	DecodingResult result = verifier.RecoverMessage(recovered, NULL, 0, signature, signatureLen);
//	if (!result.isValidCoding)
//		throw InvalidSignature();
	unsigned int recoveredLen = result.messageLength;
*/
	/*
    AutoSeededRandomPool rng;
    unsigned char m_Key[DES::DEFAULT_KEYLENGTH];
    unsigned char m_iv[DES::BLOCKSIZE];
    rng.GenerateBlock(m_Key,sizeof(m_Key));
    rng.GenerateBlock(m_iv,sizeof(m_iv));

    std::string EncryptionBuffer;
    ECB_Mode<DES>::Encryption 
ChiperEncrypt(m_Key,DES::DEFAULT_KEYLENGTH,m_iv);
    StreamTransformationFilter STFilterEncrypt(ChiperEncrypt,new 
StringSink(EncryptionBuffer));
   
    unsigned char plaintext[] = "test bla bla bla";

    STFilterEncrypt.Put(plaintext,sizeof(plaintext));
    STFilterEncrypt.MessageEnd();

    //well it should exit here without problems I guess ...  :)
    return 0;
	*/
/*
	FileSource f(argv[2], true);
	ByteQueue q, q2;
	f.CopyTo(q);
	InvertibleRSAFunction r;
	r.BERDecode(f);
	r.DEREncode(q2);
	assert(q==q2);
*/
#if 0
	byte key[32];
	CBC_Mode<AES >::Encryption cfbEncryption(key, 32, key);
	return 0;

	FileSource(argv[2], true, new ZlibDecompressor(new FileSink(argv[3])));

	{HashTransformation* hash = new HMAC<HAVAL5>;}
	{HashTransformation* hash = new HMAC<PanamaHash<LittleEndian> >;}
#endif

#if 0
	InvertibleRSAFunction rsa;
	rsa.Initialize(GlobalRNG(), 512);

/*    RSAES_PKCS1v15_Decryptor RsaPrv;
	ByteQueue bqRsaPrv;
    RsaPrv.AccessKey().BERDecodeKey(bqRsaPrv);
*/
	Timer t(Timer::MILLISECONDS);
/*	t.StartTimer();
	FileSource(argv[2], true, new Deflator(new BitBucket, 6, Deflator::DEFAULT_LOG2_WINDOW_SIZE, false));
	cout << t.ElapsedTime() << endl;
*/
	t.StartTimer();
	FileSource f1(argv[2], true, new Deflator(new BitBucket, 6, Deflator::DEFAULT_LOG2_WINDOW_SIZE, true));
	cout << t.ElapsedTime() << endl;

	t.StartTimer();
	FileSource f2(argv[2], true, new Deflator(new BitBucket, 1, Deflator::DEFAULT_LOG2_WINDOW_SIZE, false));
	cout << t.ElapsedTime() << endl;

	t.StartTimer();
	FileSource f3(argv[2], true, new Deflator(new BitBucket, 0, Deflator::DEFAULT_LOG2_WINDOW_SIZE, false));
	cout << t.ElapsedTime() << endl;
#endif

	return 0;
}

extern int (*AdhocTest)(int argc, char *argv[]);
static int s_i = (AdhocTest = &MyAdhocTest, 0);
#endif
