/*
 * Decompiled with CFR 0.152.
 */
package test.hash;

import gnu.crypto.hash.IMessageDigest;
import gnu.crypto.hash.MD5;
import gnu.crypto.util.Util;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestOfMD5
extends TestCase {
    static /* synthetic */ Class class$test$hash$TestOfMD5;

    public TestOfMD5(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestOfMD5.suite());
    }

    public static Test suite() {
        return new TestSuite(class$test$hash$TestOfMD5 == null ? (class$test$hash$TestOfMD5 = TestOfMD5.class$("test.hash.TestOfMD5")) : class$test$hash$TestOfMD5);
    }

    public void testSelfTest() {
        try {
            MD5 algorithm = new MD5();
            Assert.assertTrue((String)"selfTest()", (boolean)algorithm.selfTest());
        }
        catch (Exception x) {
            Assert.fail((String)("selfTest(): " + String.valueOf(x)));
        }
    }

    public void testA() {
        try {
            MD5 algorithm = new MD5();
            algorithm.update("a".getBytes(), 0, 1);
            byte[] md = algorithm.digest();
            String exp = "0CC175B9C0F1B6A831C399E269772661";
            Assert.assertTrue((String)"testA()", (boolean)exp.equals(Util.toString((byte[])md)));
        }
        catch (Exception x) {
            Assert.fail((String)("testA(): " + String.valueOf(x)));
        }
    }

    public void testABC() {
        try {
            MD5 algorithm = new MD5();
            algorithm.update("abc".getBytes(), 0, 3);
            byte[] md = algorithm.digest();
            String exp = "900150983CD24FB0D6963F7D28E17F72";
            Assert.assertTrue((String)"testABC()", (boolean)exp.equals(Util.toString((byte[])md)));
        }
        catch (Exception x) {
            Assert.fail((String)("testABC(): " + String.valueOf(x)));
        }
    }

    public void testMessageDigest() {
        try {
            MD5 algorithm = new MD5();
            algorithm.update("message digest".getBytes(), 0, 14);
            byte[] md = algorithm.digest();
            String exp = "F96B697D7CB7938D525A2F31AAF161D0";
            Assert.assertTrue((String)"testMessageDigest()", (boolean)exp.equals(Util.toString((byte[])md)));
        }
        catch (Exception x) {
            Assert.fail((String)("testMessageDigest(): " + String.valueOf(x)));
        }
    }

    public void testAlphabet() {
        try {
            MD5 algorithm = new MD5();
            algorithm.update("abcdefghijklmnopqrstuvwxyz".getBytes(), 0, 26);
            byte[] md = algorithm.digest();
            String exp = "C3FCD3D76192E4007DFB496CCA67E13B";
            Assert.assertTrue((String)"testAlphabet()", (boolean)exp.equals(Util.toString((byte[])md)));
        }
        catch (Exception x) {
            Assert.fail((String)("testAlphabet(): " + String.valueOf(x)));
        }
    }

    public void testAsciiSubset() {
        try {
            MD5 algorithm = new MD5();
            algorithm.update("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".getBytes(), 0, 62);
            byte[] md = algorithm.digest();
            String exp = "D174AB98D277D9F5A5611C2C9F419D9F";
            Assert.assertTrue((String)"testAsciiSubset()", (boolean)exp.equals(Util.toString((byte[])md)));
        }
        catch (Exception x) {
            Assert.fail((String)("testAsciiSubset(): " + String.valueOf(x)));
        }
    }

    public void testEightyNumerics() {
        try {
            MD5 algorithm = new MD5();
            algorithm.update("12345678901234567890123456789012345678901234567890123456789012345678901234567890".getBytes(), 0, 80);
            byte[] md = algorithm.digest();
            String exp = "57EDF4A22BE3C955AC49DA2E2107B67A";
            Assert.assertTrue((String)"testEightyNumerics()", (boolean)exp.equals(Util.toString((byte[])md)));
        }
        catch (Exception x) {
            Assert.fail((String)("testEightyNumerics(): " + String.valueOf(x)));
        }
    }

    public void testCloning() {
        try {
            MD5 algorithm = new MD5();
            algorithm.update("a".getBytes(), 0, 1);
            IMessageDigest clone = (IMessageDigest)algorithm.clone();
            byte[] md = algorithm.digest();
            String exp = "0CC175B9C0F1B6A831C399E269772661";
            Assert.assertTrue((String)"testCloning()", (boolean)exp.equals(Util.toString((byte[])md)));
            clone.update("bc".getBytes(), 0, 2);
            md = clone.digest();
            exp = "900150983CD24FB0D6963F7D28E17F72";
            Assert.assertTrue((String)"testABC()", (boolean)exp.equals(Util.toString((byte[])md)));
        }
        catch (Exception x) {
            Assert.fail((String)("testCloning(): " + String.valueOf(x)));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

