/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.gnu.crypto.cipher;

import gnu.crypto.cipher.IBlockCipher;
import gnu.crypto.util.Util;
import gnu.testlet.Testlet;
import java.util.HashMap;

public abstract class BaseCipherTestCase
implements Testlet {
    protected static final int BIG_ENDIAN = 0;
    protected static final int LITTLE_ENDIAN = 1;
    protected IBlockCipher cipher;
    protected int endianness;

    public BaseCipherTestCase() {
        this(0);
    }

    public BaseCipherTestCase(int endianness) {
        this.endianness = endianness;
    }

    private static void shiftRight1(byte[] kb) {
        int i = 0;
        while (kb[i] == 0 && i < kb.length) {
            ++i;
        }
        kb[i] = (byte)((kb[i] & 0xFF) >>> 1);
        if (kb[i] == 0 && ++i < kb.length) {
            kb[i] = -128;
        }
    }

    private static void revShiftRight1(byte[] kb) {
        int i = kb.length - 1;
        while (kb[i] == 0 && i >= 0) {
            --i;
        }
        kb[i] = (byte)((kb[i] & 0xFF) >>> 1);
        if (kb[i] == 0 && --i >= 0) {
            kb[i] = -128;
        }
    }

    protected boolean katVK(String[] answers, IBlockCipher cipher, int ks) throws Exception {
        HashMap<String, byte[]> attrib = new HashMap<String, byte[]>();
        byte[] pt = new byte[cipher.currentBlockSize()];
        byte[] ct = new byte[cipher.currentBlockSize()];
        byte[] kb = new byte[ks];
        if (this.endianness == 0) {
            kb[0] = -128;
        } else {
            kb[ks - 1] = -128;
        }
        attrib.put("gnu.crypto.cipher.key.material", kb);
        int i = 0;
        while (i < answers.length) {
            cipher.reset();
            cipher.init(attrib);
            cipher.encryptBlock(pt, 0, ct, 0);
            if (this.endianness == 0) {
                if (!answers[i].equals(Util.toString((byte[])ct))) {
                    return false;
                }
                BaseCipherTestCase.shiftRight1(kb);
            } else {
                if (!answers[i].equals(Util.toReversedString((byte[])ct))) {
                    return false;
                }
                BaseCipherTestCase.revShiftRight1(kb);
            }
            ++i;
        }
        return true;
    }

    protected boolean katVT(String[] answers, IBlockCipher cipher, int ks) throws Exception {
        HashMap<String, byte[]> attrib = new HashMap<String, byte[]>();
        byte[] pt = new byte[cipher.currentBlockSize()];
        byte[] ct = new byte[cipher.currentBlockSize()];
        byte[] kb = new byte[ks];
        if (this.endianness == 0) {
            pt[0] = -128;
        } else {
            pt[pt.length - 1] = -128;
        }
        attrib.put("gnu.crypto.cipher.key.material", kb);
        cipher.reset();
        cipher.init(attrib);
        int i = 0;
        while (i < answers.length) {
            cipher.encryptBlock(pt, 0, ct, 0);
            if (this.endianness == 0) {
                if (!answers[i].equals(Util.toString((byte[])ct))) {
                    return false;
                }
                BaseCipherTestCase.shiftRight1(pt);
            } else {
                if (!answers[i].equals(Util.toReversedString((byte[])ct))) {
                    return false;
                }
                BaseCipherTestCase.revShiftRight1(pt);
            }
            ++i;
        }
        return true;
    }

    protected boolean mctEncryptECB(String[] answers, IBlockCipher cipher, int ks) throws Exception {
        HashMap<String, byte[]> attrib = new HashMap<String, byte[]>();
        byte[] kb = new byte[ks];
        byte[] pt = new byte[cipher.currentBlockSize()];
        byte[] ct = new byte[cipher.currentBlockSize()];
        byte[] lct = new byte[cipher.currentBlockSize()];
        int off = ks - cipher.currentBlockSize();
        attrib.put("gnu.crypto.cipher.key.material", kb);
        int i = 0;
        while (i < answers.length) {
            cipher.reset();
            cipher.init(attrib);
            int j = 0;
            while (j < 10000) {
                if (j == 9999) {
                    System.arraycopy(ct, 0, lct, 0, ct.length);
                }
                cipher.encryptBlock(pt, 0, ct, 0);
                System.arraycopy(ct, 0, pt, 0, ct.length);
                ++j;
            }
            if (this.endianness == 0 ? !answers[i].equals(Util.toString((byte[])ct)) : !answers[i].equals(Util.toReversedString((byte[])ct))) {
                return false;
            }
            j = 0;
            while (j + (lct.length - off) < lct.length && j < off) {
                int n = j;
                kb[n] = (byte)(kb[n] ^ lct[j + (lct.length - off)]);
                ++j;
            }
            j = 0;
            while (j + off < kb.length && j < ct.length) {
                int n = j + off;
                kb[n] = (byte)(kb[n] ^ ct[j]);
                ++j;
            }
            ++i;
        }
        return true;
    }

    protected boolean mctDecryptECB(String[] answers, IBlockCipher cipher, int ks) throws Exception {
        HashMap<String, byte[]> attrib = new HashMap<String, byte[]>();
        byte[] kb = new byte[ks];
        byte[] pt = new byte[cipher.currentBlockSize()];
        byte[] ct = new byte[cipher.currentBlockSize()];
        byte[] lpt = new byte[cipher.currentBlockSize()];
        int off = ks - cipher.currentBlockSize();
        attrib.put("gnu.crypto.cipher.key.material", kb);
        int i = 0;
        while (i < answers.length) {
            cipher.reset();
            cipher.init(attrib);
            int j = 0;
            while (j < 10000) {
                if (j == 9999) {
                    System.arraycopy(pt, 0, lpt, 0, ct.length);
                }
                cipher.decryptBlock(ct, 0, pt, 0);
                System.arraycopy(pt, 0, ct, 0, ct.length);
                ++j;
            }
            if (this.endianness == 0 ? !answers[i].equals(Util.toString((byte[])pt)) : !answers[i].equals(Util.toReversedString((byte[])pt))) {
                return false;
            }
            j = 0;
            while (j + (lpt.length - off) < lpt.length && j < off) {
                int n = j;
                kb[n] = (byte)(kb[n] ^ lpt[j + (lpt.length - off)]);
                ++j;
            }
            j = 0;
            while (j + off < kb.length && j < pt.length) {
                int n = j + off;
                kb[n] = (byte)(kb[n] ^ pt[j]);
                ++j;
            }
            ++i;
        }
        return true;
    }

    protected boolean mctEncryptCBC(String[] answers, IBlockCipher cipher, int ks) throws Exception {
        HashMap<String, byte[]> attrib = new HashMap<String, byte[]>();
        byte[] kb = new byte[ks];
        byte[] pt = new byte[cipher.currentBlockSize()];
        byte[] ct = new byte[cipher.currentBlockSize()];
        byte[] lct = new byte[cipher.currentBlockSize()];
        byte[] iv = new byte[cipher.currentBlockSize()];
        int off = ks - cipher.currentBlockSize();
        attrib.put("gnu.crypto.cipher.key.material", kb);
        int i = 0;
        while (i < answers.length) {
            cipher.reset();
            cipher.init(attrib);
            int j = 0;
            while (j < 10000) {
                int k = 0;
                while (k < pt.length) {
                    int n = k;
                    pt[n] = (byte)(pt[n] ^ iv[k]);
                    ++k;
                }
                System.arraycopy(ct, 0, lct, 0, ct.length);
                cipher.encryptBlock(pt, 0, ct, 0);
                System.arraycopy(ct, 0, iv, 0, ct.length);
                System.arraycopy(lct, 0, pt, 0, lct.length);
                ++j;
            }
            if (this.endianness == 0 ? !answers[i].equals(Util.toString((byte[])ct)) : !answers[i].equals(Util.toReversedString((byte[])ct))) {
                return false;
            }
            j = 0;
            while (j + (lct.length - off) < lct.length && j < off) {
                int n = j;
                kb[n] = (byte)(kb[n] ^ lct[j + (lct.length - off)]);
                ++j;
            }
            j = 0;
            while (j + off < kb.length && j < ct.length) {
                int n = j + off;
                kb[n] = (byte)(kb[n] ^ ct[j]);
                ++j;
            }
            ++i;
        }
        return true;
    }

    protected boolean mctDecryptCBC(String[] answers, IBlockCipher cipher, int ks) throws Exception {
        HashMap<String, byte[]> attrib = new HashMap<String, byte[]>();
        byte[] kb = new byte[ks];
        byte[] pt = new byte[cipher.currentBlockSize()];
        byte[] ct = new byte[cipher.currentBlockSize()];
        byte[] lpt = new byte[cipher.currentBlockSize()];
        byte[] iv = new byte[cipher.currentBlockSize()];
        int off = ks - cipher.currentBlockSize();
        attrib.put("gnu.crypto.cipher.key.material", kb);
        int i = 0;
        while (i < answers.length) {
            cipher.reset();
            cipher.init(attrib);
            int j = 0;
            while (j < 10000) {
                if (j == 9999) {
                    System.arraycopy(pt, 0, lpt, 0, pt.length);
                }
                cipher.decryptBlock(ct, 0, pt, 0);
                int k = 0;
                while (k < pt.length) {
                    int n = k;
                    pt[n] = (byte)(pt[n] ^ iv[k]);
                    ++k;
                }
                System.arraycopy(ct, 0, iv, 0, ct.length);
                System.arraycopy(pt, 0, ct, 0, pt.length);
                ++j;
            }
            if (this.endianness == 0 ? !answers[i].equals(Util.toString((byte[])pt)) : !answers[i].equals(Util.toReversedString((byte[])pt))) {
                return false;
            }
            j = 0;
            while (j + (lpt.length - off) < lpt.length && j < off) {
                int n = j;
                kb[n] = (byte)(kb[n] ^ lpt[j + (lpt.length - off)]);
                ++j;
            }
            j = 0;
            while (j + off < kb.length && j < pt.length) {
                int n = j + off;
                kb[n] = (byte)(kb[n] ^ pt[j]);
                ++j;
            }
            ++i;
        }
        return true;
    }

    protected boolean validityTest() {
        return this.cipher.selfTest();
    }

    protected boolean cloneabilityTest() throws Exception {
        int blockSize = this.cipher.defaultBlockSize();
        int keySize = this.cipher.defaultKeySize();
        byte[] pt = new byte[blockSize];
        byte[] ct1 = new byte[blockSize];
        byte[] ct2 = new byte[blockSize];
        byte[] kb = new byte[keySize];
        HashMap<String, byte[]> attributes = new HashMap<String, byte[]>();
        attributes.put("gnu.crypto.cipher.key.material", kb);
        this.cipher.reset();
        this.cipher.init(attributes);
        this.cipher.encryptBlock(pt, 0, pt, 0);
        IBlockCipher thomas = (IBlockCipher)this.cipher.clone();
        thomas.init(attributes);
        this.cipher.encryptBlock(pt, 0, ct1, 0);
        thomas.encryptBlock(pt, 0, ct2, 0);
        return Util.areEqual((byte[])ct1, (byte[])ct2);
    }
}

