/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.keyring;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

final class MeteredInputStream
extends FilterInputStream {
    private int count;
    private final int limit;

    MeteredInputStream(InputStream in, int limit) {
        super(in);
        if (limit < 0) {
            throw new IllegalArgumentException("limit must be nonnegative");
        }
        this.limit = limit;
        this.count = 0;
    }

    public boolean limitReached() {
        return this.count == this.limit;
    }

    public int available() throws IOException {
        return Math.min(this.in.available(), this.limit - this.count);
    }

    public void close() throws IOException {
        this.in.close();
    }

    public void mark(int readLimit) {
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        if (this.limitReached()) {
            return -1;
        }
        int i = this.in.read();
        if (i != -1) {
            ++this.count;
        }
        return i;
    }

    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        if (this.limitReached()) {
            return -1;
        }
        int i = this.in.read(buf, off, Math.min(len, this.limit - this.count));
        if (i != -1) {
            this.count += i;
        }
        return i;
    }

    public void reset() throws IOException {
    }

    public long skip(long len) throws IOException {
        if (this.limitReached()) {
            return 0L;
        }
        len = Math.min(len, (long)(this.limit - this.count));
        len = this.in.skip(len);
        this.count += (int)len;
        return len;
    }
}

