(in-package "COMMON-LISP")

;;Not classified:
(defun values (&rest-vector x) (declare (external |Values1|)))

;; CHAPTER 5.  PROGRAM STRUCTURE

;; 2.  Functions
;; 2.2.  Lambda-Expressions
;;(defconstant lambda-list-keywords '(&required &optional &rest &aux &key))

;; CHAPTER 6.  PREDICATES

;; 1.  Logical Values
(defconstant t 't)

;; 3.  Equality Predicates

(defun eq (x y) (declare (external |LispEq|)))
(defun eql (x y) (declare (external |LispEql|)))
(defun equal (x y) (declare (external |LispEqual|)))
(defun equalp (x y) (declare (external |LispEqualp|)))

;; CHAPTER 7.  CONTROL STRUCTURE

;; 1.1.  Reference
(defun symbol-value (s) (declare (external |SymbolValue1|)))
(defun symbol-function (s) (declare (external |SymbolFunction1|)))
(defun boundp (s) (declare (external |Boundp|)))
(defun fboundp (s) (declare (external |FBoundp|)))

;; 1.2.  Assignment
(defun set (sym val) (declare (external |SetSymbol|)))
(defun makunbound (sym) (declare (external |MakeUnbound|)))
(defun fmakunbound (sym) (declare (external |FMakeUnbound|)))


;; CHAPTER 8.  MACROS

;; 1.  Macro Definitions
(defun macro-function (s &optional env) (declare (external |MacroFunction|)))


;; CHAPTER 10.  SYMBOLS

;; 1.  The Property List
(defun get (sym key &optional default) (declare (external |GetProp3|)))
(defun remprop (s k) (declare (external |RemProp|)))
(defun symbol-plist (arg) (declare (external |SymbolPlist|)))

;; 2. The Print Name

(defun symbol-name (arg) (declare (external |Symbol2String|)))

;; 3.  Creating Symbols
(defun make-symbol (arg) (declare (external |MakeSymbol|)))
(defun symbol-package (arg) (declare (external |SymbolPackage|))) 


;; CHAPTER 11.  PACKAGES

;; .7.  Package System Functions and Variable
(defun make-package (n &key :nicknames :use) (declare(external |MakePackage|)))
(defun find-package (p) (declare (external |FindPackage|)))
(defun package-name (p) (declare (external |PackageName|)))
(defun package-nicknames (p) (declare (external |PackageNicknames|)))
(defun rename-package (p n &optional m) (declare (external |RenamePackage|)))
(defun package-use-list (p) (declare (external |PackageUseList|)))
(defun package-used-by-list (p) (declare (external |PackageUsedByList|)))
(defun package-shadowing-symbols (p)
  (declare (external |PackageShadowingSymbols|)))
(defun list-all-packages () (declare (external |ListAllPackages|)))
(defun delete-package (p) (declare (external |DeletePackage|)))
(defun intern (x &optional y) (declare (external |DoIntern|)))
(defun find-symbol (x &optional y) (declare (external |DoFindSymbol|)))
(defun unintern (s &optional p) (declare (external |UnInternSymbol|)))
(defun export (s &optional p) (declare (external |ExportSymbol|)))
(defun unexport (s &optional p) (declare (external |UnExportSymbol|)))
(defun import (s &optional p) (declare (external |ImportSymbol|)))
(defun shadowing-import (s &optional p)
  (declare (external |ShadowingImportSymbol|)))
(defun shadow (s &optional p) (declare (external |ShadowSymbol|)))
(defun use-package (l &optional p) (declare (external |UsePackage|)))
(defun unuse-package (l &optional p) (declare (external |UnUsePackage|)))


;; CHAPTER 12.  NUMBERS

;; .2.  Predicates on Numbers (COMPLETE)
(defun zerop (number) (declare (external |ZeroP|)))
(defun plusp (number) (declare (external |PlusP|)))
(defun minusp (number) (declare (external |MinusP|)))
(defun oddp (number) (declare (external |OddP|)))
(defun evenp (number) (declare (external |EvenP|)))


;; .3.  Comparisons on Numbers

;; .4.  Arithmetic Operations
(defun + (&rest-vector args) (declare (external |LispPlus|)))
(defun - (arg1 &rest-vector args) (declare (external |LispMinus|)))
(defun * (&rest-vector args) (declare (external |LispTimes|)))
(defun / (arg1 &rest-vector args) (declare (external |LispDivide|)))
(defun 1- (arg) (declare (external |MinusOne1|)))

;; 7.  Logical Operations on Numbers
(defun boole (op int1 int2)
  (declare (external |BooleOp|) (integer op int1 int2)))
(defconstant boole-clr 0)
(defconstant boole-and 1)
(defconstant boole-andc2 2)
(defconstant boole-1 3)
(defconstant boole-andc1 4)
(defconstant boole-2 5)
(defconstant boole-xor 6)
(defconstant boole-ior 7)
(defconstant boole-nor 8)
(defconstant boole-eqv 9)
(defconstant boole-c2 10)
(defconstant boole-orc2 11)
(defconstant boole-c1 12)
(defconstant boole-orc1 13)
(defconstant boole-nand 14)
(defconstant boole-set 15)
(defun logand (&rest-vector args) (declare (external |LogAnd|)))
(defun logandc1 (arg1 arg2)
  (declare (external |LogAndC1|) (integer arg1 arg2)))
(defun logandc2 (arg1 arg2)
  (declare (external |LogAndC2|) (integer arg1 arg2)))
(defun logbitp (arg1 arg2)
  (declare (external |LogBitP|) (integer arg1 arg2)))
(defun logcount (arg1)
  (declare (external |LogCount|) (integer arg1)))
(defun logeqv (&rest-vector args) (declare (external |LogEqv|)))
(defun logior (&rest-vector args) (declare (external |LogIor|)))
(defun logorc1 (arg1 arg2)
  (declare (external |LogOrC1|) (integer arg1 arg2)))
(defun logorc2 (arg1 arg2)
  (declare (external |LogOrC2|) (integer arg1 arg2)))
(defun lognand (arg1 arg2)
  (declare (external |LogNand|) (integer arg1 arg2)))
(defun lognor (arg1 arg2)
  (declare (external |LogNor|) (integer arg1 arg2)))
(defun lognot (arg1)
  (declare (external |LogNot|) (integer arg1)))
(defun logtest (arg1 arg2)
  (declare (external |LogTest|) (integer arg1 arg2)))
(defun logxor (&rest-vector args) (declare (external |LogXor|)))
(defun ash (arg1 arg2)
  (declare (external |DoShift|) (integer arg1 arg2)))
(defun integer-length (arg1)
  (declare (external |IntegerLength|)  (integer arg1)))

;; 8.  Byte Manipulation Functions
(defun byte (size position)
  (declare (external |DoByteOp|) (integer size position)))
(defun byte-size (byte-spec) (declare (external |ByteSpecSize|)))
(defun byte-position (byte-spec) (declare (external |ByteSpecPosition|)))
(defun ldb (byte-spec i)
  (declare (external |LoadByte|) (integer i)))
(defun ldb-test (byte-spec i)
  (declare (external |LoadByteTest|) (integer i)))
(defun mask-field (byte-spec i)
  (declare (external |MaskField|) (integer i)))
(defun dpb (new-byte byte-spec i)
  (declare (external |DepositByte|) (integer new-byte i)))
(defun deposit-field (new-byte byte-spec i)
  (declare (external |DepositField|) (integer new-byte i)))

;; CHAPTER 14.  SEQUENCES

;; 14.3.  Modifying Sequences
(defun replace (seq1 seq2 &key start1 end1 start2 end2)
  (declare (external |ReplaceSequence|)))

;; CHAPTER 15.  LISTS

;; 15.2.  Conses
(defun car (a) (declare (external |DoCar|)))
(defun cdr (a) (declare (external |DoCdr|)))
;;(defun caar (x) (car (car x)))
(defun cons (a d) (declare (external |Cons2|)))

;; 15.2.  Lists
(defun list (&rest x) x)

;; CHAPTER 17.  ARRAYS

;; 17.1.  Array Creation
(defun make-array (d &key initial-element initial-contents adjustable
			fill-pointer displaced-to displaced-index-offset)
  (declare (external |MakeArray|)))

;; 17.6.  Changing the Dimensions of an Array
(defun adjust-array (array d &key initial-element initial-contents
			fill-pointer displaced-to displaced-index-offset)
  (declare (external |AdjustArray|)))

;; CHAPTER 20.  THE EVALUATOR

;; 20.1.  Run-Time Evaluation of Forms
(defun eval (form) (declare (external |LispEval|)))

;; CHAPTER 22.  INPUT/OUTPUT

;; 22.3.1.  Output to Character Streams
(defun finish-output (&optional stream) (declare (external |DoFlush|)))
(defun force-output (&optional stream) (declare (external |DoFlush|)))

;; 22.3.3.  Formatted Output to Character Streams
(defun format (d f &rest-vector a) (declare (external |LispFormatOp|)))

;; CHAPTER 23.  FILE SYSTEM INTERFACE

;; 23.4.  Loading Files
(defun load (n) (declare (external |LispLoad|)))

;; CHAPTER 25.  MISCELLANEOUS FUNCTIONS

;; 1.  The Compiler
(defun compile-file (path) (declare (external |LispCompileFile|)))
