// class cl_ht_from_integer_to_rcpointer.

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_I_hash_rcpointer.h"


// Implementation.

#include "cl_I.h"
#include "cl_hash1.h"

static void cl_hashtable_from_integer_to_rcpointer_destructor (cl_heap* pointer)
{
#if (defined(__mips__) || defined(__mips64__)) && !defined(__GNUC__) // workaround SGI CC bug
	(*(cl_heap_hashtable_from_integer_to_rcpointer*)pointer).~cl_heap_hashtable_1();
#else
	(*(cl_heap_hashtable_from_integer_to_rcpointer*)pointer).~cl_heap_hashtable_from_integer_to_rcpointer();
#endif
}

cl_class cl_class_hashtable_from_integer_to_rcpointer = {
	cl_hashtable_from_integer_to_rcpointer_destructor,
	0
};

// These are not inline, because they tend to duplicate a lot of template code.

cl_ht_from_integer_to_rcpointer::cl_ht_from_integer_to_rcpointer ()
{
	var cl_heap_hashtable_from_integer_to_rcpointer* ht = new cl_heap_hashtable_from_integer_to_rcpointer ();
	ht->refcount = 1;
	ht->type = &cl_class_hashtable_from_integer_to_rcpointer;
	pointer = ht;
}

cl_rcpointer * cl_ht_from_integer_to_rcpointer::get (const cl_I& x) const
{
	return ((cl_heap_hashtable_from_integer_to_rcpointer*)pointer)->get(x);
}

void cl_ht_from_integer_to_rcpointer::put (const cl_I& x, const cl_rcpointer& y) const
{
	((cl_heap_hashtable_from_integer_to_rcpointer*)pointer)->put(x,y);
}

