// div2adic().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_2DS.h"


// Implementation.

#include "cl_2D.h"
#include "cl_DS.h"

extern void div2adic (uintC len, const uintD* a_LSDptr, const uintD* b_LSDptr, uintD* dest_LSDptr)
{
      var uintD b0inv = div2adic(1,b_LSDptr[-1]); // b'
      copy_loop_down(a_LSDptr,dest_LSDptr,len); // d := a
      do { var uintD digit = dest_LSDptr[-1]; // nchstes d[j]
           digit = mul2adic(b0inv,digit);
           // digit = nchstes c[j]
           mulusub_loop_down(digit,b_LSDptr,dest_LSDptr,len); // d := d - b * c[j] * beta^j
           // Nun ist dest_LSDptr[-1] = 0.
           *--dest_LSDptr = digit; len--; // c[j] ablegen, nchstes j
         }
         until (len==0);
}
