// binary operator *

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_dfloat.h"


// Implementation.

#include "cl_DF.h"
#include "cl_F.h"
#include "cl_low.h"
#include "cl_DS.h"
#include "cl_ieee.h"
NEED_IEEE_FLOATS()

#undef MAYBE_INLINE
#define MAYBE_INLINE inline
#include "cl_DF_zerop.cc"

cl_DF operator* (const cl_DF& x1, const cl_DF& x2)
{
// Methode:
// Falls x1=0.0 oder x2=0.0 -> Ergebnis 0.0
// Sonst: Ergebnis-Vorzeichen = VZ von x1 xor VZ von x2.
//        Ergebnis-Exponent = Summe der Exponenten von x1 und x2.
//        Ergebnis-Mantisse = Produkt der Mantissen von x1 und x2, gerundet:
//          2^-53 * mant1  *  2^-53 * mant2  =  2^-106 * (mant1*mant2),
//          die Klammer ist >=2^104, <=(2^53-1)^2<2^106 .
//          Falls die Klammer >=2^105 ist, um 53 Bit nach rechts schieben und
//            runden: Falls Bit 52 Null, abrunden; falls Bit 52 Eins und
//            Bits 51..0 alle Null, round-to-even; sonst aufrunden.
//          Falls die Klammer <2^105 ist, um 52 Bit nach rechts schieben und
//            runden: Falls Bit 51 Null, abrunden; falls Bit 51 Eins und
//            Bits 50..0 alle Null, round-to-even; sonst aufrunden. Nach
//            Aufrunden: Falls =2^53, um 1 Bit nach rechts schieben. Sonst
//            Exponenten um 1 erniedrigen.
#ifdef FAST_DOUBLE
      double_to_DF(DF_to_double(x1) * DF_to_double(x2), return ,
                   TRUE, TRUE, // Overflow und subnormale Zahl abfangen
                   !(zerop(x1) || zerop(x2)), // ein Ergebnis +/- 0.0
                               // ist genau dann in Wirklichkeit ein Underflow
                   FALSE, FALSE // keine Singularitt, kein NaN als Ergebnis mglich
                  );
#else
      // x1,x2 entpacken:
      var cl_signean sign1;
      var sintL exp1;
      var uintL manthi1;
      var uintL mantlo1;
      var cl_signean sign2;
      var sintL exp2;
      var uintL manthi2;
      var uintL mantlo2;
      #if (cl_word_size==64)
      { var uint64 mant1;
        DF_decode(x1, { return x1; }, sign1=,exp1=,mant1=);
        manthi1 = (uint32)(mant1>>32); mantlo1 = (uint32)mant1;
      }
      { var uint64 mant2;
        DF_decode(x2, { return x2; }, sign2=,exp2=,mant2=);
        manthi2 = (uint32)(mant2>>32); mantlo2 = (uint32)mant2;
      }
      #else
      DF_decode2(x1, { return x1; }, sign1=,exp1=,manthi1=,mantlo1=);
      DF_decode2(x2, { return x2; }, sign2=,exp2=,manthi2=,mantlo2=);
      #endif
      exp1 = exp1 + exp2; // Summe der Exponenten
      sign1 = sign1 ^ sign2; // Ergebnis-Vorzeichen
      // Mantissen mant1 und mant2 multiplizieren (64x64-Bit-Multiplikation):
      var uintD mant1 [64/intDsize];
      var uintD mant2 [64/intDsize];
      var uintD mant [128/intDsize];
      #if (intDsize==32) || (intDsize==16) || (intDsize==8)
      set_32_Dptr(mant1,manthi1); set_32_Dptr(&mant1[32/intDsize],mantlo1);
      set_32_Dptr(mant2,manthi2); set_32_Dptr(&mant2[32/intDsize],mantlo2);
      #else
      {var uintD* ptr;
       ptr = &mant1[64/intDsize];
       doconsttimes(32/intDsize, { *--ptr = (uintD)mantlo1; mantlo1 = mantlo1>>intDsize; } );
       doconsttimes(32/intDsize, { *--ptr = (uintD)manthi1; manthi1 = manthi1>>intDsize; } );
      }
      {var uintD* ptr;
       ptr = &mant2[64/intDsize];
       doconsttimes(32/intDsize, { *--ptr = (uintD)mantlo2; mantlo2 = mantlo2>>intDsize; } );
       doconsttimes(32/intDsize, { *--ptr = (uintD)manthi2; manthi2 = manthi2>>intDsize; } );
      }
      #endif
      cl_mulu_2loop_down(&mant1[64/intDsize],64/intDsize,
                         &mant2[64/intDsize],64/intDsize,
                         &mant[128/intDsize]
                        );
      {
        #if (cl_word_size==64)
        var uint64 manterg;
        #else
        var uintL manthi;
        var uintL mantlo;
        #endif
        // Produkt mant = mant1 * mant2 ist >= 2^104, < 2^106. Bit 105 abtesten:
        #define mant_bit(k)  (mant[128/intDsize - 1 - floor(k,intDsize)] & bit((k)%intDsize))
        if (mant_bit(2*DF_mant_len+1))
          // mant>=2^(2*DF_mant_len+1), um DF_mant_len+1 Bits nach rechts schieben:
          { // Bits 105..53 holen:
            #if (cl_word_size==64) // && (intDsize==32)
              manterg = ((uint64)mant[0] << 43) | ((uint64)mant[1] << 11) | ((uint64)mant[2] >> 21); // Bits 116..53
              #define mantrest() ((mant[2] & (bit(21)-1)) || mant[3])
            #elif (intDsize==32)
              manthi = ((uint32)mant[0] << 11) | ((uint32)mant[1] >> 21); // Bits 116..85
              mantlo = ((uint32)mant[1] << 11) | ((uint32)mant[2] >> 21); // Bits 84..53
              #define mantrest() ((mant[2] & (bit(21)-1)) || mant[3])
            #elif (intDsize==16)
              manthi = // ((uint32)mant[0] << 27) | ((uint32)mant[1] << 11) | ((uint32)mant[2] >> 5); # Bits 116..85
                       (highlow32_at(&mant[0])<<11) | ((uint32)mant[2] >> 5); // Bits 116..85
              mantlo = // ((uint32)mant[2] << 27) | ((uint32)mant[3] << 11) | ((uint32)mant[4] >> 5); # Bits 84..53
                       (highlow32_at(&mant[2])<<11) | ((uint32)mant[4] >> 5); // Bits 84..53
              #define mantrest() ((mant[4] & (bit(5)-1)) || mant[5] || mant[6] || mant[7])
            #elif (intDsize==8)
              manthi = ((uint32)mant[1] << 27) | ((uint32)mant[2] << 19) | ((uint32)mant[3] << 11) | ((uint32)mant[4] << 3) | ((uint32)mant[5] >> 5); // Bits 116..85
              mantlo = ((uint32)mant[5] << 27) | ((uint32)mant[6] << 19) | ((uint32)mant[7] << 11) | ((uint32)mant[8] << 3) | ((uint32)mant[9] >> 5); // Bits 84..53
              #define mantrest() ((mant[9] & (bit(5)-1)) || mant[10] || mant[11] || mant[12] || mant[13] || mant[14] || mant[15])
            #endif
            if ( (mant_bit(DF_mant_len) ==0) // Bit DF_mant_len =0 -> abrunden
                 || ( !mantrest() // Bit DF_mant_len =1 und Bits DF_mant_len-1..0 >0 -> aufrunden
                      // round-to-even, je nach Bit DF_mant_len+1 :
                      && (mant_bit(DF_mant_len+1) ==0)
               )    )
              // abrunden
              goto ab;
              else
              // aufrunden
              goto auf;
            #undef mantrest
          }
          else
          // mant<2^(2*DF_mant_len+1), um DF_mant_len Bits nach rechts schieben:
          { exp1 = exp1-1; // Exponenten decrementieren
            // Bits 104..52 holen:
            #if (cl_word_size==64) // && (intDsize==32)
              manterg = ((uint64)mant[0] << 44) | ((uint64)mant[1] << 12) | ((uint64)mant[2] >> 20); // Bits 115..52
              #define mantrest() ((mant[2] & (bit(20)-1)) || mant[3])
            #elif (intDsize==32)
              manthi = ((uint32)mant[0] << 12) | ((uint32)mant[1] >> 20); // Bits 115..84
              mantlo = ((uint32)mant[1] << 12) | ((uint32)mant[2] >> 20); // Bits 83..52
              #define mantrest() ((mant[2] & (bit(20)-1)) || mant[3])
            #elif (intDsize==16)
              manthi = // ((uint32)mant[0] << 28) | ((uint32)mant[1] << 12) | ((uint32)mant[2] >> 4); # Bits 115..84
                       (highlow32_at(&mant[0])<<12) | ((uint32)mant[2] >> 4); // Bits 115..84
              mantlo = // ((uint32)mant[2] << 28) | ((uint32)mant[3] << 12) | ((uint32)mant[4] >> 4); # Bits 83..52
                       (highlow32_at(&mant[2])<<12) | ((uint32)mant[4] >> 4); // Bits 83..52
              #define mantrest() ((mant[4] & (bit(4)-1)) || mant[5] || mant[6] || mant[7])
            #elif (intDsize==8)
              manthi = ((uint32)mant[1] << 28) | ((uint32)mant[2] << 20) | ((uint32)mant[3] << 12) | ((uint32)mant[4] << 4) | ((uint32)mant[5] >> 4); // Bits 115..84
              mantlo = ((uint32)mant[5] << 28) | ((uint32)mant[6] << 20) | ((uint32)mant[7] << 12) | ((uint32)mant[8] << 4) | ((uint32)mant[9] >> 4); // Bits 83..52
              #define mantrest() ((mant[9] & (bit(4)-1)) || mant[10] || mant[11] || mant[12] || mant[13] || mant[14] || mant[15])
            #endif
            if ( (mant_bit(DF_mant_len-1) ==0) // Bit DF_mant_len-1 =0 -> abrunden
                 || ( !mantrest() // Bit DF_mant_len-1 =1 und Bits DF_mant_len-2..0 >0 -> aufrunden
                      // round-to-even, je nach Bit DF_mant_len :
                      && (mant_bit(DF_mant_len) ==0)
               )    )
              // abrunden
              goto ab;
              else
              // aufrunden
              goto auf;
            #undef mantrest
          }
        #undef mant_bit
        auf:
        #if (cl_word_size==64)
        manterg = manterg+1;
        // Hier ist 2^DF_mant_len <= manterg <= 2^(DF_mant_len+1)
        if (manterg >= bit(DF_mant_len+1)) // rounding overflow?
          { manterg = manterg>>1; exp1 = exp1+1; } // Shift nach rechts
        #else
        mantlo = mantlo+1;
        if (mantlo==0)
          { manthi = manthi+1;
            // Hier ist 2^(DF_mant_len-32) <= manthi <= 2^(DF_mant_len-32+1)
            if (manthi >= bit(DF_mant_len-32+1)) // rounding overflow?
              { manthi = manthi>>1; exp1 = exp1+1; } // Shift nach rechts
          }
        #endif
        ab:
        // Runden fertig, 2^DF_mant_len <= manterg < 2^(DF_mant_len+1)
        #if (cl_word_size==64)
        return encode_DF(sign1,exp1,manterg);
        #else
        return encode_DF(sign1,exp1,manthi,mantlo);
        #endif
      }
#endif
}
