// cl_DF_to_LF().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_F.h"


// Implementation.

#include "cl_DF.h"
#include "cl_LF.h"
#include "cl_LF_impl.h"
#include "cl_DS.h"

cl_LF cl_DF_to_LF (const cl_DF& x, uintC len)
{
      // x entpacken:
      var cl_signean sign;
      var sintL exp;
      var uint32 manthi;
      var uint32 mantlo;
      #if (cl_word_size==64)
      var uint64 mant;
      DF_decode(x, { return encode_LF0(len); }, sign=,exp=(sintL),mant=);
      #else
      DF_decode2(x, { return encode_LF0(len); }, sign=,exp=(sintL),manthi=,mantlo=);
      #endif
      // Long-Float allozieren,
      // Mantisse mit intDsize*len-DF_mant_len-1 Nullbits auffllen:
      var Lfloat y = allocate_lfloat(len,exp+LF_exp_mid,sign);
      var uintD* ptr = &TheLfloat(y)->data[0];
      // erste k := ceiling(DF_mant_len+1,intDsize) Digits mit mant fllen:
      #define shiftcount  (ceiling(DF_mant_len+1,intDsize)*intDsize-(DF_mant_len+1))
      #if (cl_word_size==64)
      mant = mant<<shiftcount;
      manthi = (uint32)(mant>>32); mantlo = (uint32)mant;
      #else
      manthi = (manthi<<shiftcount) | (mantlo>>(32-shiftcount));
      mantlo = mantlo<<shiftcount;
      #endif
      #undef shiftcount
      set_max32_Dptr(DF_mant_len+1-32,ptr,manthi);
      set_32_Dptr(&ptr[ceiling(DF_mant_len+1-32,intDsize)],mantlo);
      clear_loop_up(&ptr[ceiling(DF_mant_len+1,intDsize)],len-ceiling(DF_mant_len+1,intDsize));
      return y;
}
