// cl_UDS_divide().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_DS.h"


// Implementation.

#include "cl_N.h"

// Methode:
// erst a und b normalisieren: a=[a[m-1],...,a[0]], b=[b[n-1],...,b[0]]
// mit m>=0 und n>0 (Stellensystem der Basis beta=2^intDsize).
// Falls m<n, ist q:=0 und r:=a.
// Falls m>=n=1, Single-Precision-Division:
//   r:=0, j:=m,
//   while j>0 do
//     {Hier (q[m-1]*beta^(m-1)+...+q[j]*beta^j) * b[0] + r*beta^j =
//           = a[m-1]*beta^(m-1)+...+a[j]*beta^j und 0<=r<b[0]<beta}
//     j:=j-1, r:=r*beta+a[j], q[j]:=floor(r/b[0]), r:=r-b[0]*q[j].
//   Normalisiere [q[m-1],...,q[0]], liefert q.
// Falls m>=n>1, Multiple-Precision-Division:
//   Es gilt a/b < beta^(m-n+1).
//   s:=intDsize-1-(Nummer des hchsten Bits in b[n-1]), 0<=s<intDsize.
//   Schiebe a und b um s Bits nach links und kopiere sie dabei. r:=a.
//   r=[r[m],...,r[0]], b=[b[n-1],...,b[0]] mit b[n-1]>=beta/2.
//   Fr j=m-n,...,0: {Hier 0 <= r < b*beta^(j+1).}
//     Berechne q* :
//       q* := floor((r[j+n]*beta+r[j+n-1])/b[n-1]).
//       Bei berlauf (q* >= beta) setze q* := beta-1.
//       Berechne c2 := ((r[j+n]*beta+r[j+n-1]) - q* * b[n-1])*beta + r[j+n-2]
//       und c3 := b[n-2] * q*.
//       {Es ist 0 <= c2 < 2*beta^2, sogar 0 <= c2 < beta^2 falls kein
//        berlauf aufgetreten war. Ferner 0 <= c3 < beta^2.
//        Bei berlauf und r[j+n]*beta+r[j+n-1] - q* * b[n-1] >= beta,
//        das heit c2 >= beta^2, kann man die nchste Abfrage berspringen.}
//       Solange c3 > c2, {hier 0 <= c2 < c3 < beta^2} setze
//         q* := q* - 1, c2 := c2 + b[n-1]*beta, c3 := c3 - b[n-2].
//       Falls q* > 0:
//         Setze r := r - b * q* * beta^j, im einzelnen:
//           [r[n+j],...,r[j]] := [r[n+j],...,r[j]] - q* * [b[n-1],...,b[0]].
//           also: u:=0, for i:=0 to n-1 do
//                         u := u + q* * b[i],
//                         r[j+i]:=r[j+i]-(u mod beta) (+ beta, falls Carry),
//                         u:=u div beta (+ 1, falls bei der Subtraktion Carry)
//                 r[n+j]:=r[n+j]-u.
//           {Da stets u = (q* * [b[i-1],...,b[0]] div beta^i) + 1
//                       < q* + 1 <= beta, luft der bertrag u nicht ber.}
//         Tritt dabei ein negativer bertrag auf, so setze q* := q* - 1
//           und [r[n+j],...,r[j]] := [r[n+j],...,r[j]] + [0,b[n-1],...,b[0]].
//     Setze q[j] := q*.
//   Normalisiere [q[m-n],..,q[0]] und erhalte den Quotienten q,
//   Schiebe [r[n-1],...,r[0]] um s Bits nach rechts, normalisiere und
//   erhalte den Rest r.
//   Dabei kann q[j] auf dem Platz von r[n+j] liegen.
  void cl_UDS_divide (const uintD* a_MSDptr, uintC a_len, const uintD* a_LSDptr,
                      const uintD* b_MSDptr, uintC b_len, const uintD* b_LSDptr,
                      uintD* roomptr, // ab roomptr kommen a_len+1 freie Digits
                      DS* q_, DS* r_)
    { // a normalisieren (a_MSDptr erhhen, a_len erniedrigen):
      while ((a_len>0) && (a_MSDptr[0]==0)) { a_MSDptr++; a_len--; }
      // b normalisieren (b_MSDptr erhhen, b_len erniedrigen):
      loop
        { if (b_len==0) { cl_error_division_by_0(); }
          if (b_MSDptr[0]==0) { b_MSDptr++; b_len--; }
          else break;
        }
      // jetzt m=a_len >=0 und n=b_len >0.
      if (a_len < b_len)
        // m<n: Trivialfall, q=0, r:= Kopie von a.
        { var uintD* r_MSDptr = roomptr;
          var uintD* r_LSDptr = &roomptr[a_len];
          // Speicheraufbau: r_MSDptr/0/r_MSDptr/a_len/r_LSDptr
          //                    |     q    |       r      |
          copy_loop_down(a_LSDptr,r_LSDptr,a_len);
          q_->MSDptr = r_MSDptr; q_->len = 0; q_->LSDptr = r_MSDptr; // q = 0, eine NUDS
          r_->MSDptr = r_MSDptr; r_->len = a_len; r_->LSDptr = r_LSDptr; // r = Kopie von a, eine NUDS
          return;
        }
      elif (b_len==1)
        // n=1: Single-Precision-Division
        { // beta^(m-1) <= a < beta^m  ==>  beta^(m-2) <= a/b < beta^m
          var uintD* q_MSDptr = roomptr;
          var uintD* q_LSDptr = &roomptr[a_len];
          var uintD* r_MSDptr = q_LSDptr;
          var uintD* r_LSDptr = &r_MSDptr[1];
          // Speicheraufbau: q_MSDptr/a_len/q_LSDptr    r_MSDptr/1/r_LSDptr
          //                     |      q      |           |     r    |
         {var uintD rest = divucopy_loop_up(b_MSDptr[0],a_MSDptr,q_MSDptr,a_len); // Division durch b[0]
          var uintC r_len;
          if (!(rest==0))
            { r_MSDptr[0] = rest; r_len=1; } // Rest als r ablegen
            else
            { r_MSDptr = r_LSDptr; r_len=0; } // Rest auf 0 normalisieren
          if (q_MSDptr[0]==0)
            { q_MSDptr++; a_len--; } // q normalisieren
          q_->MSDptr = q_MSDptr; q_->len = a_len; q_->LSDptr = q_LSDptr; // q ablegen
          r_->MSDptr = r_MSDptr; r_->len = r_len; r_->LSDptr = r_LSDptr; // r ablegen
          return;
        }}
      else
        // n>1: Multiple-Precision-Division
        { // beta^(m-1) <= a < beta^m, beta^(n-1) <= b < beta^n  ==>
          // beta^(m-n-1) <= a/b < beta^(m-n+1).
          var uintL s;
          SAVE_NUM_STACK // num_stack retten
          // s bestimmen:
          { var uintD msd = b_MSDptr[0]; // b[n-1]
            #if 0
            s = 0;
            while ((sintD)msd >= 0) { msd = msd<<1; s++; }
            #else // ein wenig effizienter, Abfrage auf s=0 vorwegnehmen
            if ((sintD)msd < 0)
              { s = 0; goto shift_ok; }
              else
              { integerlengthD(msd, s = intDsize - ); goto shift; }
            #endif
          }
          // 0 <= s < intDsize.
          // Kopiere b und schiebe es dabei um s Bits nach links:
          if (!(s==0))
            shift:
            { var uintD* new_b_MSDptr;
              var uintD* new_b_LSDptr;
              num_stack_need(b_len,new_b_MSDptr=,new_b_LSDptr=);
              shiftleftcopy_loop_down(b_LSDptr,new_b_LSDptr,b_len,s);
              b_MSDptr = new_b_MSDptr; b_LSDptr = new_b_LSDptr;
            }
          shift_ok:
          // Wieder b = b_MSDptr/b_len/b_LSDptr.
          // Kopiere a und schiebe es dabei um s Bits nach links, erhalte r:
         {var uintD* r_MSDptr = roomptr;
          var uintD* r_LSDptr = &roomptr[a_len+1];
          // Speicheraufbau:  r_MSDptr/          a_len+1           /r_LSDptr
          //                     |                  r                  |
          // spter:          q_MSDptr/a_len-b_len+1/r_MSDptr/b_len/r_LSDptr
          //                     |           q          |       r      |
          if (s==0)
            { copy_loop_down(a_LSDptr,r_LSDptr,a_len); r_MSDptr[0] = 0; }
            else
            { r_MSDptr[0] = shiftleftcopy_loop_down(a_LSDptr,r_LSDptr,a_len,s); }
          // Nun r = r_MSDptr/a_len+1/r_LSDptr.
          {var uintC j = a_len-b_len; // m-n
           var uintD* r_ptr = &r_LSDptr[-(uintP)j]; // Pointer oberhalb von r[j]
           var uintD* q_MSDptr = r_MSDptr;
           var uintC q_len = j = j+1; // q wird m-n+1 Digits haben
           var uintD b_msd = b_MSDptr[0]; // b[n-1]
           var uintD b_2msd = b_MSDptr[1]; // b[n-2]
           #if HAVE_DD
           var uintDD b_msdd = highlowDD(b_msd,b_2msd); // b[n-1]*beta+b[n-2]
           #endif
           // Divisions-Schleife: (wird m-n+1 mal durchlaufen)
           // j = Herabzhler, b_MSDptr/b_len/b_LSDptr = [b[n-1],...,b[0]], b_len=n,
           // r_MSDptr = Pointer auf r[n+j] = Pointer auf q[j],
           // r_ptr = Pointer oberhalb von r[j].
           do { var uintD q_stern;
                var uintD c1;
                if (r_MSDptr[0] < b_msd) // r[j+n] < b[n-1] ?
                  { // Dividiere r[j+n]*beta+r[j+n-1] durch b[n-1], ohne berlauf:
                    #if HAVE_DD
                      divuD(highlowDD(r_MSDptr[0],r_MSDptr[1]),b_msd, q_stern=,c1=);
                    #else
                      divuD(r_MSDptr[0],r_MSDptr[1],b_msd, q_stern=,c1=);
                    #endif
                  }
                  else
                  { // berlauf, also r[j+n]*beta+r[j+n-1] >= beta*b[n-1]
                    q_stern = bitm(intDsize)-1; // q* = beta-1
                    // Teste ob r[j+n]*beta+r[j+n-1] - (beta-1)*b[n-1] >= beta
                    // <==> r[j+n]*beta+r[j+n-1] + b[n-1] >= beta*b[n-1]+beta
                    // <==> b[n-1] < floor((r[j+n]*beta+r[j+n-1]+b[n-1])/beta) {<= beta !} ist.
                    // Wenn ja, direkt zur Subtraktionschleife.
                    // (Andernfalls ist r[j+n]*beta+r[j+n-1] - (beta-1)*b[n-1] < beta
                    //  <==> floor((r[j+n]*beta+r[j+n-1]+b[n-1])/beta) = b[n-1] ).
                    if ((r_MSDptr[0] > b_msd) || ((c1 = r_MSDptr[1]+b_msd) < b_msd))
                      // r[j+n] >= b[n-1]+1 oder
                      // r[j+n] = b[n-1] und Addition r[j+n-1]+b[n-1] gibt Carry ?
                      { goto subtract; } // ja -> direkt in die Subtraktion
                  }
                // q_stern = q*,
                // c1 = (r[j+n]*beta+r[j+n-1]) - q* * b[n-1] (>=0, <beta).
                #if HAVE_DD
                  { var uintDD c2 = highlowDD(c1,r_MSDptr[2]); // c1*beta+r[j+n-2]
                    var uintDD c3 = muluD(b_2msd,q_stern); // b[n-2] * q*
                    // Solange c2 < c3, c2 erhhen, c3 erniedrigen:
                    // Rechne dabei mit c3-c2:
                    // solange >0, um b[n-1]*beta+b[n-2] erniedrigen.
                    // Dies kann wegen b[n-1]*beta+b[n-2] >= beta^2/2
                    // hchstens zwei mal auftreten.
                    if (c3 > c2)
                      { q_stern = q_stern-1; // q* := q* - 1
                        if (c3-c2 > b_msdd)
                          { q_stern = q_stern-1; } // q* := q* - 1
                  }   }
                #else
                  // Wie oben, nur mit zweigeteilten c2=[c2hi|c2lo] und c3=[c3hi|c3lo]:
                  #define c2hi c1
                  { var uintD c2lo = r_MSDptr[2]; // c2hi*beta+c2lo = c1*beta+r[j+n-2]
                    var uintD c3hi;
                    var uintD c3lo;
                    muluD(b_2msd,q_stern, c3hi=,c3lo=); // c3hi*beta+c3lo = b[n-2] * q*
                    if ((c3hi > c2hi) || ((c3hi == c2hi) && (c3lo > c2lo)))
                      { q_stern = q_stern-1; // q* := q* - 1
                        c3hi -= c2hi; if (c3lo < c2lo) { c3hi--; }; c3lo -= c2lo; // c3 := c3-c2
                        if ((c3hi > b_msd) || ((c3hi == b_msd) && (c3lo > b_2msd)))
                          { q_stern = q_stern-1; } // q* := q* - 1
                  }   }
                  #undef c2hi
                #endif
                if (!(q_stern==0))
                  subtract:
                  { // Subtraktionsschleife: r := r - b * q* * beta^j
                    var uintD carry = mulusub_loop_down(q_stern,b_LSDptr,r_ptr,b_len);
                    // Noch r_ptr[-b_len-1] -= carry, d.h. r_MSDptr[0] -= carry
                    // durchfhren und danach r_MSDptr[0] vergessen:
                    if (carry > r_MSDptr[0])
                      // Subtraktion ergab bertrag
                      { q_stern = q_stern-1; // q* := q* - 1
                        addto_loop_down(b_LSDptr,r_ptr,b_len); // Additionsschleife
                        // r[n+j] samt Carry kann vergessen werden...
                  }   }
                // Berechnung von q* ist fertig.
                *r_MSDptr++ = q_stern; // als q[j] ablegen
                r_ptr++;
              }
              until (--j == 0);
           // Nun ist q = [q[m-n],..,q[0]] = q_MSDptr/q_len/r_MSDptr
           // und r = [r[n-1],...,r[0]] = r_MSDptr/b_len/r_LSDptr.
           // q normalisieren und ablegen:
           if (q_MSDptr[0]==0)
             { q_MSDptr++; q_len--; }
           q_->MSDptr = q_MSDptr; q_->len = q_len; q_->LSDptr = r_MSDptr;
           // Schiebe [r[n-1],...,r[0]] um s Bits nach rechts:
           if (!(s==0))
             { shiftright_loop_up(r_MSDptr,b_len,s); }
           // r normalisieren und ablegen:
           while ((b_len>0) && (r_MSDptr[0]==0)) { r_MSDptr++; b_len--; }
           r_->MSDptr = r_MSDptr; r_->len = b_len; r_->LSDptr = r_LSDptr;
           return;
        }}}
    }
