// expx().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_R_tran.h"


// Implementation.

#include "cl_real.h"
#include "cl_float.h"
#include "cl_low.h"

cl_F expx (const cl_F& x)
{
// Methode:
// e := Exponent aus (decode-float x), d := (float-digits x)
// Bei x=0.0 oder e<-d liefere 1.0
//   (denn bei e<=-d-1 ist abs(exp(x)-1) = abs(x)+O(x^2) < 2^(-d-1),
//    also ist exp(x), auf d Bits gerundet, gleich 1.0).
// Bei e<=-sqrt(d) verwende die Potenzreihe
//   exp(x) = sum(j=0..inf,x^j/j!):
//   b:=1, i:=0, sum:=0,
//   while (/= sum (setq sum (+ sum b))) do b:=b*x/(i+1), i:=i+1.
//   Ergebnis sum.
// Sonst setze y := x/2 = (scale-float x -1),
//   berechne rekursiv z:=exp(y) und liefere z^2.
// Aufwand: asymptotisch d^2.5 .

	if (zerop(x))
		return cl_float(1,x);
	var uintL d = float_digits(x);
	var sintL e = float_exponent(x);
	if (e < -(sintL)d) // e < -d ?
		return cl_float(1,x); // ja -> 1.0 als Ergebnis
 {	Mutable(cl_F,x);
	var uintL k = 0; // Rekursionszhler k:=0
	// Bei e <= -1-floor(sqrt(d)) kann die Potenzreihe angewandt werden.
	var sintL e_limit = -1-isqrt(d); // -1-floor(sqrt(d))
	if (e > e_limit) {
		// e > -1-floor(sqrt(d)) -> mu |x| verkleinern.
		k = e - e_limit;
		x = scale_float(x,-(sintL)k); // x := x/2^k
		// Neuer Exponent = e-k = e_limit.
	}
	// Potenzreihe anwenden:
	var int i = 0;
	var cl_F b = cl_float(1,x); // b := (float 1 x)
	var cl_F sum = cl_float(0,x); // sum := (float 0 x)
	loop {
		var cl_F new_sum = sum + b;
		if (new_sum == sum) // = sum ?
			break; // ja -> Potenzreihe abbrechen
		sum = new_sum;
		i = i+1;
		b = (b*x)/cl_float(i,x); // b := b*x/i
	}
	var cl_F& result = sum; // sum als Ergebnis
	// Wegen Rekursion noch k mal quadrieren:
	for ( ; k > 0; k--)
		result = result*result;
	return result;
}}
