// ash().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_integer.h"


// Implementation.

#include "cl_I.h"
#include "cl_DS.h"
#include "cl_I_ash.h"

cl_I ash (const cl_I& x, const cl_I& y)
{
    // Methode:
    // x = 0 -> 0 als Ergebnis
    // y = 0 -> x als Ergebnis
    // y > 0 -> y = intDsize*k + i, j=k+(1 falls i>0, 0 falls i=0).
    //          j Wrter mehr reservieren, k Nullwrter, dann bertragen,
    //          bei i>0: um i Bits links schieben (i=1 geht einfacher).
    // y < 0 -> y <= - intDsize * (Lnge(A0) in Digits) -> Ergebnis = 0 oder -1.
    //          Sonst: -y = intDsize*k + i mit k<Lnge(A0).
    //                  bertrage die (Lnge(A0)-k) MSDigits,
    //                  falls i>0: schiebe sie um i Bits nach rechts (i=1 geht einfacher).
	if (zerop(x))
		return 0;		// x=0 -> 0 als Ergebnis
	if (zerop(y))
		return x;		// y=0 -> x als Ergebnis
    {	SAVE_NUM_STACK // num_stack retten
	if (!minusp(y)) {
	        // y>0
        	if (bignump(y)) // y ein Bignum
			// y so gro, da selbst (ASH 1 y) einen berlauf gbe.
			{ cl_ash_error(y); }
	      { var uintL y_ = FN_to_L(y); // Wert von y, >=0, <intDsize*2^intCsize
		var uintL i = y_%intDsize; // i = y mod intDsize, >=0, <intDsize
		var uintL k = floor(y_,intDsize); // k = y div intDsize, >=0, <2^intCsize
		var uintD* LSDptr;
		var uintC len;
		var const uintD* x_LSDptr;
		I_to_NDS_nocopy(x, ,len=,x_LSDptr=); // DS zu x bilden.
		if (k >= (uintC)(~(uintC)len)) // kann len+k+1 berlauf geben?
			{ cl_ash_error(y); } // ja -> Fehler
		num_stack_need_1(len+k,,LSDptr=);
		LSDptr = clear_loop_down(LSDptr,k); // k Nulldigits
	       {var uintD* MSDptr = copy_loop_down(x_LSDptr,LSDptr,len);
		// Nun ist MSDptr/len/LSDptr die DS zu x.
		// Oberhalb von ihr liegen k Nulldigits, unterhalb ist 1 Digit Platz.
		// MSDptr/len+k/.. ist jetzt die Gesamt-DS.
		// Noch um i Bits nach links schieben:
		if (!(i==0)) // Bei i>0
		  { // noch ein weiteres Digit dazunehmen (Vorzeichen)
		    {var uintD sign = sign_of_sintD(MSDptr[0]);
		     *--MSDptr = sign;
		     len++;
		    }
		    // Schiebeschleife: die unteren len Digits um i Bits schieben
		    if (i==1)
		      { shift1left_loop_down(LSDptr,len); }
		    else
		      { shiftleft_loop_down(LSDptr,len,i,0); }
		  }
		return DS_to_I(MSDptr,len+k);
	      }}
	} else {
		// y<0
		if (bignump(y)) goto sign; // y ein Bignum -> Vorzeichen von x zurck
	      { var uintL y_ = -FN_to_L(y); // Wert von -y, >0
		var uintL i = y_%intDsize; // i = (-y) mod intDsize, >=0, <intDsize
		var uintL k = floor(y_,intDsize); // k = (-y) div intDsize, >=0
		// DS zu x bilden:
		var uintD* MSDptr;
		var uintC len;
		I_to_NDS(x, MSDptr=,len=,); // DS zu x bilden.
		if (k>=len) goto sign; // -y >= intDsize*len -> Vorzeichen von x zurck
		len -= k; // rechte k Digits einfach streichen
		// Noch ist len>0. Um i Bits nach rechts schieben:
		if (!(i==0)) // Bei i>0:
		  { // Schiebe len Digits ab MSDptr um i Bits nach rechts:
		    if (i==1)
		      { shift1right_loop_up(MSDptr,len,sign_of_sintD(MSDptr[0])); }
		      else
		      { shiftrightsigned_loop_up(MSDptr,len,i); }
		  }
		return DS_to_I(MSDptr,len);
	      }
	}
sign:	// Ergebnis ist 0, falls x>=0, und -1, falls x<0:
	return (minusp(x) ? cl_I(-1) : cl_I(0));
    }
}
