// cl_compare().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_integer.h"


// Implementation.

#include "cl_I.h"
#include "cl_DS.h"

cl_signean cl_compare (const cl_I& x, const cl_I& y)
{
      // Methode:
      // x und y haben verschiedenes Vorzeichen ->
      //    x < 0 -> x < y
      //    x >= 0 -> x > y
      // x und y haben gleiches Vorzeichen ->
      // x Fixnum ->
      //    y Fixnum -> direkt vergleichen.
      //    y Bignum ->
      //       y > 0 -> x < y
      //       y < 0 -> x > y
      // x Bignum ->
      //    y Fixnum ->
      //       x < 0 -> x < y
      //       x > 0 -> x > y
      //    y Bignum ->
      //       falls beide gleich lang -> wortweise vergleichen
      //       x krzer als y -> bei x,y > 0 : x < y, bei x,y < 0 : x > y
      //       y krzer als x -> bei x,y > 0 : x > y, bei x,y > 0 : x < y
      var uintC xlen;
      var uintC ylen;
      if (fixnump(x))
        // x Fixnum
        if (fixnump(y))
          // x Fixnum, y Fixnum
          { // This assumes cl_value_shift + cl_value_len == cl_word_size.
            if ((cl_sint)x.word == (cl_sint)y.word) return signean_null;
            else if ((cl_sint)x.word > (cl_sint)y.word) return signean_plus;
            else return signean_minus;
          }
          else
          // x Fixnum, y Bignum
          if ((sintD)TheBignum(y)->data[0] >= 0)
            // x Fixnum, y Bignum >0
            return signean_minus; // x<y
            else
            // x Fixnum, y Bignum <0
            return signean_plus; // x>y
        else
        // x Bignum
        if (fixnump(y))
          // x Bignum, y Fixnum
          if ((sintD)TheBignum(x)->data[0] >= 0)
            // x Bignum >0, y Fixnum
            return signean_plus; // x>y
            else
            // x Bignum <0, y Fixnum
            return signean_minus; // x<y
          else
          // x Bignum, y Bignum
          if ((sintD)TheBignum(x)->data[0] >= 0)
            // x Bignum >0, y Bignum
            if ((sintD)TheBignum(y)->data[0] >= 0)
              // x und y Bignums >0
              if (x.pointer == y.pointer)
                return signean_null; // gleiche Pointer -> selbe Zahl
                else
                { xlen = TheBignum(x)->length;
                  ylen = TheBignum(y)->length;
                  if (xlen==ylen)
                    samelength:
                    // gleiche Lnge -> digitweise vergleichen
                    return compare_loop_up(&TheBignum(x)->data[0],&TheBignum(y)->data[0],xlen);
                    else
                    return (xlen > ylen ? signean_plus : signean_minus);
                }
              else
              // x Bignum >0, y Bignum <0
              return signean_plus; // x>y
            else
            // x Bignum <0, y Bignum
            if ((sintD)TheBignum(y)->data[0] >= 0)
              // x Bignum <0, y Bignum >0
              return signean_minus; // x<y
              else
              // x und y Bignums <0
              if (x.pointer == y.pointer)
                return signean_null; // gleiche Pointer -> selbe Zahl
                else
                { xlen = TheBignum(x)->length;
                  ylen = TheBignum(y)->length;
                  if (xlen==ylen)
                    // gleiche Lnge -> wortweise vergleichen
                    goto samelength; // wie oben
                    else
                    return (xlen > ylen ? signean_minus : signean_plus);
                }
}
