// L_to_I().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_I.h"


// Implementation.

#include "cl_number.h"

#if (cl_value_len < 32)

#include "cl_DS.h"

cl_I L_to_I (sint32 wert)
{
	var uint32 test = wert & minus_bit(cl_value_len-1);
	// test enthlt die Bits, die nicht in den Fixnum-Wert >= 0 reinpassen.
	if ((test == 0) || (test == (uint32)minus_bit(cl_value_len-1)))
		{ return cl_I_from_word(cl_combine(cl_FN_tag,wert)); }
	// Bignum erzeugen:
	// (dessen Lnge  bn_minlength <= n <= ceiling(32/intDsize)  erfllt)
	if (bn_minlength == ceiling(32,intDsize)) {
		#if (intDsize==8)
		goto bignum4;
		#endif
		#if (intDsize==16)
		goto bignum2;
		#endif
		#if (intDsize==32)
		goto bignum1;
		#endif
	}
	if (wert >= 0) {
		#define IF_LENGTH(i)  \
		  if ((bn_minlength <= i) && (i*intDsize <= 32))	\
		    if (!((i+1)*intDsize <= 32)				\
		        || ((uint32)wert < (uint32)bitc(i*intDsize-1))	\
		       )
		#if (intDsize <= 32)
		IF_LENGTH(1)
			bignum1:
			{ var cl_bignum* ptr = allocate_bignum(1);
			  ptr->data[0] = wert;
			  return cl_I(ptr);
			}
		#if (intDsize <= 16)
		IF_LENGTH(2)
			bignum2:
			{ var cl_bignum* ptr = allocate_bignum(2);
			  ptr->data[1] = (uintD)wert;
			  ptr->data[0] = (uintD)(wert>>intDsize);
			  return cl_I(ptr);
			}
		#if (intDsize <= 8)
		IF_LENGTH(3)
			bignum3:
			{ var cl_bignum* ptr = allocate_bignum(3);
			  ptr->data[2] = (uintD)wert; wert >>= intDsize;
			  ptr->data[1] = (uintD)wert;
			  ptr->data[0] = (uintD)(wert>>intDsize);
			  return cl_I(ptr);
			}
		IF_LENGTH(4)
			bignum4:
			{ var cl_bignum* ptr = allocate_bignum(4);
			  ptr->data[3] = (uintD)wert; wert >>= intDsize;
			  ptr->data[2] = (uintD)wert; wert >>= intDsize;
			  ptr->data[1] = (uintD)wert;
			  ptr->data[0] = (uintD)(wert>>intDsize);
			  return cl_I(ptr);
			}
		#endif
		#endif
		#endif
		#undef IF_LENGTH
	} else {
		#define IF_LENGTH(i)  \
		  if ((bn_minlength <= i) && (i*intDsize <= 32))	\
		    if (!((i+1)*intDsize <= 32)				\
		        || ((uint32)wert >= (uint32)(-bitc(i*intDsize-1))) \
		       )
		#if (intDsize <= 32)
		IF_LENGTH(1)
			goto bignum1;
		#if (intDsize <= 16)
		IF_LENGTH(2)
			goto bignum2;
		#if (intDsize <= 8)
		IF_LENGTH(3)
			goto bignum3;
		IF_LENGTH(4)
			goto bignum4;
		#endif
		#endif
		#endif
		#undef IF_LENGTH
	}
}	

#endif
