// Q_to_I().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_I.h"


// Implementation.

#include "cl_number.h"

#ifdef intQsize

#include "cl_DS.h"

cl_I Q_to_I (sint64 wert)
{
	var uint64 test = wert & (sint64)minus_bit(cl_value_len-1);
	// test enthlt die Bits, die nicht in den Fixnum-Wert >= 0 reinpassen.
	if ((test == 0) || (test == (uint64)(sint64)minus_bit(cl_value_len-1)))
		return cl_I_from_word(cl_combine(cl_FN_tag,(sint32)wert));
	// Bignum erzeugen:
	// (dessen Lnge  bn_minlength <= n <= ceiling(32/intDsize)  erfllt)
	if (wert >= 0) {
		#define IF_LENGTH(i)  \
		  if ((bn_minlength <= i) && (i*intDsize <= 64))	\
		    if (!((i+1)*intDsize <= 64)				\
		        || ((uint64)wert < ((uint64)1 << (i*intDsize-1))) \
		       )
		IF_LENGTH(1)
			bignum1:
			{ var cl_bignum* ptr = allocate_bignum(1);
			  ptr->data[0] = (uintD)wert;
			  return cl_I(ptr);
			}
		#if (intDsize <= 32)
		IF_LENGTH(2)
			bignum2:
			{ var cl_bignum* ptr = allocate_bignum(2);
			  ptr->data[1] = (uintD)wert;
			  ptr->data[0] = (uintD)(wert>>intDsize);
			  return cl_I(ptr);
			}
		#if (intDsize <= 16)
		IF_LENGTH(3)
			bignum3:
			{ var cl_bignum* ptr = allocate_bignum(3);
			  ptr->data[2] = (uintD)wert; wert >>= intDsize;
			  ptr->data[1] = (uintD)wert;
			  ptr->data[0] = (uintD)(wert>>intDsize);
			  return cl_I(ptr);
			}
		IF_LENGTH(4)
			bignum4:
			{ var cl_bignum* ptr = allocate_bignum(4);
			  ptr->data[3] = (uintD)wert; wert >>= intDsize;
			  ptr->data[2] = (uintD)wert; wert >>= intDsize;
			  ptr->data[1] = (uintD)wert;
			  ptr->data[0] = (uintD)(wert>>intDsize);
			  return cl_I(ptr);
			}
		#if (intDsize <= 8)
		IF_LENGTH(5)
			bignum5:
			{ var cl_bignum* ptr = allocate_bignum(5);
			  ptr->data[4] = (uintD)wert; wert >>= intDsize;
			  ptr->data[3] = (uintD)wert; wert >>= intDsize;
			  ptr->data[2] = (uintD)wert; wert >>= intDsize;
			  ptr->data[1] = (uintD)wert;
			  ptr->data[0] = (uintD)(wert>>intDsize);
			  return cl_I(ptr);
			}
		IF_LENGTH(6)
			bignum6:
			{ var cl_bignum* ptr = allocate_bignum(6);
			  ptr->data[5] = (uintD)wert; wert >>= intDsize;
			  ptr->data[4] = (uintD)wert; wert >>= intDsize;
			  ptr->data[3] = (uintD)wert; wert >>= intDsize;
			  ptr->data[2] = (uintD)wert; wert >>= intDsize;
			  ptr->data[1] = (uintD)wert;
			  ptr->data[0] = (uintD)(wert>>intDsize);
			  return cl_I(ptr);
			}
		IF_LENGTH(7)
			bignum7:
			{ var cl_bignum* ptr = allocate_bignum(7);
			  ptr->data[6] = (uintD)wert; wert >>= intDsize;
			  ptr->data[5] = (uintD)wert; wert >>= intDsize;
			  ptr->data[4] = (uintD)wert; wert >>= intDsize;
			  ptr->data[3] = (uintD)wert; wert >>= intDsize;
			  ptr->data[2] = (uintD)wert; wert >>= intDsize;
			  ptr->data[1] = (uintD)wert;
			  ptr->data[0] = (uintD)(wert>>intDsize);
			  return cl_I(ptr);
			}
		IF_LENGTH(8)
			bignum8:
			{ var cl_bignum* ptr = allocate_bignum(8);
			  ptr->data[7] = (uintD)wert; wert >>= intDsize;
			  ptr->data[6] = (uintD)wert; wert >>= intDsize;
			  ptr->data[5] = (uintD)wert; wert >>= intDsize;
			  ptr->data[4] = (uintD)wert; wert >>= intDsize;
			  ptr->data[3] = (uintD)wert; wert >>= intDsize;
			  ptr->data[2] = (uintD)wert; wert >>= intDsize;
			  ptr->data[1] = (uintD)wert;
			  ptr->data[0] = (uintD)(wert>>intDsize);
			  return cl_I(ptr);
			}
		#endif
		#endif
		#endif
		#undef IF_LENGTH
	} else {
		#define IF_LENGTH(i)  \
		  if ((bn_minlength <= i) && (i*intDsize <= 64))	\
		    if (!((i+1)*intDsize <= 64)				\
		        || ((uint64)wert >= ((uint64)(-1) << (i*intDsize-1))) \
		       )
		IF_LENGTH(1)
			goto bignum1;
		#if (intDsize <= 32)
		IF_LENGTH(2)
			goto bignum2;
		#if (intDsize <= 16)
		IF_LENGTH(3)
			goto bignum3;
		IF_LENGTH(4)
			goto bignum4;
		#if (intDsize <= 8)
		IF_LENGTH(5)
			goto bignum5;
		IF_LENGTH(6)
			goto bignum6;
		IF_LENGTH(7)
			goto bignum7;
		IF_LENGTH(8)
			goto bignum8;
		#endif
		#endif
		#endif
		#undef IF_LENGTH
	}
}	

#endif
