// UL_to_I().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_I.h"


// Implementation.

#include "cl_number.h"

#if (cl_value_len <= 32)

#include "cl_DS.h"

cl_I UL_to_I (uint32 wert)
{
	if ((wert & minus_bit(cl_value_len-1)) == 0)
	   // Bits, die nicht in den Fixnum-Wert >= 0 reinpassen.
		return cl_I_from_word(cl_combine(cl_FN_tag,wert));
	// Bignum erzeugen:
	// (dessen Lnge  bn_minlength <= n <= ceiling((32+1)/intDsize)  erfllt)
	#define UL_maxlength  ceiling(32+1,intDsize)
	#define IF_LENGTH(i)  \
	  if ((bn_minlength <= i) && (i <= UL_maxlength))	\
	    if (!(i+1 <= UL_maxlength)				\
	        || ((uint32)wert < (uint32)bitc(i*intDsize-1))	\
	       )
	IF_LENGTH(1)
		{ var cl_bignum* ptr = allocate_bignum(1);
		  ptr->data[0] = wert;
		  return cl_I(ptr);
		}
	#if (intDsize <= 32)
	IF_LENGTH(2)
		{ var cl_bignum* ptr = allocate_bignum(2);
		  ptr->data[1] = (uintD)wert;
		  #if (intDsize>=32)
		  ptr->data[0] = 0;
		  #else
		  ptr->data[0] = (uintD)(wert>>intDsize);
		  #endif
		  return cl_I(ptr);
		}
	#if (intDsize <= 16)
	IF_LENGTH(3)
		{ var cl_bignum* ptr = allocate_bignum(3);
		  ptr->data[2] = (uintD)wert; wert >>= intDsize;
		  ptr->data[1] = (uintD)wert;
		  #if (2*intDsize>=32)
		  ptr->data[0] = 0;
		  #else
		  ptr->data[0] = (uintD)(wert>>intDsize);
		  #endif
		  return cl_I(ptr);
		}
	#if (intDsize <= 8)
	IF_LENGTH(4)
		{ var cl_bignum* ptr = allocate_bignum(4);
		  ptr->data[3] = (uintD)wert; wert >>= intDsize;
		  ptr->data[2] = (uintD)wert; wert >>= intDsize;
		  ptr->data[1] = (uintD)wert;
		  #if (3*intDsize>=32)
		  ptr->data[0] = 0;
		  #else
		  ptr->data[0] = (uintD)(wert>>intDsize);
		  #endif
		  return cl_I(ptr);
		}
	IF_LENGTH(5)
		{ var cl_bignum* ptr = allocate_bignum(5);
		  ptr->data[4] = (uintD)wert; wert >>= intDsize;
		  ptr->data[3] = (uintD)wert; wert >>= intDsize;
		  ptr->data[2] = (uintD)wert; wert >>= intDsize;
		  ptr->data[1] = (uintD)wert;
		  ptr->data[1] = (uintD)wert;
		  #if (4*intDsize>=32)
		  ptr->data[0] = 0;
		  #else
		  ptr->data[0] = (uintD)(wert>>intDsize);
		  #endif
		  return cl_I(ptr);
		}
	#endif
	#endif
	#endif
	#undef IF_LENGTH
	#undef UL_maxlength
}	

#endif
