// UL2_to_I().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_I.h"


// Implementation.

#include "cl_number.h"
#include "cl_DS.h"

cl_I UL2_to_I (uint32 wert_hi, uint32 wert_lo)
{
	if ((wert_hi == 0)
	    && ((wert_lo & minus_bit(cl_value_len-1)) == 0)
	   )
		return cl_I_from_word(cl_combine(cl_FN_tag,wert_lo));
	// Bignum erzeugen:
	// (dessen Lnge  bn_minlength <= n <= ceiling((64+1)/intDsize)  erfllt)
	#define UL2_maxlength  ceiling(64+1,intDsize)
	#define FILL_1_DIGIT(i,from) \
		ptr->data[i] = (uintD)from;
	#define FILL_2_DIGIT(i,from) \
		ptr->data[i] = (uintD)from; \
		ptr->data[i+1] = (uintD)(from>>intDsize);
	#define FILL_3_DIGIT(i,from) \
		ptr->data[i] = (uintD)from; from>>=intDsize; \
		ptr->data[i+1] = (uintD)from; \
		ptr->data[i+2] = (uintD)(from>>intDsize);
	#define FILL_4_DIGIT(i,from) \
		ptr->data[i] = (uintD)from; from>>=intDsize; \
		ptr->data[i+1] = (uintD)from; from>>=intDsize; \
		ptr->data[i+2] = (uintD)from; \
		ptr->data[i+3] = (uintD)(from>>intDsize);
	#if (32/intDsize==1)
	#define FILL_1	FILL_1_DIGIT(0,wert_lo);
	#define FILL_2	FILL_1_DIGIT(0,wert_hi); FILL_1_DIGIT(1,wert_lo);
	#define FILL_3	ptr->data[0] = 0; FILL_1_DIGIT(1,wert_hi); FILL_1_DIGIT(2,wert_lo);
	#endif
	#if (32/intDsize==2)
	#define FILL_1	FILL_1_DIGIT(0,wert_lo);
	#define FILL_2	FILL_2_DIGIT(0,wert_lo);
	#define FILL_3	FILL_1_DIGIT(0,wert_hi); FILL_2_DIGIT(1,wert_lo);
	#define FILL_4	FILL_2_DIGIT(0,wert_hi); FILL_2_DIGIT(2,wert_lo);
	#define FILL_5	ptr->data[0] = 0; FILL_2_DIGIT(1,wert_hi); FILL_2_DIGIT(3,wert_lo);
	#endif
	#if (32/intDsize==4)
	#define FILL_1	FILL_1_DIGIT(0,wert_lo);
	#define FILL_2	FILL_2_DIGIT(0,wert_lo);
	#define FILL_3	FILL_3_DIGIT(0,wert_lo);
	#define FILL_4	FILL_4_DIGIT(0,wert_lo);
	#define FILL_5	FILL_1_DIGIT(0,wert_hi); FILL_4_DIGIT(1,wert_lo);
	#define FILL_6	FILL_2_DIGIT(0,wert_hi); FILL_4_DIGIT(2,wert_lo);
	#define FILL_7	FILL_3_DIGIT(0,wert_hi); FILL_4_DIGIT(3,wert_lo);
	#define FILL_8	FILL_4_DIGIT(0,wert_hi); FILL_4_DIGIT(4,wert_lo);
	#define FILL_9	ptr->data[0] = 0; FILL_4_DIGIT(1,wert_hi); FILL_4_DIGIT(5,wert_lo);
	#endif
	#define IF_LENGTH(i)  \
	  if ((bn_minlength <= i) && (i <= UL2_maxlength))	\
	    if (!(i+1 <= UL2_maxlength)				\
	        || (i*intDsize-1 < 32				\
	            ? ((wert_hi == 0) && (wert_lo < (uint32)bitc(i*intDsize-1))) \
	            : (wert_hi < (uint32)bitc(i*intDsize-1-32)) \
	       )   )
	#define ALLOC(i)  \
	  var cl_bignum* ptr = allocate_bignum(i);
	#define OK  \
	  return cl_I(ptr);
	IF_LENGTH(1)
		{ ALLOC(1); FILL_1; OK; }
	IF_LENGTH(2)
		{ ALLOC(2); FILL_2; OK; }
	#if (intDsize <= 32)
	IF_LENGTH(3)
		{ ALLOC(3); FILL_3; OK; }
	#if (intDsize <= 16)
	IF_LENGTH(4)
		{ ALLOC(4); FILL_4; OK; }
	IF_LENGTH(5)
		{ ALLOC(5); FILL_5; OK; }
	#if (intDsize <= 8)
	IF_LENGTH(6)
		{ ALLOC(6); FILL_6; OK; }
	IF_LENGTH(7)
		{ ALLOC(7); FILL_7; OK; }
	IF_LENGTH(8)
		{ ALLOC(8); FILL_8; OK; }
	IF_LENGTH(9)
		{ ALLOC(9); FILL_9; OK; }
	#endif
	#endif
	#endif
	#undef IF_LENGTH
	#undef UL2_maxlength
}	
