// UQ_to_I().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_I.h"


// Implementation.

#include "cl_number.h"

#ifdef intQsize

#include "cl_DS.h"

cl_I UQ_to_I (uint64 wert)
{
	if ((wert & (sint64)minus_bit(cl_value_len-1)) == 0)
	   // Bits, die nicht in den Fixnum-Wert >= 0 reinpassen.
		return cl_I_from_word(cl_combine(cl_FN_tag,(uint32)wert));
	// Bignum erzeugen:
	// (dessen Lnge  bn_minlength <= n <= ceiling((32+1)/intDsize)  erfllt)
	#define UQ_maxlength  ceiling(64+1,intDsize)
	#define IF_LENGTH(i)  \
	  if ((bn_minlength <= i) && (i <= UQ_maxlength))	\
	    if (!(i+1 <= UQ_maxlength)				\
	        || ((uint64)wert < ((uint64)1 << (i*intDsize-1 < 64 ? i*intDsize-1 : 0))) \
	       )
	IF_LENGTH(1)
		{ var cl_bignum* ptr = allocate_bignum(1);
		  ptr->data[0] = (uintD)wert;
		  return cl_I(ptr);
		}
	IF_LENGTH(2)
		{ var cl_bignum* ptr = allocate_bignum(2);
		  ptr->data[1] = (uintD)wert;
		  #if (intDsize>=64)
		  ptr->data[0] = 0;
		  #else
		  ptr->data[0] = (uintD)(wert>>intDsize);
		  #endif
		  return cl_I(ptr);
		}
	#if (intDsize <= 32)
	IF_LENGTH(3)
		{ var cl_bignum* ptr = allocate_bignum(3);
		  ptr->data[2] = (uintD)wert; wert >>= intDsize;
		  ptr->data[1] = (uintD)wert;
		  #if (2*intDsize>=64)
		  ptr->data[0] = 0;
		  #else
		  ptr->data[0] = (uintD)(wert>>intDsize);
		  #endif
		  return cl_I(ptr);
		}
	#if (intDsize <= 16)
	IF_LENGTH(4)
		{ var cl_bignum* ptr = allocate_bignum(4);
		  ptr->data[3] = (uintD)wert; wert >>= intDsize;
		  ptr->data[2] = (uintD)wert; wert >>= intDsize;
		  ptr->data[1] = (uintD)wert;
		  #if (3*intDsize>=64)
		  ptr->data[0] = 0;
		  #else
		  ptr->data[0] = (uintD)(wert>>intDsize);
		  #endif
		  return cl_I(ptr);
		}
	IF_LENGTH(5)
		{ var cl_bignum* ptr = allocate_bignum(5);
		  ptr->data[4] = (uintD)wert; wert >>= intDsize;
		  ptr->data[3] = (uintD)wert; wert >>= intDsize;
		  ptr->data[2] = (uintD)wert; wert >>= intDsize;
		  ptr->data[1] = (uintD)wert;
		  #if (4*intDsize>=64)
		  ptr->data[0] = 0;
		  #else
		  ptr->data[0] = (uintD)(wert>>intDsize);
		  #endif
		  return cl_I(ptr);
		}
	#if (intDsize <= 8)
	IF_LENGTH(6)
		{ var cl_bignum* ptr = allocate_bignum(6);
		  ptr->data[5] = (uintD)wert; wert >>= intDsize;
		  ptr->data[4] = (uintD)wert; wert >>= intDsize;
		  ptr->data[3] = (uintD)wert; wert >>= intDsize;
		  ptr->data[2] = (uintD)wert; wert >>= intDsize;
		  ptr->data[1] = (uintD)wert;
		  #if (5*intDsize>=64)
		  ptr->data[0] = 0;
		  #else
		  ptr->data[0] = (uintD)(wert>>intDsize);
		  #endif
		  return cl_I(ptr);
		}
	IF_LENGTH(7)
		{ var cl_bignum* ptr = allocate_bignum(7);
		  ptr->data[6] = (uintD)wert; wert >>= intDsize;
		  ptr->data[5] = (uintD)wert; wert >>= intDsize;
		  ptr->data[4] = (uintD)wert; wert >>= intDsize;
		  ptr->data[3] = (uintD)wert; wert >>= intDsize;
		  ptr->data[2] = (uintD)wert; wert >>= intDsize;
		  ptr->data[1] = (uintD)wert;
		  #if (6*intDsize>=64)
		  ptr->data[0] = 0;
		  #else
		  ptr->data[0] = (uintD)(wert>>intDsize);
		  #endif
		  return cl_I(ptr);
		}
	IF_LENGTH(8)
		{ var cl_bignum* ptr = allocate_bignum(8);
		  ptr->data[7] = (uintD)wert; wert >>= intDsize;
		  ptr->data[6] = (uintD)wert; wert >>= intDsize;
		  ptr->data[5] = (uintD)wert; wert >>= intDsize;
		  ptr->data[4] = (uintD)wert; wert >>= intDsize;
		  ptr->data[3] = (uintD)wert; wert >>= intDsize;
		  ptr->data[2] = (uintD)wert; wert >>= intDsize;
		  ptr->data[1] = (uintD)wert;
		  #if (7*intDsize>=64)
		  ptr->data[0] = 0;
		  #else
		  ptr->data[0] = (uintD)(wert>>intDsize);
		  #endif
		  return cl_I(ptr);
		}
	IF_LENGTH(9)
		{ var cl_bignum* ptr = allocate_bignum(9);
		  ptr->data[8] = (uintD)wert; wert >>= intDsize;
		  ptr->data[7] = (uintD)wert; wert >>= intDsize;
		  ptr->data[6] = (uintD)wert; wert >>= intDsize;
		  ptr->data[5] = (uintD)wert; wert >>= intDsize;
		  ptr->data[4] = (uintD)wert; wert >>= intDsize;
		  ptr->data[3] = (uintD)wert; wert >>= intDsize;
		  ptr->data[2] = (uintD)wert; wert >>= intDsize;
		  ptr->data[1] = (uintD)wert;
		  #if (8*intDsize>=64)
		  ptr->data[0] = 0;
		  #else
		  ptr->data[0] = (uintD)(wert>>intDsize);
		  #endif
		  return cl_I(ptr);
		}
	#endif
	#endif
	#endif
	#undef IF_LENGTH
	#undef UQ_maxlength
}	

#endif
