// ldb_extract().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_I_byte.h"


// Implementation.

#include "cl_integer.h"
#include "cl_I.h"
#include "cl_DS.h"

cl_I ldb_extract (const cl_I& x, uintL p, uintL q)
    { SAVE_NUM_STACK // num_stack retten
      var const uintD* MSDptr;
      var uintC len;
      var const uintD* LSDptr;
      I_to_NDS_nocopy(x, MSDptr=,len=,LSDptr=); // NDS zu x bilden
      // MSDptr erhhen und len erniedrigen, so da len = ceiling(q/intDsize) wird:
      { var uintL qD = ceiling(q,intDsize); // ceiling(q/intDsize)
        // wegen q<=l ist qD = ceiling(q/intDsize) <= ceiling((l+1)/intDsize) = len, also
        // pat qD ebenso wie len in ein uintC.
        MSDptr += ((uintL)len - qD); // MSDptr um len-qD Digits erhhen
        len = qD; // len um len-qD erniedrigen
      }
      // LSDptr und len um floor(p/intDsize) erniedrigen:
      { var uintL pD = floor(p,intDsize); // floor(p/intDsize)
        LSDptr -= pD;
        len -= pD;
      }
      // Jetzt enthlt MSDptr/len/LSDptr genau die mageblichen Digits.
     {var uintD* newMSDptr;
      { var uintL i = p%intDsize; // p mod intDsize
        // Kopiere sie und schiebe sie dabei um i Bits nach rechts:
        num_stack_need_1((uintL)len, newMSDptr=,); // neue UDS newMSDptr/len/..
        if (i==0)
          { copy_loop_up(MSDptr,newMSDptr,len); }
          else
          { shiftrightcopy_loop_up(MSDptr,newMSDptr,len,i,0); }
      }
      // newMSDptr/len/.. = geschobene Kopie der mageblichen Digits
      // Ausblenden der Bits mit Nummern >= q-p:
      { var uintL bitcount = intDsize*(uintL)len - (q-p);
        // Anzahl vorne auszublendender Bits ( >=0, <= intDsize-1 + intDsize-1 )
        if (bitcount>=intDsize)
          { bitcount -= intDsize; newMSDptr += 1; len -= 1; } // intDsize Bits ausblenden
        // Noch 0 <= bitcount < intDsize Bits auszublenden:
        newMSDptr[0] &= (uintD)(bitm(intDsize-bitcount)-1);
      }
      // Jetzt enthlt die UDS newMSDptr/len/.. die extrahierten Bits.
      return UDS_to_I(newMSDptr,len); // UDS in Integer umwandeln
    }}
