// ldb_extract_test().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_I_byte.h"


// Implementation.

#include "cl_integer.h"
#include "cl_I.h"
#include "cl_DS.h"

cl_boolean ldb_extract_test (const cl_I& x, uintL p, uintL q)
    { var const uintD* MSDptr;
      var uintC len;
      var const uintD* LSDptr;
      I_to_NDS_nocopy(x, MSDptr=,len=,LSDptr=); // NDS zu x bilden
      // MSDptr erhhen und len erniedrigen, so da len = ceiling(q/intDsize) wird:
      { var uintL qD = ceiling(q,intDsize); // ceiling(q/intDsize)
        // wegen q<=l ist qD = ceiling(q/intDsize) <= ceiling((l+1)/intDsize) = len, also
        // pat qD ebenso wie len in ein uintC.
        MSDptr += ((uintL)len - qD); // MSDptr um len-qD Digits erhhen
        len = qD; // len um len-qD erniedrigen
      }
      // LSDptr und len um floor(p/intDsize) erniedrigen:
      { var uintL pD = p/intDsize; // floor(p/intDsize)
        LSDptr -= pD;
        len -= pD;
      }
      // Jetzt enthlt MSDptr/len/LSDptr genau die mageblichen Digits.
      if (len==0) return cl_false; // len=0 -> keine Bits abzutesten
      q = ((q-1)%intDsize); // q := intDsize - (intDsize*ceiling(q/intDsize) - q) - 1
      p = p%intDsize; // p := p - intDsize*floor(p/intDsize)
      // Jetzt ist 0 <= q < intDsize, 0 <= p < intDsize.
      // Vom ersten Digit mssen die vorderen intDsize-1-q Bits unbercksichtigt bleiben.
      // Ein AND 2^(q+1)-1 erreicht dies.
      // Vom letzten Digit mssen die hinteren p Bits unbercksichtigt bleiben.
      // Ein AND -2^p erreicht dies.
      if (--len==0)
        // 1 Digit mageblich, wird von beiden Seiten angeschnitten:
        // Ein AND 2^(q+1)-2^p erreicht dies.
        if (!(((uintD)(bitm(q+1)-bit(p)) & *MSDptr) == 0))
          return cl_true;
          else
          return cl_false;
      // mindestens 2 Digits. Teste erst die Randdigits, dann die inneren:
      if (!(((*MSDptr++ & (uintD)(bitm(q+1)-1)) == 0) &&
            ((*--LSDptr & (uintD)(minus_bit(p))) == 0)
         ) )
        return cl_true;
      len--; // die beiden Randdigits sind jetzt abgezogen.
      if (test_loop_up(MSDptr,len)) { return cl_true; } else { return cl_false; }
    }

