// logand().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_integer.h"


// Implementation.

#include "cl_I.h"
#include "cl_DS.h"
#include "cl_I_log.h"

// Logische Operationen auf Integers:
// Methode: aus den Lngen der beiden Argumente eine obere Schranke fr
// die Lnge des Ergebnisses berechnen (das Maximum der beiden Lngen und
// FN_maxlength), so da das MSD fr unendlich viele Bits steht.
// Dann beide Argumente in gleichgroe Digit sequences umwandeln, Operation
// mit einer einfachen Schleife durchfhren.

cl_I logand (const cl_I& x, const cl_I& y)
    { if (fixnump(x) && fixnump(y)) // Beides Fixnums -> ganz einfach:
        { // bitweise als Fixnum zurck
          return cl_I_from_word(x.word & y.word);
        }
        else
        { SAVE_NUM_STACK // num_stack retten
          var uintC n; // Anzahl der Digits
         {var uintC nx = I_to_DS_need(x);
          var uintC ny = I_to_DS_need(y);
          n = (nx>=ny ? nx : ny);
         }
         {  var uintD* xptr; I_to_DS_n(x,n,xptr=); // Pointer in DS zu x
          { var uintD* yptr; I_to_DS_n(y,n,yptr=); // Pointer in DS zu y
           {var uintD* zptr = xptr; // Pointer aufs Ergebnis
            and_loop_up(xptr,yptr,n); // mit AND verknpfen
            return DS_to_I(zptr,n); // Ergebnis als Integer
    }   }}}}
