// logtest().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_integer.h"


// Implementation.

#include "cl_I.h"
#include "cl_DS.h"

cl_boolean logtest (const cl_I& x, const cl_I& y)
{
    // Methode:
    //  Fixnums separat behandeln.
    //  Sei oBdA x die krzere der beiden Zahlen (in Digits).
    //  x echt krzer und x<0 -> [eines der most signif. intDsize+1 Bits von y ist 1] Ja.
    //  Beide gleich lang oder x>=0 ->
    //   Kann mich auf die untersten length(x) Digits beschraenken.
    //   Mit AND durchlaufen, abbrechen (mit "Ja") falls /=0. Am Ende: Nein.
      if (fixnump(x))
        if (fixnump(y))
          // beides Fixnums
          { if ((x.word & y.word & cl_combine(0,~(cl_uint)0))==0)
              return cl_false;
              else
              return cl_true;
          }
          else
          // x Fixnum, y Bignum, also ist x echt krzer
          { if (FN_L_minusp(x,FN_to_L(x))) return cl_true; // x<0 -> ja.
            // x>=0. Kombiniere x mit den pFN_maxlength letzten Digits von y.
           {var const uintD* yLSDptr;
            var uintL x_ = FN_to_L(x);
            BN_to_NDS_nocopy(y, ,,yLSDptr=);
            #if (pFN_maxlength > 1)
            doconsttimes(pFN_maxlength-1,
              if (*--yLSDptr & (uintD)x_) return cl_true;
              x_ = x_ >> intDsize;
              );
            #endif
            if (*--yLSDptr & (uintD)x_) return cl_true;
            return cl_false;
          }}
        else
        if (fixnump(y))
          // x Bignum, y Fixnum, analog wie oben, nur x und y vertauscht
          { if (FN_L_minusp(y,FN_to_L(y))) return cl_true; // y<0 -> ja.
            // y>=0. Kombiniere y mit den pFN_maxlength letzten Digits von x.
           {var const uintD* xLSDptr;
            var uintL y_ = FN_to_L(y);
            BN_to_NDS_nocopy(x, ,,xLSDptr=);
            #if (pFN_maxlength > 1)
            doconsttimes(pFN_maxlength-1,
              if (*--xLSDptr & (uintD)y_) return cl_true;
              y_ = y_ >> intDsize;
              );
            #endif
            if (*--xLSDptr & (uintD)y_) return cl_true;
            return cl_false;
          }}
          else
          // x,y Bignums
          { var const uintD* xMSDptr;
            var uintC xlen;
            var const uintD* yMSDptr;
            var uintC ylen;
            BN_to_NDS_nocopy(x, xMSDptr=,xlen=,);
            BN_to_NDS_nocopy(y, yMSDptr=,ylen=,);
            // Beachte: xlen>0, ylen>0.
            if (!(xlen==ylen))
              // beide verschieden lang
              { if (xlen>ylen)
                  // vertauschen
                  {{var const uintD* temp = xMSDptr; xMSDptr = yMSDptr; yMSDptr = temp; }
                   xlen = ylen;
                  }
                // jetzt ist x die echt krzere DS.
                if ((sintD)xMSDptr[0]<0) // der echt krzere ist negativ?
                  return cl_true;
                // Der echt krzere ist positiv.
              }
            // xMSDptr/xlen/.. ist die krzere DS, yMSDptr/../.. ist die lngere DS.
            return and_test_loop_up(xMSDptr,yMSDptr,xlen);
          }
}
