// print_integer_to_string().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_print.h"


// Implementation.

#include "cl_I.h"
#include "cl_DS.h"
#include "cl_string.h"

char * print_integer_to_string (unsigned int base, const cl_I& z)
{
	var cl_boolean minus_p = cl_false;
	var cl_I abs_z;
	if (minusp(z)) {
		// z<0 -> spter Vorzeichen ausgeben:
		minus_p = cl_true;
		abs_z = -z;
	} else
		abs_z = z;
	SAVE_NUM_STACK // num_stack retten
	var uintD* MSDptr;
	var uintC len;
	I_to_NDS(abs_z, MSDptr=,len=,); // |z| als UDS
	var uintL need = 1+cl_digits_need(len,base);
	var DYNAMIC_ARRAY(ziffern,uintB,need); // Platz fr die Ziffern
	var cl_digits erg; erg.LSBptr = &ziffern[need];
	UDS_to_digits(MSDptr,len,(uintD)base,&erg); // Umwandlung in Ziffern
	// Vorzeichen ankleben:
	var char* ergptr = (char*)erg.MSBptr;
	var uintL erglen = erg.len;
	if (minus_p) {
		*--ergptr = '-';
		erglen++;
	}
	var char* result = cl_string(ergptr,erglen); // Ziffern in String schreiben
	FREE_DYNAMIC_ARRAY(ziffern);
	return result;
}
