// sqrtp().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_integer.h"


// Implementation.

#include "cl_I.h"
#include "cl_DS.h"

cl_boolean sqrtp (const cl_I& x, cl_I* w)
{
// Methode:
// Damit x eine Quadratzahl ist, mu es ==0,1 mod 4 sein, und
// bei ISQRT mu ein Rest 0 herauskommen.
      if (logbitp(1,x)) // Bit 1 von x gesetzt?
        { return cl_false; } // ja -> x==2,3 mod 4, also kein Quadrat
      { SAVE_NUM_STACK // num_stack retten
        var const uintD* x_MSDptr;
        var uintC x_len;
        var const uintD* x_LSDptr;
        I_to_NDS_nocopy(x, x_MSDptr=,x_len=,x_LSDptr=); // Digit sequence >=0 zu x
       {var DS y;
        var cl_boolean squarep;
        UDS_sqrt(x_MSDptr,x_len,x_LSDptr, &y, squarep=); // Wurzel ziehen
        if (squarep)
          { *w = NUDS_to_I(y.MSDptr,y.len); } // als Integer
        return squarep;
      }}
}
