// LF_LF_mul_LF().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_LF.h"


// Implementation.

#include "cl_LF_impl.h"
#include "cl_DS.h"
#include "cl_F.h"

cl_LF LF_LF_mul_LF (const cl_LF& x1, const cl_LF& x2)
{
// Methode:
// Falls x1=0.0 oder x2=0.0 -> Ergebnis 0.0
// Sonst: Ergebnis-Vorzeichen = VZ von x1 xor VZ von x2.
//        Ergebnis-Exponent = Summe der Exponenten von x1 und x2.
//        Produkt der Mantissen bilden (2n Digits).
//        Falls das fhrende Bit =0 ist: Mantissenprodukt um 1 Bit nach links
//          schieben (die vorderen n+1 Digits gengen)
//          und Exponent decrementieren.
//        Runden auf n Digits liefert die Ergebnis-Mantisse.
      var uintL uexp1 = TheLfloat(x1)->expo;
      if (uexp1==0) { return x1; } // x1=0.0 -> Ergebnis 0.0
      var uintL uexp2 = TheLfloat(x2)->expo;
      if (uexp2==0) { return x2; } // x2=0.0 -> Ergebnis 0.0
      // Exponenten addieren:
      // (uexp1-LF_exp_mid) + (uexp2-LF_exp_mid) = (uexp1+uexp2-LF_exp_mid)-LF_exp_mid
      uexp1 = uexp1 + uexp2;
      if (uexp1 >= uexp2)
        // kein Carry
        { if (uexp1 < LF_exp_mid+LF_exp_low)
            { if (underflow_allowed())
                { cl_error_floating_point_underflow(); }
                else
                { return encode_LF0(TheLfloat(x1)->len); } // Ergebnis 0.0
        }   }
        else
        // Carry
        { if (uexp1 > (uintL)(LF_exp_mid+LF_exp_high+1)) { cl_error_floating_point_overflow(); } }
      uexp1 = uexp1 - LF_exp_mid;
      // Nun ist LF_exp_low <= uexp1 <= LF_exp_high+1.
      // neues Long-Float allozieren:
      var uintC len = TheLfloat(x1)->len; // Lnge n von x1 und x2
      var Lfloat y = allocate_lfloat(len,uexp1,
                                     TheLfloat(x1)->sign ^ TheLfloat(x2)->sign // Vorzeichen kombinieren
                                    );
      // Produkt bilden:
      {var uintD* MSDptr;
       SAVE_NUM_STACK // num_stack retten
       UDS_UDS_mal_UDS(len,&TheLfloat(x1)->data[(uintP)len],
                       len,&TheLfloat(x2)->data[(uintP)len],
                       MSDptr=,,);
       {var uintD* midptr = &MSDptr[(uintP)len]; // Pointer in die Mitte der 2n Digits
        if ((sintD)MSDptr[0] >= 0) // fhrendes Bit abtesten
          { // erste n+1 Digits um 1 Bit nach links schieben:
            shift1left_loop_down(&midptr[1],len+1);
            // Exponenten decrementieren:
            if ((TheLfloat(y)->expo)-- == LF_exp_low-1)
              { if (underflow_allowed())
                  { cl_error_floating_point_underflow(); }
                  else
                  { return encode_LF0(len); } // Ergebnis 0.0
              }
          }
        // erste Hlfte des Mantissenprodukts bertragen:
        {var uintD* y_mantMSDptr = &TheLfloat(y)->data[0];
         var uintD* y_mantLSDptr =
           copy_loop_up(MSDptr,y_mantMSDptr,len);
         // Runden:
         if ( ((sintD)midptr[0] >= 0) // nchstes Bit =0 -> abrunden
              || ( ((midptr[0] & ((uintD)bit(intDsize-1)-1)) ==0) // Bit =1, weitere Bits >0 -> aufrunden
                   && !test_loop_up(&midptr[1],len-1)
                   // round-to-even
                   && ((midptr[-1] & bit(0)) ==0)
            )    )
           // abrunden
           {}
           else
           // aufrunden
           { if ( inc_loop_down(y_mantLSDptr,len) )
               { // bertrag durchs Aufrunden (kann nur auftreten,
                 // wenn vorhin um 1 Bit nach links geschoben wurde)
                 y_mantMSDptr[0] = bit(intDsize-1); // Mantisse := 10...0
                 (TheLfloat(y)->expo)++; // Exponent wieder zurck-erhhen
           }   }
         // LF_exp_low <= exp <= LF_exp_high sicherstellen:
         if (TheLfloat(y)->expo == LF_exp_high+1) { cl_error_floating_point_overflow(); }
       }}
       return y;
      }
}
