// fround().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_lfloat.h"


// Implementation.

#include "cl_LF.h"
#include "cl_LF_impl.h"
#include "cl_DS.h"

cl_LF fround (const cl_LF& x)
{
// Methode:
// x = 0.0 oder e<0 -> Ergebnis 0.0
// 0<=e<16n -> letzte (16n-e) Bits der Mantisse wegrunden,
//             Exponent und Vorzeichen beibehalten.
// e>=16n -> Ergebnis x
#if 0
      var signean sign;
      var sintL exp;
      var uintD* mantMSDptr;
      var uintC mantlen;
      LF_decode(x, { return x; }, sign=,exp=,mantMSDptr=,mantlen=,);
      if (exp<0) { return encode_LF0(mantlen); } // e<0 -> Ergebnis 0.0
      if ((uintL)exp >= intDsize*(uintL)mantlen) // e>=16n -> x als Ergebnis
        { return x; }
        else
        // 0 <= e < 16n
        { // alle hinteren 16n-e Bits wegrunden:
          var uintC count = floor((uintL)exp,intDsize); // zu kopierende Digits, < mantlen
          var uintC bitcount = ((uintL)exp) % intDsize; // zu kopierende Bits danach, >=0, <intDsize
          var uintD mask = minus_bit(intDsize-bitcount-1); // Maske mit bitcount+1 Bits
          var uintD* mantptr = &mantMSDptr[count];
          if ((mantptr[0] & -mask) ==0) goto ab; // Bit 16n-e-1 =0 -> abrunden
          if (!((mantptr[0] & ~mask) ==0)) goto auf; // Bit 16n-e-1 =1 und Bits 16n-e-2..0 >0 -> aufrunden
          if (test_loop_up(&mantptr[1],mantlen-count-1)) goto auf;
          // round-to-even, je nach Bit 16n-e :
          if (bitcount>0)
            { if ((mantptr[0] & (-2*mask)) ==0) goto ab; else goto auf; }
            elif (count>0)
              { if ((mantptr[-1] & bit(0)) ==0) goto ab; else goto auf; }
              else
              // bitcount=0, count=0, also exp=0: Abrunden von +-0.5 zu 0.0
              { return encode_LF0(mantlen); }
          ab: // abrunden
          { SAVE_NUM_STACK // num_stack retten
            var uintD* MSDptr;
            num_stack_need(mantlen, MSDptr=,);
           {var uintD* ptr =
              copy_loop_up(mantMSDptr,MSDptr,count); // count ganze Digits kopieren
            *ptr++ = mantMSDptr[count] & mask; // dann bitcount Bits kopieren
            clear_loop_up(ptr,mantlen-count-1); // Rest mit Nullen fllen
            return encode_LF(sign,exp,MSDptr,mantlen);
          }}
          auf: // aufrunden
          { SAVE_NUM_STACK // num_stack retten
            var uintD* MSDptr;
            num_stack_need(mantlen, MSDptr=,);
           {var uintD* ptr =
              copy_loop_up(mantMSDptr,MSDptr,count); // count ganze Digits kopieren
            if ((ptr[0] = ((mantptr[0] & mask) - mask)) == 0) // dann bitcount Bits kopieren und incrementieren
              { if (!( inc_loop_down(ptr,count) ==0)) // evtl. weiterincrementieren
                  { MSDptr[0] = bit(intDsize-1); exp = exp+1; } // evtl. Exponenten erhhen
              }
            clear_loop_up(&ptr[1],mantlen-count-1); // Rest mit Nullen fllen
            return encode_LF(sign,exp,MSDptr,mantlen);
          }}
        }
#else
      var uintC len = TheLfloat(x)->len;
      var uintL uexp = TheLfloat(x)->expo;
      if (uexp < LF_exp_mid)
        { if (uexp == 0) { return x; } // x=0.0 -> Ergebnis 0.0
          return encode_LF0(len); // e<0 -> Ergebnis 0.0
        }
      var uintL exp = uexp - LF_exp_mid;
      if (exp >= intDsize*(uintL)len) // e>=16n -> x als Ergebnis
        { return x; }
      // 0 <= e < 16n
      // alle hinteren 16n-e Bits wegrunden:
      var uintC count = floor(exp,intDsize); // zu kopierende Digits, < mantlen
      var uintC bitcount = exp % intDsize; // zu kopierende Bits danach, >=0, <intDsize
      var uintD mask = minus_bit(intDsize-bitcount-1); // Maske mit bitcount+1 Bits
      {var uintD* mantptr = &TheLfloat(x)->data[count];
       if ((mantptr[0] & -mask) ==0) goto ab; // Bit 16n-e-1 =0 -> abrunden
       if (!((mantptr[0] & ~mask) ==0)) goto auf; // Bit 16n-e-1 =1 und Bits 16n-e-2..0 >0 -> aufrunden
       if (test_loop_up(&mantptr[1],len-count-1)) goto auf;
       // round-to-even, je nach Bit 16n-e :
       if (bitcount>0)
         { if ((mantptr[0] & (-2*mask)) ==0) goto ab; else goto auf; }
         elif (count>0)
           { if ((mantptr[-1] & bit(0)) ==0) goto ab; else goto auf; }
           else
           // bitcount=0, count=0, also exp=0: Abrunden von +-0.5 zu 0.0
           { return encode_LF0(len); }
      }
      ab: // abrunden
        {var Lfloat y = allocate_lfloat(len,uexp,TheLfloat(x)->sign); // neues Long-Float
         // y_mant := NUDS mit e Bits aus x_mant und 16n-e Nullbits:
         {var uintD* x_mantMSDptr = &TheLfloat(x)->data[0];
          var uintD* ptr =
            copy_loop_up(x_mantMSDptr,&TheLfloat(y)->data[0],count); // count ganze Digits kopieren
          *ptr++ = x_mantMSDptr[count] & mask; // dann bitcount Bits kopieren
          clear_loop_up(ptr,len-count-1); // Rest mit Nullen fllen
         }
         return y;
        }
      auf: // aufrunden
        {var Lfloat y = allocate_lfloat(len,uexp,TheLfloat(x)->sign); // neues Long-Float
         // y_mant := NUDS mit e Bits aus x_mant mit Increment und 16n-e Nullbits:
         {var uintD* x_mantMSDptr = &TheLfloat(x)->data[0];
          var uintD* y_mantMSDptr = &TheLfloat(y)->data[0];
          var uintD* ptr =
            copy_loop_up(x_mantMSDptr,y_mantMSDptr,count); // count ganze Digits kopieren
          if ((ptr[0] = ((x_mantMSDptr[count] & mask) - mask)) == 0) // dann bitcount Bits kopieren und incrementieren
            { if (!( inc_loop_down(ptr,count) ==0)) // evtl. weiterincrementieren
                { y_mantMSDptr[0] = bit(intDsize-1); (TheLfloat(y)->expo)++; } // evtl. Exponenten erhhen
            }
          clear_loop_up(&ptr[1],len-count-1); // Rest mit Nullen fllen
         }
         return y;
        }
#endif
}
