// futruncate().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_LF.h"


// Implementation.

#include "cl_LF_impl.h"
#include "cl_DS.h"

cl_LF futruncate (const cl_LF& x)
{
// Methode:
// x = 0.0 -> Ergebnis 0.0
// e<=0 -> Ergebnis 1.0 oder -1.0, je nach Vorzeichen von x.
// 1<=e<16n -> Greife die letzten (16n-e) Bits von x heraus.
//             Sind sie alle =0 -> Ergebnis x.
//             Sonst setze sie alle auf 0 und erhhe dann die vorderen e Bits
//             um 1.
//             Kein berlauf -> fertig.
//             Sonst (Ergebnis eine Zweierpotenz): Mantisse := .1000...000,
//               e:=e+1. (Test auf berlauf wegen e<=16n berflssig)
// e>=16n -> Ergebnis x.
#if 0
      var signean sign;
      var sintL exp;
      var uintD* mantMSDptr;
      var uintC mantlen;
      LF_decode(x, { return x; }, sign=,exp=,mantMSDptr=,mantlen=,);
      if (exp<=0) { return encode_LF1s(sign,mantlen); } // e<=0 -> Ergebnis +-1.0
      if ((uintL)exp >= intDsize*(uintL)mantlen) // e>=16n -> x als Ergebnis
        { return x; }
        else
        // 0 < e < 16n
        { // Testen, ob alle hinteren 16n-e Bits =0 sind:
          var uintC count = floor((uintL)exp,intDsize); // zu kopierende Digits, < mantlen
          var uintC bitcount = ((uintL)exp) % intDsize; // zu kopierende Bits danach, >=0, <intDsize
          var uintD mask = minus_bitm(intDsize-bitcount); // Maske mit bitcount Bits
          var uintD* mantptr = &mantMSDptr[count];
          if (   ((mantptr[0] & ~mask) ==0)
              && !test_loop_up(&mantptr[1],mantlen-count-1)
             )
            { return x; }
          // neue NUDS erzeugen mit e Bits aus mant mit Increment
          // und 16n-e Nullbits:
         {SAVE_NUM_STACK // num_stack retten
          var uintD* MSDptr;
          num_stack_need(mantlen, MSDptr=,);
          { var uintD* ptr =
              copy_loop_up(mantMSDptr,MSDptr,count); // count ganze Digits kopieren
            if ((ptr[0] = ((mantptr[0] & mask) - mask)) == 0) // dann bitcount Bits kopieren und incrementieren
              { if (!( inc_loop_down(ptr,count) ==0)) // evtl. weiterincrementieren
                  { MSDptr[0] = bit(intDsize-1); exp = exp+1; } // evtl. Exponenten erhhen
              }
            clear_loop_up(&ptr[1],mantlen-count-1); // Rest mit Nullen fllen
          }
          return encode_LF(sign,exp,MSDptr,mantlen);
        }}
#else
      var uintC len = TheLfloat(x)->len;
      var uintL uexp = TheLfloat(x)->expo;
      if (uexp <= LF_exp_mid)
        { if (uexp == 0) { return x; } // x=0.0 -> Ergebnis 0.0
          return encode_LF1s(TheLfloat(x)->sign,len); // e<=0 -> Ergebnis +-1.0
        }
      var uintL exp = uexp - LF_exp_mid;
      if (exp >= intDsize*(uintL)len) // e>=16n -> x als Ergebnis
        { return x; }
      // 0 < e < 16n
      // Testen, ob alle hinteren 16n-e Bits =0 sind:
      var uintC count = floor(exp,intDsize); // zu kopierende Digits, < mantlen
      var uintC bitcount = exp % intDsize; // zu kopierende Bits danach, >=0, <intDsize
      var uintD mask = minus_bitm(intDsize-bitcount); // Maske mit bitcount Bits
      {var uintD* mantptr = &TheLfloat(x)->data[count];
       if (   ((mantptr[0] & ~mask) ==0)
           && !test_loop_up(&mantptr[1],len-count-1)
          )
         { return x; }
      }
      // Nein -> neues Long-Float produzieren:
      var Lfloat y = allocate_lfloat(len,uexp,TheLfloat(x)->sign); // neues Long-Float
      // y_mant := NUDS mit e Bits aus x_mant mit Increment und 16n-e Nullbits:
      {var uintD* x_mantMSDptr = &TheLfloat(x)->data[0];
       var uintD* y_mantMSDptr = &TheLfloat(y)->data[0];
       var uintD* ptr =
         copy_loop_up(x_mantMSDptr,y_mantMSDptr,count); // count ganze Digits kopieren
       if ((ptr[0] = ((x_mantMSDptr[count] & mask) - mask)) == 0) // dann bitcount Bits kopieren und incrementieren
         { if (!( inc_loop_down(ptr,count) ==0)) // evtl. weiterincrementieren
             { y_mantMSDptr[0] = bit(intDsize-1); (TheLfloat(y)->expo)++; } // evtl. Exponenten erhhen
         }
       clear_loop_up(&ptr[1],len-count-1); // Rest mit Nullen fllen
      }
      return y;
#endif
}
